/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.preferences;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.ui.preferences.PreferenceTab;
import de.dal33t.powerfolder.ui.util.SimpleComponentFactory;
import de.dal33t.powerfolder.ui.util.TextLinesPanelBuilder;
import de.dal33t.powerfolder.ui.widget.LinkLabel;
import de.dal33t.powerfolder.util.Debug;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.JavaVersion;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.os.OSUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class InformationTab
extends PFComponent
implements PreferenceTab {
    private static final int HEADER_FONT_SIZE = 16;
    private JPanel panel;

    public InformationTab(Controller controller) {
        super(controller);
        this.initComponents();
    }

    @Override
    public String getTabName() {
        return Translation.get("exp.preferences.information.title");
    }

    @Override
    public boolean needsRestart() {
        return false;
    }

    @Override
    public void undoChanges() {
    }

    @Override
    public boolean validate() {
        return true;
    }

    private void initComponents() {
        FormLayout formLayout = new FormLayout("pref:grow, pref:grow, pref:grow", "fill:pref:grow, fill:pref:grow, fill:pref:grow");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.createGeneralBox(), cellConstraints.xywh(1, 1, 2, 1));
        panelBuilder.add((Component)this.createPowerFolderBox(), cellConstraints.xy(1, 2));
        panelBuilder.add((Component)this.createSystemBox(), cellConstraints.xy(2, 2));
        this.panel = panelBuilder.getPanel();
    }

    private JButton createActivateButton() {
        boolean bl;
        boolean bl2 = this.getController().getNodeManager().isStarted();
        if (bl2) {
            return null;
        }
        boolean bl3 = bl = this.getController().getUIController().getApplicationModel().getLicenseModel().getActivationAction() != null;
        if (!bl) {
            return null;
        }
        JButton jButton = new JButton(Translation.get("exp.preferences.information.activate_text"));
        jButton.setToolTipText(Translation.get("exp.preferences.information.activate_tips"));
        jButton.setMnemonic(Translation.get("exp.preferences.information.activate_key").trim().charAt(0));
        Action action = this.getController().getUIController().getApplicationModel().getLicenseModel().getActivationAction();
        if (action != null) {
            jButton.addActionListener(action);
        }
        jButton.setBackground(Color.WHITE);
        boolean bl4 = ConfigurationEntry.SERVER_CONNECT_CHANGE_LOGIN_ALLOWED.getValueBoolean(this.getController());
        jButton.setEnabled(bl4);
        return jButton;
    }

    private long calculateTotalLocalSharedSize() {
        long l = 0L;
        for (Folder folder : this.getController().getFolderRepository().getFolders()) {
            l += folder.getStatistic().getLocalSize();
        }
        return l;
    }

    private JPanel createSystemBox() {
        return InformationTab.createTextBox(Translation.get("exp.preferences.information.your_system_title"), Translation.get("exp.preferences.information.your_system_java_version", JavaVersion.systemVersion().toString()) + "\n" + Translation.get("exp.preferences.information.your_system_os", System.getProperty("os.name")) + " (" + (OSUtil.is64BitPlatform() ? "64bit" : "32bit") + ")\n" + Translation.get("exp.preferences.information.power_folder_max", String.valueOf(Runtime.getRuntime().maxMemory() / 1024L / 1024L)) + "\n" + Translation.get("exp.preferences.information.power_folder_used", String.valueOf(Runtime.getRuntime().totalMemory() / 1024L / 1024L)));
    }

    private JPanel createPowerFolderBox() {
        String string = this.getController().getConfig().getProperty("config.url", "Default");
        if (string != null) {
            int n = string.lastIndexOf("/");
            int n2 = string.lastIndexOf(".config");
            string = n2 > 0 ? string.substring(n + 1, n2) : "Default";
        }
        long l = Debug.countDataitems(this.getController());
        return InformationTab.createTextBox(Translation.get("general.application.name"), Translation.get("exp.preferences.information.power_folder_text", "23.4.100") + "\n" + Translation.get("exp.preferences.information.power_folder_distribution", this.getController().getDistribution().getName()) + "\n" + Translation.get("exp.preferences.information.config_name", string) + "\n" + Translation.get("exp.preferences.information.power_folder_data_size", Format.formatBytesShort(this.calculateTotalLocalSharedSize())) + "\n" + Translation.get("exp.preferences.information.power_folder_db_size", String.valueOf(l)), this.createActivateButton());
    }

    private static JPanel createTextBox(String string, String string2) {
        return InformationTab.createTextBox(string, string2, null);
    }

    private static JPanel createTextBox(String string, String string2, JButton jButton) {
        String[] stringArray = string2.split("\n");
        FormLayout formLayout = new FormLayout("pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        TitledBorder titledBorder = new TitledBorder(string);
        titledBorder.setTitleColor(Color.BLACK);
        panelBuilder.setBorder(new CompoundBorder(titledBorder, new EmptyBorder(2, 2, 2, 2)));
        int n = 1;
        CellConstraints cellConstraints = new CellConstraints();
        for (String string3 : stringArray) {
            if (StringUtils.isEmpty(string3.trim())) {
                panelBuilder.appendRow("3dlu");
            } else {
                panelBuilder.appendRow("pref");
                panelBuilder.add((Component)new JLabel("<HTML><BODY>" + string3 + "</BODY></HTML>"), cellConstraints.xy(1, n));
            }
            ++n;
        }
        if (jButton != null) {
            panelBuilder.appendRow("3dlu");
            panelBuilder.appendRow("pref");
            panelBuilder.add((Component)jButton, cellConstraints.xy(1, ++n));
        }
        JPanel jPanel = panelBuilder.getPanel();
        jPanel.setBackground(Color.WHITE);
        return jPanel;
    }

    private JPanel createGeneralBox() {
        FormLayout formLayout = new FormLayout("pref", "pref, 15dlu, pref, 3dlu, pref, 3dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)TextLinesPanelBuilder.createTextPanel(Translation.get("exp.preferences.information.app_description"), 16), cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.createHomeLink().getUIComponent(), cellConstraints.xy(1, 3));
        panelBuilder.add((Component)this.createDocLink().getUIComponent(), cellConstraints.xy(1, 5));
        panelBuilder.add((Component)this.createSupportLink().getUIComponent(), cellConstraints.xy(1, 7));
        TitledBorder titledBorder = new TitledBorder(Translation.get("exp.preferences.information.general_information"));
        titledBorder.setTitleColor(Color.BLACK);
        panelBuilder.setBorder(new CompoundBorder(titledBorder, new EmptyBorder(2, 2, 2, 2)));
        JPanel jPanel = panelBuilder.getPanel();
        jPanel.setBackground(Color.WHITE);
        return jPanel;
    }

    private LinkLabel createHomeLink() {
        LinkLabel linkLabel = new LinkLabel(this.getController(), Translation.get("exp.preferences.information.home_page"), ConfigurationEntry.PROVIDER_URL.getValue(this.getController()));
        SimpleComponentFactory.setFontSize(linkLabel.getUIComponent(), 15);
        return linkLabel;
    }

    private LinkLabel createDocLink() {
        String string = ConfigurationEntry.PROVIDER_WIKI_URL.getValue(this.getController());
        if (StringUtils.isBlank(string)) {
            string = ConfigurationEntry.PROVIDER_QUICKSTART_URL.getValue(this.getController());
        }
        LinkLabel linkLabel = new LinkLabel(this.getController(), Translation.get("exp.preferences.information.documentation"), string);
        linkLabel.setVisible(StringUtils.isNotBlank(string));
        SimpleComponentFactory.setFontSize(linkLabel.getUIComponent(), 15);
        return linkLabel;
    }

    private LinkLabel createSupportLink() {
        LinkLabel linkLabel = new LinkLabel(this.getController(), Translation.get("exp.preferences.information.support"), ConfigurationEntry.PROVIDER_SUPPORT_URL.getValue(this.getController()));
        SimpleComponentFactory.setFontSize(linkLabel.getUIComponent(), 15);
        return linkLabel;
    }

    @Override
    public JPanel getUIPanel() {
        FormLayout formLayout = new FormLayout("pref:grow", "pref, pref:grow");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.panel, cellConstraints.xy(1, 1));
        return panelBuilder.getPanel();
    }

    @Override
    public void save() {
    }
}

