/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.preferences;

import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.net.HTTPProxySettings;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.util.SimpleComponentFactory;
import de.dal33t.powerfolder.util.LoginUtil;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HTTPProxySettingsDialog
extends PFUIComponent {
    private Window parentFrame;
    private JDialog dialog;
    private JPanel panel;
    private JLabel messageField;
    private JTextField proxyHostField;
    private JSpinner proxyPortField;
    private JCheckBox useUserAndPasswordBox;
    private JTextField proxyUsernameField;
    private JPasswordField proxyPasswordField;
    private JTextArea nonProxyHosts;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel buttonBar;
    private ValueModel tempProxyHostModel;
    private ValueModel tempProxyUsernameModel;
    private ValueModel tempProxyPasswordModel;
    private ValueModel tempNonProxyHostsModel;

    public HTTPProxySettingsDialog(Controller controller) {
        this(controller, controller.getUIController().getMainFrame().getUIComponent());
    }

    public HTTPProxySettingsDialog(Controller controller, Window window) {
        super(controller);
        this.parentFrame = window;
    }

    public void open() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.parentFrame, Translation.get("http.options.title"), Dialog.ModalityType.APPLICATION_MODAL);
            this.dialog.setContentPane(this.getUIComponent());
            this.dialog.pack();
            this.dialog.setResizable(false);
            if (this.parentFrame != null) {
                int n = this.parentFrame.getX() + (this.parentFrame.getWidth() - this.dialog.getWidth()) / 2;
                int n2 = this.parentFrame.getY() + (this.parentFrame.getHeight() - this.dialog.getHeight()) / 2;
                this.dialog.setLocation(n, n2);
            }
        }
        this.dialog.setVisible(true);
    }

    private JPanel getUIComponent() {
        if (this.panel == null) {
            this.initComponents();
            FormLayout formLayout = new FormLayout("r:p:grow, 3dlu, 80dlu", "p, 7dlu, p, 3dlu, p, 7dlu, p, 3dlu, p, 3dlu, p, 14dlu, p, 3dlu, fill:42dlu:grow, 21dlu, p");
            PanelBuilder panelBuilder = new PanelBuilder(formLayout);
            panelBuilder.setDefaultDialogBorder();
            CellConstraints cellConstraints = new CellConstraints();
            int n = 1;
            panelBuilder.add((Component)this.messageField, cellConstraints.xywh(1, n, 3, 1));
            panelBuilder.addLabel(Translation.get("http.options.host"), cellConstraints.xy(1, n += 2));
            panelBuilder.add((Component)this.proxyHostField, cellConstraints.xy(3, n));
            panelBuilder.addLabel(Translation.get("http.options.port"), cellConstraints.xy(1, n += 2));
            panelBuilder.add((Component)this.proxyPortField, cellConstraints.xy(3, n));
            panelBuilder.add((Component)this.useUserAndPasswordBox, cellConstraints.xy(3, n += 2));
            panelBuilder.addLabel(Translation.get("http.options.username"), cellConstraints.xy(1, n += 2));
            panelBuilder.add((Component)this.proxyUsernameField, cellConstraints.xy(3, n));
            panelBuilder.addLabel(Translation.get("http.options.password"), cellConstraints.xy(1, n += 2));
            panelBuilder.add((Component)this.proxyPasswordField, cellConstraints.xy(3, n));
            panelBuilder.addLabel(Translation.get("http.options.nonproxyhosts"), cellConstraints.xywh(1, n += 2, 3, 1));
            panelBuilder.add((Component)new JScrollPane(this.nonProxyHosts), cellConstraints.xywh(1, n += 2, 3, 1));
            panelBuilder.add((Component)this.buttonBar, cellConstraints.xyw(1, n += 2, 3));
            return panelBuilder.getPanel();
        }
        return this.panel;
    }

    private void initComponents() {
        boolean bl = HTTPProxySettings.requiresProxyAuthorization(this.getController());
        this.messageField = SimpleComponentFactory.createLabel("");
        this.messageField.setForeground(Color.RED);
        if (bl) {
            this.messageField.setText(Translation.get("http.options.authrequired"));
        }
        this.tempProxyHostModel = new ValueHolder(ConfigurationEntry.HTTP_PROXY_HOST.getValue(this.getController()), true);
        int n = ConfigurationEntry.HTTP_PROXY_PORT.getValueInt(this.getController());
        this.tempProxyUsernameModel = new ValueHolder(ConfigurationEntry.HTTP_PROXY_USERNAME.getValue(this.getController()), true);
        this.tempProxyPasswordModel = new ValueHolder(Util.toString(LoginUtil.deobfuscate(ConfigurationEntry.HTTP_PROXY_PASSWORD.getValue(this.getController()))), true);
        this.proxyHostField = BasicComponentFactory.createTextField(this.tempProxyHostModel);
        this.proxyPortField = new JSpinner(new SpinnerNumberModel(n, 0, 65536, 1));
        this.proxyPortField.setEditor(new JSpinner.NumberEditor(this.proxyPortField, "####0"));
        this.useUserAndPasswordBox = new JCheckBox(Translation.get("http.options.withauth"));
        this.useUserAndPasswordBox.setOpaque(false);
        this.useUserAndPasswordBox.setSelected(this.tempProxyUsernameModel.getValue() != null || bl);
        this.proxyUsernameField = BasicComponentFactory.createTextField(this.tempProxyUsernameModel);
        this.proxyPasswordField = BasicComponentFactory.createPasswordField(this.tempProxyPasswordModel);
        String string = ConfigurationEntry.HTTP_PROXY_NON_PROXY_HOSTS.getValue(this.getController());
        this.tempNonProxyHostsModel = new ValueHolder(string, true);
        this.nonProxyHosts = BasicComponentFactory.createTextArea(this.tempNonProxyHostsModel);
        this.okButton = new JButton(Translation.get("general.ok"));
        this.okButton.setMnemonic(Translation.get("general.ok.key").charAt(0));
        this.okButton.addActionListener(new OkAction());
        this.cancelButton = new JButton(Translation.get("general.cancel"));
        this.cancelButton.setMnemonic(Translation.get("general.cancel.key").charAt(0));
        this.cancelButton.addActionListener(new CancelAction());
        this.buttonBar = ButtonBarFactory.buildCenteredBar(this.okButton, this.cancelButton);
        this.buttonBar.setOpaque(false);
        this.updateComponents();
        this.initEventHandling();
    }

    private void initEventHandling() {
        this.useUserAndPasswordBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                HTTPProxySettingsDialog.this.updateComponents();
            }
        });
    }

    private void updateComponents() {
        this.proxyUsernameField.setEditable(this.useUserAndPasswordBox.isSelected());
        this.proxyPasswordField.setEditable(this.useUserAndPasswordBox.isSelected());
    }

    private void saveSettings() {
        boolean bl = StringUtils.isNotBlank(this.proxyHostField.getText());
        boolean bl2 = this.useUserAndPasswordBox.isSelected();
        if (bl) {
            String string = bl2 ? this.proxyUsernameField.getText() : null;
            String string2 = bl2 ? new String(this.proxyPasswordField.getPassword()) : "";
            String string3 = (String)this.tempNonProxyHostsModel.getValue();
            HTTPProxySettings.saveToConfig(this.getController(), this.proxyHostField.getText(), (Integer)this.proxyPortField.getValue(), string, string2, string3);
        } else {
            HTTPProxySettings.saveToConfig(this.getController(), null, 0, null, null, null);
        }
        this.getController().saveConfig();
    }

    private class OkAction
    extends AbstractAction {
        private OkAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HTTPProxySettingsDialog.this.saveSettings();
            if (!HTTPProxySettings.requiresProxyAuthorization(HTTPProxySettingsDialog.this.getController())) {
                HTTPProxySettingsDialog.this.dialog.setVisible(false);
                HTTPProxySettingsDialog.this.dialog.dispose();
            } else {
                HTTPProxySettingsDialog.this.messageField.setText(Translation.get("http.options.authfailed"));
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HTTPProxySettingsDialog.this.dialog.setVisible(false);
            HTTPProxySettingsDialog.this.dialog.dispose();
        }
    }
}

