/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.preferences;

import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.FolderRepository;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.panel.ArchiveModeSelectorPanel;
import de.dal33t.powerfolder.ui.preferences.PreferenceTab;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.util.SimpleComponentFactory;
import de.dal33t.powerfolder.ui.util.update.ManuallyInvokedUpdateHandler;
import de.dal33t.powerfolder.ui.widget.ActivityVisualizationWorker;
import de.dal33t.powerfolder.ui.widget.JButtonMini;
import de.dal33t.powerfolder.ui.wizard.PFWizard;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.os.OSUtil;
import de.dal33t.powerfolder.util.update.Updater;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class GeneralSettingsTab
extends PFUIComponent
implements PreferenceTab {
    private JPanel panel;
    private JTextField nickField;
    private JCheckBox runOnStartupBox;
    private JCheckBox updateCheck;
    private boolean originalQuitOnX;
    private JComponent locationField;
    private JTextField locationTF;
    private ValueModel locationModel;
    private JComboBox<String> xBehaviorChooser;
    private ArchiveModeSelectorPanel archiveModeSelectorPanel;
    private ValueModel versionModel;
    private JComboBox<String> archiveCleanupCombo;
    private Action cleanupAction;
    private JComboBox<Locale> languageChooser;
    private JCheckBox modeChooser;
    private JCheckBox verboseCB;
    private boolean originalVerbose;
    private boolean needsRestart;

    GeneralSettingsTab(Controller controller) {
        super(controller);
        this.initComponents();
    }

    @Override
    public String getTabName() {
        return Translation.get("preferences.general.title");
    }

    @Override
    public boolean needsRestart() {
        return this.needsRestart;
    }

    @Override
    public boolean validate() {
        return true;
    }

    private void initComponents() {
        this.languageChooser = this.createLanguageChooser();
        this.nickField = new JTextField(this.getController().getMySelf().getNick());
        this.updateCheck = new JCheckBox(Translation.get("preferences.general.check_for_program_updates"));
        this.updateCheck.setSelected(PreferencesEntry.CHECK_UPDATE.getValueBoolean(this.getController()));
        this.xBehaviorChooser = this.createXBehaviorChooser();
        this.originalVerbose = ConfigurationEntry.VERBOSE.getValueBoolean(this.getController());
        if (OSUtil.isStartupItemSupported()) {
            if (OSUtil.isMacOS()) {
                this.runOnStartupBox = new JCheckBox(Translation.get("preferences.general.start_with_macos"));
            }
            if (OSUtil.isWindowsSystem()) {
                this.runOnStartupBox = new JCheckBox(Translation.get("preferences.general.start_with_windows"));
            }
            if (OSUtil.isLinux()) {
                this.runOnStartupBox = new JCheckBox(Translation.get("preferences.general.start_with_linux"));
            }
            try {
                this.runOnStartupBox.setSelected(OSUtil.hasPFStartup(this.getController()));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.runOnStartupBox = null;
            }
        }
        this.versionModel = new ValueHolder();
        this.archiveModeSelectorPanel = new ArchiveModeSelectorPanel(this.getController(), this.versionModel);
        this.archiveModeSelectorPanel.setArchiveMode(ConfigurationEntry.DEFAULT_ARCHIVE_VERSIONS.getValueInt(this.getController()));
        this.locationModel = new ValueHolder(this.getController().getFolderRepository().getFoldersBasedirString());
        this.locationModel.addValueChangeListener(propertyChangeEvent -> this.updateLocationComponents());
        this.locationField = this.createLocationField();
        this.archiveCleanupCombo = new JComboBox();
        this.archiveCleanupCombo.addItem(Translation.get("preferences.general.archive_cleanup_day"));
        this.archiveCleanupCombo.addItem(Translation.get("preferences.general.archive_cleanup_week"));
        this.archiveCleanupCombo.addItem(Translation.get("preferences.general.archive_cleanup_month"));
        this.archiveCleanupCombo.addItem(Translation.get("preferences.general.archive_cleanup_year"));
        this.archiveCleanupCombo.addItem(Translation.get("preferences.general.archive_cleanup_never"));
        int n = ConfigurationEntry.DEFAULT_ARCHIVE_CLEANUP_DAYS.getValueInt(this.getController());
        switch (n) {
            case 1: {
                this.archiveCleanupCombo.setSelectedIndex(0);
                break;
            }
            case 7: {
                this.archiveCleanupCombo.setSelectedIndex(1);
                break;
            }
            default: {
                this.archiveCleanupCombo.setSelectedIndex(2);
                break;
            }
            case 365: {
                this.archiveCleanupCombo.setSelectedIndex(3);
                break;
            }
            case 0x7FFFFFFF: {
                this.archiveCleanupCombo.setSelectedIndex(4);
                break;
            }
            case 0: {
                this.archiveCleanupCombo.setSelectedIndex(4);
            }
        }
        this.cleanupAction = new MyCleanupAction(this.getController());
        this.modeChooser = new JCheckBox();
        this.modeChooser.setSelected(PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()));
        this.modeChooser.setText(Translation.get("preferences_show_advaned_options"));
        this.verboseCB = SimpleComponentFactory.createCheckBox(Translation.get("exp.preferences.advanced.verbose"));
        this.verboseCB.setSelected(ConfigurationEntry.VERBOSE.getValueBoolean(this.getController()));
    }

    @Override
    public JPanel getUIPanel() {
        if (this.panel == null) {
            FormLayout formLayout = new FormLayout("right:pref, 3dlu, 163dlu, pref:grow", "pref");
            PanelBuilder panelBuilder = new PanelBuilder(formLayout);
            panelBuilder.setBorder(Borders.createEmptyBorder("3dlu, 3dlu, 3dlu, 3dlu"));
            CellConstraints cellConstraints = new CellConstraints();
            int n = 1;
            if (!PreferencesEntry.WEBDAV_ONLY.getValueBoolean(this.getController()).booleanValue()) {
                panelBuilder.addLabel(Translation.get("exp.preferences.expert.base_dir"), cellConstraints.xy(1, n));
                panelBuilder.add((Component)this.locationField, cellConstraints.xyw(3, n, 2));
                n += 2;
                panelBuilder.appendUnrelatedComponentsGapRow();
                panelBuilder.appendRow("pref");
            }
            panelBuilder.addLabel(Translation.get("preferences.general.account_label"), cellConstraints.xy(1, n));
            panelBuilder.add((Component)this.createChangeAccountLogoutPanel(), cellConstraints.xyw(3, n, 2));
            panelBuilder.appendRelatedComponentsGapRow();
            panelBuilder.appendRow("pref");
            panelBuilder.addLabel(Translation.get("preferences.general.nickname"), cellConstraints.xy(1, n += 2));
            panelBuilder.add((Component)this.nickField, cellConstraints.xy(3, n));
            panelBuilder.appendUnrelatedComponentsGapRow();
            panelBuilder.appendRow("pref");
            panelBuilder.addLabel(Translation.get("preferences.general.language"), cellConstraints.xy(1, n += 2));
            panelBuilder.add(this.languageChooser, cellConstraints.xy(3, n));
            if (PreferencesEntry.VIEW_ACHIVE.getValueBoolean(this.getController()).booleanValue()) {
                panelBuilder.appendUnrelatedComponentsGapRow();
                panelBuilder.appendRow("pref");
                panelBuilder.addLabel(Translation.get("preferences.general.default_archive_mode_text"), cellConstraints.xy(1, n += 2, CellConstraints.RIGHT, CellConstraints.TOP));
                panelBuilder.add(GeneralSettingsTab.threePanel(this.archiveModeSelectorPanel.getUIComponent(), this.archiveCleanupCombo, new JButton(this.cleanupAction)), cellConstraints.xyw(3, n, 2));
            }
            if (OSUtil.isStartupItemSupported() && this.runOnStartupBox != null) {
                panelBuilder.appendUnrelatedComponentsGapRow();
                panelBuilder.appendRow("pref");
                panelBuilder.addLabel(Translation.get("preferences.general.start_behavior"), cellConstraints.xy(1, n += 2));
                panelBuilder.add((Component)this.runOnStartupBox, cellConstraints.xyw(3, n, 2));
            }
            panelBuilder.appendRelatedComponentsGapRow();
            panelBuilder.appendRow("pref");
            panelBuilder.addLabel(Translation.get("preferences.general.exit_behavior"), cellConstraints.xy(1, n += 2));
            panelBuilder.add(this.xBehaviorChooser, cellConstraints.xy(3, n));
            panelBuilder.appendUnrelatedComponentsGapRow();
            panelBuilder.appendRow("pref");
            panelBuilder.add((Component)this.verboseCB, cellConstraints.xy(3, n += 2));
            if (PreferencesEntry.MODE_SELECT.getValueBoolean(this.getController()).booleanValue()) {
                panelBuilder.appendRelatedComponentsGapRow();
                panelBuilder.appendRow("pref");
                panelBuilder.add((Component)this.modeChooser, cellConstraints.xy(3, n += 2));
            }
            if (PreferencesEntry.SHOW_UPDATE.getValueBoolean(this.getController()).booleanValue()) {
                panelBuilder.appendUnrelatedComponentsGapRow();
                panelBuilder.appendRow("pref");
                panelBuilder.addLabel(Translation.get("preferences.general.check_for_updates_text"), cellConstraints.xy(1, n += 2));
                panelBuilder.add((Component)this.updateCheck, cellConstraints.xy(3, n));
                panelBuilder.appendRelatedComponentsGapRow();
                panelBuilder.appendRow("pref");
                panelBuilder.add((Component)this.createUpdateCheckPanel(), cellConstraints.xyw(3, n += 2, 2));
            }
            this.panel = panelBuilder.getPanel();
        }
        return this.panel;
    }

    private JComponent createLocationField() {
        FormLayout formLayout = new FormLayout("140dlu, 3dlu, pref", "pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.locationTF = new JTextField();
        this.locationTF.setEditable(false);
        this.locationTF.setText((String)this.locationModel.getValue());
        panelBuilder.add((Component)this.locationTF, cellConstraints.xy(1, 1));
        JButtonMini jButtonMini = new JButtonMini(Icons.getIconById("directory.icon"), Translation.get("exp.preferences.expert.select_directory_text"));
        jButtonMini.addActionListener(new MyActionListener());
        panelBuilder.add((Component)jButtonMini, cellConstraints.xy(3, 1));
        return panelBuilder.getPanel();
    }

    private void updateLocationComponents() {
        String string = (String)this.locationModel.getValue();
        this.locationTF.setText(string);
    }

    private JPanel createUpdateCheckPanel() {
        FormLayout formLayout = new FormLayout("80dlu, 3dlu, pref", "pref, 3dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)new JLabel(Translation.get("exp.preferences.information.power_folder_text", "23.4.100")), cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.createCheckForUpdatesButton(), cellConstraints.xy(1, 3));
        return panelBuilder.getPanel();
    }

    private JButton createCheckForUpdatesButton() {
        JButton jButton = new JButton(Translation.get("preferences.general.check_for_updates_text"));
        jButton.setToolTipText(Translation.get("preferences.general.check_for_updates_tips"));
        jButton.setMnemonic(Translation.get("preferences.general.check_for_updates_key").trim().charAt(0));
        jButton.addActionListener(new UpdateAction());
        jButton.setBackground(Color.WHITE);
        return jButton;
    }

    private JPanel createChangeAccountLogoutPanel() {
        FormLayout formLayout = new FormLayout("80dlu, 3dlu, 80dlu", "pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.createChangeAccountButton(), cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.createLogoutButton(), cellConstraints.xy(3, 1));
        return panelBuilder.getPanel();
    }

    private JButton createChangeAccountButton() {
        JButton jButton = new JButton(Translation.get("preferences.general.change_account_text"));
        jButton.setToolTipText(Translation.get("preferences.general.change_account_tips"));
        jButton.setMnemonic(Translation.get("preferences.general.change_account_key").trim().charAt(0));
        jButton.addActionListener(new ChangeAccountAction());
        jButton.setBackground(Color.WHITE);
        return jButton;
    }

    private JButton createLogoutButton() {
        JButton jButton = new JButton(Translation.get("preferences.general.logout_text"));
        jButton.setToolTipText(Translation.get("preferences.general.logout_tips"));
        jButton.setMnemonic(Translation.get("preferences.general.logout_key").trim().charAt(0));
        jButton.addActionListener(new LogoutAction());
        jButton.setBackground(Color.WHITE);
        return jButton;
    }

    private JComboBox<Locale> createLanguageChooser() {
        JComboBox<Locale> jComboBox = new JComboBox<Locale>();
        for (Locale locale : Translation.getSupportedLocales()) {
            jComboBox.addItem(locale);
        }
        jComboBox.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 100L;

            @Override
            public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent(jList, object, n, bl, bl2);
                if (object instanceof Locale) {
                    Locale locale = (Locale)object;
                    this.setText(locale.getDisplayName(locale));
                } else {
                    this.setText("- unknown -");
                }
                return this;
            }
        });
        jComboBox.setSelectedItem(Translation.getActiveLocale());
        return jComboBox;
    }

    private static Component threePanel(Component component, Component component2, Component component3) {
        FormLayout formLayout = new FormLayout("80dlu, 3dlu, 80dlu", "pref, 3dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add(component, cellConstraints.xy(1, 1));
        panelBuilder.add(component2, cellConstraints.xy(3, 1));
        panelBuilder.add(component3, cellConstraints.xy(1, 3));
        return panelBuilder.getPanel();
    }

    @Override
    public void undoChanges() {
    }

    @Override
    public void save() {
        if (!StringUtils.isBlank(this.nickField.getText())) {
            this.getController().changeNick(this.nickField.getText(), false);
        }
        if (this.originalVerbose ^ this.verboseCB.isSelected()) {
            this.needsRestart = true;
        }
        ConfigurationEntry.VERBOSE.setValue(this.getController(), Boolean.toString(this.verboseCB.isSelected()));
        if (this.languageChooser.getSelectedItem() instanceof Locale) {
            Locale locale = (Locale)this.languageChooser.getSelectedItem();
            this.needsRestart |= !Util.equals(locale, Translation.getActiveLocale());
            Translation.saveLocalSetting(locale);
        } else {
            Translation.saveLocalSetting(null);
        }
        PreferencesEntry.CHECK_UPDATE.setValue(this.getController(), this.updateCheck.isSelected());
        PreferencesEntry.QUIT_ON_X.setValue(this.getController(), this.xBehaviorChooser.getSelectedIndex() == 0);
        if (this.xBehaviorChooser.getSelectedIndex() == 0 ^ this.originalQuitOnX) {
            this.needsRestart = true;
        }
        int n = this.archiveCleanupCombo.getSelectedIndex();
        switch (n) {
            case 0: {
                ConfigurationEntry.DEFAULT_ARCHIVE_CLEANUP_DAYS.setValue(this.getController(), 1);
                break;
            }
            case 1: {
                ConfigurationEntry.DEFAULT_ARCHIVE_CLEANUP_DAYS.setValue(this.getController(), 7);
                break;
            }
            default: {
                ConfigurationEntry.DEFAULT_ARCHIVE_CLEANUP_DAYS.setValue(this.getController(), 31);
                break;
            }
            case 3: {
                ConfigurationEntry.DEFAULT_ARCHIVE_CLEANUP_DAYS.setValue(this.getController(), 365);
                break;
            }
            case 4: {
                ConfigurationEntry.DEFAULT_ARCHIVE_CLEANUP_DAYS.setValue(this.getController(), 0);
            }
        }
        try {
            ConfigurationEntry.DEFAULT_ARCHIVE_VERSIONS.setValue(this.getController(), this.versionModel.getValue().toString());
        }
        catch (Exception exception) {
            this.logWarning("Unable to store archive settings: " + exception);
        }
        if (OSUtil.isStartupItemSupported() && this.runOnStartupBox != null) {
            boolean bl;
            boolean bl2 = this.runOnStartupBox.isSelected();
            boolean bl3 = bl = OSUtil.hasPFStartup(this.getController()) != bl2;
            if (bl) {
                try {
                    OSUtil.setPFStartup(this.runOnStartupBox.isSelected(), this.getController());
                }
                catch (IOException iOException) {
                    this.logWarning(iOException.getMessage());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    this.logWarning(unsupportedOperationException.getMessage());
                    DialogFactory.genericDialog(this.getController(), Translation.get("exception.startup_item.title"), unsupportedOperationException.getMessage(), new String[]{Translation.get("general.ok")}, 0, GenericDialogType.INFO);
                }
            }
        }
        FolderRepository folderRepository = this.getController().getFolderRepository();
        String string = folderRepository.getFoldersBasedirString();
        Path path = folderRepository.getFoldersBasedir();
        String string2 = path.getFileName() != null ? path.getFileName().toString() : path.toString();
        String string3 = (String)this.locationModel.getValue();
        Path path2 = Paths.get(string3, new String[0]);
        if (!StringUtils.isEqual(string, string3)) {
            int n2;
            long l = 0L;
            long l2 = 0L;
            int n3 = 0;
            for (Folder folder : folderRepository.getFolders()) {
                if (!PathUtils.isSubdirectory(folderRepository.getFoldersBasedir(), folder.getLocalBase())) {
                    this.logWarning("Skipping: " + folder + " @ " + folder.getLocalBase());
                    continue;
                }
                l += folder.getStatistic().getTotalSize();
                l2 += (long)folder.getKnownItemCount();
                ++n3;
            }
            if (n3 > 0) {
                boolean bl = false;
                try {
                    long l3;
                    if (!Files.getFileStore(folderRepository.getFoldersBasedir()).equals(Files.getFileStore(path2)) && (l3 = Files.getFileStore(path2).getUsableSpace()) < l) {
                        DialogFactory.genericDialog(this.getController(), Translation.get("settings_tab.move_basedir_error_title"), Translation.get("settings_tab.move_basedir_error_message_space", string3), GenericDialogType.ERROR);
                        bl = true;
                    }
                }
                catch (IOException iOException) {
                    this.logWarning("Unable to access " + path2 + ": " + iOException);
                    DialogFactory.genericDialog(this.getController(), Translation.get("settings_tab.move_basedir_error_title"), Translation.get("settings_tab.move_basedir_error_message_access", string3, iOException.toString()), GenericDialogType.ERROR);
                    bl = true;
                }
                if (!bl) {
                    String[] stringArray = new String[]{Translation.get("general.yes"), Translation.get("general.no"), Translation.get("general.cancel")};
                    n2 = DialogFactory.genericDialog(this.getController(), Translation.get("settings_tab.move_basedir_title"), Translation.get("settings_tab.move_basedir_message", string, string3, String.valueOf(n3), String.valueOf(l2), Format.formatBytesShort(l)), stringArray, 0, GenericDialogType.QUESTION);
                } else {
                    n2 = 2;
                }
            } else {
                n2 = 1;
            }
            if (n2 == 0 || n2 == 1) {
                if (n2 == 0) {
                    new MoveFoldersWorker(path2).start();
                } else {
                    Path path3 = folderRepository.getFoldersBasedir().resolve("Getting started.pdf");
                    if (Files.exists(path3, new LinkOption[0])) {
                        try {
                            Files.delete(path3);
                        }
                        catch (IOException iOException) {
                            this.logFine("Unable to delete " + path3);
                        }
                    }
                    folderRepository.setFoldersBasedir(string3);
                    folderRepository.updateShortcuts(string2);
                }
            } else {
                this.locationModel.setValue(string);
            }
        }
        if (PreferencesEntry.MODE_SELECT.getValueBoolean(this.getController()).booleanValue()) {
            boolean bl = PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController());
            if (this.modeChooser.isSelected()) {
                PreferencesEntry.EXPERT_MODE.setValue(this.getController(), true);
                if (!bl) {
                    this.needsRestart = true;
                }
            } else {
                PreferencesEntry.EXPERT_MODE.setValue(this.getController(), false);
                if (bl) {
                    this.needsRestart = true;
                }
            }
        }
        this.getController().saveConfig();
    }

    private JComboBox<String> createXBehaviorChooser() {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement(Translation.get("preferences.general.exit_behavior_exit"));
        if (OSUtil.isSystraySupported()) {
            defaultComboBoxModel.addElement(Translation.get("preferences.general.exit_behavior_minimize"));
        }
        JComboBox<String> jComboBox = new JComboBox<String>(defaultComboBoxModel);
        jComboBox.setEnabled(OSUtil.isSystraySupported());
        if (OSUtil.isSystraySupported() && !PreferencesEntry.QUIT_ON_X.getValueBoolean(this.getController()).booleanValue()) {
            jComboBox.setSelectedIndex(1);
        }
        this.originalQuitOnX = jComboBox.getSelectedIndex() == 0;
        return jComboBox;
    }

    private static class MyCleanupAction
    extends BaseAction {
        private static final long serialVersionUID = 10L;

        private MyCleanupAction(Controller controller) {
            super("action_cleanup_archive", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = DialogFactory.genericDialog(this.getController(), Translation.get("settings_tab.purge_archive_title"), Translation.get("settings_tab.purge_archive_message"), new String[]{Translation.get("settings_tab.purge_archive_purge"), Translation.get("general.cancel")}, 0, GenericDialogType.WARN);
            if (n == 0) {
                SwingUtilities.invokeLater(() -> this.getController().getFolderRepository().cleanupOldFiles(true));
            }
        }
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)GeneralSettingsTab.this.locationModel.getValue();
            List<Path> list = DialogFactory.chooseDirectory(GeneralSettingsTab.this.getController().getUIController(), string, false);
            if (!list.isEmpty()) {
                Path path = list.get(0);
                for (Folder folder : GeneralSettingsTab.this.getController().getFolderRepository().getFolders(true)) {
                    if (!folder.getLocalBase().equals(path)) continue;
                    DialogFactory.genericDialog(GeneralSettingsTab.this.getController(), Translation.get("exp.preferences.expert.duplicate_local_base_title"), Translation.get("exp.preferences.expert.duplicate_local_base_message", folder.getName()), GenericDialogType.ERROR);
                    return;
                }
                GeneralSettingsTab.this.locationModel.setValue(path.toAbsolutePath().toString());
            }
        }
    }

    private class UpdateAction
    implements ActionListener {
        private UpdateAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (GeneralSettingsTab.this.getController().getUpdateSettings() != null) {
                ManuallyInvokedUpdateHandler manuallyInvokedUpdateHandler = new ManuallyInvokedUpdateHandler(GeneralSettingsTab.this.getController());
                Updater updater = new Updater(GeneralSettingsTab.this.getController(), manuallyInvokedUpdateHandler);
                updater.start();
            }
            PreferencesEntry.CHECK_UPDATE.setValue(GeneralSettingsTab.this.getController(), true);
        }
    }

    private class ChangeAccountAction
    implements ActionListener {
        private ChangeAccountAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PFWizard.openLoginWizard(GeneralSettingsTab.this.getController(), GeneralSettingsTab.this.getController().getOSClient());
        }
    }

    private class LogoutAction
    implements ActionListener {
        private LogoutAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SwingWorker<Object, Object> swingWorker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    GeneralSettingsTab.this.getController().getOSClient().logout();
                    return null;
                }
            };
            swingWorker.execute();
        }
    }

    private final class MoveFoldersWorker
    extends ActivityVisualizationWorker {
        private final Path newFoldersBasePath;
        private String failed;

        private MoveFoldersWorker(Path path) {
            super(GeneralSettingsTab.this.getUIController());
            this.failed = "";
            this.newFoldersBasePath = path;
        }

        @Override
        protected String getTitle() {
            return Translation.get("settings_tab.working.title");
        }

        @Override
        protected String getWorkingText() {
            return Translation.get("settings_tab.working.description");
        }

        @Override
        public Object construct() {
            FolderRepository folderRepository = GeneralSettingsTab.this.getController().getFolderRepository();
            folderRepository.setSuspendNewFolderSearch(true);
            for (Folder object2 : folderRepository.getFolders()) {
                if (!PathUtils.isSubdirectory(folderRepository.getFoldersBasedir(), object2.getLocalBase())) continue;
                Path path = this.newFoldersBasePath.resolve(object2.getLocalBase().getFileName());
                if (object2.getLocalBase().equals(path)) continue;
                GeneralSettingsTab.this.logInfo("Moving " + object2.getName() + " from " + object2.getLocalBase() + " to " + path);
                if (folderRepository.moveLocalFolder(object2, path) != null) continue;
                this.failed = this.failed + object2.getLocalizedName() + "\n";
            }
            folderRepository.setSuspendNewFolderSearch(false);
            Path path = folderRepository.getFoldersBasedir().resolve("Getting started.pdf");
            if (Files.exists(path, new LinkOption[0])) {
                try {
                    Files.delete(path);
                }
                catch (IOException iOException) {
                    GeneralSettingsTab.this.logFine("Unable to delete " + (Path)path);
                }
            }
            String string = folderRepository.getFoldersBasedir().getFileName().toString();
            folderRepository.setFoldersBasedir(this.newFoldersBasePath.toString());
            folderRepository.updateShortcuts(string);
            return null;
        }

        @Override
        public void finished() {
            if (StringUtils.isBlank(this.failed)) {
                return;
            }
            DialogFactory.genericDialog(GeneralSettingsTab.this.getController(), Translation.get("settings_tab.move_basedir_error_title"), Translation.get("settings_tab.move_basedir_error_message_list", this.failed), GenericDialogType.ERROR);
        }
    }
}

