/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.preferences;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.ui.preferences.PreferenceTab;
import de.dal33t.powerfolder.ui.util.SimpleComponentFactory;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.os.OSUtil;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class ExpertSettingsTab
extends PFComponent
implements PreferenceTab {
    private JPanel panel;
    private JCheckBox useZipOnInternetCB;
    private JCheckBox useZipOnLanCB;
    private JCheckBox useDeltaSyncOnLanCB;
    private JCheckBox useDeltaSyncOnInternetCB;
    private JCheckBox useSwarmingOnLanCB;
    private JCheckBox useSwarmingOnInternetCB;
    private JCheckBox conflictDetectionCB;
    private JCheckBox usePowerFolderIconCB;
    private JCheckBox folderAutoSetupCB;
    private JCheckBox autoDetectFoldersCB;
    private JCheckBox allowFoldersOutsideDefaultCB;
    private boolean needsRestart;

    public ExpertSettingsTab(Controller controller) {
        super(controller);
        this.initComponents();
    }

    @Override
    public String getTabName() {
        return Translation.get("exp.preferences.expert_title");
    }

    @Override
    public boolean needsRestart() {
        return this.needsRestart;
    }

    @Override
    public void undoChanges() {
    }

    @Override
    public boolean validate() {
        return true;
    }

    private void initComponents() {
        if (OSUtil.isWindowsSystem()) {
            this.usePowerFolderIconCB = new JCheckBox(Translation.get("exp.preferences.expert.use_pf_icon"), (boolean)ConfigurationEntry.USE_PF_ICON.getValueBoolean(this.getController()));
        }
        this.conflictDetectionCB = new JCheckBox(Translation.get("exp.preferences.expert.use_conflict_handling"));
        this.conflictDetectionCB.setSelected(ConfigurationEntry.CONFLICT_DETECTION.getValueBoolean(this.getController()));
        this.useZipOnLanCB = SimpleComponentFactory.createCheckBox(Translation.get("exp.preferences.expert.use_zip_on_lan"));
        this.useZipOnLanCB.setToolTipText(Translation.get("exp.preferences.expert.use_zip_on_lan_tooltip"));
        this.useZipOnLanCB.setSelected(ConfigurationEntry.USE_ZIP_ON_LAN.getValueBoolean(this.getController()));
        this.useZipOnInternetCB = SimpleComponentFactory.createCheckBox(Translation.get("exp.preferences.expert.use_zip_on_internet"));
        this.useZipOnInternetCB.setSelected(true);
        this.useZipOnInternetCB.setEnabled(false);
        this.useDeltaSyncOnLanCB = SimpleComponentFactory.createCheckBox(Translation.get("exp.preferences.expert.use_delta_on_lan"));
        this.useDeltaSyncOnLanCB.setToolTipText(Translation.get("exp.preferences.expert.use_delta_on_lan_tooltip"));
        this.useDeltaSyncOnLanCB.setSelected(ConfigurationEntry.USE_DELTA_ON_LAN.getValueBoolean(this.getController()));
        this.useDeltaSyncOnInternetCB = SimpleComponentFactory.createCheckBox(Translation.get("exp.preferences.expert.use_delta_on_internet"));
        this.useDeltaSyncOnInternetCB.setToolTipText(Translation.get("exp.preferences.expert.use_delta_on_internet_tooltip"));
        this.useDeltaSyncOnInternetCB.setSelected(ConfigurationEntry.USE_DELTA_ON_INTERNET.getValueBoolean(this.getController()));
        this.useSwarmingOnLanCB = SimpleComponentFactory.createCheckBox(Translation.get("exp.preferences.expert.swarming_lan"));
        this.useSwarmingOnLanCB.setToolTipText(Translation.get("exp.preferences.expert.swarming_lan_tooltip"));
        this.useSwarmingOnLanCB.setSelected(ConfigurationEntry.USE_SWARMING_ON_LAN.getValueBoolean(this.getController()));
        this.useSwarmingOnInternetCB = SimpleComponentFactory.createCheckBox(Translation.get("exp.preferences.expert.swarming_internet"));
        this.useSwarmingOnInternetCB.setToolTipText(Translation.get("exp.preferences.expert.swarming_internet_tooltip"));
        this.useSwarmingOnInternetCB.setSelected(ConfigurationEntry.USE_SWARMING_ON_INTERNET.getValueBoolean(this.getController()));
        this.folderAutoSetupCB = new JCheckBox(Translation.get("exp.preferences.expert.auto_setup_folders"), (boolean)ConfigurationEntry.AUTO_SETUP_ACCOUNT_FOLDERS.getValueBoolean(this.getController()));
        this.autoDetectFoldersCB = new JCheckBox(Translation.get("exp.preferences.expert.auto_detect_folders"), (boolean)ConfigurationEntry.LOOK_FOR_FOLDER_CANDIDATES.getValueBoolean(this.getController()));
        this.allowFoldersOutsideDefaultCB = new JCheckBox(Translation.get("exp.dialog.expert.allow_folders_outside_default"), ConfigurationEntry.FOLDER_CREATE_IN_BASEDIR_ONLY.getValueBoolean(this.getController()) == false);
    }

    @Override
    public JPanel getUIPanel() {
        if (this.panel == null) {
            String string = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref";
            FormLayout formLayout = new FormLayout("right:pref, 3dlu, 140dlu, pref:grow", string);
            PanelBuilder panelBuilder = new PanelBuilder(formLayout);
            panelBuilder.setBorder(Borders.createEmptyBorder("3dlu, 3dlu, 3dlu, 3dlu"));
            CellConstraints cellConstraints = new CellConstraints();
            int n = 1;
            panelBuilder.add((Component)this.autoDetectFoldersCB, cellConstraints.xyw(3, n, 2));
            panelBuilder.add((Component)this.allowFoldersOutsideDefaultCB, cellConstraints.xyw(3, n += 2, 2));
            panelBuilder.add((Component)this.conflictDetectionCB, cellConstraints.xyw(3, n += 2, 2));
            panelBuilder.add((Component)this.folderAutoSetupCB, cellConstraints.xyw(3, n += 2, 2));
            panelBuilder.addLabel(Translation.get("exp.preferences.expert.zip_compression"), cellConstraints.xy(1, n += 2));
            ButtonBarBuilder buttonBarBuilder = ButtonBarBuilder.createLeftToRightBuilder();
            buttonBarBuilder.addGridded(this.useZipOnInternetCB);
            buttonBarBuilder.addRelatedGap();
            buttonBarBuilder.addGridded(this.useZipOnLanCB);
            panelBuilder.add((Component)buttonBarBuilder.getPanel(), cellConstraints.xyw(3, n, 2));
            panelBuilder.addLabel(Translation.get("exp.preferences.expert.delta_sync"), cellConstraints.xy(1, n += 2));
            ButtonBarBuilder buttonBarBuilder2 = ButtonBarBuilder.createLeftToRightBuilder();
            buttonBarBuilder2.addGridded(this.useDeltaSyncOnInternetCB);
            buttonBarBuilder2.addRelatedGap();
            buttonBarBuilder2.addGridded(this.useDeltaSyncOnLanCB);
            panelBuilder.add((Component)buttonBarBuilder2.getPanel(), cellConstraints.xyw(3, n, 2));
            panelBuilder.addLabel(Translation.get("exp.preferences.expert.swarming"), cellConstraints.xy(1, n += 2));
            ButtonBarBuilder buttonBarBuilder3 = ButtonBarBuilder.createLeftToRightBuilder();
            buttonBarBuilder3.addGridded(this.useSwarmingOnInternetCB);
            buttonBarBuilder3.addRelatedGap();
            buttonBarBuilder3.addGridded(this.useSwarmingOnLanCB);
            panelBuilder.add((Component)buttonBarBuilder3.getPanel(), cellConstraints.xyw(3, n, 2));
            if (this.usePowerFolderIconCB != null) {
                panelBuilder.add((Component)this.usePowerFolderIconCB, cellConstraints.xyw(3, n += 2, 2));
            }
            this.panel = panelBuilder.getPanel();
        }
        return this.panel;
    }

    @Override
    public void save() {
        ConfigurationEntry.CONFLICT_DETECTION.setValue(this.getController(), this.conflictDetectionCB.isSelected());
        boolean bl = ConfigurationEntry.USE_ZIP_ON_LAN.getValueBoolean(this.getController());
        if (bl != this.useZipOnLanCB.isSelected()) {
            ConfigurationEntry.USE_ZIP_ON_LAN.setValue(this.getController(), String.valueOf(this.useZipOnLanCB.isSelected()));
        }
        if (this.usePowerFolderIconCB != null) {
            ConfigurationEntry.USE_PF_ICON.setValue(this.getController(), Boolean.toString(this.usePowerFolderIconCB.isSelected()));
        }
        if ((bl = ConfigurationEntry.USE_DELTA_ON_LAN.getValueBoolean(this.getController()).booleanValue()) != this.useDeltaSyncOnLanCB.isSelected()) {
            ConfigurationEntry.USE_DELTA_ON_LAN.setValue(this.getController(), String.valueOf(this.useDeltaSyncOnLanCB.isSelected()));
            this.needsRestart = true;
        }
        if ((bl = ConfigurationEntry.USE_DELTA_ON_INTERNET.getValueBoolean(this.getController()).booleanValue()) != this.useDeltaSyncOnInternetCB.isSelected()) {
            ConfigurationEntry.USE_DELTA_ON_INTERNET.setValue(this.getController(), Boolean.toString(this.useDeltaSyncOnInternetCB.isSelected()));
            this.needsRestart = true;
        }
        if ((bl = ConfigurationEntry.USE_SWARMING_ON_LAN.getValueBoolean(this.getController()).booleanValue()) != this.useSwarmingOnLanCB.isSelected()) {
            ConfigurationEntry.USE_SWARMING_ON_LAN.setValue(this.getController(), String.valueOf(this.useSwarmingOnLanCB.isSelected()));
            this.needsRestart = true;
        }
        if ((bl = ConfigurationEntry.USE_SWARMING_ON_INTERNET.getValueBoolean(this.getController()).booleanValue()) != this.useSwarmingOnInternetCB.isSelected()) {
            ConfigurationEntry.USE_SWARMING_ON_INTERNET.setValue(this.getController(), Boolean.toString(this.useSwarmingOnInternetCB.isSelected()));
            this.needsRestart = true;
        }
        ConfigurationEntry.FOLDER_CREATE_IN_BASEDIR_ONLY.setValue(this.getController(), !this.allowFoldersOutsideDefaultCB.isSelected());
        ConfigurationEntry.AUTO_SETUP_ACCOUNT_FOLDERS.setValue(this.getController(), this.folderAutoSetupCB.isSelected());
        if (this.folderAutoSetupCB.isSelected() && this.getController().getOSClient().isLoggedIn()) {
            this.getController().schedule(() -> this.getController().getFolderRepository().updateFolders(this.getController().getOSClient().getAccountDetails()), 0L);
        }
        boolean bl2 = ConfigurationEntry.LOOK_FOR_FOLDER_CANDIDATES.getValueBoolean(this.getController());
        ConfigurationEntry.LOOK_FOR_FOLDER_CANDIDATES.setValue(this.getController(), this.autoDetectFoldersCB.isSelected());
        if (bl2 ^ this.autoDetectFoldersCB.isSelected()) {
            this.needsRestart = true;
        }
    }
}

