/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.notification;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.ui.notices.Notice;
import de.dal33t.powerfolder.ui.notification.NotificationHandlerBase;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Translation;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class SystemNotificationHandler
extends NotificationHandlerBase {
    public SystemNotificationHandler(Controller controller, final Notice notice) {
        super(controller);
        Reject.ifNull(notice, "Notice must not be null");
        this.setTitle(notice.getTitle());
        this.setMessageText(notice.getSummary());
        if (notice.isActionable()) {
            this.setAcceptAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SystemNotificationHandler.this.sliderClose();
                    SystemNotificationHandler.this.getController().getUIController().getApplicationModel().getNoticesModel().activateNotice(notice);
                }
            });
            this.setAcceptOptionLabel(Translation.get("notification_handler.display.text"));
            this.setCancelOptionLabel(Translation.get("notification_handler.ignore.text"));
            this.setCancelAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SystemNotificationHandler.this.sliderClose();
                    SystemNotificationHandler.this.getController().getUIController().getApplicationModel().getNoticesModel().markRead(notice);
                }
            });
        } else {
            this.setAcceptOptionLabel(Translation.get("general.ok"));
            this.setAcceptAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SystemNotificationHandler.this.sliderClose();
                }
            });
        }
    }
}

