/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.model;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.event.NodeManagerAdapter;
import de.dal33t.powerfolder.event.NodeManagerEvent;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.compare.MemberComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class NodesSelectTableModel
implements TableModel {
    private final Controller controller;
    private final List<Member> nodes = new ArrayList<Member>();
    private boolean hideOffline;
    private final List<TableModelListener> listeners = new LinkedList<TableModelListener>();
    private static final String[] COLUMN_NAMES = new String[]{Translation.get("friend_search.node_table.name")};

    public NodesSelectTableModel(Controller controller) {
        this.controller = controller;
        controller.getNodeManager().addNodeManagerListener(new MyNodeManagerListener());
        this.reset();
    }

    private void reset() {
        this.nodes.clear();
        Member[] memberArray = this.controller.getNodeManager().getFriends();
        for (Member member : memberArray) {
            if (this.hideOffline) {
                if (!member.isConnectedToNetwork()) continue;
                this.nodes.add(member);
                continue;
            }
            this.nodes.add(member);
        }
        for (Member member : this.controller.getNodeManager().getConnectedNodes()) {
            if (!member.isOnLAN() || this.nodes.contains(member)) continue;
            this.nodes.add(member);
        }
        Collections.sort(this.nodes, MemberComparator.IN_GUI);
        this.fireModelStructureChanged();
    }

    public void setHideOffline(boolean bl) {
        boolean bl2 = this.hideOffline;
        this.hideOffline = bl;
        if (bl2 != this.hideOffline) {
            this.reset();
        }
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listeners.add(tableModelListener);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return Member.class;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public int getRowCount() {
        return Math.max(this.nodes.size(), 1);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.nodes.isEmpty()) {
            return Translation.get("exp.friend_search.no_computers_found");
        }
        int n3 = 0;
        for (Member member : this.nodes) {
            if (n3++ != n) continue;
            return member;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listeners.remove(tableModelListener);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        throw new IllegalStateException("not editable");
    }

    private void fireModelStructureChanged() {
        TableModelEvent tableModelEvent = new TableModelEvent(this);
        this.fireTableModelEvent(tableModelEvent);
    }

    private void fireTableModelEvent(TableModelEvent tableModelEvent) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TableModelListener tableModelListener = this.listeners.get(i);
            tableModelListener.tableChanged(tableModelEvent);
        }
    }

    private class MyNodeManagerListener
    extends NodeManagerAdapter {
        private MyNodeManagerListener() {
        }

        @Override
        public void nodeRemoved(NodeManagerEvent nodeManagerEvent) {
            if (NodesSelectTableModel.this.nodes.remove(nodeManagerEvent.getNode())) {
                NodesSelectTableModel.this.fireModelStructureChanged();
            }
        }

        @Override
        public void nodeAdded(NodeManagerEvent nodeManagerEvent) {
            this.addNodeIfRequired(nodeManagerEvent.getNode());
        }

        @Override
        public void nodeConnected(NodeManagerEvent nodeManagerEvent) {
            this.addNodeIfRequired(nodeManagerEvent.getNode());
        }

        @Override
        public void nodeDisconnected(NodeManagerEvent nodeManagerEvent) {
            if (NodesSelectTableModel.this.nodes.remove(nodeManagerEvent.getNode())) {
                NodesSelectTableModel.this.fireModelStructureChanged();
            }
        }

        @Override
        public void nodeOffline(NodeManagerEvent nodeManagerEvent) {
            this.addNodeIfRequired(nodeManagerEvent.getNode());
        }

        @Override
        public void nodeOnline(NodeManagerEvent nodeManagerEvent) {
            this.addNodeIfRequired(nodeManagerEvent.getNode());
        }

        @Override
        public void friendAdded(NodeManagerEvent nodeManagerEvent) {
            this.addNodeIfRequired(nodeManagerEvent.getNode());
        }

        @Override
        public void friendRemoved(NodeManagerEvent nodeManagerEvent) {
            if (NodesSelectTableModel.this.nodes.remove(nodeManagerEvent.getNode())) {
                NodesSelectTableModel.this.fireModelStructureChanged();
            }
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }

        private void addNodeIfRequired(Member member) {
            if (member.isFriend() || member.isOnLAN() && member.isCompletelyConnected()) {
                if (NodesSelectTableModel.this.hideOffline) {
                    if (member.isConnectedToNetwork() && !NodesSelectTableModel.this.nodes.contains(member)) {
                        NodesSelectTableModel.this.nodes.add(member);
                    }
                } else if (!NodesSelectTableModel.this.nodes.contains(member)) {
                    NodesSelectTableModel.this.nodes.add(member);
                }
                NodesSelectTableModel.this.fireModelStructureChanged();
            }
        }
    }
}

