/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.model;

import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.clientserver.ServerClientEvent;
import de.dal33t.powerfolder.clientserver.ServerClientListener;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.FolderRepository;
import de.dal33t.powerfolder.disk.FolderSettings;
import de.dal33t.powerfolder.disk.Lock;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.event.FolderRepositoryAdapter;
import de.dal33t.powerfolder.event.FolderRepositoryEvent;
import de.dal33t.powerfolder.event.LockingEvent;
import de.dal33t.powerfolder.event.LockingListener;
import de.dal33t.powerfolder.event.NodeManagerAdapter;
import de.dal33t.powerfolder.event.NodeManagerEvent;
import de.dal33t.powerfolder.event.OverallFolderStatListener;
import de.dal33t.powerfolder.event.PausedModeEvent;
import de.dal33t.powerfolder.event.PausedModeListener;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.FolderInfoFactory;
import de.dal33t.powerfolder.message.FileListRequest;
import de.dal33t.powerfolder.message.clientserver.AccountDetails;
import de.dal33t.powerfolder.security.AdminPermission;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.action.ActionModel;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.dialog.SyncFolderDialog;
import de.dal33t.powerfolder.ui.event.SyncStatusEvent;
import de.dal33t.powerfolder.ui.event.SyncStatusListener;
import de.dal33t.powerfolder.ui.model.LicenseModel;
import de.dal33t.powerfolder.ui.model.NodeManagerModel;
import de.dal33t.powerfolder.ui.model.NoticesModel;
import de.dal33t.powerfolder.ui.model.ServerClientModel;
import de.dal33t.powerfolder.ui.model.SyncingModel;
import de.dal33t.powerfolder.ui.model.TransferManagerModel;
import de.dal33t.powerfolder.ui.notices.CloudStorageNotice;
import de.dal33t.powerfolder.ui.notices.NoticeSeverity;
import de.dal33t.powerfolder.ui.notices.SimpleNotificationNotice;
import de.dal33t.powerfolder.ui.notices.WarningNotice;
import de.dal33t.powerfolder.ui.notification.NotificationHandlerBase;
import de.dal33t.powerfolder.ui.widget.ActivityVisualizationWorker;
import de.dal33t.powerfolder.ui.wizard.DesktopSyncSetupPanel;
import de.dal33t.powerfolder.ui.wizard.PFWizard;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.os.OSUtil;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;

public class ApplicationModel
extends PFUIComponent {
    private ActionModel actionModel = new ActionModel(this.getController());
    private SyncingModel syncingModel = new SyncingModel(this.getController());
    private NodeManagerModel nodeManagerModel = new NodeManagerModel(this.getController());
    private TransferManagerModel transferManagerModel = new TransferManagerModel(this.getController().getTransferManager());
    private ServerClientModel serverClientModel = new ServerClientModel(this.getController(), this.getController().getOSClient());
    private ValueModel systemNotificationsValueModel;
    private LicenseModel licenseModel;
    private NoticesModel noticesModel;
    private Date lastMouseAction;
    private Point lastMouseLocation;
    private final List<SyncStatusListener> syncStatusListeners;

    public ApplicationModel(final Controller controller) {
        super(controller);
        this.systemNotificationsValueModel = new ValueHolder(PreferencesEntry.SHOW_SYSTEM_NOTIFICATIONS.getValueBoolean(controller));
        this.systemNotificationsValueModel.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PreferencesEntry.SHOW_SYSTEM_NOTIFICATIONS.setValue(controller, (Boolean)propertyChangeEvent.getNewValue());
                controller.saveConfig();
            }
        });
        this.licenseModel = new LicenseModel();
        this.noticesModel = new NoticesModel(this.getController());
        this.syncStatusListeners = new CopyOnWriteArrayList<SyncStatusListener>();
    }

    public void initialize() {
        this.transferManagerModel.initialize();
        this.getController().getOSClient().addListener(new MyServerClientListener());
        this.getController().addPausedModeListener(new MyPausedModeListener());
        this.getController().getFolderRepository().addFolderRepositoryListener(new MyFolderRepositoryListener());
        this.getController().getNodeManager().addNodeManagerListener(new MyNodeManagerListener());
        this.getController().getFolderRepository().getLocking().addListener(new MyLockingListener());
        this.getApplicationModel().getSyncingModel().addOverallFolderStatListener(new MyOverallFolderStatListener());
        this.getNoticesModel().getUnreadNoticesCountVM().addValueChangeListener(new MyNoticesModelPropertyChangeListener());
        this.getNoticesModel().getAllNoticesCountVM().addValueChangeListener(new MyNoticesModelPropertyChangeListener());
    }

    public void syncFolder(Folder folder) {
        this.syncingModel.addInterestedFolderInfo(folder.getInfo());
        if (SyncProfile.MANUAL_SYNCHRONIZATION.equals(folder.getSyncProfile())) {
            new SyncFolderDialog(this.getController(), folder).open();
        } else {
            this.getController().setPaused(false);
            folder.broadcastScanCommand();
            folder.broadcastMessages(new FileListRequest(folder.getInfo()));
            folder.recommendScanOnNextMaintenance(true);
            this.getController().getFolderRepository().triggerMaintenance();
            this.getController().getFolderRepository().getFileRequestor().triggerFileRequesting(folder.getInfo());
        }
        Folder folder2 = this.getController().getFolderRepository().getMetaFolder(folder.getInfo());
        folder2.scanLocalFiles();
        folder2.syncRemoteDeletedFiles(true);
        folder2.getStatistic().scheduleCalculate();
        folder.getStatistic().scheduleCalculate();
    }

    public boolean isUserActive() {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo == null) {
            return true;
        }
        Point point = pointerInfo.getLocation();
        if (point == null) {
            return true;
        }
        if (this.lastMouseLocation == null) {
            this.lastMouseLocation = point;
            this.lastMouseAction = new Date();
            return true;
        }
        if (!point.equals(this.lastMouseLocation)) {
            this.lastMouseLocation = point;
            this.lastMouseAction = new Date();
            return true;
        }
        long l = (System.currentTimeMillis() - this.lastMouseAction.getTime()) / 1000L;
        return l <= 10L;
    }

    private void checkCloudSpace(ServerClientEvent serverClientEvent) {
        if (!PreferencesEntry.WARN_FULL_CLOUD.getValueBoolean(this.getController()).booleanValue()) {
            return;
        }
        ServerClient serverClient = serverClientEvent.getClient();
        if (serverClient == null || !serverClient.isLoggedIn()) {
            return;
        }
        AccountDetails accountDetails = serverClientEvent.getAccountDetails();
        if (!accountDetails.getAccount().hasOwnStorage()) {
            return;
        }
        long l = accountDetails.getAccount().getOSSubscription().getStorageSize();
        long l2 = accountDetails.getSpaceUsed();
        double d = 100.0 * (double)l2 / (double)l;
        if (l2 > l) {
            this.logWarning(accountDetails.getAccount() + String.format(": Storage quota exceeded: used = %d bytes, quota = %d bytes (%.2f%%)", l2, l, d));
            CloudStorageNotice.clear(this.noticesModel);
            this.noticesModel.handleNotice(CloudStorageNotice.full());
        } else if (d >= 90.0) {
            this.logWarning(accountDetails.getAccount() + String.format(": Storage usage is at %.2f%% of quota: used = %d bytes, quota = %d bytes", d, l2, l));
            this.noticesModel.handleNotice(CloudStorageNotice.almostFull());
        } else {
            CloudStorageNotice.clear(this.noticesModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveLocalFolder(Folder folder) {
        this.getController().getFolderRepository().setSuspendNewFolderSearch(true);
        try {
            Path path = folder.getCommitOrLocalDir();
            List<Path> list = DialogFactory.chooseDirectory(this.getController().getUIController(), path, false);
            if (!list.isEmpty()) {
                Path path2 = list.get(0);
                if (!folder.checkIfDeviceDisconnected() && PathUtils.isSubdirectory(path, path2)) {
                    DialogFactory.genericDialog(this.getController(), Translation.get("general.directory"), Translation.get("general.subdirectory_error.text"), GenericDialogType.ERROR);
                    return;
                }
                Path path3 = this.getController().getFolderRepository().getFoldersBasedir();
                if (path2.equals(path3)) {
                    DialogFactory.genericDialog(this.getController(), Translation.get("general.directory"), Translation.get("general.basedir_error.text"), GenericDialogType.ERROR);
                    return;
                }
                if (ConfigurationEntry.FOLDER_CREATE_IN_BASEDIR_ONLY.getValueBoolean(this.getController()).booleanValue() && !path2.getParent().equals(this.getController().getFolderRepository().getFoldersBasedir())) {
                    DialogFactory.genericDialog(this.getController(), Translation.get("general.directory"), Translation.get("general.outside_basedir_error.text", this.getController().getFolderRepository().getFoldersBasedirString()), GenericDialogType.ERROR);
                    return;
                }
                int n = this.shouldMoveContent();
                if (n == 2) {
                    return;
                }
                this.moveDirectory(path, path2, n == 0, folder);
            }
        }
        finally {
            try {
                this.getController().getFolderRepository().setSuspendNewFolderSearch(false);
            }
            catch (Exception exception) {
                this.logSevere(exception);
            }
        }
    }

    private int shouldMoveContent() {
        return DialogFactory.genericDialog(this.getController(), Translation.get("settings_tab.move_content.title"), Translation.get("settings_tab.move_content"), new String[]{Translation.get("settings_tab.move_content.move"), Translation.get("settings_tab.move_content.dont"), Translation.get("general.cancel")}, 0, GenericDialogType.INFO);
    }

    private void moveDirectory(Path path, Path path2, boolean bl, Folder folder) {
        if (!path2.equals(path) && this.checkNewLocalFolder(path2)) {
            try {
                FolderMoveWorker folderMoveWorker = new FolderMoveWorker(bl, path2, folder);
                folderMoveWorker.start();
            }
            catch (Exception exception) {
                DialogFactory.genericDialog(this.getController(), Translation.get("settings_tab.move_error.title"), Translation.get("settings_tab.move_error.temp"), this.getController().isVerbose(), exception);
            }
        }
    }

    private boolean shouldMoveLocal(Path path, Folder folder) {
        String string = Translation.get("settings_tab.confirm_local_folder_move.title");
        String string2 = Translation.get("settings_tab.confirm_local_folder_move.text", folder.getCommitOrLocalDir().toAbsolutePath().toString(), path.toAbsolutePath().toString());
        return DialogFactory.genericDialog(this.getController(), string, string2, new String[]{Translation.get("general.continue"), Translation.get("general.cancel")}, 0, GenericDialogType.INFO) == 0;
    }

    private boolean checkNewLocalFolder(Path path) {
        if (path != null && Files.exists(path, new LinkOption[0]) && PathUtils.getNumberOfSiblings(path) > 0) {
            int n = DialogFactory.genericDialog(this.getController(), Translation.get("exp.settings_tab.folder_not_empty.title"), Translation.get("exp.settings_tab.folder_not_empty", path.toAbsolutePath().toString()), new String[]{Translation.get("general.ok")}, 0, GenericDialogType.WARN);
            return n == 0;
        }
        return true;
    }

    private void displayError(Exception exception) {
        DialogFactory.genericDialog(this.getController(), Translation.get("settings_tab.move_error.title"), Translation.get("settings_tab.move_error.other", exception.getMessage()), GenericDialogType.WARN);
    }

    private Object transferFolder(Folder folder, Path path) {
        path = PathUtils.removeInvalidFilenameChars(path);
        try {
            boolean bl;
            if (Files.notExists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            FolderRepository folderRepository = this.getController().getFolderRepository();
            folderRepository.removeFolder(folder, false);
            Path path2 = null;
            boolean bl2 = bl = folder.getCommitDir() != null;
            if (bl) {
                path2 = path;
                path = path.resolve(".temp-dir");
                PathUtils.setAttributesOnWindows(path, true, true);
            }
            List<String> list = folder.getDiskItemFilter().getPatterns();
            FolderInfo folderInfo = FolderInfoFactory.copyFrom(folder);
            FolderSettings folderSettings = new FolderSettings(path, folder.getSyncProfile(), folder.getDownloadScript(), folder.getFileArchiver().getVersionsPerFile(), folder.isSyncPatterns(), path2, folder.getSyncWarnSeconds());
            folder = folderRepository.createFolder(folderInfo, folderSettings);
            if (list != null) {
                for (String string : list) {
                    folder.addPattern(string);
                }
            }
        }
        catch (Exception exception) {
            return exception;
        }
        return null;
    }

    public void openExplorer() {
        this.getController().getIOProvider().startIO(() -> PathUtils.openFile(this.getController().getFolderRepository().getFoldersBasedir()));
    }

    public void openExplorer(Folder folder) {
        Reject.ifNull(folder, "Folder");
        this.getController().getIOProvider().startIO(() -> PathUtils.openFile(folder.getCommitOrLocalDir()));
    }

    public void openExplorerWebDAVPath(FolderInfo folderInfo) {
        Reject.ifNull(folderInfo, "Folder");
        if (!OSUtil.isWindowsSystem()) {
            return;
        }
        this.getController().getIOProvider().startIO(() -> {
            char c = this.getController().getDistribution().getBinaryName().charAt(0);
            Path path = Paths.get(c + ":\\" + folderInfo.getLocalizedName(), new String[0]);
            if (Files.notExists(path, new LinkOption[0])) {
                path = Paths.get(c + ":\\", new String[0]);
            }
            PathUtils.openFile(path);
        });
    }

    public void openExplorerWebDAVPath() {
        if (!OSUtil.isWindowsSystem()) {
            return;
        }
        this.getController().getIOProvider().startIO(() -> {
            char c = this.getController().getDistribution().getBinaryName().charAt(0);
            Path path = Paths.get(c + ":\\", new String[0]);
            PathUtils.openFile(path);
        });
    }

    public ActionModel getActionModel() {
        return this.actionModel;
    }

    public SyncingModel getSyncingModel() {
        return this.syncingModel;
    }

    public NodeManagerModel getNodeManagerModel() {
        return this.nodeManagerModel;
    }

    public TransferManagerModel getTransferManagerModel() {
        return this.transferManagerModel;
    }

    public ServerClientModel getServerClientModel() {
        return this.serverClientModel;
    }

    public ValueModel getSystemNotificationsValueModel() {
        return this.systemNotificationsValueModel;
    }

    public LicenseModel getLicenseModel() {
        return this.licenseModel;
    }

    public NoticesModel getNoticesModel() {
        return this.noticesModel;
    }

    public void addSyncStatusListener(SyncStatusListener syncStatusListener) {
        this.syncStatusListeners.add(syncStatusListener);
    }

    public void removeSyncStatusListener(SyncStatusListener syncStatusListener) {
        this.syncStatusListeners.remove(syncStatusListener);
    }

    private void handleSyncStatusChange() {
        FolderRepository folderRepository = this.getController().getFolderRepository();
        ServerClient serverClient = this.getController().getOSClient();
        boolean bl = serverClient.isConnected();
        boolean bl2 = serverClient.isLoggingIn();
        boolean bl3 = serverClient.isLoggedIn();
        boolean bl4 = this.getNoticesModel().getHighestUnreadSeverity() != null || folderRepository.getFolderProblemsCount() > 0;
        SyncStatusEvent syncStatusEvent = SyncStatusEvent.SYNC_INCOMPLETE;
        if (this.getController().isPaused() && !bl4) {
            syncStatusEvent = SyncStatusEvent.PAUSED;
        } else if (!this.getController().getNodeManager().isStarted()) {
            syncStatusEvent = SyncStatusEvent.NOT_STARTED;
        } else if (!bl) {
            syncStatusEvent = SyncStatusEvent.NOT_CONNECTED;
        } else if (bl2) {
            syncStatusEvent = SyncStatusEvent.LOGGING_IN;
        } else if (!bl3) {
            syncStatusEvent = SyncStatusEvent.NOT_LOGGED_IN;
        } else if (PreferencesEntry.WEBDAV_ONLY.getValueBoolean(this.getController()).booleanValue()) {
            syncStatusEvent = SyncStatusEvent.SYNCHRONIZED;
        } else if (folderRepository.getFoldersCount() == 0 && !bl4) {
            syncStatusEvent = SyncStatusEvent.NO_FOLDERS;
        } else if (this.syncingModel.isSyncing()) {
            syncStatusEvent = SyncStatusEvent.SYNCING;
        } else if (folderRepository.areAllFoldersInSync() && !bl4) {
            syncStatusEvent = SyncStatusEvent.SYNCHRONIZED;
        } else if (this.getNoticesModel().getHighestUnreadSeverity() == NoticeSeverity.WARNING || folderRepository.getFolderProblemsCount() > 0) {
            syncStatusEvent = SyncStatusEvent.WARNING;
        } else if (this.getNoticesModel().getHighestUnreadSeverity() == NoticeSeverity.INFORMATION) {
            syncStatusEvent = SyncStatusEvent.INFORMATION;
        }
        this.triggerSyncStatusChange(syncStatusEvent);
    }

    private void triggerSyncStatusChange(SyncStatusEvent syncStatusEvent) {
        if (this.isFiner()) {
            this.logFiner(syncStatusEvent.toString());
        }
        for (SyncStatusListener syncStatusListener : this.syncStatusListeners) {
            syncStatusListener.syncStatusChanged(syncStatusEvent);
        }
    }

    private class MyServerClientListener
    implements ServerClientListener {
        private MyServerClientListener() {
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }

        @Override
        public void login(ServerClientEvent serverClientEvent) {
            ApplicationModel.this.handleSyncStatusChange();
            ApplicationModel.this.checkCloudSpace(serverClientEvent);
            if (serverClientEvent.getAccountDetails().getAccount().hasPermission(AdminPermission.INSTANCE)) {
                WarningNotice warningNotice = new WarningNotice(Translation.get("warning_notice.title"), Translation.get("warning_notice.admin_login.summary"), Translation.get("warning_notice.admin_login.message"));
                ApplicationModel.this.noticesModel.handleNotice(warningNotice);
            }
            if (DesktopSyncSetupPanel.offerOption(ApplicationModel.this.getController()) && ApplicationModel.this.serverClientModel.getClient().isAllowedToCreateFolders()) {
                PFWizard.openDesktopSyncWizard(ApplicationModel.this.getController(), ApplicationModel.this.serverClientModel.getClient());
            }
        }

        @Override
        public void accountUpdated(ServerClientEvent serverClientEvent) {
            ApplicationModel.this.handleSyncStatusChange();
            ApplicationModel.this.checkCloudSpace(serverClientEvent);
        }

        @Override
        public void serverConnected(ServerClientEvent serverClientEvent) {
            ApplicationModel.this.handleSyncStatusChange();
            ServerClient serverClient = serverClientEvent.getClient();
            if (serverClient.isPasswordRequired() && !serverClient.isLoggedIn() && !PFWizard.isWizardOpen()) {
                if (!StringUtils.isBlank(serverClient.getUsername())) {
                    ApplicationModel.this.getController().getUIController().getApplicationModel().getNoticesModel().handleNotice(new SimpleNotificationNotice(Translation.get("main_frame.log_in_failed.text"), Translation.get("exp.uilock.dialog.error.wronglogin")));
                }
                if (!serverClient.isLoggedIn()) {
                    PFWizard.openLoginWizard(ApplicationModel.this.getController(), serverClient);
                }
            }
        }

        @Override
        public void serverDisconnected(ServerClientEvent serverClientEvent) {
            ApplicationModel.this.handleSyncStatusChange();
        }

        @Override
        public void nodeServerStatusChanged(ServerClientEvent serverClientEvent) {
            ApplicationModel.this.handleSyncStatusChange();
        }

        @Override
        public void childClientSpawned(ServerClientEvent serverClientEvent) {
            ApplicationModel.this.handleSyncStatusChange();
        }
    }

    private class MyPausedModeListener
    implements PausedModeListener {
        private MyPausedModeListener() {
        }

        @Override
        public void setPausedMode(PausedModeEvent pausedModeEvent) {
            ApplicationModel.this.handleSyncStatusChange();
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }

    private class MyFolderRepositoryListener
    extends FolderRepositoryAdapter {
        private MyFolderRepositoryListener() {
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }

        @Override
        public void folderRemoved(FolderRepositoryEvent folderRepositoryEvent) {
            ApplicationModel.this.handleSyncStatusChange();
        }

        @Override
        public void folderCreated(FolderRepositoryEvent folderRepositoryEvent) {
            ApplicationModel.this.handleSyncStatusChange();
        }

        @Override
        public void folderMoved(FolderRepositoryEvent folderRepositoryEvent) {
            ApplicationModel.this.handleSyncStatusChange();
        }
    }

    private class MyNodeManagerListener
    extends NodeManagerAdapter {
        private MyNodeManagerListener() {
        }

        @Override
        public void startStop(NodeManagerEvent nodeManagerEvent) {
            ApplicationModel.this.handleSyncStatusChange();
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }

    private class MyLockingListener
    implements LockingListener {
        private MyLockingListener() {
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return false;
        }

        @Override
        public void locked(LockingEvent lockingEvent) {
        }

        @Override
        public void unlocked(LockingEvent lockingEvent) {
        }

        @Override
        public void autoLockForbidden(LockingEvent lockingEvent) {
            FileInfo fileInfo = lockingEvent.getFileInfo();
            Lock lock = fileInfo.getLock(ApplicationModel.this.getController());
            if (lock == null) {
                return;
            }
            String string = lock.getAccountDisplayName();
            String string2 = fileInfo.getFilenameOnly();
            String string3 = new SimpleDateFormat("dd MMM yyyy HH:mm").format(lock.getCreated());
            String string4 = Translation.get("context_menu.unlock.message.web");
            if (lock.getMemberInfo() != null) {
                string4 = lock.getMemberInfo().getNick();
            }
            String string5 = string4;
            new LockOverwriteNoticeHandler(ApplicationModel.this.getController(), string2, string, string3, string5).show();
        }
    }

    private class MyOverallFolderStatListener
    implements OverallFolderStatListener {
        private MyOverallFolderStatListener() {
        }

        @Override
        public void statCalculated() {
            ApplicationModel.this.handleSyncStatusChange();
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }

    private class MyNoticesModelPropertyChangeListener
    implements PropertyChangeListener {
        private MyNoticesModelPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ApplicationModel.this.handleSyncStatusChange();
        }
    }

    private class FolderMoveWorker
    extends ActivityVisualizationWorker {
        private final boolean moveContent;
        private final Path newDirectory;
        private final Folder folder;

        FolderMoveWorker(boolean bl, Path path, Folder folder) {
            super(ApplicationModel.this.getController().getUIController());
            this.moveContent = bl;
            this.newDirectory = path;
            this.folder = folder;
        }

        @Override
        public Object construct() {
            if (this.moveContent) {
                return ApplicationModel.this.getController().getFolderRepository().moveLocalFolder(this.folder, this.newDirectory);
            }
            return ApplicationModel.this.transferFolder(this.folder, this.newDirectory);
        }

        @Override
        protected String getTitle() {
            return Translation.get("settings_tab.working.title");
        }

        @Override
        protected String getWorkingText() {
            return Translation.get("settings_tab.working.description");
        }

        @Override
        public void finished() {
            if (this.get() != null && this.get() instanceof Exception) {
                ApplicationModel.this.displayError((Exception)this.get());
            }
        }
    }

    private class LockOverwriteNoticeHandler
    extends NotificationHandlerBase {
        LockOverwriteNoticeHandler(Controller controller, String string, String string2, String string3, String string4) {
            super(controller);
            this.setTitle(Translation.get("context_menu.unlock.title"));
            this.setMessageText(Translation.get("context_menu.unlock.notice", string, string2, string3, string4));
            this.setCancelOptionLabel(Translation.get("general.ok"));
            this.setCancelAction(new AbstractAction(){
                private static final long serialVersionUID = 100L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LockOverwriteNoticeHandler.this.sliderClose();
                }
            });
        }
    }
}

