/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.notices;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.ui.model.SortedTableModel;
import de.dal33t.powerfolder.ui.notices.Notice;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.compare.NoticeComparator;
import de.dal33t.powerfolder.util.compare.ReverseComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class NoticesTableModel
implements TableModel,
SortedTableModel {
    private final Controller controller;
    private final List<Notice> notices = new ArrayList<Notice>();
    private final List<TableModelListener> listeners = new LinkedList<TableModelListener>();
    private final NoticeComparator[] columComparators = new NoticeComparator[]{NoticeComparator.BY_SEVERITY, NoticeComparator.BY_DATE, NoticeComparator.BY_SUMMARY};
    private NoticeComparator comparator;
    private boolean sortAscending;
    private int sortColumn;
    private static final String[] COLUMN_NAMES = new String[]{"", Translation.get("notices_table.date"), Translation.get("notices_table.summary")};

    public NoticesTableModel(Controller controller) {
        this.controller = controller;
        this.sortAscending = false;
        this.sortBy(1);
        this.reset();
    }

    public void reset() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NoticesTableModel.this.notices.clear();
                List<Notice> list = NoticesTableModel.this.controller.getUIController().getApplicationModel().getNoticesModel().getAllNotices();
                NoticesTableModel.this.notices.addAll(list);
                NoticesTableModel.this.sort();
                NoticesTableModel.this.fireModelStructureChanged();
            }
        });
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listeners.add(tableModelListener);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return Notice.class;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public int getRowCount() {
        return Math.max(this.notices.size(), 1);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        int n3 = 0;
        for (Notice notice : this.notices) {
            if (n3++ != n) continue;
            return notice;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listeners.remove(tableModelListener);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        throw new IllegalStateException("not editable");
    }

    private void fireModelStructureChanged() {
        TableModelEvent tableModelEvent = new TableModelEvent(this);
        this.fireTableModelEvent(tableModelEvent);
    }

    private void fireTableModelEvent(TableModelEvent tableModelEvent) {
        for (TableModelListener tableModelListener : this.listeners) {
            tableModelListener.tableChanged(tableModelEvent);
        }
    }

    @Override
    public int getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public boolean isSortAscending() {
        return this.sortAscending;
    }

    @Override
    public void setAscending(boolean bl) {
        this.sortAscending = bl;
    }

    @Override
    public boolean sortBy(int n) {
        if (n < 0 && n > this.columComparators.length || this.columComparators[n] == null) {
            this.sortColumn = -1;
            this.comparator = null;
            return false;
        }
        this.sortColumn = n;
        return this.sortBy(this.columComparators[n]);
    }

    public void reverseList() {
        this.sortAscending = !this.sortAscending;
        this.sort();
    }

    private boolean sortBy(NoticeComparator noticeComparator) {
        NoticeComparator noticeComparator2 = this.comparator;
        this.comparator = noticeComparator;
        if (!Util.equals(noticeComparator2, noticeComparator)) {
            return this.sort();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sort() {
        if (this.comparator != null) {
            List<Notice> list = this.notices;
            synchronized (list) {
                if (this.sortAscending) {
                    Collections.sort(this.notices, this.comparator);
                } else {
                    Collections.sort(this.notices, new ReverseComparator<Notice>(this.comparator));
                }
            }
            this.fireModelChanged();
            return true;
        }
        return false;
    }

    private void fireModelChanged() {
        TableModelEvent tableModelEvent = new TableModelEvent(this, 0, this.getRowCount(), -1, 0);
        this.fireTableModelEvent(tableModelEvent);
    }
}

