/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.folder.members;

import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.ui.information.folder.members.FolderMember;
import java.util.Comparator;

public enum FolderMemberComparator implements Comparator<FolderMember>
{
    BY_TYPE{

        @Override
        public int compare(FolderMember folderMember, FolderMember folderMember2) {
            boolean bl;
            Member member = folderMember.getMember();
            Member member2 = folderMember2.getMember();
            if (member == null) {
                return member2 == null ? 0 : -1;
            }
            if (member2 == null) {
                return 1;
            }
            boolean bl2 = member.isFriend();
            boolean bl3 = member2.isFriend();
            boolean bl4 = member.isCompletelyConnected() || member.isMySelf();
            boolean bl5 = bl = member2.isCompletelyConnected() || member2.isMySelf();
            if (bl2 != bl3) {
                return bl2 ? 1 : -1;
            }
            if (bl4 != bl) {
                return bl4 ? 1 : -1;
            }
            return 0;
        }
    }
    ,
    BY_COMPUTER_NAME{

        @Override
        public int compare(FolderMember folderMember, FolderMember folderMember2) {
            Member member = folderMember.getMember();
            Member member2 = folderMember2.getMember();
            if (member == null) {
                return member2 == null ? 0 : 1;
            }
            if (member2 == null) {
                return -1;
            }
            return member.getNick().compareTo(member2.getNick());
        }
    }
    ,
    BY_SYNC_STATUS{

        @Override
        public int compare(FolderMember folderMember, FolderMember folderMember2) {
            Double d = folderMember.getFolder().getStatistic().getSyncPercentage(folderMember.getMember());
            Double d2 = folderMember2.getFolder().getStatistic().getSyncPercentage(folderMember2.getMember());
            if (d == null) {
                return d2 == null ? 0 : -1;
            }
            if (d2 == null) {
                return 1;
            }
            return d.compareTo(d2);
        }
    }
    ,
    BY_LOCAL_SIZE{

        @Override
        public int compare(FolderMember folderMember, FolderMember folderMember2) {
            Long l = folderMember.getFolder().getStatistic().getSizeInSync(folderMember.getMember());
            Long l2 = folderMember2.getFolder().getStatistic().getSizeInSync(folderMember2.getMember());
            if (l == null) {
                return l2 == null ? 0 : 1;
            }
            if (l2 == null) {
                return -1;
            }
            return l.compareTo(l2);
        }
    }
    ,
    BY_USERNAME{

        @Override
        public int compare(FolderMember folderMember, FolderMember folderMember2) {
            AccountInfo accountInfo = folderMember.getAccountInfo();
            AccountInfo accountInfo2 = folderMember2.getAccountInfo();
            if (accountInfo == null) {
                return accountInfo2 == null ? 0 : 1;
            }
            if (accountInfo2 == null) {
                return -1;
            }
            if (accountInfo.getUsername() == null) {
                return accountInfo2.getUsername() == null ? 0 : 1;
            }
            if (accountInfo2.getUsername() == null) {
                return -1;
            }
            return accountInfo.getUsername().compareTo(accountInfo2.getUsername());
        }
    }
    ,
    BY_DISPLAY_NAME{

        @Override
        public int compare(FolderMember folderMember, FolderMember folderMember2) {
            AccountInfo accountInfo = folderMember.getAccountInfo();
            AccountInfo accountInfo2 = folderMember2.getAccountInfo();
            if (accountInfo == null) {
                return accountInfo2 == null ? 0 : 1;
            }
            if (accountInfo2 == null) {
                return -1;
            }
            if (accountInfo.getDisplayName() == null) {
                return accountInfo2.getDisplayName() == null ? 0 : 1;
            }
            if (accountInfo2.getDisplayName() == null) {
                return -1;
            }
            return accountInfo.getDisplayName().compareTo(accountInfo2.getDisplayName());
        }
    }
    ,
    BY_PERMISSION{

        @Override
        public int compare(FolderMember folderMember, FolderMember folderMember2) {
            FolderPermission folderPermission = folderMember.getPermission();
            FolderPermission folderPermission2 = folderMember2.getPermission();
            if (folderPermission == null) {
                return folderPermission2 == null ? 0 : -1;
            }
            if (folderPermission2 == null) {
                return 1;
            }
            return folderPermission.getName().compareTo(folderPermission2.getName());
        }
    };


    @Override
    public int compare(FolderMember folderMember, FolderMember folderMember2) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

