/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.folder.files.table;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.event.DiskItemFilterListener;
import de.dal33t.powerfolder.event.PatternChangedEvent;
import de.dal33t.powerfolder.light.DirectoryInfo;
import de.dal33t.powerfolder.light.DiskItem;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.ui.information.folder.files.FilteredDirectoryModel;
import de.dal33t.powerfolder.ui.model.SortedTableModel;
import de.dal33t.powerfolder.ui.util.DelayedUpdater;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.compare.FileInfoComparator;
import de.dal33t.powerfolder.util.compare.ReverseComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class FilesTableModel
extends PFComponent
implements TableModel,
SortedTableModel {
    private String[] columns;
    private static final int COL_FILE_TYPE = 0;
    private static final int COL_NAME = 1;
    public static final int COL_SIZE = 2;
    private static final int COL_MEMBER = 3;
    private static final int COL_MODIFIED_DATE = 4;
    private Folder folder;
    private final List<FileInfo> fileInfos = new ArrayList<FileInfo>();
    private final AtomicBoolean significantlyChanged;
    private Folder previousFolder;
    private final List<FileInfo> previousFileInfos = new ArrayList<FileInfo>();
    private boolean previouslySorted;
    private final List<TableModelListener> tableModelListeners = new CopyOnWriteArrayList<TableModelListener>();
    private int fileInfoComparatorType = -1;
    private boolean sortAscending = true;
    private int sortColumn;
    private DiskItemFilterListener patternChangeListener = new MyPatternChangeListener();
    private DelayedUpdater modelChangedUpdater;

    public FilesTableModel(Controller controller) {
        super(controller);
        this.significantlyChanged = new AtomicBoolean();
        this.modelChangedUpdater = new DelayedUpdater(this.getController());
        int n = ConfigurationEntry.MEMBERS_ENABLED.getValueBoolean(controller) != false ? 5 : 4;
        this.columns = new String[n];
        this.columns[0] = "";
        this.columns[1] = Translation.get("files_table_model.name");
        this.columns[2] = Translation.get("files_table_model.size");
        if (ConfigurationEntry.MEMBERS_ENABLED.getValueBoolean(controller).booleanValue()) {
            this.columns[3] = Translation.get("files_table_model.modified_by");
            this.columns[4] = Translation.get("files_table_model.date");
        } else {
            this.columns[3] = Translation.get("files_table_model.date");
        }
    }

    public void setFolder(Folder folder) {
        if (this.folder != null) {
            this.folder.getDiskItemFilter().removeListener(this.patternChangeListener);
        }
        this.folder = folder;
        this.folder.getDiskItemFilter().addListener(this.patternChangeListener);
        this.update();
    }

    public void setFilteredDirectoryModel(FilteredDirectoryModel filteredDirectoryModel) {
        this.fileInfos.clear();
        this.fileInfos.addAll(filteredDirectoryModel.getFileInfos());
        this.update();
    }

    public Folder getFolder() {
        return this.folder;
    }

    private void update() {
        if (this.folder == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = FilesTableModel.this.fileInfos;
                synchronized (list) {
                    FilesTableModel.this.sort();
                    FilesTableModel.this.preprocessSignificantlyChanged();
                    FilesTableModel.this.fireModelChanged0();
                    FilesTableModel.this.postprocessSignificantlyChanged();
                }
            }
        };
        this.modelChangedUpdater.schedule(runnable);
    }

    private void preprocessSignificantlyChanged() {
        if (this.previouslySorted) {
            this.significantlyChanged.set(true);
            return;
        }
        if (this.folder == null || this.previousFolder == null || !this.folder.equals(this.previousFolder)) {
            this.significantlyChanged.set(true);
            return;
        }
        if (this.fileInfos.size() != this.previousFileInfos.size()) {
            this.significantlyChanged.set(true);
            return;
        }
        for (FileInfo fileInfo : this.fileInfos) {
            boolean bl = false;
            for (FileInfo fileInfo2 : this.previousFileInfos) {
                if (!fileInfo.equals(fileInfo2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.significantlyChanged.set(true);
            return;
        }
        this.significantlyChanged.set(false);
    }

    private void postprocessSignificantlyChanged() {
        this.previousFolder = this.folder;
        this.previousFileInfos.clear();
        this.previousFileInfos.addAll(this.fileInfos);
        this.previouslySorted = false;
    }

    public boolean isSignificantlyChanged() {
        return this.significantlyChanged.get();
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.tableModelListeners.add(tableModelListener);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return FileInfo.class;
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columns[n];
    }

    @Override
    public int getRowCount() {
        return this.fileInfos.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.fileInfos.get(n);
    }

    public DiskItem[] getDiskItemsAtRows(int[] nArray) {
        DiskItem[] diskItemArray = new DiskItem[nArray.length];
        int n = 0;
        for (int n2 : nArray) {
            Object object = this.getValueAt(n2, 1);
            if (object instanceof DirectoryInfo) {
                diskItemArray[n] = (DirectoryInfo)object;
            } else if (object instanceof FileInfo) {
                diskItemArray[n] = (FileInfo)object;
            } else {
                this.logSevere("Object was a " + object.getClass().getName() + "???");
            }
            ++n;
        }
        return diskItemArray;
    }

    public DiskItem[] getAllDiskItems() {
        DiskItem[] diskItemArray = new DiskItem[this.fileInfos.size()];
        for (int i = 0; i < diskItemArray.length; ++i) {
            Object object = this.getValueAt(i, 1);
            if (object instanceof DirectoryInfo) {
                diskItemArray[i] = (DirectoryInfo)object;
                continue;
            }
            if (object instanceof FileInfo) {
                diskItemArray[i] = (FileInfo)object;
                continue;
            }
            this.logSevere("Object was a " + object.getClass().getName() + "???");
        }
        return diskItemArray;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.tableModelListeners.remove(tableModelListener);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        throw new UnsupportedOperationException("Cannot modify FilesTableModel");
    }

    @Override
    public int getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public boolean isSortAscending() {
        return this.sortAscending;
    }

    @Override
    public boolean sortBy(int n) {
        this.previouslySorted = true;
        this.sortColumn = n;
        switch (n) {
            case 0: {
                return this.sortMe(0);
            }
            case 1: {
                return this.sortMe(1);
            }
            case 2: {
                return this.sortMe(3);
            }
            case 3: {
                return this.sortMe(4);
            }
            case 4: {
                return this.sortMe(5);
            }
        }
        this.sortColumn = -1;
        return false;
    }

    public boolean sortMe(int n) {
        boolean bl;
        int n2 = this.fileInfoComparatorType;
        this.fileInfoComparatorType = n;
        if (n2 != n && (bl = this.sort())) {
            this.fireModelChanged0();
            return true;
        }
        return false;
    }

    public void sortLatestDate() {
        this.sortAscending = true;
        this.sortBy(4);
    }

    private void fireModelChanged0() {
        TableModelEvent tableModelEvent = new TableModelEvent(this);
        for (TableModelListener tableModelListener : this.tableModelListeners) {
            tableModelListener.tableChanged(tableModelEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sort() {
        if (this.fileInfoComparatorType != -1) {
            FileInfoComparator fileInfoComparator = new FileInfoComparator(this.fileInfoComparatorType);
            List<FileInfo> list = this.fileInfos;
            synchronized (list) {
                if (this.sortAscending) {
                    Collections.sort(this.fileInfos, fileInfoComparator);
                } else {
                    Collections.sort(this.fileInfos, new ReverseComparator<FileInfo>(fileInfoComparator));
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reverseList() {
        this.sortAscending = !this.sortAscending;
        List<FileInfo> list = this.fileInfos;
        synchronized (list) {
            Collections.reverse(this.fileInfos);
        }
        this.fireModelChanged0();
    }

    @Override
    public void setAscending(boolean bl) {
        this.sortAscending = bl;
    }

    private class MyPatternChangeListener
    implements DiskItemFilterListener {
        private MyPatternChangeListener() {
        }

        @Override
        public void patternAdded(PatternChangedEvent patternChangedEvent) {
            FilesTableModel.this.fireModelChanged0();
        }

        @Override
        public void patternRemoved(PatternChangedEvent patternChangedEvent) {
            FilesTableModel.this.fireModelChanged0();
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }
}

