/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.downloads;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Constants;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.transfer.DownloadManager;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.information.HasDetailsPanel;
import de.dal33t.powerfolder.ui.information.InformationCard;
import de.dal33t.powerfolder.ui.information.InformationCardType;
import de.dal33t.powerfolder.ui.information.downloads.DownloadsTablePanel;
import de.dal33t.powerfolder.ui.information.folder.files.FileDetailsPanel;
import de.dal33t.powerfolder.ui.information.folder.files.versions.FileVersionsPanel;
import de.dal33t.powerfolder.ui.util.DelayedUpdater;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.TimerTask;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class DownloadsInformationCard
extends InformationCard
implements HasDetailsPanel {
    private JPanel uiComponent;
    private JPanel toolBar;
    private DownloadsTablePanel tablePanel;
    private Action abortDownloadsAction;
    private Action openDownloadAction;
    private JPanel detailsPanel;
    private FileDetailsPanel fileDetailsPanel;
    private FileVersionsPanel fileVersionsPanel;
    private Action clearCompletedDownloadsAction;
    private JSlider cleanupSlider;
    private JLabel cleanupLabel;
    private JPanel statsPanel;
    private JLabel downloadCounterLabel;
    private JLabel activeDownloadCountLabel;
    private JLabel completedDownloadCountLabel;
    private DelayedUpdater updater;
    private Action addIgnoreAction;

    public DownloadsInformationCard(Controller controller) {
        super(controller);
        this.updater = new DelayedUpdater(controller);
    }

    @Override
    public InformationCardType getInformationCardType() {
        return InformationCardType.TRANSFERS;
    }

    @Override
    public Image getCardImage() {
        return Icons.getImageById("folder.icon");
    }

    @Override
    public String getCardTitle() {
        return Translation.get("exp.downloads_information_card.title");
    }

    @Override
    public JComponent getUIComponent() {
        if (this.uiComponent == null) {
            this.initialize();
            this.buildUIComponent();
        }
        return this.uiComponent;
    }

    private void initialize() {
        this.cleanupLabel = new JLabel();
        this.cleanupLabel.setToolTipText(Translation.get("exp.downloads_information_card.auto_cleanup.frequency_tip"));
        this.buildToolbar();
        this.tablePanel = new DownloadsTablePanel(this.getController(), this.openDownloadAction, this.abortDownloadsAction, this.clearCompletedDownloadsAction, this.addIgnoreAction);
        this.tablePanel.addTableModelListener(new MyTableModelListener());
        this.tablePanel.addListSelectionListener(new MyListSelectionListener());
        this.fileDetailsPanel = new FileDetailsPanel(this.getController(), true);
        this.fileVersionsPanel = new FileVersionsPanel(this.getController());
        this.detailsPanel = this.createDetailsPanel();
        this.detailsPanel.setVisible(false);
        this.buildStatsPanel();
        this.update0();
    }

    private void buildStatsPanel() {
        FormLayout formLayout = new FormLayout("3dlu, pref:grow, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref", "pref");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.activeDownloadCountLabel = new JLabel();
        defaultFormBuilder.add((Component)this.activeDownloadCountLabel, cellConstraints.xy(3, 1));
        JSeparator jSeparator = new JSeparator(1);
        jSeparator.setPreferredSize(new Dimension(2, 12));
        defaultFormBuilder.add((Component)jSeparator, cellConstraints.xy(5, 1));
        this.completedDownloadCountLabel = new JLabel();
        defaultFormBuilder.add((Component)this.completedDownloadCountLabel, cellConstraints.xy(7, 1));
        JSeparator jSeparator2 = new JSeparator(1);
        jSeparator2.setPreferredSize(new Dimension(2, 12));
        defaultFormBuilder.add((Component)jSeparator2, cellConstraints.xy(9, 1));
        this.downloadCounterLabel = new JLabel();
        defaultFormBuilder.add((Component)this.downloadCounterLabel, cellConstraints.xy(11, 1));
        this.statsPanel = defaultFormBuilder.getPanel();
    }

    private void buildToolbar() {
        this.abortDownloadsAction = new AbortDownloadAction();
        this.openDownloadAction = new OpenFileAction();
        this.clearCompletedDownloadsAction = new ClearCompletedDownloadsAction(this.getController());
        this.addIgnoreAction = new AddIgnoreAction(this.getController());
        Integer n = ConfigurationEntry.DOWNLOAD_AUTO_CLEANUP_FREQUENCY.getValueInt(this.getController());
        if (n > 4) {
            n = 4;
        }
        this.cleanupSlider = new JSlider(0, 4, (int)n){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(20, (int)super.getPreferredSize().getSize().getHeight());
            }
        };
        this.cleanupSlider.setMinorTickSpacing(1);
        this.cleanupSlider.setPaintTicks(true);
        this.cleanupSlider.setSnapToTicks(true);
        this.cleanupSlider.addChangeListener(new MyChangeListener());
        this.cleanupSlider.setToolTipText(Translation.get("exp.downloads_information_card.auto_cleanup.frequency_tip"));
        ButtonBarBuilder buttonBarBuilder = ButtonBarBuilder.createLeftToRightBuilder();
        JToggleButton jToggleButton = new JToggleButton(new DetailsAction(this.getController()));
        jToggleButton.setIcon(null);
        buttonBarBuilder.addGridded(jToggleButton);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addGridded(DownloadsInformationCard.createButton(this.openDownloadAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addGridded(DownloadsInformationCard.createButton(this.abortDownloadsAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addGridded(DownloadsInformationCard.createButton(this.clearCompletedDownloadsAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addGridded(this.cleanupSlider);
        this.toolBar = buttonBarBuilder.getPanel();
        this.updateCleanupLabel();
    }

    private static JButton createButton(Action action) {
        JButton jButton = new JButton(action);
        jButton.setIcon(null);
        return jButton;
    }

    private void buildUIComponent() {
        FormLayout formLayout = new FormLayout("3dlu, pref, 3dlu, pref:grow, 3dlu", "3dlu, pref, 3dlu, pref, 3dlu, fill:pref:grow, 3dlu, pref, pref, pref");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.add((Component)this.toolBar, cellConstraints.xy(2, 2));
        defaultFormBuilder.add((Component)this.cleanupLabel, cellConstraints.xy(4, 2));
        defaultFormBuilder.addSeparator(null, cellConstraints.xyw(1, 4, 5));
        defaultFormBuilder.add((Component)this.tablePanel.getUIComponent(), cellConstraints.xyw(2, 6, 3));
        defaultFormBuilder.add((Component)this.detailsPanel, cellConstraints.xyw(2, 8, 3));
        defaultFormBuilder.addSeparator(null, cellConstraints.xyw(1, 9, 5));
        defaultFormBuilder.add((Component)this.statsPanel, cellConstraints.xyw(2, 10, 3));
        this.uiComponent = defaultFormBuilder.getPanel();
        this.initStatsTimer();
    }

    private void initStatsTimer() {
        this.getController().scheduleAndRepeat(new MyStatsTask(), 100L, 1000L);
    }

    @Override
    public void toggleDetails() {
        this.detailsPanel.setVisible(!this.detailsPanel.isVisible());
    }

    public void update() {
        this.updater.schedule(new Runnable(){

            @Override
            public void run() {
                DownloadsInformationCard.this.update0();
            }
        });
    }

    private void update0() {
        boolean bl = this.tablePanel.isSingleCompleteSelected();
        boolean bl2 = this.tablePanel.isRowsExist();
        boolean bl3 = this.tablePanel.isIncompleteSelected();
        this.openDownloadAction.setEnabled(bl);
        this.abortDownloadsAction.setEnabled(bl3);
        this.clearCompletedDownloadsAction.setEnabled(bl2);
        this.addIgnoreAction.setEnabled(this.tablePanel.getSelectedRows().length > 0);
        this.fileDetailsPanel.setFileInfo(this.tablePanel.getSelectdFile());
        this.fileVersionsPanel.setFileInfo(this.tablePanel.getSelectdFile());
    }

    private void updateCleanupLabel() {
        ConfigurationEntry.DOWNLOAD_AUTO_CLEANUP_FREQUENCY.setValue(this.getController(), String.valueOf(this.cleanupSlider.getValue()));
        this.getController().saveConfig();
        if (this.cleanupSlider.getValue() == 0) {
            this.cleanupLabel.setText(Translation.get("exp.downloads_information_card.auto_cleanup.immediate"));
        } else if (this.cleanupSlider.getValue() >= 4) {
            this.cleanupLabel.setText(Translation.get("exp.downloads_information_card.auto_cleanup.never"));
        } else {
            int n = Constants.CLEANUP_VALUES[this.cleanupSlider.getValue()];
            this.cleanupLabel.setText(Translation.get("exp.downloads_information_card.auto_cleanup.days", String.valueOf(n)));
        }
    }

    private void displayStats() {
        int n = this.tablePanel.countActiveDownloadCount();
        this.activeDownloadCountLabel.setText(Translation.get("status.active_download_count", String.valueOf(n)));
        int n2 = this.tablePanel.countCompletedDownloadCount();
        this.completedDownloadCountLabel.setText(Translation.get("status.completed_download_count", String.valueOf(n2)));
        double d = this.getController().getTransferManager().getDownloadCounter().calculateCurrentKBS();
        this.downloadCounterLabel.setText(Translation.get("status.download", Format.formatDecimal(d)));
    }

    private JPanel createDetailsPanel() {
        FormLayout formLayout = new FormLayout("fill:pref:grow", "pref, 3dlu, pref");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.addSeparator(null, cellConstraints.xy(1, 1));
        JTabbedPane jTabbedPane = new JTabbedPane();
        defaultFormBuilder.add((Component)jTabbedPane, cellConstraints.xy(1, 3));
        jTabbedPane.add((Component)this.fileDetailsPanel.getPanel(), Translation.get("files_table_panel.file_details_tab.text"));
        jTabbedPane.setToolTipTextAt(0, Translation.get("files_table_panel.file_details_tab.tip"));
        jTabbedPane.add(this.fileVersionsPanel.getPanel(), Translation.get("files_table_panel.file_versions_tab.text"));
        jTabbedPane.setToolTipTextAt(1, Translation.get("files_table_panel.file_versions_tab.tip"));
        return defaultFormBuilder.getPanel();
    }

    private class MyTableModelListener
    implements TableModelListener {
        private MyTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            DownloadsInformationCard.this.update();
        }
    }

    private class MyListSelectionListener
    implements ListSelectionListener {
        private MyListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            DownloadsInformationCard.this.update();
        }
    }

    private class AbortDownloadAction
    extends BaseAction {
        AbortDownloadAction() {
            super("exp.action_abort_download", DownloadsInformationCard.this.getController());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DownloadsInformationCard.this.tablePanel.abortSelectedDownloads();
        }
    }

    private class OpenFileAction
    extends BaseAction {
        OpenFileAction() {
            super("action_open_file", DownloadsInformationCard.this.getController());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DownloadsInformationCard.this.tablePanel.openSelectedDownload();
        }
    }

    private class ClearCompletedDownloadsAction
    extends BaseAction {
        ClearCompletedDownloadsAction(Controller controller) {
            super("exp.action_clear_completed_downloads", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DownloadsInformationCard.this.tablePanel.clearDownloads();
        }
    }

    private class AddIgnoreAction
    extends BaseAction {
        private AddIgnoreAction(Controller controller) {
            super("action_add_ignore", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (DownloadManager downloadManager : DownloadsInformationCard.this.tablePanel.getSelectedRows()) {
                if (downloadManager == null) continue;
                FileInfo fileInfo = downloadManager.getFileInfo();
                Folder folder = this.getController().getFolderRepository().getFolder(fileInfo.getFolderInfo());
                folder.addPattern(fileInfo.getRelativeName());
                if (downloadManager.isStarted()) {
                    downloadManager.abort();
                }
                this.getController().getTransferManager().checkActiveTranfersForExcludes();
            }
        }
    }

    private class MyChangeListener
    implements ChangeListener {
        private MyChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            DownloadsInformationCard.this.updateCleanupLabel();
        }
    }

    private class DetailsAction
    extends BaseAction {
        DetailsAction(Controller controller) {
            super("action_details", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DownloadsInformationCard.this.toggleDetails();
        }
    }

    private class MyStatsTask
    extends TimerTask {
        private MyStatsTask() {
        }

        @Override
        public void run() {
            DownloadsInformationCard.this.displayStats();
        }
    }
}

