/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.debug;

import de.dal33t.powerfolder.ui.util.UIUtil;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.StyledDocument;

public class TextPanel {
    private AutoScrollDocumentListner docListener;
    private JTextPane textArea;
    private JScrollPane textAreaPane;
    private boolean autoScroll;

    public JComponent getUIComponent() {
        if (this.textAreaPane == null) {
            this.initComponents();
        }
        return this.textAreaPane;
    }

    private void initComponents() {
        this.textArea = new JTextPane(){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return false;
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (this.getParent() instanceof JViewport) {
                    dimension.width = Math.max(this.getParent().getWidth(), dimension.width);
                }
                return dimension;
            }
        };
        this.textAreaPane = new JScrollPane(this.textArea);
        this.textArea.setEditable(false);
        UIUtil.removeBorder(this.textAreaPane);
        UIUtil.setZeroWidth(this.textAreaPane);
        this.docListener = new AutoScrollDocumentListner();
    }

    public void setText(StyledDocument styledDocument, boolean bl) {
        this.autoScroll = bl;
        if (this.textArea == null) {
            this.initComponents();
        }
        this.textArea.getDocument().removeDocumentListener(this.docListener);
        this.textArea.setDocument(styledDocument);
        if (bl) {
            styledDocument.addDocumentListener(this.docListener);
            this.docListener.insertUpdate(null);
        }
    }

    public void setAutoScroll(boolean bl) {
        this.autoScroll = bl;
    }

    public boolean isAutoScroll() {
        return this.autoScroll;
    }

    private class AutoScrollDocumentListner
    implements DocumentListener {
        private AutoScrollDocumentListner() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (TextPanel.this.autoScroll) {
                TextPanel.this.textArea.setCaretPosition(TextPanel.this.textArea.getDocument().getLength());
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (TextPanel.this.autoScroll) {
                TextPanel.this.textArea.setCaretPosition(TextPanel.this.textArea.getDocument().getLength());
            }
        }
    }
}

