/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.event.FolderRepositoryAdapter;
import de.dal33t.powerfolder.event.FolderRepositoryEvent;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.information.InformationCard;
import de.dal33t.powerfolder.ui.information.debug.DebugInformationCard;
import de.dal33t.powerfolder.ui.information.downloads.DownloadsInformationCard;
import de.dal33t.powerfolder.ui.information.folder.FolderInformationCard;
import de.dal33t.powerfolder.ui.information.notices.NoticesInformationCard;
import de.dal33t.powerfolder.ui.information.uploads.UploadsInformationCard;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.util.Translation;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;

public class InformationFrame
extends PFUIComponent {
    private JFrame uiComponent;
    private FolderInformationCard folderInformationCard;
    private DownloadsInformationCard downloadsInformationCard;
    private UploadsInformationCard uploadsInformationCard;
    private DebugInformationCard debugInformationCard;
    private NoticesInformationCard noticesCard;
    private boolean showingFolder;
    private FolderInfo currentFolderInfo;

    public InformationFrame(Controller controller) {
        super(controller);
        controller.getFolderRepository().addFolderRepositoryListener(new MyFolderRepositoryListener());
    }

    public JFrame getUIComponent() {
        if (this.uiComponent == null) {
            this.initialize();
        }
        return this.uiComponent;
    }

    private void initialize() {
        this.uiComponent = new JFrame();
        this.uiComponent.setIconImage(Icons.getImageById("powerfolder_32.icon"));
    }

    public boolean isShowingFolder() {
        return this.showingFolder;
    }

    public void displayFile(FileInfo fileInfo) {
        this.buildFolderInformationCard();
        this.folderInformationCard.setFileInfo(fileInfo);
        this.folderInformationCard.showFiles();
        this.displayCard(this.folderInformationCard);
        this.showingFolder = true;
        this.currentFolderInfo = fileInfo.getFolderInfo();
    }

    public void displayFolderFiles(FolderInfo folderInfo) {
        this.buildFolderInformationCard();
        this.folderInformationCard.setFolderInfo(folderInfo);
        this.folderInformationCard.showFiles();
        this.displayCard(this.folderInformationCard);
        this.showingFolder = true;
        this.currentFolderInfo = folderInfo;
        if (this.isFine()) {
            this.logFine("displayedFolderFiles: " + folderInfo);
        }
    }

    public void displayFolderFilesDeleted(FolderInfo folderInfo) {
        this.buildFolderInformationCard();
        this.folderInformationCard.setFolderInfoDeleted(folderInfo);
        this.folderInformationCard.showFiles();
        this.displayCard(this.folderInformationCard);
        this.showingFolder = true;
        this.currentFolderInfo = folderInfo;
    }

    public void displayFolderFilesUnsynced(FolderInfo folderInfo) {
        this.buildFolderInformationCard();
        this.folderInformationCard.setFolderInfoUnsynced(folderInfo);
        this.folderInformationCard.showFiles();
        this.displayCard(this.folderInformationCard);
        this.showingFolder = true;
        this.currentFolderInfo = folderInfo;
    }

    public void displayFolderFilesLatest(FolderInfo folderInfo) {
        this.buildFolderInformationCard();
        this.folderInformationCard.setFolderInfoLatest(folderInfo);
        this.folderInformationCard.showFiles();
        this.displayCard(this.folderInformationCard);
        this.showingFolder = true;
        this.currentFolderInfo = folderInfo;
    }

    public void displayFolderSettings(FolderInfo folderInfo) {
        this.buildFolderInformationCard();
        this.folderInformationCard.setFolderInfo(folderInfo);
        this.folderInformationCard.showSettings();
        this.displayCard(this.folderInformationCard);
        this.showingFolder = true;
        this.currentFolderInfo = folderInfo;
    }

    public void moveLocalFolder(FolderInfo folderInfo) {
        this.buildFolderInformationCard();
        this.folderInformationCard.setFolderInfo(folderInfo);
        this.folderInformationCard.moveLocalFolder();
    }

    public void displayFolderMembers(FolderInfo folderInfo) {
        this.buildFolderInformationCard();
        this.folderInformationCard.setFolderInfo(folderInfo);
        this.folderInformationCard.showMembers();
        this.displayCard(this.folderInformationCard);
        this.showingFolder = true;
        this.currentFolderInfo = folderInfo;
    }

    public void displayFolderProblems(FolderInfo folderInfo) {
        this.buildFolderInformationCard();
        this.folderInformationCard.setFolderInfo(folderInfo);
        this.folderInformationCard.showProblems();
        this.displayCard(this.folderInformationCard);
        this.showingFolder = true;
        this.currentFolderInfo = folderInfo;
    }

    public void displayTransfers() {
        this.buildDownloadsInformationCard();
        this.buildUploadsInformationCard();
        this.getUIComponent().getContentPane().removeAll();
        this.getUIComponent().setTitle(Translation.get("exp.information_frame.transfers.text"));
        this.getUIComponent().setIconImage(Icons.getImageById("transfers.icon"));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(this.downloadsInformationCard.getCardTitle(), this.downloadsInformationCard.getUIComponent());
        jTabbedPane.add(this.uploadsInformationCard.getCardTitle(), this.uploadsInformationCard.getUIComponent());
        this.getUIComponent().getContentPane().add(jTabbedPane);
        this.showingFolder = false;
    }

    public void displayDebug() {
        this.buildDebugInformationCard();
        this.displayCard(this.debugInformationCard);
        this.showingFolder = false;
    }

    public void displayNotices() {
        this.buildNoticesCard();
        this.displayCard(this.noticesCard);
        this.showingFolder = false;
    }

    public void displayCard(InformationCard informationCard) {
        this.getUIComponent().setIconImage(informationCard.getCardImage());
        this.getUIComponent().setTitle(informationCard.getCardTitle());
        this.getUIComponent().getContentPane().removeAll();
        this.getUIComponent().getContentPane().add(informationCard.getUIComponent());
    }

    private void buildFolderInformationCard() {
        if (this.folderInformationCard == null) {
            this.folderInformationCard = new FolderInformationCard(this.getController());
        }
    }

    private void buildDownloadsInformationCard() {
        if (this.downloadsInformationCard == null) {
            this.downloadsInformationCard = new DownloadsInformationCard(this.getController());
        }
    }

    private void buildUploadsInformationCard() {
        if (this.uploadsInformationCard == null) {
            this.uploadsInformationCard = new UploadsInformationCard(this.getController());
        }
    }

    private void buildDebugInformationCard() {
        if (this.debugInformationCard == null) {
            this.debugInformationCard = new DebugInformationCard(this.getController());
        }
    }

    private void buildNoticesCard() {
        if (this.noticesCard == null) {
            this.noticesCard = new NoticesInformationCard(this.getController());
        }
    }

    private void removedFolder(FolderInfo folderInfo) {
        if (this.showingFolder && this.currentFolderInfo != null && this.currentFolderInfo.equals(folderInfo)) {
            this.getUIComponent().setVisible(false);
        }
    }

    private class MyFolderRepositoryListener
    extends FolderRepositoryAdapter {
        private MyFolderRepositoryListener() {
        }

        @Override
        public void folderRemoved(FolderRepositoryEvent folderRepositoryEvent) {
            InformationFrame.this.removedFolder(folderRepositoryEvent.getFolderInfo());
        }

        @Override
        public void folderCreated(FolderRepositoryEvent folderRepositoryEvent) {
            if (InformationFrame.this.getController().isUIOpen() && InformationFrame.this.showingFolder && ConfigurationEntry.FILES_ENABLED.getValueBoolean(InformationFrame.this.getController()).booleanValue()) {
                InformationFrame.this.displayFolderFiles(folderRepositoryEvent.getFolderInfo());
            }
        }

        @Override
        public void folderMoved(FolderRepositoryEvent folderRepositoryEvent) {
            InformationFrame.this.removedFolder(folderRepositoryEvent.getOldFolder().getInfo());
            this.folderCreated(folderRepositoryEvent);
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }
}

