/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.friends;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.ui.util.ColorUtil;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class MemberTableCellRenderer
extends DefaultTableCellRenderer {
    private Controller controller;

    MemberTableCellRenderer(Controller controller) {
        this.controller = controller;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        int n3 = UIUtil.toModel(jTable, n2);
        this.setHorizontalAlignment(2);
        this.setIcon(null);
        if (object instanceof String) {
            if (n3 != 0) {
                object = "";
            }
        } else if (object instanceof Member) {
            Member member = (Member)object;
            switch (n3) {
                case 0: {
                    object = member.getNick();
                    this.setIcon(Icons.getIconFor(member));
                    break;
                }
                case 1: {
                    object = MemberTableCellRenderer.renderAccount(member.getAccountInfo());
                    break;
                }
                case 2: {
                    object = member.isCompletelyConnected() ? Translation.get("exp.friends_panel.connected") : (member.isConnectedToNetwork() ? (member.isUnableToConnect() ? Translation.get("exp.friends_panel.unable_to_connect") : Translation.get("exp.friends_panel.currently_online")) : Format.formatDateShort(member.getLastConnectTime()));
                    if (member.getController().isVerbose()) {
                        String string = member.getLastProblem() != null ? member.getLastProblem().message : "n/a";
                        object = object + " (" + string + ")";
                    }
                    this.setHorizontalAlignment(4);
                    break;
                }
                case 3: {
                    object = MemberTableCellRenderer.replaceNullWithNA(member.getIP());
                    int n4 = member.getPort();
                    if (n4 != 1337) {
                        object = object + ":" + n4;
                    }
                    this.setHorizontalAlignment(4);
                    break;
                }
                case 4: {
                    JCheckBox jCheckBox = new JCheckBox("", member.isOnLAN());
                    jCheckBox.setBackground(n % 2 == 0 ? ColorUtil.EVEN_TABLE_ROW_COLOR : ColorUtil.ODD_TABLE_ROW_COLOR);
                    jCheckBox.setHorizontalAlignment(0);
                    return jCheckBox;
                }
            }
        } else {
            throw new IllegalStateException("don't know how to render this");
        }
        if (!bl) {
            this.setBackground(n % 2 == 0 ? ColorUtil.EVEN_TABLE_ROW_COLOR : ColorUtil.ODD_TABLE_ROW_COLOR);
        }
        return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
    }

    private static String renderAccount(AccountInfo accountInfo) {
        if (accountInfo != null) {
            return accountInfo.getDisplayName();
        }
        return "";
    }

    private static String replaceNullWithNA(String string) {
        return string == null ? Translation.get("exp.friends_panel.n_a") : string;
    }
}

