/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.friends;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.ui.friends.MemberTableCellRenderer;
import de.dal33t.powerfolder.ui.model.SearchNodeTableModel;
import de.dal33t.powerfolder.ui.render.SortedTableHeaderRenderer;
import de.dal33t.powerfolder.ui.util.Icons;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class FindComputersTable
extends JTable {
    private Controller controller;

    public FindComputersTable(Controller controller) {
        this.controller = controller;
    }

    public FindComputersTable(SearchNodeTableModel searchNodeTableModel) {
        super(searchNodeTableModel);
        this.setRowHeight(Icons.getIconById("node_friend_connected.icon").getIconHeight() + 3);
        this.setShowGrid(false);
        this.setDefaultRenderer(Member.class, new MemberTableCellRenderer(this.controller));
        this.getTableHeader().addMouseListener(new TableHeaderMouseListener());
        this.setupColumns();
        SortedTableHeaderRenderer.associateHeaderRenderer(searchNodeTableModel, this.getColumnModel(), 0, true);
    }

    private void setupColumns() {
        int n = this.getWidth();
        this.getTableHeader().setPreferredSize(new Dimension(n, 20));
        TableColumn tableColumn = this.getColumn(this.getColumnName(0));
        tableColumn.setPreferredWidth(140);
        tableColumn = this.getColumn(this.getColumnName(1));
        tableColumn.setPreferredWidth(140);
        tableColumn = this.getColumn(this.getColumnName(2));
        tableColumn.setPreferredWidth(100);
        tableColumn = this.getColumn(this.getColumnName(3));
        tableColumn.setPreferredWidth(100);
        tableColumn = this.getColumn(this.getColumnName(4));
        tableColumn.setPreferredWidth(20);
    }

    private class TableHeaderMouseListener
    extends MouseAdapter {
        private TableHeaderMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                SearchNodeTableModel searchNodeTableModel;
                boolean bl;
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
                TableColumn tableColumn = jTableHeader.getColumnModel().getColumn(n);
                int n2 = tableColumn.getModelIndex();
                TableModel tableModel = jTableHeader.getTable().getModel();
                if (tableModel instanceof SearchNodeTableModel && !(bl = (searchNodeTableModel = (SearchNodeTableModel)tableModel).sortBy(n2))) {
                    searchNodeTableModel.reverseList();
                }
            }
        }
    }
}

