/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.folders;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.clientserver.RemoteCallException;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.clientserver.ServerClientEvent;
import de.dal33t.powerfolder.clientserver.ServerClientListener;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.FolderStatistic;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.disk.problem.ResolvableProblem;
import de.dal33t.powerfolder.event.FolderEvent;
import de.dal33t.powerfolder.event.FolderListener;
import de.dal33t.powerfolder.event.FolderMembershipEvent;
import de.dal33t.powerfolder.event.FolderMembershipListener;
import de.dal33t.powerfolder.event.FolderRepositoryAdapter;
import de.dal33t.powerfolder.event.FolderRepositoryEvent;
import de.dal33t.powerfolder.event.ListenerSupportFactory;
import de.dal33t.powerfolder.event.NodeManagerAdapter;
import de.dal33t.powerfolder.event.NodeManagerEvent;
import de.dal33t.powerfolder.event.TransferManagerAdapter;
import de.dal33t.powerfolder.event.TransferManagerEvent;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.message.clientserver.AccountDetails;
import de.dal33t.powerfolder.security.FolderAdminPermission;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.security.FolderRemovePermission;
import de.dal33t.powerfolder.transfer.DownloadManager;
import de.dal33t.powerfolder.transfer.TransferManager;
import de.dal33t.powerfolder.ui.ExpandableView;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.FolderRemoveDialog;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.event.ExpansionEvent;
import de.dal33t.powerfolder.ui.event.ExpansionListener;
import de.dal33t.powerfolder.ui.folders.ExpandableFolderModel;
import de.dal33t.powerfolder.ui.folders.OnlineStorageComponent;
import de.dal33t.powerfolder.ui.util.CursorUtils;
import de.dal33t.powerfolder.ui.util.DelayedUpdater;
import de.dal33t.powerfolder.ui.util.Help;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.util.SyncIconButtonMini;
import de.dal33t.powerfolder.ui.widget.ActionLabel;
import de.dal33t.powerfolder.ui.widget.ActivityVisualizationWorker;
import de.dal33t.powerfolder.ui.widget.JButtonMini;
import de.dal33t.powerfolder.ui.widget.ResizingJLabel;
import de.dal33t.powerfolder.ui.wizard.PFWizard;
import de.dal33t.powerfolder.util.BrowserLauncher;
import de.dal33t.powerfolder.util.DateUtil;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.os.LinuxUtil;
import de.dal33t.powerfolder.util.os.OSUtil;
import de.dal33t.powerfolder.util.os.Win32.WinUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class ExpandableFolderView
extends PFUIComponent
implements ExpandableView {
    private FolderInfo folderInfo;
    private Folder folder;
    private ExpandableFolderModel.Type type;
    private boolean online;
    private boolean admin;
    private final AtomicBoolean focus = new AtomicBoolean();
    private final AtomicBoolean showing100Sync = new AtomicBoolean();
    private ResizingJLabel nameLabel;
    private JButtonMini openSettingsInformationButton;
    private JButtonMini openFilesInformationButton;
    private JButtonMini inviteButton;
    private ActionLabel membersLabel;
    private ActionLabel upperSyncPercentageLabel;
    private JPanel uiComponent;
    private JPanel borderPanel;
    private JPanel lowerOuterPanel;
    private AtomicBoolean expanded;
    private AtomicBoolean mouseOver;
    private ActionLabel filesLabel;
    private ActionLabel deletedFilesLabel;
    private ActionLabel transferModeLabel;
    private ActionLabel localDirectoryLabel;
    private JLabel syncPercentLabel;
    private ActionLabel syncDateLabel;
    private JLabel localSizeLabel;
    private JLabel totalSizeLabel;
    private JPanel upperPanel;
    private JButtonMini primaryButton;
    private SyncIconButtonMini upperSyncFolderButton;
    private JButtonMini lowerSyncFolderButton;
    private MyFolderListener myFolderListener;
    private MyFolderMembershipListener myFolderMembershipListener;
    private MyTransferManagerListener myTransferManagerListener;
    private MyFolderRepositoryListener myFolderRepositoryListener;
    private MyNodeManagerListener myNodeManagerListener;
    private ToSListener myToSListener;
    private ExpansionListener listenerSupport;
    private OnlineStorageComponent osComponent;
    private ServerClient serverClient;
    private MySyncFolderAction syncFolderAction;
    private MyOpenFilesInformationAction openFilesInformationAction;
    private MyOpenSettingsInformationAction openSettingsInformationAction;
    private MyInviteAction inviteAction;
    private MyOpenMembersInformationAction openMembersInformationAction;
    private MyMostRecentChangesAction mostRecentChangesAction;
    private MyClearCompletedDownloadsAction clearCompletedDownloadsAction;
    private MyOpenExplorerAction openExplorerAction;
    private MoveFolderAction moveFolderLocalAction;
    private FolderRemoveAction removeFolderLocalAction;
    private FolderOnlineRemoveAction removeFolderOnlineAction;
    private BackupOnlineStorageAction backupOnlineStorageAction;
    private StopOnlineStorageAction stopOnlineStorageAction;
    private WebdavAction webdavAction;
    private WebViewAction webViewAction;
    private DelayedUpdater syncUpdater;
    private DelayedUpdater folderUpdater;
    private DelayedUpdater folderDetailsUpdater;
    private String webDAVURL;
    private String ownerDisplayname;
    private String removeLabel;
    private final AtomicBoolean retrieving = new AtomicBoolean(false);

    public ExpandableFolderView(Controller controller, FolderInfo folderInfo) {
        super(controller);
        this.serverClient = controller.getOSClient();
        this.folderInfo = folderInfo;
        this.listenerSupport = ListenerSupportFactory.createListenerSupport(ExpansionListener.class);
        this.admin = this.getController().getOSClient().getAccount().hasAdminPermission(folderInfo);
        this.initComponent();
        this.buildUI();
    }

    public void configure(ExpandableFolderModel expandableFolderModel) {
        boolean bl = false;
        Folder folder = expandableFolderModel.getFolder();
        FolderInfo folderInfo = expandableFolderModel.getFolderInfo().intern();
        ExpandableFolderModel.Type type = expandableFolderModel.getType();
        boolean bl2 = expandableFolderModel.isOnline();
        if (folder != null && this.folder == null) {
            bl = true;
        } else if (folder == null && this.folder != null) {
            bl = true;
        } else if (folder != null && !this.folder.equals(folder)) {
            bl = true;
        } else if (!this.folderInfo.getName().equals(folderInfo.getName())) {
            bl = true;
        } else if (type != this.type) {
            bl = true;
        } else if (bl2 ^ this.online) {
            bl = true;
        }
        if (!bl) {
            return;
        }
        this.unregisterFolderListeners();
        this.type = type;
        this.folder = folder;
        this.folderInfo = folderInfo;
        this.online = bl2;
        this.osComponent.setFolder(folder);
        this.updateStatsDetails();
        this.updateNumberOfFiles();
        this.updateTransferMode();
        this.updateIconAndOS();
        this.updateLocalButtons();
        this.updateNameLabel();
        this.updatePermissions();
        this.updateDeletedFiles();
        this.registerFolderListeners();
    }

    public void expand() {
        if (PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue() && this.type == ExpandableFolderModel.Type.Local) {
            this.expanded.set(true);
            this.retrieveAdditionalInfosFromServer();
            if (PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
                this.upperPanel.setToolTipText(Translation.get("exp_folder_view.collapse"));
            } else {
                this.upperPanel.setToolTipText(Translation.get("exp_folder_view.remove"));
            }
            this.updateNameLabel();
            this.lowerOuterPanel.setVisible(true);
        }
        this.listenerSupport.resetAllButSource(new ExpansionEvent(this));
    }

    @Override
    public void collapse() {
        this.expanded.set(false);
        this.retrieveAdditionalInfosFromServer();
        if (PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
            this.upperPanel.setToolTipText(Translation.get("exp_folder_view.expand"));
        } else {
            this.upperPanel.setToolTipText(Translation.get("exp_folder_view.create"));
        }
        this.updateNameLabel();
        this.lowerOuterPanel.setVisible(false);
    }

    public void setFocus(boolean bl) {
        this.focus.set(bl);
        this.updateBorderPanel();
    }

    public boolean hasFocus() {
        return this.focus.get();
    }

    private void updateBorderPanel() {
        if (this.focus.get()) {
            this.borderPanel.setBorder(BorderFactory.createEtchedBorder());
        } else {
            this.borderPanel.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    private void retrieveAdditionalInfosFromServer() {
        SwingWorker<Object, Void> swingWorker = new SwingWorker<Object, Void>(){

            @Override
            protected Object doInBackground() throws Exception {
                if (ExpandableFolderView.this.retrieving.compareAndSet(false, true)) {
                    try {
                        ExpandableFolderView.this.retrieveWebDAVURL();
                        ExpandableFolderView.this.retrieveOwnerDisplayname();
                    }
                    finally {
                        ExpandableFolderView.this.retrieving.set(false);
                    }
                }
                return null;
            }
        };
        swingWorker.execute();
    }

    private synchronized String retrieveWebDAVURL() {
        if (!this.serverClient.isConnected() || !this.serverClient.isLoggedIn()) {
            return null;
        }
        if (this.webDAVURL == null) {
            this.webDAVURL = this.serverClient.getFolderService(this.folderInfo).getWebDAVURL(this.folderInfo);
            if (this.webDAVURL == null) {
                this.webDAVURL = "";
            }
        }
        return this.webDAVURL;
    }

    private String retrieveOwnerDisplayname() {
        if (!this.serverClient.isConnected() || !this.serverClient.isLoggedIn()) {
            return null;
        }
        if (this.serverClient.getAccount().hasOwnerPermission(this.folderInfo)) {
            return null;
        }
        if (this.ownerDisplayname == null) {
            try {
                this.ownerDisplayname = this.serverClient.getFolderService(this.folderInfo).getOwnerDisplayname(this.folderInfo);
            }
            catch (RemoteCallException remoteCallException) {
                this.logFine("Unsupported/Old server. Not able to retrieve owner name of " + this.folderInfo.getName() + ". " + remoteCallException);
            }
            if (this.ownerDisplayname != null && this.serverClient.getAccount().getDisplayName().equals(this.ownerDisplayname)) {
                this.ownerDisplayname = null;
            }
            if (this.ownerDisplayname == null) {
                this.ownerDisplayname = "";
            } else {
                if (this.isFine()) {
                    this.logFine("Owner of " + this.folderInfo.getName() + ": " + this.ownerDisplayname);
                }
                this.updateNameLabel();
            }
        }
        return this.ownerDisplayname;
    }

    public JPanel getUIComponent() {
        return this.uiComponent;
    }

    private void buildUI() {
        FormLayout formLayout = new FormLayout("pref, 3dlu, pref:grow, 3dlu, pref, 3dlu", "pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.updateIconAndOS();
        panelBuilder.add((Component)this.primaryButton, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.upperSyncFolderButton, cellConstraints.xy(1, 1));
        MyMouseClickAdapter myMouseClickAdapter = new MyMouseClickAdapter();
        MyMouseOverAdapter myMouseOverAdapter = new MyMouseOverAdapter();
        this.nameLabel = new ResizingJLabel();
        panelBuilder.add((Component)this.nameLabel, cellConstraints.xy(3, 1));
        this.nameLabel.addMouseListener(myMouseOverAdapter);
        this.nameLabel.addMouseListener(myMouseClickAdapter);
        panelBuilder.add((Component)this.upperSyncPercentageLabel.getUIComponent(), cellConstraints.xy(5, 1));
        this.upperPanel = panelBuilder.getPanel();
        this.upperPanel.setOpaque(false);
        if (this.type == ExpandableFolderModel.Type.Local) {
            this.upperPanel.setToolTipText(Translation.get("exp_folder_view.expand"));
        }
        CursorUtils.setHandCursor(this.upperPanel);
        this.upperPanel.addMouseListener(myMouseOverAdapter);
        this.upperPanel.addMouseListener(myMouseClickAdapter);
        FormLayout formLayout2 = this.getController().isBackupOnly() ? new FormLayout("3dlu, pref, pref:grow, 3dlu, pref, 3dlu", "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, pref") : new FormLayout("3dlu, pref, pref:grow, 3dlu, pref, 3dlu", "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, pref");
        PanelBuilder panelBuilder2 = new PanelBuilder(formLayout2);
        int n = 1;
        panelBuilder2.addSeparator(null, cellConstraints.xywh(1, n, 6, 1));
        panelBuilder2.add((Component)this.syncDateLabel.getUIComponent(), cellConstraints.xy(2, n += 2));
        panelBuilder2.add((Component)this.lowerSyncFolderButton, cellConstraints.xy(5, n));
        panelBuilder2.add((Component)this.syncPercentLabel, cellConstraints.xy(2, n += 2));
        panelBuilder2.add((Component)this.openFilesInformationButton, cellConstraints.xy(5, n));
        panelBuilder2.add((Component)this.filesLabel.getUIComponent(), cellConstraints.xy(2, n += 2));
        panelBuilder2.add((Component)this.localSizeLabel, cellConstraints.xy(2, n += 2));
        panelBuilder2.add((Component)this.totalSizeLabel, cellConstraints.xy(2, n += 2));
        panelBuilder2.add((Component)this.deletedFilesLabel.getUIComponent(), cellConstraints.xy(2, n += 2));
        panelBuilder2.addSeparator(null, cellConstraints.xywh(2, n += 2, 4, 1));
        n += 2;
        if (this.getController().isBackupOnly()) {
            panelBuilder2.add((Component)this.transferModeLabel.getUIComponent(), cellConstraints.xy(2, n));
            panelBuilder2.add((Component)this.openSettingsInformationButton, cellConstraints.xy(5, n));
            panelBuilder2.add((Component)this.localDirectoryLabel.getUIComponent(), cellConstraints.xy(2, n += 2));
        } else {
            if (ConfigurationEntry.MEMBERS_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
                panelBuilder2.add((Component)this.membersLabel.getUIComponent(), cellConstraints.xy(2, n));
            }
            if (ConfigurationEntry.SERVER_INVITE_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
                panelBuilder2.add((Component)this.inviteButton, cellConstraints.xy(5, n));
            }
            if (ConfigurationEntry.MEMBERS_ENABLED.getValueBoolean(this.getController()).booleanValue() || ConfigurationEntry.SERVER_INVITE_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
                panelBuilder2.addSeparator(null, cellConstraints.xywh(2, n += 2, 4, 1));
            }
            if (!PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
                panelBuilder2.add((Component)this.transferModeLabel.getUIComponent(), cellConstraints.xy(2, n += 2));
                panelBuilder2.add((Component)this.openSettingsInformationButton, cellConstraints.xy(5, n));
                panelBuilder2.add((Component)this.localDirectoryLabel.getUIComponent(), cellConstraints.xy(2, n += 2));
            }
        }
        panelBuilder2.add(this.osComponent.getUIComponent(), cellConstraints.xywh(2, ++n, 4, 1));
        JPanel jPanel = panelBuilder2.getPanel();
        jPanel.setOpaque(false);
        FormLayout formLayout3 = new FormLayout("pref:grow", "3dlu, pref");
        PanelBuilder panelBuilder3 = new PanelBuilder(formLayout3);
        this.lowerOuterPanel = panelBuilder3.getPanel();
        this.lowerOuterPanel.setVisible(false);
        panelBuilder3.add((Component)jPanel, cellConstraints.xy(1, 2));
        FormLayout formLayout4 = new FormLayout("3dlu, pref:grow, 3dlu", "3dlu, pref, pref, 3dlu");
        PanelBuilder panelBuilder4 = new PanelBuilder(formLayout4);
        panelBuilder4.add((Component)this.upperPanel, cellConstraints.xy(2, 2));
        JPanel jPanel2 = panelBuilder3.getPanel();
        jPanel2.setOpaque(false);
        panelBuilder4.add((Component)jPanel2, cellConstraints.xy(2, 3));
        this.borderPanel = panelBuilder4.getPanel();
        this.borderPanel.setOpaque(false);
        FormLayout formLayout5 = new FormLayout("3dlu, pref:grow, 3dlu", "pref, 3dlu");
        PanelBuilder panelBuilder5 = new PanelBuilder(formLayout5);
        panelBuilder5.add((Component)this.borderPanel, cellConstraints.xy(2, 1));
        this.uiComponent = panelBuilder5.getPanel();
        this.uiComponent.setOpaque(false);
    }

    private void initComponent() {
        this.syncUpdater = new DelayedUpdater(this.getController(), 1000L);
        this.folderDetailsUpdater = new DelayedUpdater(this.getController());
        this.folderUpdater = new DelayedUpdater(this.getController());
        this.openFilesInformationAction = new MyOpenFilesInformationAction(this.getController());
        this.inviteAction = new MyInviteAction(this.getController());
        this.inviteAction.allowWith(FolderPermission.admin(this.folderInfo));
        this.openSettingsInformationAction = new MyOpenSettingsInformationAction(this.getController());
        this.openSettingsInformationAction.setEnabled(!this.getController().isBackupOnly());
        MyMoveLocalFolderAction myMoveLocalFolderAction = new MyMoveLocalFolderAction(this.getController());
        myMoveLocalFolderAction.setEnabled(!this.getController().isBackupOnly());
        this.openMembersInformationAction = new MyOpenMembersInformationAction(this.getController());
        this.mostRecentChangesAction = new MyMostRecentChangesAction(this.getController());
        this.clearCompletedDownloadsAction = new MyClearCompletedDownloadsAction(this.getController());
        this.openExplorerAction = new MyOpenExplorerAction(this.getController());
        this.moveFolderLocalAction = new MoveFolderAction(this.getController());
        this.removeFolderLocalAction = new FolderRemoveAction(this.getController());
        this.removeLabel = this.admin ? "action_remove_online_folder_admin" : "action_remove_online_folder";
        this.removeFolderOnlineAction = new FolderOnlineRemoveAction(this.getController());
        this.removeFolderOnlineAction.allowWith(FolderRemovePermission.INSTANCE);
        this.backupOnlineStorageAction = new BackupOnlineStorageAction(this.getController());
        this.stopOnlineStorageAction = new StopOnlineStorageAction(this.getController());
        this.syncFolderAction = new MySyncFolderAction(this.getController());
        this.webdavAction = new WebdavAction(this.getController());
        this.webViewAction = new WebViewAction(this.getController());
        this.expanded = new AtomicBoolean();
        this.mouseOver = new AtomicBoolean();
        this.osComponent = new OnlineStorageComponent(this.getController(), this.folder);
        this.primaryButton = new JButtonMini(Icons.getIconById("blank.icon"), "");
        this.primaryButton.addActionListener(new PrimaryButtonActionListener());
        this.openSettingsInformationButton = new JButtonMini(this.openSettingsInformationAction);
        this.upperSyncPercentageLabel = new ActionLabel(this.getController(), new MyOpenFilesUnsyncedAction(this.getController()));
        if (!ConfigurationEntry.FILES_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
            this.upperSyncPercentageLabel.setNeverUnderline(true);
        }
        this.openFilesInformationButton = new JButtonMini(this.openFilesInformationAction);
        this.openFilesInformationButton.setVisible(ConfigurationEntry.FILES_ENABLED.getValueBoolean(this.getController()));
        this.inviteButton = new JButtonMini(this.inviteAction);
        this.upperSyncFolderButton = new SyncIconButtonMini(this.getController());
        this.upperSyncFolderButton.addActionListener(new PrimaryButtonActionListener());
        this.upperSyncFolderButton.setVisible(false);
        Icon icon = Icons.getIconById("sync_complete.icon");
        Icon icon2 = Icons.getIconById(Icons.SYNC_ANIMATION[0]);
        if (icon.getIconHeight() > icon2.getIconHeight()) {
            this.upperSyncFolderButton.setBorder(Borders.createEmptyBorder("6, 6, 6, 6"));
        }
        this.lowerSyncFolderButton = new JButtonMini(this.syncFolderAction);
        this.filesLabel = new ActionLabel(this.getController(), this.openFilesInformationAction);
        this.transferModeLabel = new ActionLabel(this.getController(), this.openSettingsInformationAction);
        this.localDirectoryLabel = new ActionLabel(this.getController(), myMoveLocalFolderAction);
        this.syncPercentLabel = new JLabel();
        this.syncDateLabel = new ActionLabel(this.getController(), this.mostRecentChangesAction);
        this.localSizeLabel = new JLabel();
        this.totalSizeLabel = new JLabel();
        this.membersLabel = new ActionLabel(this.getController(), this.openMembersInformationAction);
        this.deletedFilesLabel = new ActionLabel(this.getController(), new MyDeletedFilesAction());
        this.updateNumberOfFiles();
        this.updateStatsDetails();
        this.updateTransferMode();
        this.updateLocalButtons();
        this.updateIconAndOS();
        this.updatePermissions();
        this.registerListeners();
    }

    private void updatePermissions() {
        FolderAdminPermission folderAdminPermission = FolderPermission.admin(this.folderInfo);
        this.backupOnlineStorageAction.allowWith(folderAdminPermission);
        this.stopOnlineStorageAction.allowWith(folderAdminPermission);
        this.inviteAction.allowWith(folderAdminPermission);
        this.admin = this.getController().getOSClient().getAccount().hasAdminPermission(this.folderInfo);
        if (ConfigurationEntry.SERVER_SYNC_MANDATORY.getValueBoolean(this.getController()).booleanValue()) {
            this.stopOnlineStorageAction.setEnabled(false);
        }
    }

    private void updateLocalButtons() {
        boolean bl = this.type == ExpandableFolderModel.Type.Local;
        this.openSettingsInformationButton.setEnabled(bl && !this.getController().isBackupOnly());
        this.transferModeLabel.setEnabled(bl && !this.getController().isBackupOnly());
        this.localDirectoryLabel.setEnabled(bl && !this.getController().isBackupOnly());
        this.openSettingsInformationAction.setEnabled(bl && !this.getController().isBackupOnly());
        this.openFilesInformationButton.setEnabled(bl);
        this.openFilesInformationAction.setEnabled(bl);
        this.inviteButton.setEnabled(bl && !this.getController().isBackupOnly());
        this.inviteAction.setEnabled(bl && !this.getController().isBackupOnly());
        this.syncDateLabel.setEnabled(bl);
        this.mostRecentChangesAction.setEnabled(bl);
        this.membersLabel.setEnabled(bl);
        this.openMembersInformationAction.setEnabled(bl && !this.getController().isBackupOnly());
        this.openExplorerAction.setEnabled(bl);
        this.updateSyncButton();
    }

    private void updateSyncButton() {
        if (this.type != ExpandableFolderModel.Type.Local) {
            this.upperSyncFolderButton.setVisible(false);
            this.upperSyncFolderButton.spin(false);
            this.primaryButton.setVisible(true);
            return;
        }
        this.syncUpdater.schedule(new Runnable(){

            @Override
            public void run() {
                if (ExpandableFolderView.this.folder == null) {
                    return;
                }
                if (ExpandableFolderView.this.folder.isTransferring()) {
                    ExpandableFolderView.this.primaryButton.setVisible(false);
                    ExpandableFolderView.this.upperSyncFolderButton.setVisible(true);
                    ExpandableFolderView.this.upperSyncFolderButton.spin(true);
                } else {
                    ExpandableFolderView.this.primaryButton.setVisible(true);
                    ExpandableFolderView.this.upperSyncFolderButton.setVisible(false);
                    ExpandableFolderView.this.upperSyncFolderButton.spin(false);
                }
            }
        });
    }

    private void registerListeners() {
        this.myNodeManagerListener = new MyNodeManagerListener();
        this.getController().getNodeManager().addNodeManagerListener(this.myNodeManagerListener);
        this.myTransferManagerListener = new MyTransferManagerListener();
        this.getController().getTransferManager().addListener(this.myTransferManagerListener);
        this.myFolderRepositoryListener = new MyFolderRepositoryListener();
        this.getController().getFolderRepository().addFolderRepositoryListener(this.myFolderRepositoryListener);
        this.myToSListener = new ToSListener();
        this.getController().getOSClient().addListener(this.myToSListener);
    }

    public void unregisterListeners() {
        if (this.myToSListener != null) {
            this.getController().getOSClient().removeListener(this.myToSListener);
        }
        if (this.myNodeManagerListener != null) {
            this.getController().getNodeManager().removeNodeManagerListener(this.myNodeManagerListener);
            this.myNodeManagerListener = null;
        }
        if (this.myTransferManagerListener != null) {
            this.getController().getTransferManager().removeListener(this.myTransferManagerListener);
            this.myTransferManagerListener = null;
        }
        if (this.myFolderRepositoryListener != null) {
            this.getController().getFolderRepository().removeFolderRepositoryListener(this.myFolderRepositoryListener);
            this.myFolderRepositoryListener = null;
        }
        this.unregisterFolderListeners();
    }

    private void registerFolderListeners() {
        if (this.folder != null) {
            this.myFolderListener = new MyFolderListener();
            this.folder.addFolderListener(this.myFolderListener);
            this.myFolderMembershipListener = new MyFolderMembershipListener();
            this.folder.addMembershipListener(this.myFolderMembershipListener);
        }
    }

    private void unregisterFolderListeners() {
        if (this.folder != null) {
            if (this.myFolderListener != null) {
                this.folder.removeFolderListener(this.myFolderListener);
                this.myFolderListener = null;
            }
            if (this.myFolderMembershipListener != null) {
                this.folder.removeMembershipListener(this.myFolderMembershipListener);
                this.myFolderMembershipListener = null;
            }
        }
    }

    public FolderInfo getFolderInfo() {
        return this.folderInfo;
    }

    private void updateStatsDetails() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5 = null;
        if (this.type == ExpandableFolderModel.Type.Local) {
            Object object;
            Date date = this.folder.getLastSyncDate();
            if (date == null) {
                string4 = Translation.get("exp_folder_view.never_synchronized");
            } else {
                object = Format.formatDateShort(date);
                string4 = Translation.get("exp_folder_view.last_synchronized", new String[]{object});
            }
            if (this.folder.hasOwnDatabase()) {
                Date date2;
                object = this.folder.getStatistic();
                double d = ((FolderStatistic)object).getHarmonizedSyncPercentage();
                if (d < -1.0) {
                    d = -1.0;
                }
                if (d > 100.0) {
                    d = 100.0;
                }
                if (Double.compare(d, 100.0) < 0 && Double.compare(d, -1.0) > 0 && (date2 = this.folder.getStatistic().getEstimatedSyncDate()) != null) {
                    int n;
                    int n2;
                    int n3;
                    string4 = DateUtil.isDateMoreThanNDaysInFuture(date2, 2) ? Translation.get("main_frame.sync_eta_unknown") : (DateUtil.isDateMoreThanNHoursInFuture(date2, 20) ? ((n3 = DateUtil.getDaysInFuture(date2)) <= 1 ? Translation.get("exp_folder_view.sync_eta_one_day") : Translation.get("exp_folder_view.sync_eta_days", String.valueOf(n3))) : (DateUtil.isDateMoreThanNMinutesInFuture(date2, 45) ? ((n2 = DateUtil.getDaysInFuture(date2)) <= 1 ? Translation.get("exp_folder_view.sync_eta_one_hour") : Translation.get("exp_folder_view.sync_eta_hours", String.valueOf(n2))) : ((n = DateUtil.getHoursInFuture(date2)) <= 1 ? Translation.get("exp_folder_view.sync_eta_one_minute") : Translation.get("exp_folder_view.sync_eta_minutes", String.valueOf(n)))));
                }
                if (date == null && (Double.compare(d, 100.0) == 0 || Double.compare(d, -1.0) == 0)) {
                    string3 = Translation.get("exp_folder_view.unsynchronized");
                    this.showing100Sync.set(false);
                } else {
                    this.showing100Sync.set(Double.compare(d, 100.0) == 0);
                    if (Double.compare(d, -1.0) == 0) {
                        if (this.folder.getCompletelyConnectedMembersCount() >= 1) {
                            string3 = Translation.get("exp_folder_view.unsynchronized");
                            string5 = Translation.get("exp_folder_view.unsynchronized.tip");
                        } else {
                            string3 = "";
                            string5 = "";
                        }
                    } else {
                        string3 = Translation.get("exp_folder_view.synchronized", Format.formatPercent(d));
                        string3 = string3.replace("%%", "%");
                    }
                }
                if (date != null && Double.compare(d, 100.0) == 0) {
                    this.folder.checkSync();
                }
                long l = ((FolderStatistic)object).getLocalSize();
                string2 = Format.formatBytesShort(l);
                long l2 = ((FolderStatistic)object).getTotalSize();
                string = Format.formatBytesShort(l2);
                if (d >= 0.0 && d < 100.0) {
                    this.upperSyncPercentageLabel.setText(Format.formatPercent(d));
                } else {
                    this.upperSyncPercentageLabel.setText("");
                }
            } else {
                this.upperSyncPercentageLabel.setText("");
                this.showing100Sync.set(false);
                string3 = Translation.get("exp_folder_view.not_yet_scanned");
                string2 = "?";
                string = "?";
            }
        } else {
            this.upperSyncPercentageLabel.setText("");
            string3 = Translation.get("exp_folder_view.synchronized", "?");
            string4 = Translation.get("exp_folder_view.last_synchronized", "?");
            string2 = "?";
            string = "?";
        }
        this.syncPercentLabel.setText(string3);
        this.syncPercentLabel.setToolTipText(string5);
        this.syncDateLabel.setText(string4);
        this.localSizeLabel.setText(Translation.get("exp_folder_view.local", string2));
        this.totalSizeLabel.setText(Translation.get("exp_folder_view.total", string));
        this.retrieveAdditionalInfosFromServer();
    }

    private void updateNumberOfFiles() {
        String string = this.type == ExpandableFolderModel.Type.Local ? Translation.get("exp_folder_view.files", String.valueOf(this.folder.getStatistic().getLocalFilesCount())) : Translation.get("exp_folder_view.files", "?");
        this.filesLabel.setText(string);
    }

    private void updateDeletedFiles() {
        String string;
        if (this.type == ExpandableFolderModel.Type.Local) {
            Collection<FileInfo> collection = this.folder.getDAO().findAllFiles(this.getController().getMySelf().getId());
            int n = 0;
            for (FileInfo fileInfo : collection) {
                if (!fileInfo.isDeleted()) continue;
                ++n;
            }
            string = Translation.get("exp_folder_view.deleted_files", String.valueOf(n));
        } else {
            string = Translation.get("exp_folder_view.deleted_files", "?");
        }
        this.deletedFilesLabel.setText(string);
    }

    private void updateTransferMode() {
        String string;
        if (this.type == ExpandableFolderModel.Type.Local) {
            string = Translation.get("exp_folder_view.transfer_mode", this.folder.getSyncProfile().getName());
            Object object = this.folder.getCommitOrLocalDir().toAbsolutePath().toString();
            if (((String)object).length() >= 35) {
                object = ((String)object).substring(0, 15) + "..." + ((String)object).substring(((String)object).length() - 15, ((String)object).length());
            }
            this.localDirectoryLabel.setVisible(true);
            this.localDirectoryLabel.setText((String)object);
        } else {
            string = Translation.get("exp_folder_view.transfer_mode", "?");
            this.localDirectoryLabel.setVisible(false);
        }
        this.transferModeLabel.setText(string);
    }

    public void updateIconAndOS() {
        double d;
        boolean bl;
        boolean bl2 = bl = this.getController().getOSClient().isBackupByDefault() && !this.getController().isBackupOnly();
        if (this.type == ExpandableFolderModel.Type.Local) {
            d = this.folder.getStatistic().getHarmonizedSyncPercentage();
            if (this.folder != null && this.folder.countProblems() > 0) {
                this.primaryButton.setIcon(Icons.getIconById("problems.icon"));
                this.primaryButton.setToolTipText(Translation.get("exp_folder_view.folder_problem_text"));
            } else if (this.getController().isPaused() && Double.compare(d, 100.0) < 0 && d != -1.0) {
                this.primaryButton.setIcon(Icons.getIconById("pause.icon"));
                this.primaryButton.setToolTipText(Translation.get("exp_folder_view.folder_sync_paused"));
            } else if (Double.compare(d, 100.0) < 0) {
                this.primaryButton.setIcon(Icons.getIconById("sync_incomplete.icon"));
                this.primaryButton.setToolTipText(Translation.get("exp_folder_view.folder_sync_incomplete"));
            } else {
                this.primaryButton.setIcon(Icons.getIconById("local_folder.icon"));
                if (PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
                    this.primaryButton.setToolTipText(Translation.get("exp_folder_view.folder_sync_complete"));
                } else {
                    this.primaryButton.setToolTipText(Translation.get("exp_folder_view.explore"));
                }
            }
        } else if (this.type == ExpandableFolderModel.Type.Typical) {
            this.primaryButton.setIcon(Icons.getIconById("typical_folder.icon"));
            this.primaryButton.setToolTipText(Translation.get("exp_folder_view.folder_typical_text"));
            this.osComponent.getUIComponent().setVisible(false);
        } else {
            this.primaryButton.setIcon(Icons.getIconById("online_folder.icon"));
            this.primaryButton.setToolTipText(Translation.get("exp_folder_view.folder_online_text"));
            this.osComponent.getUIComponent().setVisible(bl);
        }
        this.osComponent.getUIComponent().setVisible(bl);
        if (bl) {
            d = 0.0;
            if (this.folder != null) {
                d = this.folder.getStatistic().getServerSyncPercentage();
            }
            boolean bl3 = this.serverClient.getAccountDetails().getAccount().getOSSubscription().isDisabledUsage();
            boolean bl4 = this.folder != null && this.serverClient.joinedByCloud(this.folder);
            this.osComponent.setSyncPercentage(d, bl3, bl4);
        }
    }

    public void addExpansionListener(ExpansionListener expansionListener) {
        ListenerSupportFactory.addListener(this.listenerSupport, expansionListener);
    }

    public void removeExpansionListener(ExpansionListener expansionListener) {
        ListenerSupportFactory.removeListener(this.listenerSupport, expansionListener);
    }

    public boolean isExpanded() {
        return this.expanded.get();
    }

    public JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (this.type == ExpandableFolderModel.Type.CloudOnly) {
            this.retrieveWebDAVURL();
            if (StringUtils.isNotBlank(this.webDAVURL)) {
                if (this.serverClient.supportsWebDAV() && !PreferencesEntry.WEBDAV_ONLY.getValueBoolean(this.getController()).booleanValue()) {
                    jPopupMenu.add(this.webdavAction).setIcon(null);
                }
                if (this.serverClient.supportsWebLogin()) {
                    jPopupMenu.add(this.webViewAction).setIcon(null);
                }
            }
            jPopupMenu.add(this.removeFolderOnlineAction).setIcon(null);
        } else {
            boolean bl;
            jPopupMenu.add(this.openExplorerAction).setIcon(null);
            jPopupMenu.addSeparator();
            boolean bl2 = PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController());
            if (bl2) {
                if (!this.folder.getSyncProfile().equals(SyncProfile.AUTOMATIC_SYNCHRONIZATION)) {
                    jPopupMenu.add(this.syncFolderAction).setIcon(null);
                }
                jPopupMenu.add(this.openFilesInformationAction).setIcon(null);
                jPopupMenu.add(this.mostRecentChangesAction).setIcon(null);
                jPopupMenu.add(this.clearCompletedDownloadsAction).setIcon(null);
            }
            if (!this.getController().isBackupOnly()) {
                bl = false;
                if (ConfigurationEntry.SERVER_INVITE_ENABLED.getValueBoolean(this.getController()).booleanValue() && this.admin) {
                    jPopupMenu.addSeparator();
                    bl = true;
                    jPopupMenu.add(this.inviteAction).setIcon(null);
                }
                if (bl2) {
                    if (!bl) {
                        jPopupMenu.addSeparator();
                    }
                    jPopupMenu.add(this.openMembersInformationAction).setIcon(null);
                }
            }
            jPopupMenu.addSeparator();
            if (ConfigurationEntry.SETTINGS_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
                jPopupMenu.add(this.openSettingsInformationAction).setIcon(null);
            }
            jPopupMenu.add(this.moveFolderLocalAction).setIcon(null);
            if (this.getController().getOSClient().isAllowedToRemoveFolders()) {
                jPopupMenu.add(this.removeFolderLocalAction).setIcon(null);
            }
            if (bl2 && this.serverClient.isConnected() && this.serverClient.isLoggedIn()) {
                bl = this.serverClient.joinedByCloud(this.folder);
                if (bl) {
                    if (!ConfigurationEntry.SERVER_SYNC_MANDATORY.getValueBoolean(this.getController()).booleanValue()) {
                        jPopupMenu.add(this.stopOnlineStorageAction).setIcon(null);
                    }
                } else {
                    jPopupMenu.add(this.backupOnlineStorageAction).setIcon(null);
                }
            }
        }
        return jPopupMenu;
    }

    public void updateNameLabel() {
        boolean bl = false;
        Object object = "";
        Object object2 = "";
        if (this.folder != null) {
            int n = this.getController().getTransferManager().countCompletedDownloads(this.folder);
            if (PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
                boolean bl2 = bl = n > 0;
            }
            if (bl) {
                object = " (" + n + ")";
                this.nameLabel.setToolTipText(Translation.get("exp_folder_view.new_files_tip_text", String.valueOf(n)));
            }
        }
        if (!bl && this.folder != null) {
            if (this.expanded.get()) {
                this.nameLabel.setToolTipText(Translation.get("exp_folder_view.collapse"));
            } else if (PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
                this.nameLabel.setToolTipText(Translation.get("exp_folder_view.expand"));
            } else {
                this.nameLabel.setToolTipText(Translation.get("exp_folder_view.remove"));
            }
        }
        if (this.folder == null) {
            this.nameLabel.setToolTipText(Translation.get("exp_folder_view.folder_online_text"));
        }
        String string = this.folderInfo.getLocalizedName();
        if (StringUtils.isNotBlank(this.ownerDisplayname)) {
            object2 = (String)object2 + " (" + this.ownerDisplayname + ")";
        }
        this.nameLabel.setText(string + (String)object + (String)object2);
        this.nameLabel.setFont(new Font(this.nameLabel.getFont().getName(), bl ? 1 : 0, this.nameLabel.getFont().getSize()));
        this.clearCompletedDownloadsAction.setEnabled(bl);
    }

    private void createWebdavConnection() {
        ActivityVisualizationWorker activityVisualizationWorker = new ActivityVisualizationWorker(this.getUIController()){

            @Override
            protected String getTitle() {
                return Translation.get("exp_folder_view.webdav_title");
            }

            @Override
            protected String getWorkingText() {
                return Translation.get("exp_folder_view.webdav_working_text");
            }

            @Override
            public Object construct() throws Throwable {
                try {
                    ExpandableFolderView.this.retrieveWebDAVURL();
                    if (OSUtil.isLinux()) {
                        return LinuxUtil.mountWebDAV(ExpandableFolderView.this.serverClient, ExpandableFolderView.this.webDAVURL);
                    }
                    WinUtils winUtils = WinUtils.getInstance();
                    if (winUtils != null) {
                        return WinUtils.mountWebDAV(ExpandableFolderView.this.serverClient, ExpandableFolderView.this.webDAVURL);
                    }
                    return Character.valueOf('N');
                }
                catch (Exception exception) {
                    ExpandableFolderView.this.logSevere(exception.getMessage(), exception);
                    return "N" + exception.getMessage();
                }
            }

            @Override
            public void finished() {
                String string = (String)this.get();
                if (string != null) {
                    if (string.startsWith("Y")) {
                        String[] stringArray;
                        for (final String string2 : stringArray = string.substring(1).split("\\s")) {
                            if (string2.length() != 2 || string2.charAt(1) != ':') continue;
                            ExpandableFolderView.this.getController().getIOProvider().startIO(new Runnable(){

                                @Override
                                public void run() {
                                    PathUtils.openFile(Paths.get(string2, new String[0]));
                                }
                            });
                            break;
                        }
                    } else if (string.startsWith("N")) {
                        String[] stringArray = Help.hasWiki(ExpandableFolderView.this.getController()) ? new String[]{Translation.get("general.ok"), Translation.get("general.help")} : new String[]{Translation.get("general.ok")};
                        int n = DialogFactory.genericDialog(ExpandableFolderView.this.getController(), Translation.get("exp_folder_view.webdav_failure_title"), Translation.get("exp_folder_view.webdav_failure_text", string.substring(1)), stringArray, 0, GenericDialogType.ERROR);
                        if (n == 1) {
                            Help.openWikiArticle(ExpandableFolderView.this.getController(), "WebDAV");
                        }
                    }
                }
            }
        };
        activityVisualizationWorker.start();
    }

    private void askToCreateFolder() {
        if (this.type != ExpandableFolderModel.Type.Typical) {
            this.logSevere("Folder " + this.folderInfo.getName() + " is not Typical");
            return;
        }
        PFWizard.openTypicalFolderJoinWizard(this.getController(), this.folderInfo);
    }

    private void doFolderChanges(Folder folder) {
        if (this.folder == null || this.folder.equals(folder)) {
            this.folderUpdater.schedule(new Runnable(){

                @Override
                public void run() {
                    ExpandableFolderView.this.updateNumberOfFiles();
                    ExpandableFolderView.this.updateDeletedFiles();
                    ExpandableFolderView.this.updateStatsDetails();
                    ExpandableFolderView.this.updateIconAndOS();
                    ExpandableFolderView.this.updateLocalButtons();
                    ExpandableFolderView.this.updateTransferMode();
                    ExpandableFolderView.this.updatePermissions();
                }
            });
        }
    }

    void dispose() {
        this.removeFolderLocalAction.dispose();
        this.removeFolderOnlineAction.dispose();
        this.backupOnlineStorageAction.dispose();
        this.stopOnlineStorageAction.dispose();
        this.inviteAction.dispose();
    }

    private class MySyncFolderAction
    extends BaseAction {
        private MySyncFolderAction(Controller controller) {
            super("action_sync_folder", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ExpandableFolderView.this.getApplicationModel().syncFolder(ExpandableFolderView.this.folder);
        }
    }

    private class MyMouseClickAdapter
    extends MouseAdapter {
        private MyMouseClickAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        private void showContextMenu(MouseEvent mouseEvent) {
            Cursor cursor = CursorUtils.setWaitCursor(ExpandableFolderView.this.upperPanel);
            try {
                ExpandableFolderView.this.createPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
            finally {
                CursorUtils.returnToOriginal(ExpandableFolderView.this.upperPanel, cursor);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                ExpandableFolderView.this.setFocus(true);
                if (ExpandableFolderView.this.expanded.get()) {
                    ExpandableFolderView.this.collapse();
                } else {
                    boolean bl;
                    ExpandableFolderView.this.expand();
                    if (ExpandableFolderView.this.type == ExpandableFolderModel.Type.Local && !(bl = ExpandableFolderView.this.getController().getUIController().openFilesInformation(ExpandableFolderView.this.folderInfo))) {
                        ExpandableFolderView.this.getApplicationModel().openExplorer(ExpandableFolderView.this.folder);
                    }
                    if (ExpandableFolderView.this.type == ExpandableFolderModel.Type.CloudOnly && ExpandableFolderView.this.folderInfo != null) {
                        if (!PreferencesEntry.WEBDAV_ONLY.getValueBoolean(ExpandableFolderView.this.getController()).booleanValue()) {
                            PFWizard.openOnlineStorageJoinWizard(ExpandableFolderView.this.getController(), Collections.singletonList(ExpandableFolderView.this.folderInfo));
                        } else {
                            ExpandableFolderView.this.getApplicationModel().openExplorerWebDAVPath(ExpandableFolderView.this.folderInfo);
                        }
                    }
                    if (ExpandableFolderView.this.type == ExpandableFolderModel.Type.Typical) {
                        ExpandableFolderView.this.askToCreateFolder();
                    }
                }
            }
        }
    }

    private class MyMouseOverAdapter
    extends MouseAdapter {
        private MyMouseOverAdapter() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            ExpandableFolderView.this.mouseOver.set(true);
            if (PreferencesEntry.AUTO_EXPAND.getValueBoolean(ExpandableFolderView.this.getController()).booleanValue() && !ExpandableFolderView.this.expanded.get()) {
                ExpandableFolderView.this.getController().schedule(() -> {
                    if (ExpandableFolderView.this.mouseOver.get() && !ExpandableFolderView.this.expanded.get()) {
                        ExpandableFolderView.this.expand();
                        PreferencesEntry.AUTO_EXPAND.setValue(ExpandableFolderView.this.getController(), Boolean.FALSE);
                    }
                }, 2000L);
            }
            ExpandableFolderView.this.retrieveAdditionalInfosFromServer();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            ExpandableFolderView.this.mouseOver.set(false);
            ExpandableFolderView.this.retrieveAdditionalInfosFromServer();
        }
    }

    private class MyOpenFilesInformationAction
    extends BaseAction {
        MyOpenFilesInformationAction(Controller controller) {
            super("action_open_files_information", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getController().getUIController().openFilesInformation(ExpandableFolderView.this.folderInfo);
        }
    }

    private class MyInviteAction
    extends BaseAction {
        private MyInviteAction(Controller controller) {
            super("action_invite_friend", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PFWizard.openSendInvitationWizard(this.getController(), ExpandableFolderView.this.folderInfo);
        }
    }

    private class MyOpenSettingsInformationAction
    extends BaseAction {
        private MyOpenSettingsInformationAction(Controller controller) {
            super("action_open_settings_information", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getController().getUIController().openSettingsInformation(ExpandableFolderView.this.folderInfo);
        }
    }

    private class MyMoveLocalFolderAction
    extends BaseAction {
        private MyMoveLocalFolderAction(Controller controller) {
            super("action_move_local_folder", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getController().getUIController().moveLocalFolder(ExpandableFolderView.this.folderInfo);
        }
    }

    private class MyOpenMembersInformationAction
    extends BaseAction {
        MyOpenMembersInformationAction(Controller controller) {
            super("action_open_members_information", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getController().getUIController().openMembersInformation(ExpandableFolderView.this.folderInfo);
        }
    }

    private class MyMostRecentChangesAction
    extends BaseAction {
        private MyMostRecentChangesAction(Controller controller) {
            super("action_most_recent_changes", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getController().getUIController().openFilesInformationLatest(ExpandableFolderView.this.folderInfo);
        }
    }

    private class MyClearCompletedDownloadsAction
    extends BaseAction {
        private MyClearCompletedDownloadsAction(Controller controller) {
            super("exp.action_clear_completed_downloads", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TransferManager transferManager = this.getController().getTransferManager();
            for (DownloadManager downloadManager : transferManager.getCompletedDownloadsCollection()) {
                if (!downloadManager.getFileInfo().getFolderInfo().equals(ExpandableFolderView.this.folder.getInfo())) continue;
                transferManager.clearCompletedDownload(downloadManager);
            }
        }
    }

    private class MyOpenExplorerAction
    extends BaseAction {
        private MyOpenExplorerAction(Controller controller) {
            super("action_open_explorer", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ExpandableFolderView.this.getApplicationModel().openExplorer(ExpandableFolderView.this.folder);
        }
    }

    private class MoveFolderAction
    extends BaseAction {
        private MoveFolderAction(Controller controller) {
            super("action_move_folder", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getController().getUIController().getApplicationModel().moveLocalFolder(ExpandableFolderView.this.folder);
        }
    }

    private class FolderRemoveAction
    extends BaseAction {
        private FolderRemoveAction(Controller controller) {
            super("action_remove_folder", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FolderRemoveDialog folderRemoveDialog = new FolderRemoveDialog(this.getController(), ExpandableFolderView.this.folderInfo);
            folderRemoveDialog.open();
        }
    }

    private class FolderOnlineRemoveAction
    extends BaseAction {
        private FolderOnlineRemoveAction(Controller controller) {
            super(ExpandableFolderView.this.removeLabel, controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FolderRemoveDialog folderRemoveDialog = new FolderRemoveDialog(this.getController(), ExpandableFolderView.this.folderInfo);
            folderRemoveDialog.open();
        }
    }

    private class BackupOnlineStorageAction
    extends BaseAction {
        private BackupOnlineStorageAction(Controller controller) {
            super("exp.action_backup_online_storage", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getUIController().getApplicationModel().getServerClientModel().checkAndSetupAccount();
            PFWizard.openMirrorFolderWizard(this.getController(), ExpandableFolderView.this.folder);
        }
    }

    private class StopOnlineStorageAction
    extends BaseAction {
        private StopOnlineStorageAction(Controller controller) {
            super("exp.action_stop_online_storage", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getUIController().getApplicationModel().getServerClientModel().checkAndSetupAccount();
            PFWizard.openMirrorFolderWizard(this.getController(), ExpandableFolderView.this.folder);
        }
    }

    private class WebdavAction
    extends BaseAction {
        private WebdavAction(Controller controller) {
            super("action_webdav", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ExpandableFolderView.this.createWebdavConnection();
        }
    }

    private class WebViewAction
    extends BaseAction {
        private WebViewAction(Controller controller) {
            super("action_webview", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            final ServerClient serverClient = this.getController().getOSClient();
            if (serverClient.supportsWebLogin()) {
                BrowserLauncher.open(this.getController(), new BrowserLauncher.URLProducer(){

                    @Override
                    public String url() {
                        FolderInfo folderInfo = ExpandableFolderView.this.folder != null ? ExpandableFolderView.this.folder.getInfo() : ExpandableFolderView.this.folderInfo;
                        return serverClient.getFolderURLWithCredentials(folderInfo);
                    }
                });
            }
        }
    }

    private class PrimaryButtonActionListener
    implements ActionListener {
        private PrimaryButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ExpandableFolderView.this.type == ExpandableFolderModel.Type.Local && ExpandableFolderView.this.folder != null && ExpandableFolderView.this.folder.countProblems() > 0) {
                if (!ConfigurationEntry.PROBLEMS_ENABLED.getValueBoolean(ExpandableFolderView.this.getController()).booleanValue()) {
                    ResolvableProblem resolvableProblem = (ResolvableProblem)ExpandableFolderView.this.folder.getProblems().get(0);
                    DialogFactory.genericDialog(ExpandableFolderView.this.getController(), resolvableProblem.getDescription(), resolvableProblem.getDescription(), GenericDialogType.WARN);
                    SwingUtilities.invokeLater(resolvableProblem.resolution(ExpandableFolderView.this.getController()));
                    ExpandableFolderView.this.folder.removeProblem(resolvableProblem);
                } else {
                    ExpandableFolderView.this.getController().getUIController().openProblemsInformation(ExpandableFolderView.this.folderInfo);
                }
            } else if (ExpandableFolderView.this.type == ExpandableFolderModel.Type.CloudOnly) {
                if (!PreferencesEntry.WEBDAV_ONLY.getValueBoolean(ExpandableFolderView.this.getController()).booleanValue()) {
                    PFWizard.openOnlineStorageJoinWizard(ExpandableFolderView.this.getController(), Collections.singletonList(ExpandableFolderView.this.folderInfo));
                } else {
                    ExpandableFolderView.this.getApplicationModel().openExplorerWebDAVPath(ExpandableFolderView.this.folderInfo);
                }
            } else if (ExpandableFolderView.this.type == ExpandableFolderModel.Type.Local) {
                ExpandableFolderView.this.getApplicationModel().openExplorer(ExpandableFolderView.this.folder);
            } else {
                ExpandableFolderView.this.askToCreateFolder();
            }
        }
    }

    private class MyOpenFilesUnsyncedAction
    extends BaseAction {
        MyOpenFilesUnsyncedAction(Controller controller) {
            super("action_open_files_unsynced", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getController().getUIController().openFilesInformationUnsynced(ExpandableFolderView.this.folderInfo);
        }
    }

    private class MyDeletedFilesAction
    extends AbstractAction {
        private MyDeletedFilesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ExpandableFolderView.this.getController().getUIController().openFilesInformationDeleted(ExpandableFolderView.this.folderInfo);
        }
    }

    private class MyNodeManagerListener
    extends NodeManagerAdapter {
        private MyNodeManagerListener() {
        }

        private void updateIfRequired(NodeManagerEvent nodeManagerEvent) {
            if (ExpandableFolderView.this.folder != null && ExpandableFolderView.this.folder.hasMember(nodeManagerEvent.getNode())) {
                ExpandableFolderView.this.doFolderChanges(ExpandableFolderView.this.folder);
            }
        }

        @Override
        public void nodeConnected(NodeManagerEvent nodeManagerEvent) {
            this.updateIfRequired(nodeManagerEvent);
        }

        @Override
        public void nodeDisconnected(NodeManagerEvent nodeManagerEvent) {
            this.updateIfRequired(nodeManagerEvent);
        }

        @Override
        public void friendAdded(NodeManagerEvent nodeManagerEvent) {
            this.updateIfRequired(nodeManagerEvent);
        }

        @Override
        public void friendRemoved(NodeManagerEvent nodeManagerEvent) {
            this.updateIfRequired(nodeManagerEvent);
        }

        @Override
        public void settingsChanged(NodeManagerEvent nodeManagerEvent) {
            this.updateIfRequired(nodeManagerEvent);
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }

    private class MyTransferManagerListener
    extends TransferManagerAdapter {
        private MyTransferManagerListener() {
        }

        private void updateIfRequired(TransferManagerEvent transferManagerEvent) {
            if (ExpandableFolderView.this.folder == null || !ExpandableFolderView.this.folderInfo.equals(transferManagerEvent.getFile().getFolderInfo())) {
                return;
            }
            ExpandableFolderView.this.updateSyncButton();
            ExpandableFolderView.this.updateIconAndOS();
        }

        @Override
        public void downloadAborted(TransferManagerEvent transferManagerEvent) {
            this.updateIfRequired(transferManagerEvent);
        }

        @Override
        public void downloadBroken(TransferManagerEvent transferManagerEvent) {
            this.updateIfRequired(transferManagerEvent);
        }

        @Override
        public void downloadCompleted(TransferManagerEvent transferManagerEvent) {
            this.updateIfRequired(transferManagerEvent);
        }

        @Override
        public void downloadQueued(TransferManagerEvent transferManagerEvent) {
            this.updateIfRequired(transferManagerEvent);
        }

        @Override
        public void downloadRequested(TransferManagerEvent transferManagerEvent) {
            this.updateIfRequired(transferManagerEvent);
        }

        @Override
        public void downloadStarted(TransferManagerEvent transferManagerEvent) {
            this.updateIfRequired(transferManagerEvent);
        }

        @Override
        public void uploadAborted(TransferManagerEvent transferManagerEvent) {
            this.updateIfRequired(transferManagerEvent);
        }

        @Override
        public void uploadBroken(TransferManagerEvent transferManagerEvent) {
            this.updateIfRequired(transferManagerEvent);
        }

        @Override
        public void uploadCompleted(TransferManagerEvent transferManagerEvent) {
            this.updateIfRequired(transferManagerEvent);
        }

        @Override
        public void uploadRequested(TransferManagerEvent transferManagerEvent) {
            this.updateIfRequired(transferManagerEvent);
        }

        @Override
        public void uploadStarted(TransferManagerEvent transferManagerEvent) {
            this.updateIfRequired(transferManagerEvent);
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }

    private class MyFolderRepositoryListener
    extends FolderRepositoryAdapter {
        private MyFolderRepositoryListener() {
        }

        private void updateIfRequired(FolderRepositoryEvent folderRepositoryEvent) {
            if (ExpandableFolderView.this.folder == null || !ExpandableFolderView.this.folder.equals(folderRepositoryEvent.getFolder())) {
                return;
            }
            ExpandableFolderView.this.updateSyncButton();
            ExpandableFolderView.this.updateIconAndOS();
        }

        @Override
        public void maintenanceFinished(FolderRepositoryEvent folderRepositoryEvent) {
            this.updateIfRequired(folderRepositoryEvent);
        }

        @Override
        public void maintenanceStarted(FolderRepositoryEvent folderRepositoryEvent) {
            this.updateIfRequired(folderRepositoryEvent);
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }

    private class ToSListener
    implements ServerClientListener {
        private ToSListener() {
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return false;
        }

        @Override
        public void login(ServerClientEvent serverClientEvent) {
            this.updateSynableItems();
        }

        @Override
        public void accountUpdated(ServerClientEvent serverClientEvent) {
            this.updateSynableItems();
        }

        @Override
        public void serverConnected(ServerClientEvent serverClientEvent) {
            this.updateSynableItems();
        }

        @Override
        public void serverDisconnected(ServerClientEvent serverClientEvent) {
            this.updateSynableItems();
        }

        @Override
        public void nodeServerStatusChanged(ServerClientEvent serverClientEvent) {
            this.updateSynableItems();
        }

        @Override
        public void childClientSpawned(ServerClientEvent serverClientEvent) {
            this.updateSynableItems();
        }

        private void updateSynableItems() {
            AccountDetails accountDetails = ExpandableFolderView.this.getController().getOSClient().getAccountDetails();
            if (accountDetails != null && accountDetails.needsToAgreeToS()) {
                ExpandableFolderView.this.upperSyncFolderButton.setEnabled(false);
                ExpandableFolderView.this.lowerSyncFolderButton.setEnabled(false);
                ExpandableFolderView.this.syncFolderAction.setEnabled(false);
                ExpandableFolderView.this.primaryButton.setEnabled(false);
            } else {
                ExpandableFolderView.this.upperSyncFolderButton.setEnabled(true);
                ExpandableFolderView.this.lowerSyncFolderButton.setEnabled(true);
                ExpandableFolderView.this.syncFolderAction.setEnabled(true);
                ExpandableFolderView.this.primaryButton.setEnabled(true);
            }
        }
    }

    private class MyFolderListener
    implements FolderListener {
        private MyFolderListener() {
        }

        @Override
        public void statisticsCalculated(FolderEvent folderEvent) {
            ExpandableFolderView.this.doFolderChanges(folderEvent.getFolder());
        }

        @Override
        public void fileChanged(FolderEvent folderEvent) {
            ExpandableFolderView.this.doFolderChanges(folderEvent.getFolder());
        }

        @Override
        public void filesDeleted(FolderEvent folderEvent) {
            ExpandableFolderView.this.doFolderChanges(folderEvent.getFolder());
        }

        @Override
        public void remoteContentsChanged(FolderEvent folderEvent) {
            if (folderEvent.getMember().hasCompleteFileListFor(folderEvent.getFolder().getInfo())) {
                ExpandableFolderView.this.doFolderChanges(folderEvent.getFolder());
            }
        }

        @Override
        public void scanResultCommitted(FolderEvent folderEvent) {
            if (folderEvent.getScanResult().isChangeDetected()) {
                ExpandableFolderView.this.doFolderChanges(folderEvent.getFolder());
            }
        }

        @Override
        public void syncProfileChanged(FolderEvent folderEvent) {
            ExpandableFolderView.this.doFolderChanges(folderEvent.getFolder());
        }

        @Override
        public void archiveSettingsChanged(FolderEvent folderEvent) {
            ExpandableFolderView.this.doFolderChanges(folderEvent.getFolder());
        }

        @Override
        public void archivePurged(FolderEvent folderEvent) {
            ExpandableFolderView.this.doFolderChanges(folderEvent.getFolder());
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }

    private class MyFolderMembershipListener
    implements FolderMembershipListener {
        private MyFolderMembershipListener() {
        }

        @Override
        public void memberJoined(FolderMembershipEvent folderMembershipEvent) {
            ExpandableFolderView.this.doFolderChanges(ExpandableFolderView.this.folder);
        }

        @Override
        public void memberLeft(FolderMembershipEvent folderMembershipEvent) {
            ExpandableFolderView.this.doFolderChanges(ExpandableFolderView.this.folder);
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }
}

