/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.folders;

import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.util.Reject;

public class ExpandableFolderModel {
    private final Type type;
    private final FolderInfo folderInfo;
    private final Folder folder;
    private boolean online;

    public ExpandableFolderModel(Type type, FolderInfo folderInfo, Folder folder, boolean bl) {
        Reject.ifNull((Object)type, "Type is required.");
        Reject.ifNull(folderInfo, "FolderInfo is required.");
        this.type = type;
        this.folderInfo = folderInfo;
        this.folder = folder;
        this.online = bl;
    }

    public FolderInfo getFolderInfo() {
        return this.folderInfo;
    }

    public Folder getFolder() {
        return this.folder;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isOnline() {
        return this.online;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ExpandableFolderModel expandableFolderModel = (ExpandableFolderModel)object;
        return this.folderInfo.equals(expandableFolderModel.folderInfo);
    }

    public int hashCode() {
        return this.folderInfo.hashCode();
    }

    public static enum Type {
        Local,
        Typical,
        CloudOnly;

    }
}

