/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.dialog.directory;

import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.forms.builder.AbstractFormBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.dialog.BaseDialog;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.dialog.directory.DirectoryTree;
import de.dal33t.powerfolder.ui.dialog.directory.DirectoryTreeCellRenderer;
import de.dal33t.powerfolder.ui.dialog.directory.DirectoryTreeNode;
import de.dal33t.powerfolder.ui.dialog.directory.NewDirectoryCreator;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DirectoryChooser
extends BaseDialog {
    private Path startPath;
    private List<Path> selectedDirs;
    private final DirectoryTree tree;
    private final JTextField pathField;
    private final JButton newDirButton;
    private DefaultTreeModel model;
    private JPopupMenu popupMenu;
    private NewDirectoryAction newDirectoryAction;
    private JButton okButton;
    private boolean multiSelect;

    public DirectoryChooser(Controller controller, Path path, List<String> list, boolean bl) {
        super(BaseDialog.Senior.NONE, controller, true);
        this.multiSelect = bl;
        this.selectedDirs = new ArrayList<Path>();
        this.startPath = path;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        this.model = new DefaultTreeModel(defaultMutableTreeNode);
        this.tree = new DirectoryTree(this.model, list);
        this.tree.getSelectionModel().setSelectionMode(bl ? 4 : 1);
        this.pathField = new JTextField();
        this.newDirectoryAction = new NewDirectoryAction(this.getController());
        this.newDirectoryAction.setEnabled(false);
        this.newDirButton = new JButton(this.newDirectoryAction);
        this.tree.addMouseListener(new NavTreeListener());
    }

    public List<Path> getSelectedDirs() {
        if (this.selectedDirs == null) {
            return null;
        }
        return Collections.unmodifiableList(this.selectedDirs);
    }

    @Override
    protected Component getButtonBar() {
        this.okButton = DirectoryChooser.createOKButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DirectoryChooser.this.okEvent();
            }
        });
        JButton jButton = DirectoryChooser.createCancelButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DirectoryChooser.this.selectedDirs.clear();
                DirectoryChooser.this.close();
            }
        });
        JButton jButton2 = new JButton(Translation.get("dialog.directorychooser.use_classic"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DirectoryChooser.this.useClassicBrowser();
            }
        });
        return ButtonBarFactory.buildCenteredBar(jButton2, this.okButton, jButton);
    }

    @Override
    protected JButton getDefaultButton() {
        return this.okButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkPathAndWarn(Path path) {
        Path path2 = null;
        if (null != path) {
            path2 = path.getParent();
            if (path2 == null) {
                path2 = path;
            }
            Path path3 = null;
            try {
                path3 = Files.createTempFile(path2, "delete_me_", ".writecheck", new FileAttribute[0]);
                boolean bl = Files.exists(path3, new LinkOption[0]);
                return bl;
            }
            catch (IOException iOException) {
            }
            finally {
                if (path3 != null) {
                    try {
                        Files.deleteIfExists(path3);
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        DialogFactory.genericDialog(this.getController(), Translation.get("dialog.directorychooser.new.description"), Translation.get("dialog.directorychooser.error.insufficient_permissions", null == path2 ? "" : path2.toString()), GenericDialogType.WARN);
        return false;
    }

    private void okEvent() {
        if (this.selectedDirs.size() <= 1 && StringUtils.isNotBlank(this.pathField.getText())) {
            Object object2;
            if (this.selectedDirs.size() == 1) {
                String string;
                object2 = this.selectedDirs.get(0);
                String object = object2.toAbsolutePath().toString();
                if (!object.equals(string = this.pathField.getText())) {
                    Path path = Paths.get(string, new String[0]);
                    if (!this.checkPathAndWarn(path)) {
                        return;
                    }
                    this.selectedDirs.clear();
                    this.selectedDirs.add(path);
                }
            } else {
                object2 = this.pathField.getText();
                Path path = Paths.get((String)object2, new String[0]);
                if (!this.checkPathAndWarn(path)) {
                    return;
                }
                this.selectedDirs.clear();
                this.selectedDirs.add(path);
            }
        }
        for (Path path : this.selectedDirs) {
            if (!Files.notExists(path, new LinkOption[0])) continue;
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                this.logSevere("Failed to create directory", iOException);
            }
        }
        if (!this.selectedDirs.isEmpty()) {
            this.close();
        }
    }

    @Override
    protected JComponent getContent() {
        try {
            return this.getContent0();
        }
        catch (Exception exception) {
            this.logSevere("Unable to render directory chooser. " + exception, exception);
            return new JLabel(Translation.get("dialog.directorychooser.error"));
        }
    }

    private JComponent getContent0() {
        Object object;
        this.logFine("getContent()");
        Iterable<Path> iterable = FileSystems.getDefault().getRootDirectories();
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        for (Path object22 : iterable) {
            if (this.isFine()) {
                this.logFine("Root " + object22);
            }
            object = new DirectoryTreeNode(this.getController(), fileSystemView.getSystemDisplayName(object22.toFile()), object22, true, true);
            ((DefaultMutableTreeNode)this.tree.getModel().getRoot()).add((MutableTreeNode)object);
        }
        this.tree.setCellRenderer(new DirectoryTreeCellRenderer());
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.addTreeSelectionListener(new MyTreeSelectionListener());
        this.tree.addTreeExpansionListener(new MyTreeExpansionListener());
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.setPreferredSize(new Dimension(450, 280));
        FormLayout formLayout = new FormLayout("pref, 3dlu, pref:grow, 3dlu, pref", "pref, 3dlu, pref");
        object = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        ((AbstractFormBuilder)object).add((Component)jScrollPane, cellConstraints.xyw(1, n, 5));
        ((AbstractFormBuilder)object).add((Component)new JLabel(Translation.get("general.directory")), cellConstraints.xy(1, n += 2));
        ((AbstractFormBuilder)object).add((Component)this.pathField, cellConstraints.xy(3, n));
        ((AbstractFormBuilder)object).add((Component)ButtonBarFactory.buildRightAlignedBar(this.newDirButton), cellConstraints.xy(5, n));
        JPanel jPanel = ((PanelBuilder)object).getPanel();
        this.logFine("Initializing path...");
        this.tree.initializePath(this.startPath);
        this.logFine("Initialized path");
        return jPanel;
    }

    @Override
    protected Icon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return Translation.get("dialog.directory-chooser.title");
    }

    private void newDirectoryAction() {
        if (this.tree.getSelectionPath() == null || !(this.tree.getSelectionPath().getLastPathComponent() instanceof DirectoryTreeNode)) {
            return;
        }
        DirectoryTreeNode directoryTreeNode = (DirectoryTreeNode)this.tree.getSelectionPath().getLastPathComponent();
        Path path = directoryTreeNode.getDir();
        String string = path.toAbsolutePath().toString();
        if (string != null) {
            String string2;
            ValueHolder valueHolder = new ValueHolder();
            NewDirectoryCreator newDirectoryCreator = new NewDirectoryCreator(this.getController(), true, string, valueHolder);
            newDirectoryCreator.open();
            Object object = valueHolder.getValue();
            if (object != null && (string2 = ((String)object).trim()).length() > 0) {
                Path path2 = Paths.get(string, string2);
                if (Files.exists(path2, new LinkOption[0])) {
                    DialogFactory.genericDialog(this.getController(), Translation.get("dialog.directorychooser.new.description"), Translation.get("dialog.directorychooser.new.exists", path2.toAbsolutePath().toString()), GenericDialogType.WARN);
                } else {
                    boolean bl = false;
                    try {
                        Files.createDirectories(path2, new FileAttribute[0]);
                        bl = true;
                    }
                    catch (IOException iOException) {
                        this.logInfo(iOException.getMessage());
                    }
                    if (bl) {
                        TreePath treePath = this.tree.getSelectionPath();
                        Object object2 = treePath.getLastPathComponent();
                        if (object2 instanceof DirectoryTreeNode) {
                            DirectoryTreeNode directoryTreeNode2 = (DirectoryTreeNode)object2;
                            this.model.insertNodeInto(new DirectoryTreeNode(this.getController(), null, path2, false, true), directoryTreeNode2, directoryTreeNode2.getChildCount());
                            Enumeration<TreeNode> enumeration = directoryTreeNode2.children();
                            while (enumeration.hasMoreElements()) {
                                Object[] objectArray;
                                Object[] objectArray2;
                                TreeNode treeNode = enumeration.nextElement();
                                if (!(treeNode instanceof DirectoryTreeNode)) continue;
                                DirectoryTreeNode directoryTreeNode3 = (DirectoryTreeNode)treeNode;
                                if (directoryTreeNode3.getUserObject() instanceof File) {
                                    objectArray2 = ((File)directoryTreeNode3.getUserObject()).toPath();
                                    if (!objectArray2.equals(path2)) continue;
                                    objectArray = this.model.getPathToRoot(directoryTreeNode3);
                                    TreePath treePath2 = new TreePath(objectArray);
                                    this.tree.setSelectionPath(treePath2);
                                    this.tree.scrollPathToVisible(treePath2);
                                    break;
                                }
                                objectArray2 = this.model.getPathToRoot(directoryTreeNode3);
                                objectArray = new TreePath(objectArray2);
                                this.tree.setSelectionPath((TreePath)objectArray);
                                this.tree.scrollPathToVisible((TreePath)objectArray);
                            }
                        }
                    } else {
                        DialogFactory.genericDialog(this.getController(), Translation.get("dialog.directorychooser.new.description"), Translation.get("dialog.directorychooser.new.problem", path2.toAbsolutePath().toString()), GenericDialogType.WARN);
                    }
                }
            }
        }
    }

    private void processTreeChange() {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray != null && treePathArray.length > 1) {
            this.pathField.setEnabled(false);
            this.pathField.setText("");
            this.newDirectoryAction.setEnabled(false);
            for (TreePath treePath : treePathArray) {
                DirectoryTreeNode directoryTreeNode = (DirectoryTreeNode)treePath.getLastPathComponent();
                if (this.isFine()) {
                    this.logFine("DirectoryTreeNode scanned " + directoryTreeNode.isScanned() + " volume " + directoryTreeNode.isVolume());
                }
                Path path = directoryTreeNode.getDir();
                if (!this.isFine()) continue;
                this.logFine("DirectoryTreeNode file " + path.toAbsolutePath());
            }
        } else {
            this.pathField.setEnabled(true);
            this.pathField.setText("");
            TreePath treePath = this.tree.getSelectionPath();
            if (treePath != null && treePath.getLastPathComponent() instanceof DirectoryTreeNode) {
                DirectoryTreeNode directoryTreeNode = (DirectoryTreeNode)treePath.getLastPathComponent();
                if (this.isFine()) {
                    this.logFine("DirectoryTreeNode scanned " + directoryTreeNode.isScanned() + " volume " + directoryTreeNode.isVolume());
                }
                Path path = directoryTreeNode.getDir();
                if (this.isFine()) {
                    this.logFine("DirectoryTreeNode file " + path.toAbsolutePath());
                }
                this.pathField.setText(path.toAbsolutePath().toString());
                this.newDirectoryAction.setEnabled(true);
            }
        }
    }

    private void useClassicBrowser() {
        this.selectedDirs = null;
        this.close();
    }

    private class NewDirectoryAction
    extends BaseAction {
        NewDirectoryAction(Controller controller) {
            super("action_directory_new", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DirectoryChooser.this.newDirectoryAction();
        }
    }

    private class NavTreeListener
    extends MouseAdapter {
        private NavTreeListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        private void showContextMenu(MouseEvent mouseEvent) {
            TreePath treePath = DirectoryChooser.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            if (DirectoryChooser.this.popupMenu == null) {
                DirectoryChooser.this.popupMenu = new JPopupMenu();
                DirectoryChooser.this.popupMenu.add(DirectoryChooser.this.newDirectoryAction);
            }
            DirectoryChooser.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private class MyTreeSelectionListener
    implements TreeSelectionListener {
        private MyTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            DirectoryChooser.this.processTreeChange();
        }
    }

    private class MyTreeExpansionListener
    implements TreeExpansionListener {
        private MyTreeExpansionListener() {
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            DirectoryChooser.this.processTreeChange();
        }

        @Override
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            DirectoryChooser.this.processTreeChange();
        }
    }
}

