/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.contextmenu;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.Lock;
import de.dal33t.powerfolder.disk.dao.FileInfoCriteria;
import de.dal33t.powerfolder.light.DirectoryInfo;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.ui.contextmenu.PFContextMenuAction;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.Util;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class UnlockAction
extends PFContextMenuAction {
    private static final Logger log = Logger.getLogger(UnlockAction.class.getName());

    UnlockAction(Controller controller) {
        super(controller);
    }

    @Override
    public void onSelection(String[] stringArray) {
        try {
            List<FileInfo> list = this.getFileInfos(stringArray);
            for (FileInfo fileInfo : list) {
                this.unlockFileInfo(fileInfo);
            }
        }
        catch (RuntimeException runtimeException) {
            log.log(Level.WARNING, "Problem trying to unlock files. " + runtimeException, runtimeException);
        }
    }

    private void unlockFileInfo(FileInfo fileInfo) {
        if (fileInfo.isDiretory()) {
            DirectoryInfo directoryInfo = (DirectoryInfo)fileInfo;
            FileInfoCriteria fileInfoCriteria = new FileInfoCriteria();
            fileInfoCriteria.addMySelf(fileInfo.getFolder(this.getController().getFolderRepository()));
            fileInfoCriteria.setPath(directoryInfo);
            fileInfoCriteria.setRecursive(true);
            Collection<FileInfo> collection = directoryInfo.getFolder(this.getController().getFolderRepository()).getDAO().findFiles(fileInfoCriteria);
            for (FileInfo fileInfo2 : collection) {
                this.unlockFileInfo(fileInfo2);
            }
        }
        this.unlock(fileInfo);
    }

    private void unlock(FileInfo fileInfo) {
        if (fileInfo.isLocked(this.getController())) {
            Lock lock = fileInfo.getLock(this.getController());
            boolean bl = lock.getMemberInfo().equals(this.getController().getMySelf().getInfo());
            boolean bl2 = Util.equals(lock.getAccountInfo(), this.getController().getOSClient().getAccountInfo());
            if (bl && bl2) {
                this.unlock0(fileInfo);
            } else {
                UIUtil.invokeLaterInEDT(new UnlockForeignTask(this.getController(), fileInfo, lock));
            }
        }
    }

    private void unlock0(FileInfo fileInfo) {
        if (!fileInfo.unlock(this.getController())) {
            log.warning("File " + fileInfo + " could not be unlocked!");
        }
    }

    private class UnlockForeignTask
    implements Runnable {
        private final Controller controller;
        private final FileInfo fileInfo;
        private final Lock lock;

        UnlockForeignTask(Controller controller, FileInfo fileInfo, Lock lock) {
            this.controller = controller;
            this.fileInfo = fileInfo;
            this.lock = lock;
        }

        @Override
        public void run() {
            int n;
            String string = this.fileInfo.getFilenameOnly();
            String string2 = this.lock.getAccountDisplayName();
            String string3 = new SimpleDateFormat("dd MMM yyyy HH:mm").format(this.lock.getCreated());
            String string4 = Translation.get("context_menu.unlock.message.web");
            MemberInfo memberInfo = this.lock.getMemberInfo();
            if (memberInfo != null) {
                string4 = memberInfo.getNick();
            }
            if ((n = DialogFactory.genericDialog(this.controller, Translation.get("context_menu.unlock.title"), Translation.get("context_menu.unlock.message", string, string2, string3, string4), new String[]{Translation.get("context_menu.unlock.unlock"), Translation.get("context_menu.unlock.keep_lock")}, 1, GenericDialogType.QUESTION)) == 0) {
                UnlockAction.this.unlock0(this.fileInfo);
            }
        }
    }
}

