/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.contextmenu;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.ui.contextmenu.PFContextMenuAction;
import de.dal33t.powerfolder.util.BrowserLauncher;
import de.dal33t.powerfolder.util.StringUtils;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class OpenColaborateAction
extends PFContextMenuAction {
    private static final Logger log = Logger.getLogger(OpenColaborateAction.class.getName());

    OpenColaborateAction(Controller controller) {
        super(controller);
    }

    @Override
    public void onSelection(String[] stringArray) {
        try {
            List<FileInfo> list = this.getFileInfos(stringArray);
            for (FileInfo fileInfo : list) {
                String string = this.getController().getOSClient().getOpenURL(fileInfo);
                if (StringUtils.isBlank(string)) {
                    log.fine("Could not get URL for file " + fileInfo);
                    continue;
                }
                BrowserLauncher.openURL(this.getController(), string);
            }
        }
        catch (RuntimeException runtimeException) {
            log.log(Level.WARNING, "Problem while opening colaboration session. " + runtimeException, runtimeException);
        }
    }
}

