/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.contextmenu;

import com.liferay.nativity.modules.contextmenu.ContextMenuControlCallback;
import com.liferay.nativity.modules.contextmenu.model.ContextMenuItem;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Constants;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.DocumentType;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.FolderRepository;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FileInfoFactory;
import de.dal33t.powerfolder.ui.contextmenu.LockAction;
import de.dal33t.powerfolder.ui.contextmenu.LockInfoAction;
import de.dal33t.powerfolder.ui.contextmenu.MoveExistingFolderAction;
import de.dal33t.powerfolder.ui.contextmenu.OpenColaborateAction;
import de.dal33t.powerfolder.ui.contextmenu.OpenWebAction;
import de.dal33t.powerfolder.ui.contextmenu.ShareFolderAction;
import de.dal33t.powerfolder.ui.contextmenu.ShareLinkAction;
import de.dal33t.powerfolder.ui.contextmenu.StopSyncAction;
import de.dal33t.powerfolder.ui.contextmenu.UnlockAction;
import de.dal33t.powerfolder.ui.contextmenu.VersionHistoryAction;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.os.OSUtil;
import de.dal33t.powerfolder.util.os.Win32.WinUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class ContextMenuHandler
extends PFComponent
implements ContextMenuControlCallback {
    private ContextMenuItem pfMainItem;
    private ContextMenuItem openColabItem = new ContextMenuItem(Translation.get("context_menu.open_and_colaborate", ConfigurationEntry.DIST_NAME.getValue(this.getController())));
    private ContextMenuItem shareLinkItem;
    private ContextMenuItem shareFolderItem;
    private ContextMenuItem moveFolderItem;
    private ContextMenuItem openWebItem;
    private ContextMenuItem stopSyncItem;
    private ContextMenuItem lockItem;
    private ContextMenuItem unlockItem;
    private ContextMenuItem versionHistoryItem;
    private ContextMenuItem lockInfoItem;

    public ContextMenuHandler(Controller controller) {
        super(controller);
        this.openColabItem.setContextMenuAction(new OpenColaborateAction(this.getController()));
        this.pfMainItem = new ContextMenuItem(Translation.get("context_menu.main_item"));
        this.shareLinkItem = new ContextMenuItem(Translation.get("context_menu.share_link"));
        this.shareLinkItem.setContextMenuAction(new ShareLinkAction(this.getController()));
        this.shareFolderItem = new ContextMenuItem(Translation.get("context_menu.share_folder"));
        this.shareFolderItem.setContextMenuAction(new ShareFolderAction(this.getController()));
        this.moveFolderItem = new ContextMenuItem(Translation.get("context_menu.move_folder"));
        this.moveFolderItem.setContextMenuAction(new MoveExistingFolderAction(this.getController()));
        this.openWebItem = new ContextMenuItem(Translation.get("context_menu.open_web"));
        this.openWebItem.setContextMenuAction(new OpenWebAction(this.getController()));
        this.stopSyncItem = new ContextMenuItem(Translation.get("context_menu.stop_sync"));
        this.stopSyncItem.setContextMenuAction(new StopSyncAction(this.getController()));
        this.lockInfoItem = new ContextMenuItem(Translation.get("context_menu.lock_information"));
        this.lockInfoItem.setContextMenuAction(new LockInfoAction(this.getController()));
        this.lockItem = new ContextMenuItem(Translation.get("context_menu.lock"));
        this.lockItem.setContextMenuAction(new LockAction(this.getController()));
        this.unlockItem = new ContextMenuItem(Translation.get("context_menu.unlock"));
        this.unlockItem.setContextMenuAction(new UnlockAction(this.getController()));
        this.versionHistoryItem = new ContextMenuItem(Translation.get("context_menu.version_history"));
        this.versionHistoryItem.setContextMenuAction(new VersionHistoryAction(this.getController()));
    }

    @Override
    public List<ContextMenuItem> getContextMenuItems(String[] stringArray) {
        try {
            for (ContextMenuItem contextMenuItem : this.pfMainItem.getAllContextMenuItems()) {
                this.pfMainItem.removeContextMenuItem(contextMenuItem);
            }
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            FileInfo fileInfo = null;
            String string = "";
            if (OSUtil.isWindowsSystem()) {
                string = WinUtils.getInstance().getSystemFolderPath(11, false);
            }
            FolderRepository folderRepository = this.getController().getFolderRepository();
            for (String documentTypeArray : stringArray) {
                Path path;
                Folder folder;
                if (documentTypeArray.equals(string) || (folder = folderRepository.findContainingFolder(path = Paths.get(documentTypeArray, new String[0]))) == null) continue;
                if (!bl && folder.getLocalBase().equals(path)) {
                    bl = true;
                    continue;
                }
                if (path.getFileName() == null) continue;
                FileInfo fileInfo2 = FileInfoFactory.lookupInstance(folder, path);
                fileInfo = folder.getDAO().find(fileInfo2, null);
                if (fileInfo != null) {
                    if (fileInfo.isFile()) {
                        bl2 = true;
                    } else if (fileInfo.isDiretory()) {
                        bl3 = true;
                    }
                }
                if (bl && bl2 && bl3) break;
            }
            if (stringArray.length == 1 && (bl && stringArray[0].contains(Constants.POWERFOLDER_SYSTEM_SUBDIR) || stringArray[0].equals(string))) {
                return new ArrayList<ContextMenuItem>(0);
            }
            if (stringArray.length == 1 && (bl2 || bl3 || bl) && ConfigurationEntry.WEB_LOGIN_ALLOWED.getValueBoolean(this.getController()).booleanValue()) {
                this.pfMainItem.addContextMenuItem(this.openWebItem);
            }
            if (bl && stringArray.length == 1 || stringArray.length == 1 && Files.isDirectory(Paths.get(stringArray[0], new String[0]), new LinkOption[0]) && this.getController().getOSClient().isAllowedToCreateFolders() && !bl3) {
                this.pfMainItem.addContextMenuItem(this.shareFolderItem);
            }
            if (bl && !bl2 && !bl3) {
                this.pfMainItem.addContextMenuItem(this.moveFolderItem);
                this.pfMainItem.addContextMenuItem(this.stopSyncItem);
            }
            if (!bl && bl2) {
                this.pfMainItem.addContextMenuItem(this.versionHistoryItem);
            }
            if ((bl3 || bl2) && stringArray.length == 1 && this.getController().getOSClient().getAccount().hasAdminPermission(fileInfo.getFolderInfo())) {
                this.pfMainItem.addContextMenuItem(this.shareLinkItem);
            }
            if (bl2 && !bl && !bl3) {
                if (bl2 && stringArray.length == 1 && fileInfo.isLocked(this.getController())) {
                    this.pfMainItem.addContextMenuItem(this.lockInfoItem);
                }
                this.pfMainItem.addContextMenuItem(this.lockItem);
                this.pfMainItem.addContextMenuItem(this.unlockItem);
            }
            ArrayList arrayList = new ArrayList(2);
            if (bl2 && stringArray.length == 1) {
                String string2 = stringArray[0];
                int n = 0;
                for (DocumentType documentType : DocumentType.values()) {
                    for (String string3 : documentType.getExtensions()) {
                        if (!string2.endsWith(string3)) continue;
                        n = 1;
                        break;
                    }
                    if (n != 0) break;
                }
                if (n != 0) {
                    arrayList.add(this.openColabItem);
                }
            }
            if (this.pfMainItem.getContextMenuItems().size() > 0) {
                arrayList.add(this.pfMainItem);
            }
            return arrayList;
        }
        catch (RuntimeException runtimeException) {
            this.logWarning("Error trying to compile context menu " + runtimeException, runtimeException);
            return new ArrayList<ContextMenuItem>(0);
        }
    }
}

