/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.computers;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.event.NodeManagerModelListener;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.computers.ComputersTab;
import de.dal33t.powerfolder.ui.computers.ExpandableComputerView;
import de.dal33t.powerfolder.ui.event.ExpansionEvent;
import de.dal33t.powerfolder.ui.event.ExpansionListener;
import de.dal33t.powerfolder.ui.model.NodeManagerModel;
import de.dal33t.powerfolder.ui.util.DelayedUpdater;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.compare.MemberComparator;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class ComputersList
extends PFUIComponent {
    private JPanel uiComponent;
    private JPanel computerListPanel;
    private final NodeManagerModel nodeManagerModel;
    private final List<ExpandableComputerView> viewList;
    private ExpansionListener expansionListener;
    private ComputersTab computersTab;
    private volatile boolean populated;
    private volatile boolean multiGroup;
    private final Set<Member> previousMyComputers;
    private final Set<Member> previousFriends;
    private final Set<Member> previousConnectedLans;
    private boolean collapseMyComputers;
    private boolean collapseFriends;
    private boolean collapseConnectedLans;
    private JLabel myComputersLabel;
    private JLabel myComputersIcon;
    private JLabel friendsLabel;
    private JLabel friendsIcon;
    private JLabel connectedLansLabel;
    private JLabel connectedLansIcon;
    private DelayedUpdater forcedUpdater;
    private DelayedUpdater lightUpdater;

    public ComputersList(Controller controller, ComputersTab computersTab) {
        super(controller);
        this.forcedUpdater = new DelayedUpdater(controller, 500L);
        this.lightUpdater = new DelayedUpdater(controller, 500L);
        this.computersTab = computersTab;
        this.expansionListener = new MyExpansionListener();
        this.nodeManagerModel = this.getUIController().getApplicationModel().getNodeManagerModel();
        this.viewList = new CopyOnWriteArrayList<ExpandableComputerView>();
        this.previousConnectedLans = new TreeSet<Member>(MemberComparator.NICK);
        this.previousFriends = new TreeSet<Member>(MemberComparator.NICK);
        this.previousMyComputers = new TreeSet<Member>(MemberComparator.NICK);
        this.myComputersLabel = new JLabel(Translation.get("exp.computers_list.my_computers"));
        this.myComputersIcon = new JLabel(Icons.getIconById("expand.icon"));
        this.myComputersLabel.addMouseListener(new MyComputersListener());
        this.myComputersIcon.addMouseListener(new MyComputersListener());
        this.friendsLabel = new JLabel(Translation.get("exp.computers_list.friends"));
        this.friendsIcon = new JLabel(Icons.getIconById("collapse.icon"));
        this.friendsLabel.addMouseListener(new FriendsListener());
        this.friendsIcon.addMouseListener(new FriendsListener());
        this.connectedLansLabel = new JLabel(Translation.get("exp.computers_list.lan"));
        this.connectedLansIcon = new JLabel(Icons.getIconById("expand.icon"));
        this.connectedLansLabel.addMouseListener(new ConnectedLansListener());
        this.connectedLansIcon.addMouseListener(new ConnectedLansListener());
    }

    public JPanel getUIComponent() {
        if (this.uiComponent == null) {
            this.buildUI();
        }
        return this.uiComponent;
    }

    private void buildUI() {
        this.initComponents();
        FormLayout formLayout = new FormLayout("pref:grow", "pref, pref:grow");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.computerListPanel, cellConstraints.xy(1, 1));
        this.uiComponent = panelBuilder.getPanel();
    }

    private void initComponents() {
        this.computerListPanel = new JPanel();
        this.computerListPanel.setLayout(new BoxLayout(this.computerListPanel, 3));
        this.getUIController().getApplicationModel().getNodeManagerModel().addNodeManagerModelListener(new MyNodeManagerModelListener());
        this.rebuild(false);
    }

    private void rebuild(boolean bl) {
        if (bl) {
            this.forcedUpdater.schedule(new Runnable(){

                @Override
                public void run() {
                    ComputersList.this.rebuild0(true);
                }
            });
        } else {
            this.lightUpdater.schedule(new Runnable(){

                @Override
                public void run() {
                    ComputersList.this.rebuild0(false);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuild0(boolean bl) {
        List<ExpandableComputerView> list;
        if (!this.populated) {
            return;
        }
        Map<NodeManagerModel.Type, Set<Member>> map = this.nodeManagerModel.getNodesMap();
        TreeMap<Member, Member> treeMap = new TreeMap<Member, Member>(MemberComparator.NICK);
        TreeMap<Member, Member> treeMap2 = new TreeMap<Member, Member>(MemberComparator.NICK);
        TreeMap<Member, Member> treeMap3 = new TreeMap<Member, Member>(MemberComparator.NICK);
        Set<Member> set2 = map.get((Object)NodeManagerModel.Type.MY_COMPUTERS_INDEX);
        for (Member set3 : set2) {
            treeMap.put(set3, set3);
        }
        Set<Member> set4 = map.get((Object)NodeManagerModel.Type.FRIENDS_INDEX);
        Iterator iterator = set4.iterator();
        while (iterator.hasNext()) {
            list = (Member)iterator.next();
            treeMap2.put((Member)((Object)list), (Member)((Object)list));
        }
        Set<Member> set = map.get((Object)NodeManagerModel.Type.CONNECTED_LAN);
        for (Member member : set) {
            treeMap3.put(member, member);
        }
        list = this.viewList;
        synchronized (list) {
            Member member2;
            boolean bl2 = bl;
            if (this.previousConnectedLans.size() == treeMap3.size() && this.previousFriends.size() == treeMap3.size() && this.previousMyComputers.size() == treeMap.size()) {
                for (Member member2 : treeMap.values()) {
                    if (this.previousMyComputers.contains(member2)) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    for (Member member2 : treeMap3.values()) {
                        if (this.previousConnectedLans.contains(member2)) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        for (Member member2 : treeMap2.values()) {
                            if (this.previousFriends.contains(member2)) continue;
                            bl2 = true;
                            break;
                        }
                    }
                }
            } else {
                bl2 = true;
            }
            if (!bl2) {
                return;
            }
            this.previousConnectedLans.clear();
            this.previousFriends.clear();
            this.previousMyComputers.clear();
            this.previousConnectedLans.addAll(treeMap3.values());
            this.previousMyComputers.addAll(treeMap.values());
            this.previousFriends.addAll(treeMap2.values());
            Object object = null;
            member2 = null;
            for (ExpandableComputerView expandableComputerView : this.viewList) {
                if (expandableComputerView.isExpanded()) {
                    object = expandableComputerView.getNode();
                }
                if (expandableComputerView.hasFocus()) {
                    member2 = expandableComputerView.getNode();
                }
                expandableComputerView.removeExpansionListener(this.expansionListener);
                expandableComputerView.removeCoreListeners();
            }
            this.viewList.clear();
            this.computerListPanel.removeAll();
            this.multiGroup = (treeMap.isEmpty() ? 0 : 1) + (treeMap3.isEmpty() ? 0 : 1) + (treeMap2.isEmpty() ? 0 : 1) > 1;
            boolean bl3 = true;
            for (Object object2 : treeMap.values()) {
                if (bl3 && this.multiGroup) {
                    bl3 = false;
                    this.addSeparator(this.collapseMyComputers, this.myComputersIcon, this.myComputersLabel);
                }
                if (this.multiGroup && this.collapseMyComputers) continue;
                this.addView((Member)object2, (Member)object, member2);
            }
            boolean bl4 = true;
            for (Object object3 : treeMap3.values()) {
                boolean bl5;
                if (bl5 && this.multiGroup) {
                    bl5 = false;
                    this.addSeparator(this.collapseConnectedLans, this.connectedLansIcon, this.connectedLansLabel);
                }
                if (this.multiGroup && this.collapseConnectedLans) continue;
                this.addView((Member)object3, (Member)object, member2);
            }
            boolean bl6 = true;
            for (Member member3 : treeMap2.values()) {
                if (bl6 && this.multiGroup) {
                    bl6 = false;
                    this.addSeparator(this.collapseFriends, this.friendsIcon, this.friendsLabel);
                }
                if (this.multiGroup && this.collapseFriends) continue;
                this.addView(member3, (Member)object, member2);
            }
            this.computersTab.updateEmptyLabel();
            this.getUIComponent().revalidate();
        }
    }

    private void addSeparator(boolean bl, JLabel jLabel, JLabel jLabel2) {
        FormLayout formLayout = new FormLayout("3dlu, pref, 3dlu, pref, 3dlu, pref:grow, 3dlu", "pref, 4dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        jLabel.setIcon(bl ? Icons.getIconById("expand.icon") : Icons.getIconById("collapse.icon"));
        jLabel.setToolTipText(bl ? Translation.get("exp.computers_list.expand_hint") : Translation.get("exp.computers_list.collapse_hint"));
        jLabel2.setToolTipText(bl ? Translation.get("exp.computers_list.expand_hint") : Translation.get("exp.computers_list.collapse_hint"));
        panelBuilder.add((Component)jLabel, cellConstraints.xy(2, 1));
        panelBuilder.add((Component)jLabel2, cellConstraints.xy(4, 1));
        panelBuilder.add((Component)new JSeparator(), cellConstraints.xy(6, 1));
        JPanel jPanel = panelBuilder.getPanel();
        jPanel.setOpaque(false);
        jPanel.setCursor(Cursor.getPredefinedCursor(12));
        this.computerListPanel.add(jPanel);
    }

    private void addView(Member member, Member member2, Member member3) {
        ExpandableComputerView expandableComputerView = new ExpandableComputerView(this.getController(), member);
        this.computerListPanel.add(expandableComputerView.getUIComponent());
        this.viewList.add(expandableComputerView);
        if (member2 != null && member.equals(member2)) {
            expandableComputerView.expand();
        }
        if (member3 != null && member.equals(member3)) {
            expandableComputerView.setFocus(true);
        }
        expandableComputerView.addExpansionListener(this.expansionListener);
    }

    public boolean isEmpty() {
        return this.viewList.isEmpty() && !this.multiGroup;
    }

    public void populate() {
        this.populated = true;
        this.rebuild(false);
    }

    private class MyExpansionListener
    implements ExpansionListener {
        private MyExpansionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resetAllButSource(ExpansionEvent expansionEvent) {
            List list = ComputersList.this.viewList;
            synchronized (list) {
                for (ExpandableComputerView expandableComputerView : ComputersList.this.viewList) {
                    if (expandableComputerView.equals(expansionEvent.getSource())) continue;
                    expandableComputerView.collapse();
                    expandableComputerView.setFocus(false);
                }
            }
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }

    private class MyComputersListener
    extends MouseAdapter {
        private MyComputersListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            ComputersList.this.collapseMyComputers = !ComputersList.this.collapseMyComputers;
            ComputersList.this.rebuild(true);
        }
    }

    private class FriendsListener
    extends MouseAdapter {
        private FriendsListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            ComputersList.this.collapseFriends = !ComputersList.this.collapseFriends;
            ComputersList.this.rebuild(true);
        }
    }

    private class ConnectedLansListener
    extends MouseAdapter {
        private ConnectedLansListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            ComputersList.this.collapseConnectedLans = !ComputersList.this.collapseConnectedLans;
            ComputersList.this.rebuild(true);
        }
    }

    private class MyNodeManagerModelListener
    implements NodeManagerModelListener {
        private MyNodeManagerModelListener() {
        }

        @Override
        public void changed() {
            ComputersList.this.rebuild(false);
        }
    }
}

