/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Feature;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.clientserver.AgreeToSListener;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.FolderRepository;
import de.dal33t.powerfolder.disk.ScanResult;
import de.dal33t.powerfolder.event.FolderAdapter;
import de.dal33t.powerfolder.event.FolderAutoCreateEvent;
import de.dal33t.powerfolder.event.FolderAutoCreateListener;
import de.dal33t.powerfolder.event.FolderEvent;
import de.dal33t.powerfolder.event.FolderListener;
import de.dal33t.powerfolder.event.FolderRepositoryAdapter;
import de.dal33t.powerfolder.event.FolderRepositoryEvent;
import de.dal33t.powerfolder.event.InvitationHandler;
import de.dal33t.powerfolder.event.PausedModeEvent;
import de.dal33t.powerfolder.event.PausedModeListener;
import de.dal33t.powerfolder.event.TransferManagerAdapter;
import de.dal33t.powerfolder.event.TransferManagerEvent;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.message.Invitation;
import de.dal33t.powerfolder.security.ChangePreferencesPermission;
import de.dal33t.powerfolder.skin.Skin;
import de.dal33t.powerfolder.ui.LookAndFeelSupport;
import de.dal33t.powerfolder.ui.MainFrame;
import de.dal33t.powerfolder.ui.SplashScreen;
import de.dal33t.powerfolder.ui.TrayIconManager;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.dialog.PauseDialog;
import de.dal33t.powerfolder.ui.dialog.SingleFileTransferDialog;
import de.dal33t.powerfolder.ui.information.InformationFrame;
import de.dal33t.powerfolder.ui.model.ApplicationModel;
import de.dal33t.powerfolder.ui.model.BoundPermission;
import de.dal33t.powerfolder.ui.model.TransferManagerModel;
import de.dal33t.powerfolder.ui.notices.FolderAutoCreateNotice;
import de.dal33t.powerfolder.ui.notices.InvitationNotice;
import de.dal33t.powerfolder.ui.notices.OutOfMemoryNotice;
import de.dal33t.powerfolder.ui.notices.SimpleNotificationNotice;
import de.dal33t.powerfolder.ui.notification.PreviewNotificationHandler;
import de.dal33t.powerfolder.ui.preferences.PreferencesDialog;
import de.dal33t.powerfolder.ui.util.DelayedUpdater;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.util.NeverAskAgainResponse;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.ui.util.update.UIUpdateHandler;
import de.dal33t.powerfolder.util.BrowserLauncher;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.os.OSUtil;
import de.dal33t.powerfolder.util.os.SystemUtil;
import de.dal33t.powerfolder.util.update.Updater;
import de.dal33t.powerfolder.util.update.UpdaterHandler;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.UnsupportedLookAndFeelException;

public class UIController
extends PFComponent {
    public static final int MAIN_FRAME_ID = 0;
    public static final int INFO_FRAME_ID = 1;
    public static final int WIZARD_DIALOG_ID = 3;
    public static final int MAX_RECENTLY_CHANGED_FILES = 20;
    private static final String COMMAND_OPEN_UI = "open-ui";
    private static final String COMMAND_HIDE_UI = "hide-ui";
    private static final String COMMAND_SYNC_ALL = "sync-all";
    private static final String COMMAND_EXIT = "exit";
    private static final String COMMAND_SYNC_SHUTDOWN = "sync-shutdown";
    private static final String COMMAND_SYNC_EXIT = "sync-exit";
    private static final String COMMAND_WEB = "web";
    private static final String COMMAND_PAUSE = "pause";
    private static final String COMMAND_RESUME = "resume";
    private static final String COMMAND_PREFERENCES = "preferences";
    private static final String COMMAND_BROWSE = "browse";
    private static final String COMMAND_RECENTLY_CHANGED = "recently-changed-";
    private boolean started;
    private SplashScreen splash;
    private TrayIconManager trayIconManager;
    private MainFrame mainFrame;
    private final InformationFrame informationFrame;
    private WeakReference<JDialog> wizardDialogReference;
    private final List<Runnable> pendingJobs;
    private Menu sysTrayFoldersMenu;
    private MenuItem pauseResumeMenu;
    private Menu recentlyChangedMenu;
    private BoundPermission changePrefsPermission;
    private ApplicationModel applicationModel;
    private AgreeToSListener agreeToSListener;
    private boolean seenOome;
    private TransferManagerModel transferManagerModel;
    private FolderListener folderListener;
    private final AtomicInteger activeFrame;
    private final AtomicBoolean synchronizing = new AtomicBoolean();
    private final DelayedUpdater statusUpdater;
    private final Map<Long, FileInfo> recentlyChangedFiles = new HashMap<Long, FileInfo>(20);
    private final MenuItem[] recentMenuItems = new MenuItem[20];
    private final PreferencesDialog preferencesDialog;
    private Skin[] skins;
    private Skin activeSkin;
    private final DelayedUpdater recentlyChangedUpdater = new DelayedUpdater(this.getController(), 5000L);

    public UIController(Controller controller) {
        super(controller);
        this.activeFrame = new AtomicInteger();
        this.statusUpdater = new DelayedUpdater(this.getController(), 1000L);
        this.preferencesDialog = new PreferencesDialog(controller);
        this.configureOomeHandler();
        this.initSkin();
        if (OSUtil.isMacOS()) {
            UIUtil.setMacDockImage(Icons.getImageById("picto_logo_128.icon"));
        }
        this.pendingJobs = Collections.synchronizedList(new LinkedList());
        if (!controller.isStartMinimized()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        UIController.this.logFiner("Opening splash screen");
                        UIController.this.splash = new SplashScreen(UIController.this.getController(), 260000);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                this.logSevere("InterruptedException", interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.logSevere("InvocationTargetException", invocationTargetException);
            }
        }
        this.informationFrame = new InformationFrame(this.getController());
        this.started = false;
    }

    private void configureOomeHandler() {
        Handler handler = new Handler(){

            @Override
            public void publish(LogRecord logRecord) {
                Throwable throwable = logRecord.getThrown();
                if (throwable instanceof OutOfMemoryError) {
                    OutOfMemoryError outOfMemoryError = (OutOfMemoryError)throwable;
                    UIController.this.showOutOfMemoryError(outOfMemoryError);
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        };
        Logger logger = Logger.getLogger("");
        logger.addHandler(handler);
    }

    public AgreeToSListener getAgreeToSListener() {
        return this.agreeToSListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.getController().isVerbose()) {
            // empty if block
        }
        if (PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
            ConfigurationEntry.FILES_ENABLED.setValue(this.getController(), true);
            ConfigurationEntry.SETTINGS_ENABLED.setValue(this.getController(), true);
            ConfigurationEntry.MEMBERS_ENABLED.setValue(this.getController(), true);
        } else {
            ConfigurationEntry.FILES_ENABLED.setValue(this.getController(), false);
            ConfigurationEntry.SETTINGS_ENABLED.setValue(this.getController(), false);
            ConfigurationEntry.MEMBERS_ENABLED.setValue(this.getController(), false);
        }
        this.applicationModel = new ApplicationModel(this.getController());
        this.applicationModel.initialize();
        this.mainFrame = new MainFrame(this.getController());
        this.folderListener = new MyFolderListener();
        for (Folder object : this.getController().getFolderRepository().getFolders()) {
            object.addFolderListener(this.folderListener);
        }
        this.getController().getFolderRepository().addFolderRepositoryListener(new MyFolderRepositoryListener());
        this.getController().getTransferManager().addListener(new MyTransferManagerListener());
        this.transferManagerModel = new TransferManagerModel(this.getController().getTransferManager());
        this.transferManagerModel.initialize();
        if (OSUtil.isLinux()) {
            TrayIconManager.whitelistSystray(this.getController());
        }
        if (OSUtil.isSystraySupported()) {
            this.initializeSystray();
        } else {
            this.logWarning("System tray currently only supported on windows (>98)");
            this.mainFrame.getUIComponent().setDefaultCloseOperation(3);
        }
        if (this.getController().isStartMinimized() || !PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
            this.logInfo("Starting minimized");
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    boolean bl = OSUtil.isSystraySupported();
                    boolean bl2 = OSUtil.isLinux();
                    boolean bl3 = UIController.this.getController().isStartMinimized();
                    boolean bl4 = PreferencesEntry.EXPERT_MODE.getValueBoolean(UIController.this.getController());
                    UIController.this.mainFrame.getUIComponent().setVisible(bl2 || (!bl || !bl3) && bl4);
                    if (!bl3 && bl4) {
                        UIController.this.mainFrame.toFront();
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            this.logSevere("InterruptedException", interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.logSevere("InvocationTargetException", invocationTargetException);
        }
        this.started = true;
        Object object = this.pendingJobs;
        synchronized (object) {
            if (!this.pendingJobs.isEmpty()) {
                this.logFiner("Executing " + this.pendingJobs.size() + " pending ui jobs");
                for (Runnable runnable : this.pendingJobs) {
                    SwingUtilities.invokeLater(runnable);
                }
            }
        }
        this.agreeToSListener = new AgreeToSListener(this.getController());
        this.getController().getOSClient().addListener(this.agreeToSListener);
        object = new UIUpdateHandler(this.getController());
        Updater.installPeriodicalUpdateCheck(this.getController(), (UpdaterHandler)object);
        this.getController().addInvitationHandler(new MyInvitationHandler());
        this.getController().getFolderRepository().addFolderAutoCreateListener(new MyFolderAutoCreateListener());
    }

    public void askToPauseResume() {
        if (!this.agreeToSListener.hasAgreedOnToS()) {
            this.logInfo("Not agreed to latest version of Terms of Service.");
            DialogFactory.genericDialog(this.getController(), Translation.get("dialog.tos.title"), Translation.get("dialog.tos.text"), new String[]{"OK"}, 0, GenericDialogType.INFO);
            this.getController().getIOProvider().startIO(() -> {
                try {
                    BrowserLauncher.openURL(this.getController().getOSClient().getLoginURLWithCredentials());
                }
                catch (IOException iOException) {
                    this.logWarning("Could not open browser to view ToS. " + iOException);
                }
            });
            return;
        }
        boolean bl = this.getController().isPaused();
        if (bl) {
            this.getController().schedule(() -> this.getController().setPaused(!bl), 0L);
        } else if (PreferencesEntry.SHOW_ASK_FOR_PAUSE.getValueBoolean(this.getController()).booleanValue()) {
            PauseDialog pauseDialog = new PauseDialog(this.getController());
            pauseDialog.open();
        } else {
            this.getController().schedule(() -> this.getController().setPaused(!bl), 0L);
        }
    }

    private void initializeSystray() {
        MenuItem menuItem;
        this.trayIconManager = new TrayIconManager(this);
        PopupMenu popupMenu = new PopupMenu();
        TrayIcon trayIcon = this.trayIconManager.getTrayIcon();
        if (trayIcon != null) {
            trayIcon.setPopupMenu(popupMenu);
        }
        ActionListener actionListener = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (UIController.COMMAND_OPEN_UI.equals(actionEvent.getActionCommand())) {
                    UIController.this.mainFrame.toFront();
                } else if (UIController.COMMAND_HIDE_UI.equals(actionEvent.getActionCommand())) {
                    UIController.this.mainFrame.getUIComponent().setVisible(false);
                } else if (UIController.COMMAND_EXIT.equals(actionEvent.getActionCommand())) {
                    if (UIController.this.isShutdownAllowed()) {
                        UIController.this.getController().exit(0);
                    }
                } else if (UIController.COMMAND_SYNC_SHUTDOWN.equals(actionEvent.getActionCommand())) {
                    if (OSUtil.isLinux()) {
                        FormLayout formLayout = new FormLayout("pref, pref:grow, 3dlu, pref, pref", "3dlu, pref, 3dlu, pref, 3dlu");
                        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
                        CellConstraints cellConstraints = new CellConstraints();
                        panelBuilder.add((Component)new JLabel(Translation.get("shutdown.message")), cellConstraints.xyw(2, 2, 3));
                        panelBuilder.add((Component)new JLabel(Translation.get("shutdown.prompt")), cellConstraints.xy(2, 4));
                        JPasswordField jPasswordField = new JPasswordField(20);
                        panelBuilder.add((Component)jPasswordField, cellConstraints.xy(4, 4));
                        int n = DialogFactory.genericDialog(UIController.this.getController(), Translation.get("shutdown.title"), panelBuilder.getPanel(), new String[]{Translation.get("general.ok"), Translation.get("general.cancel")}, 0, GenericDialogType.QUESTION);
                        if (n == 0) {
                            String string = Util.toString(jPasswordField.getPassword());
                            UIController.this.getController().performFullSync();
                            UIController.this.getController().shutdownAfterSync(string);
                        }
                    } else {
                        UIController.this.getController().performFullSync();
                        UIController.this.getController().shutdownAfterSync(null);
                    }
                } else if (UIController.COMMAND_SYNC_EXIT.equals(actionEvent.getActionCommand())) {
                    UIController.this.getController().performFullSync();
                    UIController.this.getController().exitAfterSync(4);
                } else if (UIController.COMMAND_SYNC_ALL.equals(actionEvent.getActionCommand())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UIController.this.getController().performFullSync();
                        }
                    });
                } else if (UIController.COMMAND_WEB.equals(actionEvent.getActionCommand())) {
                    BrowserLauncher.open(UIController.this.getController(), new BrowserLauncher.URLProducer(){

                        @Override
                        public String url() {
                            return UIController.this.getController().getOSClient().getLoginURLWithCredentials();
                        }
                    });
                } else if (UIController.COMMAND_BROWSE.equals(actionEvent.getActionCommand())) {
                    if (!PreferencesEntry.WEBDAV_ONLY.getValueBoolean(UIController.this.getController()).booleanValue()) {
                        UIController.this.getApplicationModel().openExplorer();
                    } else {
                        UIController.this.getApplicationModel().openExplorerWebDAVPath();
                    }
                } else if (UIController.COMMAND_PAUSE.equals(actionEvent.getActionCommand()) || UIController.COMMAND_RESUME.equals(actionEvent.getActionCommand())) {
                    UIController.this.askToPauseResume();
                } else if (UIController.COMMAND_PREFERENCES.equals(actionEvent.getActionCommand())) {
                    UIController.this.preferencesDialog.open();
                } else if (actionEvent.getActionCommand().startsWith(UIController.COMMAND_RECENTLY_CHANGED)) {
                    int n = actionEvent.getActionCommand().lastIndexOf(45);
                    String string = actionEvent.getActionCommand().substring(n + 1);
                    int n2 = Integer.valueOf(string);
                    Map map = UIController.this.recentlyChangedFiles;
                    synchronized (map) {
                        int n3 = 0;
                        for (FileInfo fileInfo : UIController.this.recentlyChangedFiles.values()) {
                            if (n3++ != n2) continue;
                            UIController uIController = UIController.this.getController().getUIController();
                            uIController.openFileInformation(fileInfo);
                            break;
                        }
                    }
                }
            }
        };
        final MenuItem menuItem2 = new MenuItem(Translation.get("systray.show"));
        popupMenu.add(menuItem2);
        menuItem2.setActionCommand(COMMAND_OPEN_UI);
        menuItem2.addActionListener(actionListener);
        if (ConfigurationEntry.WEB_LOGIN_ALLOWED.getValueBoolean(this.getController()).booleanValue()) {
            menuItem = popupMenu.add(new MenuItem(Translation.get("action_open_web_interface.name")));
            menuItem.setActionCommand(COMMAND_WEB);
            menuItem.addActionListener(actionListener);
        }
        this.sysTrayFoldersMenu = new Menu(Translation.get("general.folder"));
        this.sysTrayFoldersMenu.setEnabled(false);
        if (Feature.SYSTRAY_ALL_FOLDERS.isEnabled()) {
            popupMenu.add(this.sysTrayFoldersMenu);
        }
        if (PreferencesEntry.SHOW_BROWSE.getValueBoolean(this.getController()).booleanValue()) {
            menuItem = popupMenu.add(new MenuItem(Translation.get("action_open_folders_base.name")));
            menuItem.setActionCommand(COMMAND_BROWSE);
            menuItem.addActionListener(actionListener);
        }
        if (!PreferencesEntry.WEBDAV_ONLY.getValueBoolean(this.getController()).booleanValue()) {
            this.pauseResumeMenu = new MenuItem(Translation.get("action_resume_sync.name"));
            popupMenu.add(this.pauseResumeMenu);
            this.pauseResumeMenu.addActionListener(actionListener);
            this.getController().addPausedModeListener(new MyPausedModeListener());
            this.configurePauseResumeLink();
        }
        if (!PreferencesEntry.WEBDAV_ONLY.getValueBoolean(this.getController()).booleanValue()) {
            this.recentlyChangedMenu = new Menu(Translation.get("uicontroller.recently_changed"));
            this.recentlyChangedMenu.setEnabled(false);
            popupMenu.add(this.recentlyChangedMenu);
            for (int i = 0; i < 20; ++i) {
                this.recentMenuItems[i] = new MenuItem();
                this.recentMenuItems[i].setActionCommand(COMMAND_RECENTLY_CHANGED + i);
                this.recentMenuItems[i].addActionListener(actionListener);
            }
        }
        final MenuItem menuItem3 = popupMenu.add(new MenuItem(Translation.get("action_open_preferences.name")));
        menuItem3.setActionCommand(COMMAND_PREFERENCES);
        menuItem3.addActionListener(actionListener);
        this.changePrefsPermission = new BoundPermission(this.getController(), ChangePreferencesPermission.INSTANCE){

            @Override
            public void hasPermission(boolean bl) {
                menuItem3.setEnabled(bl);
            }
        };
        popupMenu.addSeparator();
        if (SystemUtil.isShutdownSupported() && PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
            menuItem = popupMenu.add(new MenuItem(Translation.get("systray.sync_shutdown")));
            menuItem.setActionCommand(COMMAND_SYNC_SHUTDOWN);
            menuItem.addActionListener(actionListener);
        }
        if (PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
            menuItem = popupMenu.add(new MenuItem(Translation.get("systray.sync_exit")));
            menuItem.setActionCommand(COMMAND_SYNC_EXIT);
            menuItem.addActionListener(actionListener);
        }
        menuItem = popupMenu.add(new MenuItem(Translation.get("systray.exit")));
        menuItem.setActionCommand(COMMAND_EXIT);
        menuItem.addActionListener(actionListener);
        if (trayIcon != null) {
            trayIcon.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    UIController.this.mainFrame.toFront();
                }
            });
        }
        try {
            SystemTray.getSystemTray().add(trayIcon);
        }
        catch (Exception exception) {
            this.logSevere("Exception", exception);
            OSUtil.disableSystray();
            return;
        }
        this.mainFrame.getUIComponent().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                menuItem2.setLabel(Translation.get("systray.hide"));
                menuItem2.setActionCommand(UIController.COMMAND_HIDE_UI);
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                menuItem2.setLabel(Translation.get("systray.show"));
                menuItem2.setActionCommand(UIController.COMMAND_OPEN_UI);
            }
        });
        this.mainFrame.getUIComponent().addWindowListener(new WindowAdapter(){

            @Override
            public void windowIconified(WindowEvent windowEvent) {
                menuItem2.setLabel(Translation.get("systray.show"));
                menuItem2.setActionCommand(UIController.COMMAND_OPEN_UI);
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
                menuItem2.setLabel(Translation.get("systray.hide"));
                menuItem2.setActionCommand(UIController.COMMAND_HIDE_UI);
            }
        });
        for (Folder folder : this.getController().getFolderRepository().getFolders()) {
            this.addFolderToSysTray(folder);
        }
    }

    private void addFolderToSysTray(Folder folder) {
        MenuItem menuItem = new MenuItem(folder.getName());
        boolean bl = false;
        for (int i = 0; i < this.sysTrayFoldersMenu.getItemCount(); ++i) {
            if (this.sysTrayFoldersMenu.getItem(i).getLabel().toLowerCase().compareTo(folder.getName().toLowerCase()) <= 0) continue;
            this.sysTrayFoldersMenu.insert(menuItem, i);
            bl = true;
            break;
        }
        if (!bl) {
            this.sysTrayFoldersMenu.add(menuItem);
        }
        this.sysTrayFoldersMenu.setEnabled(true);
        final Path path = folder.getCommitOrLocalDir();
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Files.exists(path, new LinkOption[0])) {
                    PathUtils.openFile(path);
                }
            }
        });
    }

    private void removeFolderFromSysTray(Folder folder) {
        for (int i = 0; i < this.sysTrayFoldersMenu.getItemCount(); ++i) {
            MenuItem menuItem = this.sysTrayFoldersMenu.getItem(i);
            if (!menuItem.getLabel().equals(folder.getName())) continue;
            this.sysTrayFoldersMenu.remove(i);
        }
        if (this.sysTrayFoldersMenu.getItemCount() == 0) {
            this.sysTrayFoldersMenu.setEnabled(false);
        }
    }

    public void hideSplash() {
        if (this.splash != null) {
            this.splash.shutdown();
        }
    }

    public TransferManagerModel getTransferManagerModel() {
        return this.transferManagerModel;
    }

    public Skin[] getSkins() {
        return this.skins;
    }

    public Skin getActiveSkin() {
        return this.activeSkin;
    }

    private void initSkin() {
        boolean bl;
        ArrayList<Skin> arrayList = new ArrayList<Skin>();
        ServiceLoader<Skin> serviceLoader = ServiceLoader.load(Skin.class);
        for (Skin object2 : serviceLoader) {
            this.logFine("Loading skin " + object2.getName());
            arrayList.add(object2);
        }
        this.skins = new Skin[arrayList.size()];
        int n = 0;
        for (Skin skin : arrayList) {
            for (int i = 0; i < n; ++i) {
                if (!this.skins[i].getName().equals(skin.getName())) continue;
                this.logSevere("Multiple skins with name: " + skin.getName());
            }
            this.skins[n++] = skin;
        }
        String string = PreferencesEntry.SKIN_NAME.getValueString(this.getController());
        boolean bl2 = false;
        Object object = this.skins;
        int n2 = ((Skin[])object).length;
        for (int i = 0; i < n2; ++i) {
            Skin skin = object[i];
            if (!skin.getName().equals(string)) continue;
            this.activeSkin = skin;
            bl = true;
            break;
        }
        if (!bl) {
            this.activeSkin = this.skins[0];
            PreferencesEntry.SKIN_NAME.setValue(this.getController(), this.activeSkin.getName());
        }
        if ((object = this.activeSkin.getIconsProperties()) != null) {
            Icons.setIconProperties((Properties)object);
        }
        try {
            LookAndFeelSupport.setLookAndFeel(this.activeSkin.getLookAndFeel());
        }
        catch (ParseException | UnsupportedLookAndFeelException exception) {
            this.logWarning("Failed to set look and feel for skin " + this.activeSkin.getName(), exception);
        }
    }

    public void showOutOfMemoryError(OutOfMemoryError outOfMemoryError) {
        if (!this.seenOome) {
            this.seenOome = true;
            this.applicationModel.getNoticesModel().handleNotice(new OutOfMemoryNotice(outOfMemoryError));
        }
    }

    private void displayInformationWindow() {
        this.mainFrame.showInlineInfoPanel((JPanel)this.informationFrame.getUIComponent().getContentPane(), this.informationFrame.getUIComponent().getTitle());
    }

    public void openFileInformation(FileInfo fileInfo) {
        if (ConfigurationEntry.FILES_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
            this.informationFrame.displayFile(fileInfo);
            this.displayInformationWindow();
        }
    }

    public void openFilesInformationLatest(FolderInfo folderInfo) {
        if (ConfigurationEntry.FILES_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
            this.informationFrame.displayFolderFilesLatest(folderInfo);
            this.displayInformationWindow();
        }
    }

    public void openFilesInformationDeleted(FolderInfo folderInfo) {
        if (ConfigurationEntry.FILES_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
            this.informationFrame.displayFolderFilesDeleted(folderInfo);
            this.displayInformationWindow();
        }
    }

    public void openFilesInformationUnsynced(FolderInfo folderInfo) {
        if (ConfigurationEntry.FILES_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
            this.informationFrame.displayFolderFilesUnsynced(folderInfo);
            this.displayInformationWindow();
        }
    }

    public boolean openFilesInformation(FolderInfo folderInfo) {
        if (ConfigurationEntry.FILES_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
            this.informationFrame.displayFolderFiles(folderInfo);
            this.displayInformationWindow();
            return true;
        }
        return false;
    }

    public void openSettingsInformation(FolderInfo folderInfo) {
        if (ConfigurationEntry.SETTINGS_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
            this.informationFrame.displayFolderSettings(folderInfo);
            this.displayInformationWindow();
        }
    }

    public void moveLocalFolder(FolderInfo folderInfo) {
        this.informationFrame.moveLocalFolder(folderInfo);
    }

    public void openMembersInformation(FolderInfo folderInfo) {
        if (ConfigurationEntry.MEMBERS_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
            this.informationFrame.displayFolderMembers(folderInfo);
            this.displayInformationWindow();
        }
    }

    public void openProblemsInformation(FolderInfo folderInfo) {
        if (ConfigurationEntry.PROBLEMS_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
            this.informationFrame.displayFolderProblems(folderInfo);
            this.displayInformationWindow();
        }
    }

    public void openTransfersInformation() {
        this.informationFrame.displayTransfers();
        this.displayInformationWindow();
    }

    public void openDebugInformation() {
        this.informationFrame.displayDebug();
        this.displayInformationWindow();
    }

    public void openNoticesCard() {
        this.informationFrame.displayNotices();
        this.displayInformationWindow();
    }

    public void hideChildPanels() {
        this.informationFrame.getUIComponent().setVisible(false);
    }

    public void transferSingleFile(Path path, Member member) {
        SingleFileTransferDialog singleFileTransferDialog = new SingleFileTransferDialog(this.getController(), path, member);
        singleFileTransferDialog.open();
    }

    public Window getActiveFrame() {
        JDialog jDialog;
        int n = this.activeFrame.get();
        if (n == 1) {
            JFrame jFrame = this.informationFrame.getUIComponent();
            if (jFrame.isVisible()) {
                return jFrame;
            }
        } else if (n == 3 && this.wizardDialogReference != null && (jDialog = (JDialog)this.wizardDialogReference.get()) != null) {
            return jDialog;
        }
        return this.mainFrame.getUIComponent();
    }

    public void setActiveFrame(int n) {
        this.activeFrame.set(n);
    }

    public void setWizardDialogReference(JDialog jDialog) {
        this.wizardDialogReference = new WeakReference<JDialog>(jDialog);
    }

    public void shutdown() {
        this.hideSplash();
        if (this.started) {
            this.informationFrame.getUIComponent().setVisible(false);
            this.informationFrame.getUIComponent().dispose();
            if (this.wizardDialogReference != null && this.wizardDialogReference.get() != null) {
                ((JDialog)this.wizardDialogReference.get()).setVisible(false);
                ((JDialog)this.wizardDialogReference.get()).dispose();
            }
            this.mainFrame.storeValues();
            this.mainFrame.getUIComponent().setVisible(false);
            this.mainFrame.getUIComponent().dispose();
            if (OSUtil.isSystraySupported() && this.trayIconManager != null) {
                SystemTray.getSystemTray().remove(this.trayIconManager.getTrayIcon());
            }
            this.getController().getOSClient().removeListener(this.agreeToSListener);
        }
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isShowingFolder() {
        return this.isShowingInfo() && this.informationFrame.isShowingFolder();
    }

    public boolean isShowingInfo() {
        return this.mainFrame.isShowingInfoInline();
    }

    public void setLoadingCompletion(int n, int n2) {
        if (this.splash != null) {
            this.splash.setCompletionPercentage(n, n2);
        }
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public ApplicationModel getApplicationModel() {
        return this.applicationModel;
    }

    public void invokeLater(Runnable runnable) {
        if (this.started) {
            SwingUtilities.invokeLater(runnable);
        } else {
            this.logFine("Added runner to pending jobs: " + runnable);
            this.pendingJobs.add(runnable);
        }
    }

    public void previewMessage(String string, String string2) {
        PreviewNotificationHandler previewNotificationHandler = new PreviewNotificationHandler(this.getController(), string, string2);
        previewNotificationHandler.show();
    }

    private void handleFolderAutoCreate(FolderAutoCreateEvent folderAutoCreateEvent) {
        this.applicationModel.getNoticesModel().handleNotice(new FolderAutoCreateNotice(folderAutoCreateEvent.getFolderInfo()));
    }

    public void scanResultCreated(ScanResult scanResult) {
        if (this.mainFrame == null || this.mainFrame.isIconifiedOrHidden()) {
            return;
        }
        int n = scanResult.getNewFiles().size();
        int n2 = scanResult.getChangedFiles().size();
        int n3 = scanResult.getDeletedFiles().size();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Translation.get("uicontroller.sync_info.start") + "\n\n(");
        boolean bl = false;
        if (n > 0) {
            stringBuilder.append(Translation.get("uicontroller.sync_info.new", String.valueOf(n)));
            bl = true;
        }
        if (n2 > 0) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(Translation.get("uicontroller.sync_info.changed", String.valueOf(n2)));
            bl = true;
        }
        if (n3 > 0) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(Translation.get("uicontroller.sync_info.deleted", String.valueOf(n3)));
        }
        if (n == 0 && n2 == 0 && n3 == 0) {
            stringBuilder.append(Translation.get("uicontroller.sync_info.no_changes_detected"));
        }
        stringBuilder.append(')');
        if (n > 0 || n2 > 0) {
            stringBuilder.append("\n\n");
            stringBuilder.append(Translation.get("uicontroller.sync_info.transfer", String.valueOf(n + n2)));
        }
        DialogFactory.genericDialog(this.getController(), Translation.get("uicontroller.sync_info.title"), stringBuilder.toString(), GenericDialogType.INFO);
    }

    public void displayInviteFolderContents(FolderInfo folderInfo) {
        this.mainFrame.showFoldersTab();
        this.openFilesInformation(folderInfo);
    }

    private void configurePauseResumeLink() {
        if (this.getController().isPaused()) {
            this.pauseResumeMenu.setLabel(Translation.get("action_resume_sync.name"));
            this.pauseResumeMenu.setActionCommand(COMMAND_RESUME);
        } else {
            this.pauseResumeMenu.setLabel(Translation.get("action_pause_sync.name"));
            this.pauseResumeMenu.setActionCommand(COMMAND_PAUSE);
        }
    }

    private void checkStatus() {
        this.statusUpdater.schedule(new Runnable(){

            @Override
            public void run() {
                UIController.this.checkStatus0();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStatus0() {
        Object object;
        long l = 0L;
        FolderRepository folderRepository = this.getController().getFolderRepository();
        Collection<Folder> collection = folderRepository.getFolders();
        int n = 0;
        for (Folder folder : collection) {
            if (folder.isTransferring() || Double.compare(folder.getStatistic().getAverageSyncPercentage(), 100.0) != 0) {
                ++n;
            }
            l += folder.getStatistic().getTotalSize();
        }
        boolean bl = false;
        Object object2 = this.synchronizing;
        synchronized (object2) {
            if (n == 0) {
                object = Translation.get("check_status.in_sync_all");
                if (this.synchronizing.get()) {
                    bl = true;
                    this.synchronizing.set(false);
                }
            } else {
                object = Translation.get("check_status.syncing", String.valueOf(n));
                if (!this.synchronizing.get()) {
                    bl = true;
                    this.synchronizing.set(true);
                }
            }
        }
        if (bl) {
            object2 = Translation.get("check_status.powerfolders", Format.formatBytes(l), String.valueOf(collection.size()));
            this.applicationModel.getNoticesModel().handleNotice(new SimpleNotificationNotice(Translation.get("check_status.title"), (String)object + "\n\n" + (String)object2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRecentFileChange(FileInfo fileInfo) {
        if (this.recentlyChangedMenu == null) {
            return;
        }
        if (fileInfo.getFolderInfo().isMetaFolder()) {
            return;
        }
        Folder folder = fileInfo.getFolder(this.getController().getFolderRepository());
        if (folder == null) {
            return;
        }
        if (folder.getDiskItemFilter().isExcluded(fileInfo)) {
            return;
        }
        Map<Long, FileInfo> map = this.recentlyChangedFiles;
        synchronized (map) {
            Long l;
            Object object = this.recentlyChangedFiles.keySet().iterator();
            while (object.hasNext()) {
                l = object.next();
                FileInfo fileInfo2 = this.recentlyChangedFiles.get(l);
                if (!fileInfo.getRelativeName().equals(fileInfo2.getRelativeName())) continue;
                object.remove();
            }
            object = new Date().getTime();
            while (this.recentlyChangedFiles.containsKey(object)) {
                object = (Long)object + 1L;
            }
            this.recentlyChangedFiles.put((Long)object, fileInfo);
            if (this.recentlyChangedFiles.size() > 20) {
                l = this.recentlyChangedFiles.keySet().iterator().next();
                this.recentlyChangedFiles.remove(l);
            }
        }
        this.recentlyChangedUpdater.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map map = UIController.this.recentlyChangedFiles;
                synchronized (map) {
                    UIController.this.recentlyChangedMenu.removeAll();
                    int n = 0;
                    for (FileInfo fileInfo : UIController.this.recentlyChangedFiles.values()) {
                        MenuItem menuItem = UIController.this.recentMenuItems[n++];
                        UIController.this.recentlyChangedMenu.add(menuItem);
                        menuItem.setLabel(fileInfo.getFilenameOnly());
                    }
                    UIController.this.recentlyChangedMenu.setEnabled(!UIController.this.recentlyChangedFiles.isEmpty());
                }
            }
        });
    }

    public void closePreferencesDialog() {
        if (this.preferencesDialog != null) {
            this.preferencesDialog.close();
        }
    }

    public void openPreferences() {
        if (this.preferencesDialog != null) {
            this.preferencesDialog.open();
        }
    }

    public boolean isShutdownAllowed() {
        boolean bl = PreferencesEntry.WARN_ON_CLOSE.getValueBoolean(this.getController());
        if (bl) {
            Collection<Folder> collection = this.getController().getFolderRepository().getFolders();
            ArrayList<Folder> arrayList = new ArrayList<Folder>(collection.size());
            for (Folder object3 : collection) {
                if (!object3.isTransferring()) continue;
                this.logFine("Close warning on folder: " + object3);
                arrayList.add(object3);
            }
            if (!arrayList.isEmpty()) {
                Object object;
                Object object22;
                StringBuilder stringBuilder = new StringBuilder();
                for (Object object22 : arrayList) {
                    stringBuilder.append("\n     - " + ((Folder)object22).getInfo().getLocalizedName());
                }
                String string = Translation.get("uicontroller.warn_on_close.title");
                if (this.applicationModel.getSyncingModel().isSyncing()) {
                    object = this.applicationModel.getSyncingModel().getEstimatedSyncDate();
                    object22 = Translation.get("uicontroller.warn_on_close_eta.text", stringBuilder.toString(), Format.formatDateShort((Date)object));
                } else {
                    object22 = Translation.get("uicontroller.warn_on_close.text", stringBuilder.toString());
                }
                object = Translation.get("general.neverAskAgain");
                NeverAskAgainResponse neverAskAgainResponse = DialogFactory.genericDialog(this.getController(), string, (String)object22, new String[]{Translation.get("uicontroller.continue_exit"), Translation.get("general.cancel")}, 0, GenericDialogType.QUESTION, (String)object);
                if (neverAskAgainResponse.isNeverAskAgain()) {
                    PreferencesEntry.WARN_ON_CLOSE.setValue(this.getController(), false);
                }
                return neverAskAgainResponse.getButtonIndex() == 0;
            }
            return true;
        }
        return true;
    }

    private class MyFolderListener
    extends FolderAdapter {
        private MyFolderListener() {
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return false;
        }

        @Override
        public void statisticsCalculated(FolderEvent folderEvent) {
            UIController.this.checkStatus();
        }

        @Override
        public void fileChanged(FolderEvent folderEvent) {
            Collection<FileInfo> collection = folderEvent.getScannedFileInfos();
            if (collection != null) {
                for (FileInfo fileInfo : collection) {
                    if (fileInfo.isDiretory()) continue;
                    UIController.this.addRecentFileChange(fileInfo);
                }
            }
        }

        @Override
        public void filesDeleted(FolderEvent folderEvent) {
            Collection<FileInfo> collection = folderEvent.getDeletedFileInfos();
            if (collection != null) {
                for (FileInfo fileInfo : collection) {
                    if (fileInfo.isDiretory()) continue;
                    UIController.this.addRecentFileChange(fileInfo);
                }
            }
        }
    }

    private class MyFolderRepositoryListener
    extends FolderRepositoryAdapter {
        private MyFolderRepositoryListener() {
        }

        @Override
        public void folderRemoved(FolderRepositoryEvent folderRepositoryEvent) {
            UIController.this.removeFolderFromSysTray(folderRepositoryEvent.getFolder());
            folderRepositoryEvent.getFolder().removeFolderListener(UIController.this.folderListener);
            UIController.this.checkStatus();
        }

        @Override
        public void folderCreated(FolderRepositoryEvent folderRepositoryEvent) {
            UIController.this.addFolderToSysTray(folderRepositoryEvent.getFolder());
            folderRepositoryEvent.getFolder().addFolderListener(UIController.this.folderListener);
            UIController.this.checkStatus();
        }

        @Override
        public void folderMoved(FolderRepositoryEvent folderRepositoryEvent) {
            UIController.this.removeFolderFromSysTray(folderRepositoryEvent.getOldFolder());
            folderRepositoryEvent.getOldFolder().removeFolderListener(UIController.this.folderListener);
            UIController.this.addFolderToSysTray(folderRepositoryEvent.getFolder());
            folderRepositoryEvent.getFolder().addFolderListener(UIController.this.folderListener);
            UIController.this.checkStatus();
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return false;
        }
    }

    private class MyTransferManagerListener
    extends TransferManagerAdapter {
        private MyTransferManagerListener() {
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return false;
        }

        @Override
        public void downloadQueued(TransferManagerEvent transferManagerEvent) {
            UIController.this.checkStatus();
        }

        @Override
        public void downloadStarted(TransferManagerEvent transferManagerEvent) {
            UIController.this.checkStatus();
        }

        @Override
        public void downloadAborted(TransferManagerEvent transferManagerEvent) {
            UIController.this.checkStatus();
        }

        @Override
        public void downloadBroken(TransferManagerEvent transferManagerEvent) {
            UIController.this.checkStatus();
        }

        @Override
        public void downloadCompleted(TransferManagerEvent transferManagerEvent) {
            UIController.this.checkStatus();
        }

        @Override
        public void uploadStarted(TransferManagerEvent transferManagerEvent) {
            UIController.this.checkStatus();
        }

        @Override
        public void uploadAborted(TransferManagerEvent transferManagerEvent) {
            UIController.this.checkStatus();
        }

        @Override
        public void uploadBroken(TransferManagerEvent transferManagerEvent) {
            UIController.this.checkStatus();
        }

        @Override
        public void uploadCompleted(TransferManagerEvent transferManagerEvent) {
            UIController.this.checkStatus();
        }
    }

    private class MyInvitationHandler
    implements InvitationHandler {
        private MyInvitationHandler() {
        }

        @Override
        public void gotInvitation(Invitation invitation) {
            InvitationNotice invitationNotice = new InvitationNotice(Translation.get("notice.invitation.title"), Translation.get("notice.invitation.summary", invitation.getSender(), invitation.folder.getLocalizedName()), invitation);
            UIController.this.applicationModel.getNoticesModel().handleNotice(invitationNotice);
        }
    }

    private class MyFolderAutoCreateListener
    implements FolderAutoCreateListener {
        private MyFolderAutoCreateListener() {
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }

        @Override
        public void folderAutoCreated(FolderAutoCreateEvent folderAutoCreateEvent) {
            UIController.this.handleFolderAutoCreate(folderAutoCreateEvent);
        }
    }

    private class MyPausedModeListener
    implements PausedModeListener {
        private MyPausedModeListener() {
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }

        @Override
        public void setPausedMode(PausedModeEvent pausedModeEvent) {
            UIController.this.configurePauseResumeLink();
        }
    }
}

