/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.transfer;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.message.RequestPart;
import de.dal33t.powerfolder.transfer.AbstractDownloadManager;
import de.dal33t.powerfolder.transfer.BrokenDownloadException;
import de.dal33t.powerfolder.transfer.Download;
import de.dal33t.powerfolder.transfer.DownloadManager;
import de.dal33t.powerfolder.transfer.DownloadManagerFactory;
import de.dal33t.powerfolder.transfer.Transfer;
import de.dal33t.powerfolder.util.Range;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.delta.FilePartsState;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.ConcurrentMap;

public class MultiSourceDownloadManager
extends AbstractDownloadManager {
    private final ConcurrentMap<MemberInfo, Download> downloads = Util.createConcurrentHashMap(4);
    private Download pendingPartRecordFrom;
    public static final DownloadManagerFactory factory = new DownloadManagerFactory(){

        @Override
        public DownloadManager createDownloadManager(Controller controller, FileInfo fileInfo, boolean bl) {
            return new MultiSourceDownloadManager(controller, fileInfo, bl);
        }
    };

    private MultiSourceDownloadManager(Controller controller, FileInfo fileInfo, boolean bl) {
        super(controller, fileInfo, bl);
    }

    @Override
    protected void addSourceImpl(Download download) {
        assert (download != null);
        assert (this.canAddSource(download.getPartner()));
        if (this.downloads.put(download.getPartner().getInfo(), download) != null) {
            this.logSevere("Overridden previous download for member: " + download.getPartner() + ". " + download);
        }
        if (this.isRequestedAutomatic() != download.isRequestedAutomatic()) {
            this.setAutomatic(false);
        }
    }

    @Override
    public boolean canAddSource(Member member) {
        Reject.ifNull(member, "Member is null");
        return this.downloads.isEmpty() || Util.useSwarming(this.getController(), member);
    }

    @Override
    public Download getSourceFor(Member member) {
        Reject.ifNull(member, "Member is null");
        return (Download)this.downloads.get(member.getInfo());
    }

    @Override
    public boolean hasSource(Download download) {
        Reject.ifNull(download, "Download is null!");
        return this.downloads.get(download.getPartner().getInfo()) == download;
    }

    @Override
    public Date getCompletedDate() {
        if (!this.downloads.isEmpty()) {
            Date date = null;
            for (Download download : this.downloads.values()) {
                Date date2 = download.getCompletedDate();
                if (date2 == null || date != null && !date2.after(date)) continue;
                date = date2;
            }
            return date;
        }
        return null;
    }

    @Override
    public Collection<Download> getSources() {
        return Collections.unmodifiableCollection(this.downloads.values());
    }

    @Override
    public boolean hasSources() {
        return !this.downloads.isEmpty();
    }

    @Override
    protected void removeSourceImpl(Download download) {
        assert (download != null);
        assert (this.hasSource(download));
        if (this.downloads.remove(download.getPartner().getInfo()) == null) {
            throw new AssertionError((Object)("Removed non-managed download:" + download + " " + download.getPartner().getInfo()));
        }
        if (this.filePartsState != null) {
            for (RequestPart requestPart : download.getPendingRequests()) {
                this.filePartsState.setPartState(requestPart.getRange(), FilePartsState.PartState.NEEDED);
            }
        }
    }

    @Override
    public String toString() {
        String string = super.toString() + "; sources=" + this.downloads.values() + "; pending requested bytes: ";
        if (this.filePartsState != null) {
            string = string + this.filePartsState.countPartStates(this.filePartsState.getRange(), FilePartsState.PartState.PENDING) + "; available: " + this.filePartsState.countPartStates(this.filePartsState.getRange(), FilePartsState.PartState.AVAILABLE) + "; needed: " + this.filePartsState.countPartStates(this.filePartsState.getRange(), FilePartsState.PartState.NEEDED);
        }
        return string;
    }

    protected Download findPartRecordSource(Download download) {
        assert (download != null);
        for (Download download2 : this.downloads.values()) {
            if (!download2.isStarted() || download2.isBroken() || !Util.useDeltaSync(this.getController(), download2)) continue;
            download = download2;
            break;
        }
        return download;
    }

    @Override
    protected void requestFilePartsRecord(Download download) {
        assert (download == null || Util.useDeltaSync(this.getController(), download));
        if (this.pendingPartRecordFrom != null) {
            if (!this.pendingPartRecordFrom.isBroken()) {
                return;
            }
            this.pendingPartRecordFrom = null;
        }
        if (download == null) {
            download = this.findPartRecordSource(null);
        }
        if (download != null) {
            assert (Util.useDeltaSync(this.getController(), download));
            if (this.isFine()) {
                this.logFine("Requesting Filepartsrecord from " + download);
            }
            this.setTransferState(Transfer.TransferState.FILERECORD_REQUEST);
            this.pendingPartRecordFrom = download;
            this.pendingPartRecordFrom.requestFilePartsRecord();
            this.setStarted();
        }
    }

    @Override
    protected void sendPartRequests() throws BrokenDownloadException {
        Range range;
        if (this.isFiner()) {
            this.logFiner("X Sending part requests: " + this.filePartsState.countPartStates(this.filePartsState.getRange(), FilePartsState.PartState.NEEDED));
        }
        this.setTransferState(Transfer.TransferState.DOWNLOADING);
        while ((range = this.filePartsState.findFirstPart(FilePartsState.PartState.NEEDED)) != null && this.findAndRequestDownloadFor(range = Range.getRangeByLength(range.getStart(), Math.min((long)this.getController().getTransferManager().getMaxFileChunkSize(), range.getLength())))) {
            this.filePartsState.setPartState(range, FilePartsState.PartState.PENDING);
        }
        if (this.isFiner()) {
            this.logFiner("X Sending part requests over");
        }
    }

    private boolean hasNoAvailableSources() {
        for (Download download : this.downloads.values()) {
            if (!download.isStarted() || download.isBroken()) continue;
            return false;
        }
        return true;
    }

    private boolean findAndRequestDownloadFor(Range range) throws BrokenDownloadException {
        assert (range != null);
        if (this.isFiner()) {
            this.logFiner("X findAndRequestDownloadFor: " + range);
        }
        for (Download download : this.downloads.values()) {
            if (!download.isStarted() || download.isBroken() || !download.requestPart(range)) continue;
            return true;
        }
        return false;
    }
}

