/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.transfer;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.Lock;
import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.util.Translation;
import java.nio.file.Path;
import javax.swing.SwingWorker;

public class MetaFolderDataHandler
extends PFComponent {
    public MetaFolderDataHandler(Controller controller) {
        super(controller);
    }

    public void handleMetaFolderFileInfo(FileInfo fileInfo) {
        if (!fileInfo.getFolderInfo().isMetaFolder()) {
            this.logSevere("Unable to handle meta data file. Not in meta folder: " + fileInfo.toDetailString());
            return;
        }
        Folder folder = this.getController().getFolderRepository().getContentFolder(fileInfo.getFolderInfo());
        if (folder == null) {
            this.logSevere("Parent folder for meta folder not found: " + fileInfo.getFolderInfo() + "/" + fileInfo.getFolderInfo().id);
            return;
        }
        if (fileInfo.getRelativeName().endsWith("ignore.patterns")) {
            folder.handleMetaFolderSyncPatterns(fileInfo);
        }
        if (fileInfo.getRelativeName().equals("Members")) {
            folder.updateMetaFolderMembers();
        }
        if (fileInfo.getRelativeName().startsWith("locks")) {
            this.getController().getFolderRepository().getLocking().lockStateChanged(fileInfo);
        }
    }

    public void handleRemoteLockOverwrite(final FileInfo fileInfo, Path path) {
        if (this.getController().getMySelf().isServer()) {
            return;
        }
        if (fileInfo == null) {
            return;
        }
        Lock lock = this.getController().getFolderRepository().getLocking().getLock(path);
        if (lock == null) {
            return;
        }
        final MemberInfo memberInfo = lock.getMemberInfo();
        final MemberInfo memberInfo2 = fileInfo.getModifiedBy();
        if (memberInfo == null || memberInfo2 == null || !memberInfo.getNode(this.getController(), true).isMySelf()) {
            return;
        }
        if (!memberInfo.equals(memberInfo2)) {
            AccountInfo accountInfo = memberInfo2.getNode(this.getController(), true).getAccountInfo();
            final String string = accountInfo != null ? accountInfo.getDisplayName() : memberInfo2.nick;
            SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() {
                    MetaFolderDataHandler.this.logWarning("Overwriting lock for " + fileInfo + " set by " + memberInfo.getNick() + " removed by " + memberInfo2.getNick());
                    DialogFactory.genericDialog(MetaFolderDataHandler.this.getController(), Translation.get("dialog.lock.removed_by_other_member.title"), Translation.get("dialog.lock.removed_by_other_member.message", fileInfo.getFilenameOnly(), string), new String[]{"OK"}, 0, GenericDialogType.WARN);
                    return null;
                }
            };
            swingWorker.execute();
        }
    }
}

