/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.transfer;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.transfer.BandwidthLimiterInfo;
import de.dal33t.powerfolder.transfer.BandwidthStat;
import de.dal33t.powerfolder.transfer.BandwidthStatsListener;
import de.dal33t.powerfolder.transfer.CoalescedBandwidthStat;
import de.dal33t.powerfolder.util.DateUtil;
import de.dal33t.powerfolder.util.Reject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class BandwidthStatsRecorder
extends PFComponent
implements BandwidthStatsListener {
    private final Map<StatKey, StatValue> coalescedStats = new HashMap<StatKey, StatValue>();

    public BandwidthStatsRecorder(Controller controller) {
        super(controller);
        this.loadStats();
    }

    private void loadStats() {
        String string = this.getController().getConfigName() + ".stats";
        Path path = Controller.getMiscFilesLocation().resolve(string);
        if (Files.exists(path, new LinkOption[0])) {
            this.logFiner("Loading stats");
            try (ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])));){
                Map map = (Map)objectInputStream.readObject();
                this.coalescedStats.putAll(map);
                this.logFine("Loaded " + map.size() + " stats.");
            }
            catch (IOException iOException) {
                this.logFine("IOException while loading " + string + ". " + iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.logWarning("ClassNotFoundException", classNotFoundException);
            }
            catch (ClassCastException classCastException) {
                this.logWarning("ClassCastException", classCastException);
            }
        } else {
            this.logFine("No stats found - probably first start of PF.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleBandwidthStat(BandwidthStat bandwidthStat) {
        StatKey statKey = new StatKey(bandwidthStat.getInfo(), bandwidthStat.getDate());
        Map<StatKey, StatValue> map = this.coalescedStats;
        synchronized (map) {
            StatValue statValue = this.coalescedStats.get(statKey);
            if (statValue == null) {
                statValue = new StatValue();
                this.coalescedStats.put(statKey, statValue);
            }
            statValue.update(bandwidthStat.getInitialBandwidth(), bandwidthStat.getResidualBandwidth());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pruneStats(Date date) {
        int n = 0;
        Map<StatKey, StatValue> map = this.coalescedStats;
        synchronized (map) {
            Iterator<StatKey> iterator = this.coalescedStats.keySet().iterator();
            while (iterator.hasNext()) {
                StatKey statKey = iterator.next();
                if (!statKey.date.before(date)) continue;
                iterator.remove();
                ++n;
            }
        }
        this.logFiner("Pruned " + n + " stats.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CoalescedBandwidthStat> getBandwidthStats() {
        Map<StatKey, StatValue> map = this.coalescedStats;
        synchronized (map) {
            TreeSet<CoalescedBandwidthStat> treeSet = new TreeSet<CoalescedBandwidthStat>();
            for (Map.Entry<StatKey, StatValue> entry : this.coalescedStats.entrySet()) {
                CoalescedBandwidthStat coalescedBandwidthStat = new CoalescedBandwidthStat(entry.getKey().getDate(), entry.getKey().getInfo(), entry.getValue().getInitial(), entry.getValue().getResidual(), entry.getValue().getPeak(), entry.getValue().getCount());
                treeSet.add(coalescedBandwidthStat);
            }
            return treeSet;
        }
    }

    @Override
    public boolean fireInEventDispatchThread() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistStats() {
        Map<StatKey, StatValue> map = this.coalescedStats;
        synchronized (map) {
            String string = this.getController().getConfigName() + ".stats";
            Path path = Controller.getMiscFilesLocation().resolve(string);
            boolean bl = Thread.interrupted();
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0])));){
                this.logInfo("There are " + this.coalescedStats.size() + " stats to persist.");
                objectOutputStream.writeUnshared(this.coalescedStats);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.logSevere("FileNotFoundException", fileNotFoundException);
            }
            catch (IOException iOException) {
                this.logWarning("IOException", iOException);
            }
            finally {
                if (bl) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private static class StatKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final BandwidthLimiterInfo info;
        private final Date date;

        private StatKey(BandwidthLimiterInfo bandwidthLimiterInfo, Date date) {
            Reject.ifNull((Object)bandwidthLimiterInfo, "Info is null");
            Reject.ifNull(date, "Date is null");
            this.info = bandwidthLimiterInfo;
            this.date = DateUtil.truncateToHour(date);
        }

        public BandwidthLimiterInfo getInfo() {
            return this.info;
        }

        public Date getDate() {
            return this.date;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            StatKey statKey = (StatKey)object;
            if (!this.date.equals(statKey.date)) {
                return false;
            }
            return this.info == statKey.info;
        }

        public int hashCode() {
            int n = this.info.hashCode();
            n = 31 * n + this.date.hashCode();
            return n;
        }

        public String toString() {
            return "StatKey{info=" + this.info + ", date=" + this.date + "}";
        }
    }

    private static class StatValue
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private long initial;
        private long residual;
        private long peak;
        private long count;

        private StatValue() {
        }

        public long getInitial() {
            return this.initial;
        }

        public long getResidual() {
            return this.residual;
        }

        public long getPeak() {
            return this.peak;
        }

        public long getCount() {
            return this.count;
        }

        public void update(long l, long l2) {
            if (l >= 0L) {
                this.initial += l;
            }
            if (l2 >= 0L) {
                this.residual += l2;
            }
            if (l >= 0L && l2 >= 0L) {
                this.peak = Math.max(this.peak, l - l2);
            }
            ++this.count;
        }

        public String toString() {
            return "StatValue{initial=" + this.initial + ", residual=" + this.residual + ", peak=" + this.peak + ", count=" + this.count + "}";
        }
    }
}

