/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.security;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.security.AccessMode;
import de.dal33t.powerfolder.security.FolderAdminPermission;
import de.dal33t.powerfolder.security.FolderDeletePermission;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.security.FolderReadPermission;
import de.dal33t.powerfolder.security.FolderReadWritePermission;
import de.dal33t.powerfolder.security.Permission;
import de.dal33t.powerfolder.util.Translation;

public class FolderOwnerPermission
extends FolderPermission {
    private static final long serialVersionUID = 100L;

    FolderOwnerPermission(FolderInfo folderInfo) {
        super(folderInfo);
    }

    public FolderOwnerPermission(AbstractMessage abstractMessage) {
        this.initFromD2D(abstractMessage);
    }

    @Override
    public String getName() {
        return Translation.get("permissions.folder.owner");
    }

    @Override
    public AccessMode getMode() {
        return AccessMode.OWNER;
    }

    @Override
    public boolean implies(Permission permission) {
        if (permission instanceof FolderReadPermission) {
            FolderReadPermission folderReadPermission = (FolderReadPermission)permission;
            return folderReadPermission.getFolder().equals(this.getFolder());
        }
        if (permission instanceof FolderReadWritePermission) {
            FolderReadWritePermission folderReadWritePermission = (FolderReadWritePermission)permission;
            return folderReadWritePermission.getFolder().equals(this.getFolder());
        }
        if (permission instanceof FolderAdminPermission) {
            FolderAdminPermission folderAdminPermission = (FolderAdminPermission)permission;
            return folderAdminPermission.getFolder().equals(this.getFolder());
        }
        if (permission instanceof FolderDeletePermission) {
            FolderDeletePermission folderDeletePermission = (FolderDeletePermission)permission;
            return folderDeletePermission.getFolder().equals(this.getFolder());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.folder == null ? 0 : this.folder.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof FolderOwnerPermission)) {
            return false;
        }
        FolderOwnerPermission folderOwnerPermission = (FolderOwnerPermission)object;
        return !(this.folder == null ? folderOwnerPermission.folder != null : !this.folder.equals(folderOwnerPermission.folder));
    }
}

