/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.security;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.security.AccessMode;
import de.dal33t.powerfolder.security.FolderDeletePermission;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.security.FolderReadPermission;
import de.dal33t.powerfolder.security.FolderReadWritePermission;
import de.dal33t.powerfolder.security.Permission;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Translation;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class FolderAdminPermission
extends FolderPermission {
    private static final long serialVersionUID = 100L;
    @Deprecated
    private FolderInfo folder;

    FolderAdminPermission(FolderInfo folderInfo) {
        super(folderInfo);
        Reject.ifNull(folderInfo, "Folderinfo is null");
        this.folder = folderInfo;
    }

    public FolderAdminPermission(AbstractMessage abstractMessage) {
        this.initFromD2D(abstractMessage);
    }

    @Override
    public String getName() {
        return Translation.get("permissions.folder.admin");
    }

    @Override
    public AccessMode getMode() {
        return AccessMode.ADMIN;
    }

    @Override
    public boolean implies(Permission permission) {
        if (permission instanceof FolderReadPermission) {
            FolderReadPermission folderReadPermission = (FolderReadPermission)permission;
            return folderReadPermission.getFolder().equals(this.getFolder());
        }
        if (permission instanceof FolderReadWritePermission) {
            FolderReadWritePermission folderReadWritePermission = (FolderReadWritePermission)permission;
            return folderReadWritePermission.getFolder().equals(this.getFolder());
        }
        if (permission instanceof FolderDeletePermission) {
            FolderDeletePermission folderDeletePermission = (FolderDeletePermission)permission;
            return folderDeletePermission.getFolder().equals(this.getFolder());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.folder == null ? 0 : this.folder.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof FolderAdminPermission)) {
            return false;
        }
        FolderAdminPermission folderAdminPermission = (FolderAdminPermission)object;
        return !(this.folder == null ? folderAdminPermission.folder != null : !this.folder.equals(folderAdminPermission.folder));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.folder != null) {
            ((FolderPermission)this).folder = this.folder;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (((FolderPermission)this).folder != null) {
            this.folder = ((FolderPermission)this).folder;
        }
        objectOutputStream.defaultWriteObject();
    }
}

