/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.pro.G;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.event.FolderRepositoryAdapter;
import de.dal33t.powerfolder.event.FolderRepositoryEvent;
import de.dal33t.powerfolder.plugin.AbstractPFPlugin;
import de.dal33t.powerfolder.util.Base64;
import de.dal33t.powerfolder.util.Convert;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.StreamUtils;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.os.OSUtil;
import de.dal33t.powerfolder.util.os.Win32.WinUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class A
extends AbstractPFPlugin {
    private static final String \u00ba = "Yellow blue soft/Tabbles/Tabbles.exe";
    private static final String \u00c2 = "powerfolder";
    private static final String \u00c1 = "Tabbles/Config/config.xml";
    private static final String \u00c0 = "powerfolder-beta-2010";

    public A(Controller controller) {
        super(controller);
    }

    @Override
    public String getName() {
        return Translation.get("exp.tabbles.name");
    }

    @Override
    public String getDescription() {
        return Translation.get("exp.tabbles.description");
    }

    @Override
    public void start() {
        this.\u00c4();
        this.\u00c0();
        this.\u00c2();
        this.getController().getFolderRepository().addFolderRepositoryListener(new _A());
    }

    @Override
    public void stop() {
        this.\u00c5();
    }

    private void \u00c2() {
        Path path = A.\u00c6();
        if (path == null) {
            return;
        }
        Path path2 = path.resolve(\u00ba);
        if (Files.notExists(path2, new LinkOption[0])) {
            return;
        }
        PathUtils.openFile(path2);
    }

    private static Path \u00c6() {
        String string = OSUtil.is64BitPlatform() ? "ProgramFiles(x86)" : "PROGRAMFILES";
        String string2 = System.getenv(string);
        if (StringUtils.isBlank(string2)) {
            return null;
        }
        return Paths.get(string2, new String[0]);
    }

    private synchronized void \u00c5() {
        Path path = A.\u00c6();
        if (path == null) {
            return;
        }
        Path path2 = path.resolve(\u00ba);
        if (Files.notExists(path2, new LinkOption[0])) {
            return;
        }
        try {
            final Process process = Runtime.getRuntime().exec(path2.toAbsolutePath() + " exit");
            this.getController().schedule(new Runnable(){

                @Override
                public void run() {
                    process.destroy();
                }
            }, 20000L);
            byte[] byArray = StreamUtils.readIntoByteArray(process.getInputStream());
            String string = new String(byArray);
            int n = process.waitFor();
            this.logWarning("Stopped tabbles @ " + path2 + ". exit code: " + n + ". exit output: " + string);
        }
        catch (Exception exception) {
            this.logFine("Unable to stop Tabbles @ " + path2 + ". " + exception, exception);
        }
    }

    private void \u00c4() {
        Document document;
        Object object;
        Path path = this.\u00c3();
        this.logWarning("Tabbles config file: " + path);
        if (path != null && Files.exists(path, new LinkOption[0])) {
            object = new SAXReader();
            try {
                document = ((SAXReader)object).read(Files.newInputStream(path, new OpenOption[0]));
            }
            catch (DocumentException documentException) {
                this.logSevere("Unable to read tabbles config file. " + documentException);
                return;
            }
            catch (IOException iOException) {
                this.logSevere("Problem reading tabbles config file. " + iOException);
                return;
            }
        } else {
            document = DocumentHelper.createDocument();
            document.addElement("config");
        }
        object = document.getRootElement();
        this.B((Element)object);
        this.A((Element)object);
        try {
            OutputFormat outputFormat = OutputFormat.createPrettyPrint();
            outputFormat.setEncoding("UTF-8");
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            XMLWriter xMLWriter = new XMLWriter(Files.newOutputStream(path, new OpenOption[0]), outputFormat);
            xMLWriter.write(document);
            xMLWriter.close();
        }
        catch (IOException iOException) {
            this.logSevere("Unable to create Tabbles config file @ " + path + ". " + iOException, iOException);
        }
    }

    private void B(Element element) {
        this.A(element, "unique_network_id", this.\u00c1());
        this.A(element, "cloud_sharing_enabled", "True");
        this.A(element, "powerfolder_integration", "True");
        Element element2 = element.element("license");
        if (element2 == null) {
            element2 = element.addElement("license");
            this.A(element2, "key", \u00c0);
        }
    }

    private void A(Element element) {
        Object object;
        Object object2;
        Iterator<Folder> iterator2;
        Object iOException;
        Collection<Folder> collection = this.getController().getFolderRepository().getFolders();
        HashSet<String> hashSet = new HashSet<String>();
        for (Folder object52 : collection) {
            try {
                iOException = this.getController().getFolderRepository().getMetaFolder(object52.getInfo());
                iterator2 = this.D((Folder)iOException);
                hashSet.add(iterator2.toRealPath(new LinkOption[0]).toString());
            }
            catch (IOException iOException2) {
                this.logWarning("Unable to retrieve path for folder " + object52 + ". " + iOException2, iOException2);
            }
        }
        HashSet hashSet2 = new HashSet();
        List list = element.elements("cloud_sharing_input_folder");
        for (Iterator<Folder> iterator2 : list) {
            Element element2 = (Element)((Object)iterator2);
            object2 = element2.attributeValue("path");
            if (!hashSet.contains(object2)) continue;
            element.remove((Element)((Object)iterator2));
            hashSet2.add(object2);
        }
        iOException = element.elements("cloud_sharing_output_folder");
        iterator2 = iOException.iterator();
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            object2 = (Element)e;
            object = object2.attributeValue("path");
            if (!hashSet.contains(object) || hashSet2.contains(object)) continue;
            element.remove((Element)e);
        }
        for (Folder folder : collection) {
            try {
                object2 = this.getController().getFolderRepository().getMetaFolder(folder.getInfo());
                object = this.D((Folder)object2);
                Files.createDirectories((Path)object, new FileAttribute[0]);
                String string = object.toRealPath(new LinkOption[0]).toString();
                Element element3 = element.addElement("cloud_sharing_input_folder");
                element3.addAttribute("path", string);
                if (!hashSet2.contains(string)) {
                    this.logWarning("Adding cloud_sharing_output_folder: " + string);
                    Element element4 = element.addElement("cloud_sharing_output_folder");
                    element4.addAttribute("path", string);
                } else {
                    this.logWarning("NOT adding (only input) cloud_sharing_output_folder: " + string);
                }
                ((Folder)object2).setSyncProfile(SyncProfile.AUTOMATIC_SYNCHRONIZATION);
            }
            catch (Exception exception) {
                this.logSevere("Unable to write Tabbles config entry for folder " + folder + ". " + exception, exception);
            }
        }
    }

    private Path D(Folder folder) {
        Path path = folder.getLocalBase().resolve("Tabbles");
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            return path;
        }
        catch (IOException iOException) {
            this.logWarning("Could not create directory: " + path.toAbsolutePath().toString() + "\n" + iOException.getMessage());
            return null;
        }
    }

    private void \u00c0() {
        for (Folder folder : this.getController().getFolderRepository().getFolders()) {
            this.C(folder);
        }
    }

    private void C(Folder folder) {
        Cloneable cloneable;
        Object object;
        Folder folder2 = this.getController().getFolderRepository().getMetaFolder(folder.getInfo());
        Document document = DocumentHelper.createDocument();
        document.addElement("equivalent_paths_section");
        Element element = document.getRootElement();
        element.clearContent();
        Element element2 = element.addElement("equivalence_group");
        Element element3 = element2.addElement("meta_id");
        element3.addAttribute("provider", \u00c2);
        element3.addAttribute("id", folder.getId());
        try {
            object = this.\u00c1();
            cloneable = element2.addElement("item");
            cloneable.addAttribute("client_id", (String)object);
            this.A((Element)cloneable, "path", folder.getLocalBase().toRealPath(new LinkOption[0]).toString());
        }
        catch (IOException iOException) {
            this.logWarning("Unable to update Tabbles config. Folder: " + folder2 + ". " + iOException, iOException);
        }
        object = this.D(folder2).resolve("eq_path_" + this.\u00c1() + ".xml");
        try {
            cloneable = OutputFormat.createPrettyPrint();
            ((OutputFormat)cloneable).setEncoding("UTF-8");
            XMLWriter xMLWriter = new XMLWriter(Files.newOutputStream((Path)object, new OpenOption[0]), (OutputFormat)cloneable);
            xMLWriter.write(document);
            xMLWriter.close();
        }
        catch (IOException iOException) {
            this.logSevere("Unable to create Tabbles config file @ " + (Path)object + ". " + iOException, iOException);
        }
        folder2.recommendScanOnNextMaintenance(true);
    }

    private void A(Element element, String string, String string2) {
        Attribute attribute = element.attribute(string);
        if (attribute != null) {
            attribute.setValue(string2);
        } else {
            element.addAttribute(string, string2);
        }
    }

    private String \u00c1() {
        String string = this.getController().getMySelf().getNick();
        String string2 = this.getController().getMySelf().getId();
        string2 = Base64.encodeBytes(string2.getBytes(Convert.UTF8), 8);
        return PathUtils.removeInvalidFilenameChars(string + "@" + string2);
    }

    private Path \u00c3() {
        Path path = null;
        if (WinUtils.isSupported()) {
            path = Paths.get(WinUtils.getInstance().getSystemFolderPath(5, false), \u00c1);
        } else {
            Path path2 = Paths.get(System.getProperty("user.home"), "Documents");
            if (Files.exists(path2, new LinkOption[0])) {
                path = path2.resolve(\u00c1);
            }
        }
        return path;
    }

    private class _A
    extends FolderRepositoryAdapter {
        private _A() {
        }

        @Override
        public void folderCreated(FolderRepositoryEvent folderRepositoryEvent) {
            if (folderRepositoryEvent.getFolderInfo().isMetaFolder()) {
                folderRepositoryEvent.getFolder().setSyncProfile(SyncProfile.AUTOMATIC_SYNCHRONIZATION);
            }
            A.this.\u00c4();
            A.this.C(folderRepositoryEvent.getFolder());
        }

        @Override
        public void folderMoved(FolderRepositoryEvent folderRepositoryEvent) {
            this.folderCreated(folderRepositoryEvent);
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return false;
        }
    }
}

