/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.net;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.message.Identity;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.net.AbstractSocketConnectionHandler;
import de.dal33t.powerfolder.net.ConnectionException;
import de.dal33t.powerfolder.net.ConnectionHandler;
import de.dal33t.powerfolder.util.ByteSerializer;
import java.io.IOException;
import java.net.Socket;

public class PlainSocketConnectionHandler
extends AbstractSocketConnectionHandler
implements ConnectionHandler {
    protected PlainSocketConnectionHandler(Controller controller, Socket socket) {
        super(controller, socket);
    }

    @Override
    protected Object deserialize(byte[] byArray, int n) throws ClassNotFoundException, ConnectionException {
        boolean bl;
        boolean bl2 = bl = !this.isOnLAN();
        if (this.getIdentity() != null && this.getIdentity().isUseCompressedStream() != null) {
            bl = this.getIdentity().isUseCompressedStream();
        }
        try {
            return ByteSerializer.deserializeStatic(byArray, bl);
        }
        catch (IOException iOException) {
            throw new ConnectionException("Unable to read message from peer, connection closed", iOException).with(this);
        }
    }

    @Override
    protected byte[] serialize(Message message) throws ConnectionException {
        try {
            boolean bl = this.getMyIdentity().isUseCompressedStream();
            ByteSerializer byteSerializer = this.getSerializer();
            if (byteSerializer == null) {
                throw new IOException("Connection already closed");
            }
            return byteSerializer.serialize(message, bl, -1);
        }
        catch (IOException iOException) {
            throw new ConnectionException("Unable to send message to peer, connection closed", iOException).with(this);
        }
    }

    @Override
    protected Identity createOwnIdentity() {
        return new Identity(this.getController(), this.getController().getMySelf().getInfo(), this.getMyMagicId(), false, false, this);
    }
}

