/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.net;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.event.NodeManagerAdapter;
import de.dal33t.powerfolder.event.NodeManagerEvent;
import de.dal33t.powerfolder.event.NodeManagerListener;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.message.SearchNodeRequest;
import de.dal33t.powerfolder.net.NodeFilter;
import de.dal33t.powerfolder.security.SecurityManager;
import de.dal33t.powerfolder.security.SecurityManagerClient;
import de.dal33t.powerfolder.util.Reject;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class NodeSearcher
extends PFComponent {
    private String pattern;
    private boolean stopSearching;
    private boolean ignoreFriends;
    private boolean hideOffline;
    private final Thread searchThread;
    private NodeManagerListener nodeListener;
    private Queue<Member> canidatesFromSupernodes;
    private List<Member> searchResultListModel;
    private NodeSearchFilter nodeSearchFilter;

    public NodeSearcher(Controller controller, String string, List<Member> list, boolean bl, boolean bl2) {
        super(controller);
        Reject.ifNull(list, "Result list model is null");
        Reject.ifBlank(string, "The search pattern is blank");
        this.nodeListener = new MyNodeManagerListener();
        this.searchThread = new Thread((Runnable)new Searcher(), "NodeSearcher - searching for " + string);
        this.searchThread.setDaemon(true);
        this.pattern = string;
        this.canidatesFromSupernodes = new LinkedList<Member>();
        this.searchResultListModel = list;
        this.ignoreFriends = bl;
        this.hideOffline = bl2;
        this.nodeSearchFilter = new NodeSearchFilter();
    }

    public void start() {
        this.searchThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelSearch() {
        try {
            this.stopSearching = true;
            Thread thread = this.searchThread;
            synchronized (thread) {
                this.searchThread.notifyAll();
            }
            this.searchThread.join(500L);
            if (this.isSearching()) {
                this.searchThread.interrupt();
            }
        }
        catch (InterruptedException interruptedException) {
            this.logSevere("InterruptedException", interruptedException);
        }
    }

    public boolean isSearching() {
        return this.searchThread.getState() != Thread.State.TERMINATED;
    }

    private boolean checkMember(Member member) {
        if (this.hideOffline && !member.isConnectedToNetwork()) {
            return false;
        }
        if (this.ignoreFriends && member.isFriend()) {
            return false;
        }
        if (!member.isOnSameNetwork()) {
            return false;
        }
        if (member.isMySelf()) {
            return false;
        }
        return !this.searchResultListModel.contains(member);
    }

    private class NodeSearchFilter
    implements NodeFilter {
        private NodeSearchFilter() {
        }

        @Override
        public boolean shouldAddNode(MemberInfo memberInfo) {
            return memberInfo.matches(NodeSearcher.this.pattern);
        }
    }

    private class MyNodeManagerListener
    extends NodeManagerAdapter {
        private MyNodeManagerListener() {
        }

        @Override
        public void nodeRemoved(NodeManagerEvent nodeManagerEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void nodeAdded(NodeManagerEvent nodeManagerEvent) {
            Thread thread = NodeSearcher.this.searchThread;
            synchronized (thread) {
                Queue queue = NodeSearcher.this.canidatesFromSupernodes;
                synchronized (queue) {
                    NodeSearcher.this.canidatesFromSupernodes.add(nodeManagerEvent.getNode());
                }
                NodeSearcher.this.searchThread.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void nodeConnected(NodeManagerEvent nodeManagerEvent) {
            Thread thread = NodeSearcher.this.searchThread;
            synchronized (thread) {
                Queue queue = NodeSearcher.this.canidatesFromSupernodes;
                synchronized (queue) {
                    NodeSearcher.this.canidatesFromSupernodes.add(nodeManagerEvent.getNode());
                }
                NodeSearcher.this.searchThread.notifyAll();
            }
        }

        @Override
        public void nodeDisconnected(NodeManagerEvent nodeManagerEvent) {
            if (NodeSearcher.this.hideOffline) {
                NodeSearcher.this.searchResultListModel.remove(nodeManagerEvent.getNode());
            }
        }

        @Override
        public void friendAdded(NodeManagerEvent nodeManagerEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void friendRemoved(NodeManagerEvent nodeManagerEvent) {
            Thread thread = NodeSearcher.this.searchThread;
            synchronized (thread) {
                Queue queue = NodeSearcher.this.canidatesFromSupernodes;
                synchronized (queue) {
                    NodeSearcher.this.canidatesFromSupernodes.add(nodeManagerEvent.getNode());
                }
                NodeSearcher.this.searchThread.notifyAll();
            }
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return false;
        }
    }

    private class Searcher
    implements Runnable {
        private Searcher() {
        }

        @Override
        public void run() {
            NodeSearcher.this.searchResultListModel.clear();
            this.searchLocal();
            this.searchServer();
            this.searchSupernodes();
        }

        private void searchLocal() {
            for (Member member : NodeSearcher.this.getController().getNodeManager().getNodesAsCollection()) {
                if (!NodeSearcher.this.checkMember(member) || !member.matches(NodeSearcher.this.pattern)) continue;
                NodeSearcher.this.searchResultListModel.add(member);
            }
            this.fetchAccountInfos(NodeSearcher.this.searchResultListModel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void searchSupernodes() {
            Object object;
            NodeSearcher.this.getController().getNodeManager().addNodeManagerListener(NodeSearcher.this.nodeListener);
            NodeSearcher.this.getController().getNodeManager().addNodeFilter(NodeSearcher.this.nodeSearchFilter);
            SearchNodeRequest searchNodeRequest = new SearchNodeRequest(NodeSearcher.this.pattern);
            NodeSearcher.this.getController().getNodeManager().broadcastMessageToSupernodes(searchNodeRequest, 4);
            NodeSearcher.this.getController().getNodeManager().broadcastMessageLANNodes(searchNodeRequest, 4);
            try {
                while (!NodeSearcher.this.stopSearching) {
                    while (!NodeSearcher.this.canidatesFromSupernodes.isEmpty()) {
                        Queue queue = NodeSearcher.this.canidatesFromSupernodes;
                        // MONITORENTER : queue
                        object = (Member)NodeSearcher.this.canidatesFromSupernodes.poll();
                        // MONITOREXIT : queue
                        if (object != null && NodeSearcher.this.checkMember((Member)object) && ((Member)object).matches(NodeSearcher.this.pattern)) {
                            NodeSearcher.this.searchResultListModel.add(object);
                        }
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                            NodeSearcher.this.getController().getNodeManager().removeNodeManagerListener(NodeSearcher.this.nodeListener);
                            NodeSearcher.this.getController().getNodeManager().removeNodeFilter(NodeSearcher.this.nodeSearchFilter);
                            Thread thread = NodeSearcher.this.searchThread;
                            // MONITORENTER : thread
                            NodeSearcher.this.searchThread.notifyAll();
                            // MONITOREXIT : thread
                            return;
                        }
                    }
                    this.fetchAccountInfos(NodeSearcher.this.searchResultListModel);
                    object = NodeSearcher.this.searchThread;
                    // MONITORENTER : object
                    try {
                        NodeSearcher.this.searchThread.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        NodeSearcher.this.logFine("Search was interrupted", interruptedException);
                        // MONITOREXIT : object
                        break;
                    }
                }
                NodeSearcher.this.getController().getNodeManager().removeNodeManagerListener(NodeSearcher.this.nodeListener);
                NodeSearcher.this.getController().getNodeManager().removeNodeFilter(NodeSearcher.this.nodeSearchFilter);
            }
            catch (Throwable throwable) {
                NodeSearcher.this.getController().getNodeManager().removeNodeManagerListener(NodeSearcher.this.nodeListener);
                NodeSearcher.this.getController().getNodeManager().removeNodeFilter(NodeSearcher.this.nodeSearchFilter);
                Thread thread = NodeSearcher.this.searchThread;
                // MONITORENTER : thread
                NodeSearcher.this.searchThread.notifyAll();
                // MONITOREXIT : thread
                throw throwable;
            }
            object = NodeSearcher.this.searchThread;
            // MONITORENTER : object
            NodeSearcher.this.searchThread.notifyAll();
            // MONITOREXIT : object
        }

        private void searchServer() {
            if (!NodeSearcher.this.getController().getOSClient().isConnected()) {
                return;
            }
            if (!NodeSearcher.this.getController().getOSClient().isLoggedIn()) {
                return;
            }
            try {
                Collection<MemberInfo> collection = NodeSearcher.this.getController().getOSClient().getSecurityService().searchNodes(NodeSearcher.this.pattern);
                for (MemberInfo memberInfo : collection) {
                    Member member = memberInfo.getNode(NodeSearcher.this.getController(), true);
                    if (!NodeSearcher.this.checkMember(member)) continue;
                    NodeSearcher.this.searchResultListModel.add(member);
                }
                this.fetchAccountInfos(NodeSearcher.this.searchResultListModel);
            }
            catch (Exception exception) {
                NodeSearcher.this.logWarning("Unable to search via server. " + exception);
                NodeSearcher.this.logFiner(exception);
            }
        }

        private void fetchAccountInfos(Collection<Member> collection) {
            SecurityManager securityManager = NodeSearcher.this.getController().getSecurityManager();
            if (securityManager instanceof SecurityManagerClient) {
                SecurityManagerClient securityManagerClient = (SecurityManagerClient)securityManager;
                securityManagerClient.fetchAccountInfos(collection, false);
            }
        }
    }
}

