/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.net;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.message.Ping;
import de.dal33t.powerfolder.net.AbstractRelayedConnectionHandler;
import de.dal33t.powerfolder.net.AbstractSocketConnectionHandler;
import de.dal33t.powerfolder.net.AbstractUDTSocketConnectionHandler;
import de.dal33t.powerfolder.net.ConnectionHandler;
import de.dal33t.powerfolder.net.ConnectionHandlerFactory;
import de.dal33t.powerfolder.net.RelayedConnectionManager;
import de.dal33t.powerfolder.net.UDTSocketConnectionManager;
import de.dal33t.powerfolder.util.Debug;
import de.dal33t.powerfolder.util.NamedThreadFactory;
import de.dal33t.powerfolder.util.Range;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.WrapperExecutorService;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IOProvider
extends PFComponent {
    private static final Logger log = Logger.getLogger(IOProvider.class.getName());
    private static final long CONNECTION_KEEP_ALIVE_TIMOUT_MS = 120000L;
    private static final long TIME_WITHOUT_KEEPALIVE_LEGACY_UNTIL_PING = 40000L;
    private static final long TIME_WITHOUT_KEEPALIVE_WEBSOCKET_UNTIL_PING = 13333L;
    private ExecutorService ioThreadPool;
    private ConnectionHandlerFactory conHanFactory;
    private RelayedConnectionManager relayedConManager;
    private UDTSocketConnectionManager udtConManager;
    private List<ConnectionHandler> keepAliveList;
    private boolean started;

    public IOProvider(Controller controller) {
        super(controller);
        this.conHanFactory = new ConnectionHandlerFactory(controller);
        this.keepAliveList = new CopyOnWriteArrayList<ConnectionHandler>();
        this.relayedConManager = new RelayedConnectionManager(controller);
        this.udtConManager = new UDTSocketConnectionManager(controller, Range.getRangeByNumbers(1024L, 65535L));
    }

    public void start() {
        this.ioThreadPool = new WrapperExecutorService(Executors.newCachedThreadPool(new NamedThreadFactory("IOThread-")));
        this.started = true;
        this.getController().scheduleAndRepeat(new KeepAliveChecker(), 13333L);
        this.relayedConManager.start();
    }

    public void shutdown() {
        this.started = false;
        if (this.ioThreadPool != null) {
            this.logFine("Shutting down connection I/O threadpool");
            this.ioThreadPool.shutdownNow();
        }
    }

    public synchronized void setConnectionHandlerFactory(ConnectionHandlerFactory connectionHandlerFactory) {
        Reject.ifNull(connectionHandlerFactory, "The factory must not be null");
        this.logFiner("Setting new connection factory: " + connectionHandlerFactory);
        this.conHanFactory = connectionHandlerFactory;
    }

    public ConnectionHandlerFactory getConnectionHandlerFactory() {
        return this.conHanFactory;
    }

    public RelayedConnectionManager getRelayedConnectionManager() {
        return this.relayedConManager;
    }

    public UDTSocketConnectionManager getUDTSocketConnectionManager() {
        return this.udtConManager;
    }

    public void startIO(Runnable runnable) {
        Reject.ifNull(runnable, "IO Worker is null");
        if (this.ioThreadPool.isTerminated() || this.ioThreadPool.isShutdown()) {
            this.logFine("Rejected executing of ioWorker, already stopped: " + runnable);
            return;
        }
        if (this.isFiner()) {
            this.logFiner("Starting IO for " + runnable);
        }
        try {
            this.ioThreadPool.submit(runnable);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
            this.logSevere("Out of memory while starting " + runnable + ": " + outOfMemoryError.toString(), outOfMemoryError);
            this.logSevere("Shutting down java virtual machine. Exit code: 107");
            if (outOfMemoryError.getMessage() != null && outOfMemoryError.getMessage().toLowerCase().contains("thread")) {
                this.logWarning("Current threads: ");
                this.logWarning(Debug.dumpCurrentStacktraces(false));
            }
            this.getController().exit(107);
            throw outOfMemoryError;
        }
    }

    public void startKeepAliveCheck(ConnectionHandler connectionHandler) {
        Reject.ifNull(connectionHandler, "Connection handler is null");
        if (!connectionHandler.isConnected()) {
            return;
        }
        this.keepAliveList.add(connectionHandler);
    }

    public void removeKeepAliveCheck(ConnectionHandler connectionHandler) {
        Reject.ifNull(connectionHandler, "Connection handler is null");
        this.keepAliveList.remove(connectionHandler);
    }

    private class KeepAliveChecker
    implements Runnable {
        private KeepAliveChecker() {
        }

        @Override
        public void run() {
            Object object;
            if (!IOProvider.this.started) {
                return;
            }
            if (log.isLoggable(Level.FINE)) {
                IOProvider.this.logFine("Checking " + IOProvider.this.keepAliveList.size() + " con handlers for keepalive");
            }
            HashSet<ConnectionHandler> hashSet = new HashSet<ConnectionHandler>(IOProvider.this.keepAliveList);
            if (IOProvider.this.getController().getNodeManager() != null && (object = IOProvider.this.getController().getNodeManager().getNodesAsCollection()) != null) {
                Iterator object2 = object.iterator();
                while (object2.hasNext()) {
                    Member member = (Member)object2.next();
                    ConnectionHandler connectionHandler = member.getPeer();
                    if (connectionHandler == null || !connectionHandler.isConnected() || hashSet.contains(connectionHandler)) continue;
                    IOProvider.this.logFine("ConHan not in keepalive list of " + member);
                    hashSet.add(connectionHandler);
                }
            }
            for (ConnectionHandler connectionHandler : hashSet) {
                if (!connectionHandler.isConnected()) {
                    IOProvider.this.keepAliveList.remove(connectionHandler);
                }
                if (this.checkIfOk(connectionHandler)) continue;
                IOProvider.this.keepAliveList.remove(connectionHandler);
            }
        }

        private boolean checkIfOk(ConnectionHandler connectionHandler) {
            boolean bl;
            Date date = connectionHandler.getLastKeepaliveMessageTime();
            if (date == null) {
                bl = true;
            } else {
                long l = System.currentTimeMillis() - date.getTime();
                boolean bl2 = connectionHandler instanceof AbstractSocketConnectionHandler || connectionHandler instanceof AbstractUDTSocketConnectionHandler || connectionHandler instanceof AbstractRelayedConnectionHandler;
                long l2 = bl2 ? 40000L : 13333L;
                boolean bl3 = bl = l >= l2;
                if (IOProvider.this.isFiner()) {
                    IOProvider.this.logFiner("Keep-alive check. Received last keep alive message " + l + "ms ago, ping required? " + bl + ". Node: " + connectionHandler.getMember());
                }
                if (l > 120000L) {
                    IOProvider.this.logFine("Shutting down. Dead connection detected (" + l / 1000L + "s timeout) to " + connectionHandler.getMember());
                    connectionHandler.shutdownWithMember();
                    return false;
                }
            }
            if (bl) {
                connectionHandler.sendMessagesAsynchron(new Ping(-1));
            }
            return true;
        }
    }
}

