/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.net;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.d2d.D2DSocketConnectionHandler;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.net.AbstractRelayedConnectionHandler;
import de.dal33t.powerfolder.net.AbstractSocketConnectionHandler;
import de.dal33t.powerfolder.net.AbstractUDTSocketConnectionHandler;
import de.dal33t.powerfolder.net.ConnectionException;
import de.dal33t.powerfolder.net.ConnectionHandler;
import de.dal33t.powerfolder.net.ConnectionQuality;
import de.dal33t.powerfolder.net.PlainRelayedConnectionHandler;
import de.dal33t.powerfolder.net.PlainSocketConnectionHandler;
import de.dal33t.powerfolder.net.PlainUDTSocketConnectionHandler;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.net.NetworkUtil;
import de.dal33t.powerfolder.util.net.UDTSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;

public class ConnectionHandlerFactory
extends PFComponent {
    public ConnectionHandlerFactory(Controller controller) {
        super(controller);
    }

    public ConnectionHandler tryToConnect(MemberInfo memberInfo) throws ConnectionException {
        boolean bl;
        boolean bl2 = bl = memberInfo.getConnectAddress() == null || memberInfo.getConnectAddress().getAddress() == null || NetworkUtil.isNullIP(memberInfo.getConnectAddress().getAddress());
        if (!bl) {
            try {
                ConnectionHandler connectionHandler = this.tryToConnectTCP(memberInfo.getConnectAddress());
                return connectionHandler;
            }
            catch (ConnectionException connectionException) {
                this.logFiner(connectionException);
            }
        }
        try {
            if (this.useUDTConnections() && this.useRelayedTunneledConnection(memberInfo) && !bl) {
                ConnectionHandler connectionHandler = this.tryToConnectUDTRendezvous(memberInfo);
                return connectionHandler;
            }
        }
        catch (ConnectionException connectionException) {
            this.logFiner(connectionException);
        }
        try {
            if (this.useRelayedConnections() && this.useRelayedTunneledConnection(memberInfo)) {
                ConnectionHandler connectionHandler = this.tryToConnectRelayed(memberInfo);
                return connectionHandler;
            }
        }
        catch (ConnectionException connectionException) {
            this.logFiner(connectionException);
        }
        throw new ConnectionException("No further connection alternatives.");
    }

    public ConnectionHandler tryToConnect(InetSocketAddress inetSocketAddress) throws ConnectionException {
        return this.tryToConnect(inetSocketAddress, false);
    }

    public ConnectionHandler tryToConnect(InetSocketAddress inetSocketAddress, boolean bl) throws ConnectionException {
        if (NetworkUtil.isNullIP(inetSocketAddress.getAddress())) {
            throw new ConnectionException("Unable to connect to null IP: " + inetSocketAddress);
        }
        return this.tryToConnectTCP(inetSocketAddress, bl);
    }

    public ConnectionHandler createAndInitSocketConnectionHandler(Socket socket, boolean bl) throws ConnectionException {
        AbstractSocketConnectionHandler abstractSocketConnectionHandler = bl ? new D2DSocketConnectionHandler(this.getController(), socket) : new PlainSocketConnectionHandler(this.getController(), socket);
        try {
            abstractSocketConnectionHandler.init();
        }
        catch (ConnectionException connectionException) {
            abstractSocketConnectionHandler.shutdown();
            throw connectionException;
        }
        return abstractSocketConnectionHandler;
    }

    public AbstractRelayedConnectionHandler createRelayedConnectionHandler(MemberInfo memberInfo, long l, Member member) {
        return new PlainRelayedConnectionHandler(this.getController(), memberInfo, l, member);
    }

    public AbstractUDTSocketConnectionHandler createAndInitUDTSocketConnectionHandler(UDTSocket uDTSocket) throws ConnectionException {
        PlainUDTSocketConnectionHandler plainUDTSocketConnectionHandler = new PlainUDTSocketConnectionHandler(this.getController(), uDTSocket);
        try {
            plainUDTSocketConnectionHandler.init();
        }
        catch (ConnectionException connectionException) {
            plainUDTSocketConnectionHandler.shutdown();
            throw connectionException;
        }
        return plainUDTSocketConnectionHandler;
    }

    protected ConnectionHandler tryToConnectTCP(InetSocketAddress inetSocketAddress) throws ConnectionException {
        return this.tryToConnectTCP(inetSocketAddress, false);
    }

    protected ConnectionHandler tryToConnectTCP(InetSocketAddress inetSocketAddress, boolean bl) throws ConnectionException {
        try {
            Socket socket = new Socket();
            String string = ConfigurationEntry.NET_BIND_ADDRESS.getValueArray(this.getController())[0];
            if (!StringUtils.isEmpty(string)) {
                socket.bind(new InetSocketAddress(string, 0));
            }
            socket.connect(inetSocketAddress, 30000);
            NetworkUtil.setupSocket(socket, this.getController());
            return this.createAndInitSocketConnectionHandler(socket, bl);
        }
        catch (IOException iOException) {
            throw new ConnectionException("Unable to connect to " + inetSocketAddress + ": " + iOException.getMessage(), iOException);
        }
    }

    protected ConnectionHandler tryToConnectRelayed(MemberInfo memberInfo) throws ConnectionException {
        if (this.isFiner()) {
            this.logFiner("Trying relayed connection to " + memberInfo.nick);
        }
        return this.getController().getIOProvider().getRelayedConnectionManager().initRelayedConnectionHandler(memberInfo);
    }

    protected ConnectionHandler tryToConnectUDTRendezvous(MemberInfo memberInfo) throws ConnectionException {
        if (this.isFiner()) {
            this.logFiner("Trying UDT socket connection to " + memberInfo.nick);
        }
        return this.getController().getIOProvider().getUDTSocketConnectionManager().initRendezvousUDTConnectionHandler(memberInfo);
    }

    protected boolean useRelayedConnections() {
        return !this.getController().isLanOnly() && ConfigurationEntry.RELAYED_CONNECTIONS_ENABLED.getValueBoolean(this.getController()) != false && !this.getController().getIOProvider().getRelayedConnectionManager().isRelay(this.getController().getMySelf().getInfo());
    }

    protected boolean useUDTConnections() {
        return UDTSocket.isSupported() && !this.getController().isLanOnly() && ConfigurationEntry.UDT_CONNECTIONS_ENABLED.getValueBoolean(this.getController()) != false && !this.getController().getIOProvider().getRelayedConnectionManager().isRelay(this.getController().getMySelf().getInfo());
    }

    protected boolean isOnLAN(MemberInfo memberInfo) {
        InetAddress inetAddress;
        InetAddress inetAddress2 = inetAddress = memberInfo.getConnectAddress() != null && memberInfo.getConnectAddress().getAddress() != null ? memberInfo.getConnectAddress().getAddress() : null;
        if (inetAddress == null) {
            return false;
        }
        return this.getController().getNodeManager().isOnLANorConfiguredOnLAN(inetAddress);
    }

    protected boolean useRelayedTunneledConnection(MemberInfo memberInfo) {
        boolean bl = this.isOnLAN(memberInfo);
        if (!bl) {
            return true;
        }
        return ConfigurationEntry.NET_USE_RELAY_TUNNEL_ON_LAN.getValueBoolean(this.getController());
    }

    protected boolean useRelayedTunneledConnection(InetAddress inetAddress) {
        boolean bl = this.getController().getNodeManager().isOnLANorConfiguredOnLAN(inetAddress);
        if (!bl) {
            return true;
        }
        return ConfigurationEntry.NET_USE_RELAY_TUNNEL_ON_LAN.getValueBoolean(this.getController());
    }

    public ConnectionQuality getConnectionQuality() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (Member member : this.getController().getNodeManager().getConnectedNodes()) {
            ConnectionHandler connectionHandler = member.getPeer();
            ConnectionQuality connectionQuality = connectionHandler != null ? connectionHandler.getConnectionQuality() : null;
            if (connectionQuality == null) continue;
            if (connectionQuality.equals((Object)ConnectionQuality.GOOD)) {
                ++n;
                continue;
            }
            if (connectionQuality.equals((Object)ConnectionQuality.MEDIUM)) {
                ++n2;
                continue;
            }
            if (!connectionQuality.equals((Object)ConnectionQuality.POOR)) continue;
            ++n3;
        }
        if (this.isFiner()) {
            this.logFiner("Connections ==> good: " + n + ", medium: " + n2 + ", poor: " + n3);
        }
        if (n == 0 && n2 == 0 && n3 <= 1) {
            return null;
        }
        if (n > n3 && n > n2) {
            return ConnectionQuality.GOOD;
        }
        if (n2 > n3) {
            return ConnectionQuality.MEDIUM;
        }
        return ConnectionQuality.POOR;
    }
}

