/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message.clientserver;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.protocol.ShareLinkInfoProto;
import java.util.Date;

public class ShareLinkInfo
extends Message
implements D2DObject {
    private int downloads;
    private Date expirationDate;
    private String fileRelativePath;
    private String folderId;
    private String id;
    private int maxDownloads;
    private String password;
    private boolean uploadEnabled;
    private String url;

    public ShareLinkInfo() {
    }

    public ShareLinkInfo(AbstractMessage abstractMessage) {
        this.initFromD2D(abstractMessage);
    }

    public int getDownloads() {
        return this.downloads;
    }

    public void setDownloads(int n) {
        this.downloads = n;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date date) {
        this.expirationDate = date;
    }

    public String getFileRelativePath() {
        return this.fileRelativePath;
    }

    public void setFileRelativePath(String string) {
        this.fileRelativePath = string;
    }

    public String getFolderId() {
        return this.folderId;
    }

    public void setFolderId(String string) {
        this.folderId = string;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public int getMaxDownloads() {
        return this.maxDownloads;
    }

    public void setMaxDownloads(int n) {
        this.maxDownloads = n;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public boolean isUploadEnabled() {
        return this.uploadEnabled;
    }

    public void setUploadEnabled(boolean bl) {
        this.uploadEnabled = bl;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof ShareLinkInfoProto.ShareLinkInfo) {
            ShareLinkInfoProto.ShareLinkInfo shareLinkInfo = (ShareLinkInfoProto.ShareLinkInfo)abstractMessage;
            this.downloads = shareLinkInfo.getDownloads();
            if (shareLinkInfo.getExpirationDate() >= 0L) {
                this.expirationDate = new Date(shareLinkInfo.getExpirationDate());
            }
            this.fileRelativePath = shareLinkInfo.getFileRelativePath();
            this.folderId = shareLinkInfo.getFolderId();
            this.id = shareLinkInfo.getId();
            this.maxDownloads = shareLinkInfo.getMaxDownloads();
            this.password = shareLinkInfo.getPassword();
            this.uploadEnabled = shareLinkInfo.getUploadEnabled();
            this.url = shareLinkInfo.getUrl();
        }
    }

    @Override
    public AbstractMessage toD2D() {
        ShareLinkInfoProto.ShareLinkInfo.Builder builder = ShareLinkInfoProto.ShareLinkInfo.newBuilder();
        builder.setClazzName(this.getClass().getSimpleName());
        builder.setDownloads(this.downloads);
        if (this.expirationDate != null) {
            builder.setExpirationDate(this.expirationDate.getTime());
        } else {
            builder.setExpirationDate(-1L);
        }
        if (this.fileRelativePath != null) {
            builder.setFileRelativePath(this.fileRelativePath);
        }
        if (this.folderId != null) {
            builder.setFolderId(this.folderId);
        }
        if (this.id != null) {
            builder.setId(this.id);
        }
        builder.setMaxDownloads(this.maxDownloads);
        if (this.password != null) {
            builder.setPassword(this.password);
        }
        builder.setUploadEnabled(this.uploadEnabled);
        if (this.url != null) {
            builder.setUrl(this.url);
        }
        return builder.build();
    }
}

