/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message.clientserver;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import de.dal33t.powerfolder.StatusCode;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.d2d.D2DReplyFromServer;
import de.dal33t.powerfolder.d2d.D2DReplyMessage;
import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.protocol.PermissionInfoProto;
import de.dal33t.powerfolder.protocol.PermissionListReplyProto;
import de.dal33t.powerfolder.protocol.PermissionTypeProto;
import de.dal33t.powerfolder.security.Account;
import de.dal33t.powerfolder.security.FolderPermission;
import java.io.Serializable;
import java.util.Map;

public class PermissionListReply
extends D2DReplyMessage
implements D2DReplyFromServer {
    private Map<Serializable, FolderPermission> permissions;
    private Map<AccountInfo, FolderPermission> invitations;

    public PermissionListReply() {
    }

    public PermissionListReply(String string, StatusCode statusCode) {
        this.replyCode = string;
        this.replyStatusCode = statusCode;
    }

    public PermissionListReply(String string, StatusCode statusCode, Account account) {
        this.replyCode = string;
        this.replyStatusCode = statusCode;
    }

    public PermissionListReply(String string, StatusCode statusCode, Map<Serializable, FolderPermission> map, Map<AccountInfo, FolderPermission> map2) {
        this.replyCode = string;
        this.replyStatusCode = statusCode;
        this.permissions = map;
        this.invitations = map2;
    }

    public PermissionListReply(AbstractMessage abstractMessage) {
        this.initFromD2D(abstractMessage);
    }

    public Map<Serializable, FolderPermission> getPermissions() {
        return this.permissions;
    }

    public Map<AccountInfo, FolderPermission> getInvitations() {
        return this.invitations;
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof PermissionListReplyProto.PermissionListReply) {
            PermissionListReplyProto.PermissionListReply permissionListReply = (PermissionListReplyProto.PermissionListReply)abstractMessage;
            this.replyCode = permissionListReply.getReplyCode();
            this.replyStatusCode = StatusCode.getEnum(permissionListReply.getReplyStatusCode());
        }
    }

    @Override
    public AbstractMessage toD2D() {
        PermissionInfoProto.PermissionInfo.Builder builder;
        PermissionInfoProto.PermissionInfo.Builder builder2;
        PermissionInfoProto.PermissionInfo.Builder builder3;
        PermissionInfoProto.PermissionInfo.Builder builder4;
        PermissionListReplyProto.PermissionListReply.Builder builder5 = PermissionListReplyProto.PermissionListReply.newBuilder();
        builder5.setClazzName(this.getClass().getSimpleName());
        if (this.replyCode != null) {
            builder5.setReplyCode(this.replyCode);
        }
        builder5.setReplyStatusCode(this.replyStatusCode.getCode());
        if (this.permissions != null) {
            builder4 = PermissionInfoProto.PermissionInfo.newBuilder();
            builder3 = PermissionInfoProto.PermissionInfo.newBuilder();
            builder2 = PermissionInfoProto.PermissionInfo.newBuilder();
            builder = PermissionInfoProto.PermissionInfo.newBuilder();
            builder4.setClazzName("PermissionInfo");
            builder3.setClazzName("PermissionInfo");
            builder2.setClazzName("PermissionInfo");
            builder.setClazzName("PermissionInfo");
            builder4.setPermissionType(PermissionTypeProto.PermissionType.FOLDER_ADMIN);
            builder3.setPermissionType(PermissionTypeProto.PermissionType.FOLDER_OWNER);
            builder2.setPermissionType(PermissionTypeProto.PermissionType.FOLDER_READ_WRITE);
            builder.setPermissionType(PermissionTypeProto.PermissionType.FOLDER_READ);
            for (Map.Entry<Serializable, FolderPermission> entry : this.permissions.entrySet()) {
                switch (entry.getValue().getClass().getSimpleName()) {
                    case "FolderAdminPermission": {
                        builder4.addSubjects(Any.pack(((D2DObject)((Object)entry.getKey())).toD2D()));
                        break;
                    }
                    case "FolderOwnerPermission": {
                        builder3.addSubjects(Any.pack(((D2DObject)((Object)entry.getKey())).toD2D()));
                        break;
                    }
                    case "FolderReadWritePermission": {
                        builder2.addSubjects(Any.pack(((D2DObject)((Object)entry.getKey())).toD2D()));
                        break;
                    }
                    case "FolderReadPermission": {
                        builder.addSubjects(Any.pack(((D2DObject)((Object)entry.getKey())).toD2D()));
                    }
                }
            }
            if (builder4.getSubjectsCount() > 0) {
                builder5.addPermissionInfos(builder4);
            }
            if (builder3.getSubjectsCount() > 0) {
                builder5.addPermissionInfos(builder3);
            }
            if (builder2.getSubjectsCount() > 0) {
                builder5.addPermissionInfos(builder2);
            }
            if (builder.getSubjectsCount() > 0) {
                builder5.addPermissionInfos(builder);
            }
        }
        if (this.invitations != null) {
            builder4 = PermissionInfoProto.PermissionInfo.newBuilder();
            builder3 = PermissionInfoProto.PermissionInfo.newBuilder();
            builder2 = PermissionInfoProto.PermissionInfo.newBuilder();
            builder = PermissionInfoProto.PermissionInfo.newBuilder();
            builder4.setClazzName("PermissionInfo");
            builder3.setClazzName("PermissionInfo");
            builder2.setClazzName("PermissionInfo");
            builder.setClazzName("PermissionInfo");
            builder4.setIsInvitation(true);
            builder3.setIsInvitation(true);
            builder2.setIsInvitation(true);
            builder.setIsInvitation(true);
            builder4.setPermissionType(PermissionTypeProto.PermissionType.FOLDER_ADMIN);
            builder3.setPermissionType(PermissionTypeProto.PermissionType.FOLDER_OWNER);
            builder2.setPermissionType(PermissionTypeProto.PermissionType.FOLDER_READ_WRITE);
            builder.setPermissionType(PermissionTypeProto.PermissionType.FOLDER_READ);
            for (Map.Entry<Serializable, FolderPermission> entry : this.invitations.entrySet()) {
                switch (entry.getValue().getClass().getSimpleName()) {
                    case "FolderAdminPermission": {
                        builder4.addSubjects(Any.pack(((AccountInfo)entry.getKey()).toD2D()));
                        break;
                    }
                    case "FolderOwnerPermission": {
                        builder3.addSubjects(Any.pack(((AccountInfo)entry.getKey()).toD2D()));
                        break;
                    }
                    case "FolderReadWritePermission": {
                        builder2.addSubjects(Any.pack(((AccountInfo)entry.getKey()).toD2D()));
                        break;
                    }
                    case "FolderReadPermission": {
                        builder.addSubjects(Any.pack(((AccountInfo)entry.getKey()).toD2D()));
                    }
                }
            }
            if (builder4.getSubjectsCount() > 0) {
                builder5.addPermissionInfos(builder4);
            }
            if (builder3.getSubjectsCount() > 0) {
                builder5.addPermissionInfos(builder3);
            }
            if (builder2.getSubjectsCount() > 0) {
                builder5.addPermissionInfos(builder2);
            }
            if (builder.getSubjectsCount() > 0) {
                builder5.addPermissionInfos(builder);
            }
        }
        return builder5.build();
    }
}

