/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.d2d.D2DEvent;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.d2d.D2DSocketConnectionHandler;
import de.dal33t.powerfolder.d2d.NodeEvent;
import de.dal33t.powerfolder.d2d.NodeState;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.FolderInfoFactory;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.net.ConnectionHandler;
import de.dal33t.powerfolder.protocol.FolderInfoProto;
import de.dal33t.powerfolder.protocol.FolderListProto;
import de.dal33t.powerfolder.util.ByteSerializer;
import de.dal33t.powerfolder.util.Convert;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StreamUtils;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Util;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Logger;

public class FolderList
extends Message
implements D2DObject,
D2DEvent {
    private static final long serialVersionUID = 101L;
    private static Logger LOG = Logger.getLogger(FolderList.class.getName());
    public FolderInfo[] folders = new FolderInfo[0];
    @Deprecated
    public FolderInfo[] secretFolders;
    public boolean joinedMetaFolders;

    public FolderList() {
    }

    public FolderList(Collection<FolderInfo> collection) {
        this.folders = collection.toArray(new FolderInfo[0]);
        this.secretFolders = new FolderInfo[0];
        this.joinedMetaFolders = true;
    }

    @Deprecated
    public FolderList(Collection<FolderInfo> collection, String string) {
        Reject.ifBlank(string, "Remote magic id is blank");
        ArrayList<FolderInfo> arrayList = new ArrayList<FolderInfo>(collection.size());
        for (FolderInfo folderInfo : collection) {
            String string2 = folderInfo.calculateSecureId(string);
            FolderInfo folderInfo2 = FolderInfoFactory.lookupInstance(string2, folderInfo.getName());
            arrayList.add(folderInfo2);
        }
        this.secretFolders = new FolderInfo[arrayList.size()];
        this.joinedMetaFolders = true;
        arrayList.toArray(this.secretFolders);
    }

    public boolean contains(FolderInfo folderInfo, Member member) {
        ConnectionHandler connectionHandler = member.getPeer();
        if (connectionHandler == null) {
            return false;
        }
        if (connectionHandler.getMember().getProtocolVersion() < 112) {
            String string = connectionHandler.getMyMagicId();
            if (StringUtils.isBlank(string)) {
                return false;
            }
            return this.contains(folderInfo, string);
        }
        return this.contains(folderInfo);
    }

    public boolean contains(FolderInfo folderInfo) {
        return this.folders != null && Arrays.asList(this.folders).contains(folderInfo);
    }

    @Deprecated
    public boolean contains(FolderInfo folderInfo, String string) {
        String string2 = folderInfo.calculateSecureId(string);
        for (FolderInfo folderInfo2 : this.secretFolders) {
            if (!folderInfo2.id.equals(string2)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public synchronized boolean store(Member member) {
        return this.store(FolderList.getMemberFile(member));
    }

    @Deprecated
    public synchronized boolean store(Path path) {
        Reject.ifNull(path, "File");
        try {
            if (path.getParent() != null) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            byte[] byArray = ByteSerializer.serializeStatic(this, false);
            PathUtils.copyFromStreamToFile(new ByteArrayInputStream(byArray), path);
            return true;
        }
        catch (Exception exception) {
            LOG.warning("Unable to store to " + path + ". " + exception + ". " + this);
            return false;
        }
    }

    @Deprecated
    public static FolderList load(Member member) {
        return FolderList.load(FolderList.getMemberFile(member));
    }

    @Deprecated
    public static FolderList load(Path path) {
        FolderList folderList;
        Reject.ifNull(path, "File");
        if (Files.notExists(path, new LinkOption[0])) {
            return null;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
        try {
            byte[] byArray = StreamUtils.readIntoByteArray(bufferedInputStream);
            folderList = (FolderList)ByteSerializer.deserializeStatic(byArray, false);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)bufferedInputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                LOG.warning("Unable to load to " + path + ". " + exception);
                return null;
            }
        }
        ((InputStream)bufferedInputStream).close();
        return folderList;
    }

    public static void removeMemberFiles(Controller controller) {
        try {
            PathUtils.recursiveDelete(Controller.getMiscFilesLocation().resolve(controller.getConfigName() + ".temp/nodes"));
        }
        catch (IOException iOException) {
            LOG.severe("Unable to deleted FolderList temporary files. " + iOException);
        }
    }

    private static Path getMemberFile(Member member) {
        String string = new String(Util.encodeHex(Util.md5(member.getId().getBytes(Convert.UTF8))));
        return Controller.getMiscFilesLocation().resolve(member.getController().getConfigName() + ".temp/nodes/" + string + ".FolderList");
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.joinedMetaFolders ? 1231 : 1237);
        n = 31 * n + Arrays.hashCode(this.folders);
        n = 31 * n + Arrays.hashCode(this.secretFolders);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FolderList folderList = (FolderList)object;
        if (this.joinedMetaFolders != folderList.joinedMetaFolders) {
            return false;
        }
        if (!Arrays.equals(this.folders, folderList.folders)) {
            return false;
        }
        return Arrays.equals(this.secretFolders, folderList.secretFolders);
    }

    public String toString() {
        return "FolderList: " + ((this.folders != null ? this.folders.length : 0) + (this.secretFolders != null ? this.secretFolders.length : 0)) + " folders";
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof FolderListProto.FolderList) {
            FolderListProto.FolderList folderList = (FolderListProto.FolderList)abstractMessage;
            int n = 0;
            this.folders = new FolderInfo[folderList.getFolderInfosCount()];
            for (FolderInfoProto.FolderInfo folderInfo : folderList.getFolderInfosList()) {
                this.folders[n++] = new FolderInfo(folderInfo);
            }
        }
    }

    @Override
    public AbstractMessage toD2D() {
        FolderListProto.FolderList.Builder builder = FolderListProto.FolderList.newBuilder();
        builder.setClazzName("FolderList");
        for (FolderInfo folderInfo : this.folders) {
            builder.addFolderInfos((FolderInfoProto.FolderInfo)folderInfo.toD2D());
        }
        return builder.build();
    }

    @Override
    public void handle(Member member) {
        member.processFolderListD2D(this);
        D2DSocketConnectionHandler d2DSocketConnectionHandler = (D2DSocketConnectionHandler)member.getPeer();
        if (d2DSocketConnectionHandler == null) {
            return;
        }
        if (d2DSocketConnectionHandler.getNodeStateMachine().getCurrentState() == NodeState.OPEN_FOLDER_LIST_WAIT || d2DSocketConnectionHandler.getNodeStateMachine().getCurrentState() == NodeState.OPEN_LOGIN_REQUEST_WAIT) {
            member.handshakeFolderList();
        }
    }

    @Override
    public NodeEvent getNodeEvent() {
        return NodeEvent.FOLDER_LIST;
    }
}

