/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message;

import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FileInfoFactory;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.message.FileList;
import de.dal33t.powerfolder.util.ExternalizableUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class FileListExt
extends FileList
implements Externalizable {
    private static final long serialVersionUID = -299244748325976914L;
    private static final long extVersionUID = 100L;

    public FileListExt() {
    }

    FileListExt(FolderInfo folderInfo, FileInfo[] fileInfoArray, int n) {
        super(folderInfo, fileInfoArray, n);
    }

    FileListExt(FolderInfo folderInfo) {
        super(folderInfo);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        long l = objectInput.readLong();
        if (l != 100L) {
            throw new InvalidClassException(this.getClass().getName(), "Unable to read. extVersionUID(steam): " + l + ", expected: 100");
        }
        this.folder = ExternalizableUtil.readFolderInfo(objectInput);
        this.nFollowingDeltas = objectInput.readInt();
        if (objectInput.readBoolean()) {
            this.files = new FileInfo[objectInput.readInt()];
            for (int i = 0; i < this.files.length; ++i) {
                this.files[i] = FileInfoFactory.readExt(objectInput);
            }
        } else {
            this.files = null;
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(100L);
        ExternalizableUtil.writeFolderInfo(objectOutput, this.folder, false);
        objectOutput.writeInt(this.nFollowingDeltas);
        objectOutput.writeBoolean(this.files != null);
        if (this.files != null) {
            objectOutput.writeInt(this.files.length);
            for (FileInfo fileInfo : this.files) {
                fileInfo.writeExternal(objectOutput);
            }
        }
    }
}

