/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.light;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.light.DirectoryInfo;
import de.dal33t.powerfolder.light.FileInfoFactory;
import de.dal33t.powerfolder.light.FolderInfoFactory;
import de.dal33t.powerfolder.protocol.FolderInfoProto;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.intern.FolderInfoInternalizer;
import de.dal33t.powerfolder.util.intern.Internalizer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Index;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class FolderInfo
implements Serializable,
Cloneable,
D2DObject {
    private static final Logger LOG = Logger.getLogger(FolderInfo.class.getName());
    private static final long serialVersionUID = 102L;
    private static final Internalizer<FolderInfo> INTERNALIZER = new FolderInfoInternalizer();
    public static final String PROPERTYNAME_ID = "id";
    public static final String PROPERTYNAME_NAME = "name";
    public static final String PROPERTYNAME_VERSION = "version";
    public static final String PROPERTYNAME_PARENT_FOLDER = "parentFolder";
    public static final String PROPERTYNAME_PARENT_PATH = "parentPath";
    @Index(name="IDX_FOLDER_NAME")
    private String name;
    @Id
    public String id;
    private int version;
    @ManyToOne
    @JoinColumn(name="parentFolderInfo_id")
    private FolderInfo parentFolder;
    @Column(length=1024)
    private String parentPath;
    private transient int hash;
    private static final long extVersionUID = 101L;

    private FolderInfo() {
    }

    FolderInfo(String string, String string2, int n, DirectoryInfo directoryInfo) {
        this.name = string;
        this.id = string2;
        this.version = n;
        this.setParent(directoryInfo);
        this.hash = this.hashCode0();
    }

    public FolderInfo(AbstractMessage abstractMessage) {
        this.initFromD2D(abstractMessage);
    }

    public boolean isMetaFolder() {
        return this.id != null && this.id.startsWith("meta|");
    }

    public boolean isLookupInstance() {
        return this.version < 0;
    }

    public FolderInfo lookupContentFolderInfo() {
        if (!this.isMetaFolder()) {
            return this;
        }
        try {
            int n = this.id.indexOf("meta|");
            String string = this.id.substring(n + "meta|".length());
            n = this.name.indexOf("meta|");
            String string2 = this.name.substring(n + "meta|".length());
            return FolderInfoFactory.lookupInstance(string, this.name);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "Unable to get parent folder info for meta-folder: " + this, exception);
            return this;
        }
    }

    public FolderInfo getMetaFolderInfo() {
        if (this.isMetaFolder()) {
            return this;
        }
        return FolderInfoFactory.unmarshallExistingTopFolder("meta|" + this.id, "meta|" + this.name, this.version);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        if (this.isLookupInstance()) {
            return 0;
        }
        return this.version;
    }

    private void setParent(DirectoryInfo directoryInfo) {
        if (directoryInfo != null) {
            Reject.ifNull(directoryInfo.getRelativeName(), "Parent relative name / path must not be null");
            this.parentFolder = directoryInfo.getFolderInfo();
            this.parentPath = directoryInfo.getRelativeName();
        } else {
            this.parentFolder = null;
            this.parentPath = null;
        }
    }

    public DirectoryInfo getParent() {
        if (this.parentFolder == null) {
            return null;
        }
        return FileInfoFactory.lookupDirectory(this.parentFolder, this.parentPath);
    }

    public DirectoryInfo getLocation() {
        if (this.parentFolder == null) {
            return null;
        }
        Object object = this.parentPath;
        if (StringUtils.isNotBlank((String)object)) {
            object = (String)object + "/";
        }
        object = (String)object + this.name;
        return FileInfoFactory.lookupDirectory(this.parentFolder, (String)object);
    }

    public boolean isSubFolder() {
        return this.parentFolder != null;
    }

    public Folder getFolder(Controller controller) {
        return controller.getFolderRepository().getFolder(this);
    }

    @Deprecated
    public String calculateSecureId(String string) {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            byte[] byArray2 = this.id.getBytes("UTF-8");
            byte[] byArray3 = new byte[byArray.length * 2 + byArray2.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length - 1, byArray2.length);
            System.arraycopy(byArray, 0, byArray3, byArray.length + byArray2.length - 2, byArray.length);
            return new String(Util.encodeHex(Util.md5(byArray3)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Fatal problem: UTF-8 encoding not found", unsupportedEncodingException);
        }
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.hashCode0();
        }
        return this.hash;
    }

    private int hashCode0() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof FolderInfo) {
            FolderInfo folderInfo = (FolderInfo)object;
            return Util.equals(this.id, folderInfo.id);
        }
        return false;
    }

    public FolderInfo intern() {
        return this.intern(false);
    }

    public FolderInfo intern(boolean bl) {
        if (bl) {
            LOG.info(this + ": rename (forced internalize)");
            return INTERNALIZER.rename(this);
        }
        return INTERNALIZER.intern(this);
    }

    public int compareTo(Object object) {
        FolderInfo folderInfo = (FolderInfo)object;
        return this.name.compareToIgnoreCase(folderInfo.name);
    }

    public String toString() {
        if (this.isLookupInstance()) {
            return "Folder " + this.name + "/" + this.id + "/L";
        }
        Object object = "";
        if (this.parentFolder != null) {
            object = (String)object + "(" + this.parentFolder.name;
            if (StringUtils.isNotBlank(this.parentPath)) {
                object = (String)object + "/" + this.parentPath;
            }
            object = (String)object + ")/";
        }
        return "Folder " + (String)object + this.name + "/" + this.id + "/" + this.version;
    }

    public static FolderInfo readExt(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        FolderInfo folderInfo = new FolderInfo();
        folderInfo.readExternal(objectInput);
        return folderInfo;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        long l = objectInput.readLong();
        if (l != 100L && l != 101L) {
            throw new InvalidClassException(this.getClass().getName(), "Unable to read. extVersionUID(steam): " + l + ", expected: 101");
        }
        this.id = objectInput.readUTF();
        this.name = objectInput.readUTF();
        if (l == 100L) {
            return;
        }
        this.version = objectInput.readInt();
        if (objectInput.readBoolean()) {
            DirectoryInfo directoryInfo = (DirectoryInfo)FileInfoFactory.readExt(objectInput);
            this.setParent(directoryInfo);
        } else {
            this.setParent(null);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.writeExternal(objectOutput, true);
    }

    public void writeExternal(ObjectOutput objectOutput, boolean bl) throws IOException {
        boolean bl2;
        boolean bl3 = bl2 = this.version > 0 || this.parentFolder != null;
        if (bl) {
            bl = bl2;
        } else if (!bl2 || !this.isMetaFolder()) {
            // empty if block
        }
        if (bl) {
            objectOutput.writeLong(101L);
        } else {
            objectOutput.writeLong(100L);
        }
        objectOutput.writeUTF(this.id);
        objectOutput.writeUTF(this.name);
        if (!bl) {
            return;
        }
        objectOutput.writeInt(this.version);
        if (this.parentPath != null) {
            objectOutput.writeBoolean(true);
            this.getParent().writeExternal(objectOutput);
        } else {
            objectOutput.writeBoolean(false);
        }
    }

    public String getLocalizedName() {
        if (this.name == null) {
            return null;
        }
        if (this.name.contains("$public_shared_files") || this.name.contains("$personal_files") || this.name.contains("$mail_attachments")) {
            return this.name.replace("$public_shared_files", Translation.get("general.public_shared_files")).replace("$personal_files", Translation.get("general.personal_files")).replace("$mail_attachments", Translation.get("mail_attachment_folder_name"));
        }
        return this.name;
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof FolderInfoProto.FolderInfo) {
            FolderInfoProto.FolderInfo folderInfo = (FolderInfoProto.FolderInfo)abstractMessage;
            this.name = folderInfo.getName();
            this.id = folderInfo.getId();
            this.hash = this.hashCode0();
        }
    }

    @Override
    public AbstractMessage toD2D() {
        FolderInfoProto.FolderInfo.Builder builder = FolderInfoProto.FolderInfo.newBuilder();
        builder.setClazzName(this.getClass().getSimpleName());
        builder.setName(this.name);
        builder.setId(this.id);
        return builder.build();
    }

    boolean save(Path path) {
        if (Files.notExists(path.getParent(), new LinkOption[0])) {
            return false;
        }
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0])));){
            objectOutputStream.writeObject(this);
        }
        catch (Exception exception) {
            LOG.warning(this + ": Unable to store FolderInfo to " + path + ". " + exception);
        }
        return true;
    }

    static FolderInfo load(Path path) {
        FolderInfo folderInfo;
        block9: {
            if (Files.notExists(path, new LinkOption[0])) {
                return null;
            }
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(inputStream));
                folderInfo = (FolderInfo)objectInputStream.readObject();
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    LOG.warning("Unable to read FolderInfo from " + path + ". " + exception);
                    return null;
                }
            }
            inputStream.close();
        }
        return folderInfo;
    }
}

