/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.light;

import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.util.Reject;

public class FileInfoKey {
    private FileInfo fileInfo;
    private Type type;

    public FileInfoKey(FileInfo fileInfo, Type type) {
        Reject.ifNull(fileInfo, "FileInfo is null");
        Reject.ifNull((Object)type, "Type is null");
        this.fileInfo = fileInfo;
        this.type = type;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FileInfoKey)) {
            return false;
        }
        FileInfoKey fileInfoKey = (FileInfoKey)object;
        if (fileInfoKey.type != this.type) {
            return false;
        }
        FileInfo fileInfo = fileInfoKey.fileInfo;
        switch (this.type) {
            case VERSION: {
                return this.fileInfo.getVersion() == fileInfo.getVersion() && this.fileInfo.equals(fileInfoKey);
            }
            case VERSION_DATE_SIZE: {
                return this.fileInfo.isVersionDateAndSizeIdentical(fileInfo);
            }
        }
        return this.fileInfo.equals(fileInfo);
    }

    public int hashCode() {
        switch (this.type) {
            case VERSION: {
                return this.fileInfo.hashCode() + this.fileInfo.getVersion();
            }
            case VERSION_DATE_SIZE: {
                return this.fileInfo.hashCode() + this.fileInfo.getVersion() + this.fileInfo.getModifiedDate().hashCode() + Long.valueOf(this.fileInfo.getSize()).hashCode();
            }
        }
        return this.fileInfo.hashCode();
    }

    public static enum Type {
        DEFAULT,
        VERSION,
        VERSION_DATE_SIZE;

    }
}

