/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.light;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Feature;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.FolderRepository;
import de.dal33t.powerfolder.disk.Lock;
import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.light.DirectoryInfo;
import de.dal33t.powerfolder.light.DiskItem;
import de.dal33t.powerfolder.light.FileInfoFactory;
import de.dal33t.powerfolder.light.FileInfoStrings;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.FolderInfoFactory;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.protocol.FileInfoProto;
import de.dal33t.powerfolder.util.DateUtil;
import de.dal33t.powerfolder.util.ExternalizableUtil;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StackDump;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.os.OSUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileInfo
implements Serializable,
DiskItem,
Cloneable,
D2DObject {
    public static final String UNIX_SEPARATOR = "/";
    private static final Logger log = Logger.getLogger(FileInfo.class.getName());
    public static final boolean IGNORE_CASE = OSUtil.isWindowsSystem() || OSUtil.isMacOS();
    public static final AccountInfo UNKNOWN_FROM_ARCHIVE = new AccountInfo("unknown_from_archive", "unknown_from_archive", "Unknown");
    public static final String PROPERTYNAME_FILE_NAME = "fileName";
    public static final String PROPERTYNAME_SIZE = "size";
    public static final String PROPERTYNAME_MODIFIED_BY = "modifiedBy";
    public static final String PROPERTYNAME_LAST_MODIFIED_DATE = "lastModifiedDate";
    public static final String PROPERTYNAME_VERSION = "version";
    public static final String PROPERTYNAME_DELETED = "deleted";
    public static final String PROPERTYNAME_FOLDER_INFO = "folderInfo";
    private static final long serialVersionUID = 100L;
    private String fileName;
    private String oid;
    private String hashes;
    private String tags;
    private Long size;
    private MemberInfo modifiedBy;
    private AccountInfo modifiedByAccount;
    private Date lastModifiedDate;
    private int version;
    private boolean deleted;
    private FolderInfo folderInfo;
    private transient int hash;
    private transient Reference<FileInfoStrings> cachedStrings;
    private static final long extVersion100UID = 100L;
    private static final long extVersionCurrentUID = 101L;

    protected FileInfo() {
        this.fileName = null;
        this.oid = null;
        this.hashes = null;
        this.tags = null;
        this.size = null;
        this.modifiedBy = null;
        this.lastModifiedDate = null;
        this.version = 0;
        this.deleted = false;
        this.folderInfo = null;
    }

    protected FileInfo(String string, String string2, Long l, MemberInfo memberInfo, AccountInfo accountInfo, Date date, int n, String string3, boolean bl, String string4, FolderInfo folderInfo) {
        Reject.ifNull(folderInfo, "folder is null!");
        Reject.ifNull(string, "relativeName is null!");
        Reject.ifTrue(string.contains("../"), String.format("relativeName must not contain ../ Got:  %s", string));
        this.fileName = string;
        this.oid = string2;
        this.hashes = string3;
        this.tags = string4;
        this.size = l;
        this.modifiedBy = memberInfo;
        if (this.modifiedByAccount != UNKNOWN_FROM_ARCHIVE) {
            this.modifiedByAccount = accountInfo;
        }
        this.lastModifiedDate = date;
        this.version = n;
        this.deleted = bl;
        this.folderInfo = folderInfo;
        if (Feature.FILEINFO_LOG_MISSING_MODIFIED_BY_ACCOUNT.isEnabled() && accountInfo == null && log.isLoggable(Level.WARNING) && !folderInfo.isMetaFolder() && !folderInfo.getName().endsWith("server_maintenance") && !string.endsWith("desktop.ini")) {
            log.log(Level.INFO, this.toDetailString() + ": Missing account information", new StackDump());
        }
        this.validate();
    }

    protected FileInfo(FolderInfo folderInfo, String string, Date date, AccountInfo accountInfo) {
        Reject.ifNull(folderInfo, "folder is null!");
        Reject.ifNull(string, "relativeName is null!");
        Reject.ifTrue(string.contains("../"), String.format("relativeName must not contain ../ Got:  %s", string));
        this.fileName = string;
        this.folderInfo = folderInfo;
        this.lastModifiedDate = date;
        if (this.modifiedByAccount != UNKNOWN_FROM_ARCHIVE) {
            this.modifiedByAccount = accountInfo;
        }
        this.oid = null;
        this.hashes = null;
        this.tags = null;
        this.size = null;
        this.modifiedBy = null;
        this.version = 0;
        this.deleted = false;
    }

    public FileInfo(AbstractMessage abstractMessage) {
        this.initFromD2D(abstractMessage);
    }

    public FileInfo syncFromDiskIfRequired(Folder folder, Path path, AccountInfo accountInfo) {
        Reject.ifNull(folder, "Folder is null");
        Reject.ifFalse(folder.getInfo().equals(this.folderInfo), "Folder mismatch");
        if (path == null) {
            throw new NullPointerException("diskFile is null");
        }
        String string = FileInfoFactory.decodeIllegalChars(path.getFileName().toString());
        boolean bl = this.fileName.endsWith(string);
        if (!bl && IGNORE_CASE) {
            bl = string.equalsIgnoreCase(this.getFilenameOnly());
        }
        if (!bl && !this.isBaseDirectory()) {
            throw new IllegalArgumentException("Diskfile does not match fileinfo name '" + this.getFilenameOnly() + "', details: " + this.toDetailString() + ", diskfile name '" + path.getFileName().toString() + "', path: " + path);
        }
        if (!this.inSyncWithDisk(path)) {
            MemberInfo memberInfo = folder.getController().getMySelf().getInfo();
            if (accountInfo == null) {
                accountInfo = folder.getController().getMySelf().getAccountInfo();
            }
            if (Files.exists(path, new LinkOption[0])) {
                String string2 = null;
                return FileInfoFactory.modifiedFile(this, folder, path, memberInfo, accountInfo, string2);
            }
            return FileInfoFactory.deletedFile(this, memberInfo, accountInfo, new Date());
        }
        return null;
    }

    public boolean inSyncWithDisk(Path path) {
        return this.inSyncWithDisk0(path, false);
    }

    protected boolean inSyncWithDisk0(Path path, boolean bl) {
        boolean bl2;
        boolean bl3;
        Map<String, Object> map;
        Reject.ifNull(path, "Diskfile is null");
        try {
            map = Files.readAttributes(path, "size,lastModifiedTime,isDirectory", new LinkOption[0]);
            bl3 = false;
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            bl3 = true;
            map = null;
        }
        catch (IOException iOException) {
            bl3 = Files.notExists(path, new LinkOption[0]);
            if (!bl3) {
                log.warning("Could not access file attributes of file " + path.toAbsolutePath().toString() + ", " + this.toDetailString() + ", " + iOException.toString());
                return false;
            }
            map = null;
        }
        boolean bl4 = bl2 = bl3 && this.deleted || !bl3 && !this.deleted;
        if (!bl2) {
            return false;
        }
        if (!bl3) {
            boolean bl5;
            long l;
            long l2;
            try {
                l2 = (Long)map.get(PROPERTYNAME_SIZE);
                l = ((FileTime)map.get("lastModifiedTime")).toMillis();
                bl5 = (Boolean)map.get("isDirectory");
            }
            catch (Exception exception) {
                log.warning("Could not access file attributes of file " + path.toAbsolutePath().toString() + ", " + this.toDetailString() + ", " + exception.toString());
                return false;
            }
            if (bl) {
                boolean bl6 = this.isDiretory() && bl5;
                return bl6;
            }
            boolean bl7 = DateUtil.equalsFileDateCrossPlattform(l, this.lastModifiedDate.getTime());
            if (!bl7) {
                return false;
            }
            boolean bl8 = this.size == l2;
            return bl8;
        }
        return true;
    }

    @Override
    public String getRelativeName() {
        return this.fileName;
    }

    @Override
    public String getLowerCaseFilenameOnly() {
        FileInfoStrings fileInfoStrings = this.getStringsCache();
        if (fileInfoStrings.getLowerCaseName() == null) {
            fileInfoStrings.setLowerCaseName(this.fileName.toLowerCase());
        }
        return fileInfoStrings.getLowerCaseName();
    }

    private FileInfoStrings getStringsCache() {
        FileInfoStrings fileInfoStrings;
        FileInfoStrings fileInfoStrings2 = fileInfoStrings = this.cachedStrings != null ? this.cachedStrings.get() : null;
        if (fileInfoStrings == null) {
            fileInfoStrings = new FileInfoStrings();
            this.cachedStrings = new WeakReference<FileInfoStrings>(fileInfoStrings);
        }
        return fileInfoStrings;
    }

    @Override
    public String getExtension() {
        String string = this.getFilenameOnly();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1).toUpperCase();
    }

    @Override
    public String getFilenameOnly() {
        FileInfoStrings fileInfoStrings = this.getStringsCache();
        if (fileInfoStrings.getFileNameOnly() == null) {
            fileInfoStrings.setFileNameOnly(this.getFilenameOnly0());
        }
        return fileInfoStrings.getFileNameOnly();
    }

    private String getFilenameOnly0() {
        int n = this.fileName.lastIndexOf(47);
        if (n > -1) {
            return this.fileName.substring(n + 1);
        }
        return this.fileName;
    }

    public String getOID() {
        return this.oid;
    }

    public String getHashes() {
        return this.hashes;
    }

    public String getTags() {
        return this.tags;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isExpected(FolderRepository folderRepository) {
        if (this.deleted) {
            return false;
        }
        Folder folder = folderRepository.getFolder(this.folderInfo);
        if (folder == null) {
            return false;
        }
        return !folder.isKnown(this);
    }

    public boolean isDownloading(Controller controller) {
        return controller.getTransferManager().isDownloadingActive(this);
    }

    public boolean isUploading(Controller controller) {
        return controller.getTransferManager().isUploading(this);
    }

    public boolean diskFileExists(Controller controller) {
        Path path = this.getDiskFile(controller.getFolderRepository());
        return path != null && Files.exists(path, new LinkOption[0]);
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public MemberInfo getModifiedBy() {
        return this.modifiedBy;
    }

    public AccountInfo getModifiedByAccount() {
        return this.modifiedByAccount;
    }

    @Override
    public Date getModifiedDate() {
        return this.lastModifiedDate;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isLookupInstance() {
        return this.size == null;
    }

    @Override
    public boolean isDiretory() {
        return false;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    public boolean isBaseDirectory() {
        return StringUtils.isBlank(this.fileName);
    }

    public DirectoryInfo getDirectory() {
        int n = this.fileName.lastIndexOf(47);
        if (n < 0) {
            return FileInfoFactory.createBaseDirectoryInfo(this.folderInfo);
        }
        String string = this.fileName.substring(0, n);
        return FileInfoFactory.lookupDirectory(this.folderInfo, string);
    }

    public boolean lock(Controller controller) {
        return controller.getFolderRepository().getLocking().lock(this);
    }

    public boolean lock(Controller controller, AccountInfo accountInfo) {
        return controller.getFolderRepository().getLocking().lock(this, accountInfo);
    }

    public boolean unlock(Controller controller) {
        return controller.getFolderRepository().getLocking().unlock(this);
    }

    public boolean isLocked(Controller controller) {
        return controller.getFolderRepository().getLocking().isLocked(this);
    }

    public Lock getLock(Controller controller) {
        return controller.getFolderRepository().getLocking().getLock(this);
    }

    public boolean isNewerThan(FileInfo fileInfo) {
        return this.isNewerThan(fileInfo, false);
    }

    protected boolean isNewerThan(FileInfo fileInfo, boolean bl) {
        if (fileInfo == null) {
            throw new NullPointerException("Other file is null");
        }
        if (this.version == fileInfo.version) {
            if (bl) {
                return false;
            }
            return DateUtil.isNewerFileDateCrossPlattform(this.lastModifiedDate, fileInfo.lastModifiedDate);
        }
        return this.version > fileInfo.version;
    }

    public boolean isNewerAvailable(FolderRepository folderRepository) {
        FileInfo fileInfo = this.getNewestVersion(folderRepository);
        return fileInfo != null && fileInfo.isNewerThan(this);
    }

    public FileInfo getNewestVersion(FolderRepository folderRepository) {
        Reject.ifNull(folderRepository, "FolderRepository");
        Folder folder = this.getFolder(folderRepository);
        if (folder == null) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Unable to determine newest version. Folder not joined " + this.folderInfo);
            }
            return null;
        }
        return this.getNewestVersion(folder);
    }

    public FileInfo getNewestVersion(Folder folder) {
        Reject.ifFalse(this.folderInfo.equals(folder.getInfo()), "Folder mismatch");
        FileInfo fileInfo = null;
        for (Member member : folder.getMembersAsCollection()) {
            FileInfo fileInfo2 = member.getFile(this);
            if (fileInfo2 == null || !fileInfo2.isValid() || fileInfo != null && !fileInfo2.isNewerThan(fileInfo) || !ServerClient.SERVER_HANDLE_MESSAGE_THREAD.get().booleanValue() && !folder.hasWritePermission(member)) continue;
            fileInfo = fileInfo2;
        }
        return fileInfo;
    }

    public FileInfo getNewestNotDeletedVersion(FolderRepository folderRepository) {
        if (folderRepository == null) {
            throw new NullPointerException("FolderRepo is null");
        }
        Folder folder = this.getFolder(folderRepository);
        if (folder == null) {
            log.warning("Unable to determine newest version. Folder not joined " + this.folderInfo);
            return null;
        }
        FileInfo fileInfo = null;
        for (Member member : folder.getMembersAsCollection()) {
            FileInfo fileInfo2;
            if (!member.isCompletelyConnected() && !member.isMySelf() || (fileInfo2 = member.getFile(this)) == null || fileInfo2.deleted || fileInfo != null && !fileInfo2.isNewerThan(fileInfo) || !ServerClient.SERVER_HANDLE_MESSAGE_THREAD.get().booleanValue() && !folder.hasWritePermission(member)) continue;
            fileInfo = fileInfo2;
        }
        return fileInfo;
    }

    public Path getDiskFile(FolderRepository folderRepository) {
        Reject.ifNull(folderRepository, "Repo is null");
        Folder folder = this.getFolder(folderRepository);
        if (folder == null) {
            return null;
        }
        return folder.getDiskFile(this);
    }

    public FileInfo getLocalFileInfo(FolderRepository folderRepository) {
        Reject.ifNull(folderRepository, "Repo is null");
        Folder folder = this.getFolder(folderRepository);
        if (folder == null) {
            return null;
        }
        return folder.getFile(this);
    }

    @Override
    public FolderInfo getFolderInfo() {
        return this.folderInfo;
    }

    public Folder getFolder(FolderRepository folderRepository) {
        if (folderRepository == null) {
            throw new NullPointerException("Repository is null");
        }
        return folderRepository.getFolder(this.folderInfo);
    }

    public boolean isVersionDateAndSizeIdentical(FileInfo fileInfo) {
        if (fileInfo == null) {
            return false;
        }
        if (this.version != fileInfo.version) {
            return false;
        }
        if (!Util.equals(this.size, fileInfo.size)) {
            return false;
        }
        if (!this.equals(fileInfo)) {
            return false;
        }
        return this.lastModifiedDate == null || fileInfo.lastModifiedDate == null || this.lastModifiedDate.equals(fileInfo.lastModifiedDate);
    }

    public boolean isMatchingHash(String string) {
        Reject.ifBlank(string, "Hash");
        if (StringUtils.isBlank(this.hashes)) {
            return false;
        }
        return this.hashes.contains(string);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.hashCode0();
        }
        return this.hash;
    }

    private int hashCode0() {
        int n = IGNORE_CASE ? this.fileName.toLowerCase().hashCode() : this.fileName.hashCode();
        return n += this.folderInfo.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof FileInfo) {
            FileInfo fileInfo = (FileInfo)object;
            boolean bl = Util.equalsRelativeName(this.fileName, fileInfo.fileName);
            return bl && Util.equals(this.folderInfo, fileInfo.folderInfo);
        }
        return false;
    }

    public String toString() {
        return "[" + this.folderInfo.getName() + UNIX_SEPARATOR + this.folderInfo.getId() + UNIX_SEPARATOR + this.folderInfo.getVersion() + "]:" + (this.deleted ? "(del) /" : UNIX_SEPARATOR) + this.fileName;
    }

    private void toDetailString(StringBuilder stringBuilder) {
        stringBuilder.append(this);
        stringBuilder.append(", size: ");
        stringBuilder.append(this.size);
        stringBuilder.append(" bytes, version: ");
        stringBuilder.append(this.version);
        if (this.isDeleted()) {
            stringBuilder.append(", deleted: ");
        } else {
            stringBuilder.append(", modified: ");
        }
        stringBuilder.append(this.lastModifiedDate);
        stringBuilder.append(" (");
        if (this.lastModifiedDate != null) {
            stringBuilder.append(this.lastModifiedDate.getTime());
        } else {
            stringBuilder.append("-n/a-");
        }
        stringBuilder.append(") by ");
        if (this.modifiedByAccount != null) {
            stringBuilder.append(this.modifiedByAccount.getUsername());
        } else {
            stringBuilder.append("(unknown)");
        }
        if (this.modifiedBy != null) {
            stringBuilder.append(" on ");
            stringBuilder.append(this.modifiedBy.nick);
        }
    }

    public String toDetailString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toDetailString(stringBuilder);
        return stringBuilder.toString();
    }

    public boolean isValid() {
        try {
            this.validate();
            return true;
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Invalid: " + this.toDetailString() + ". " + exception);
            return false;
        }
    }

    private void validate() {
        Reject.ifNull(this.lastModifiedDate, "Modification date is null");
        if (this.lastModifiedDate.getTime() < 0L) {
            throw new IllegalStateException("Modification date is invalid: " + this.lastModifiedDate + ": " + this.toDetailString());
        }
        Reject.ifTrue(StringUtils.isEmpty(this.fileName), "Filename is empty");
        char c = this.fileName.charAt(this.fileName.length() - 1);
        if (c == '/' || c == '\\') {
            throw new IllegalStateException("Filename ends with slash: " + this.fileName + ": " + this.toDetailString());
        }
        Reject.ifNull(this.folderInfo, "FolderInfo is null");
    }

    public void increaseVersion(int n) {
        this.version += n;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.folderInfo = this.folderInfo != null ? this.folderInfo.intern() : null;
        this.modifiedBy = this.modifiedBy != null ? this.modifiedBy.intern() : null;
        this.modifiedByAccount = this.modifiedByAccount != null ? this.modifiedByAccount.intern() : null;
        this.fileName = this.fileName;
        if (this.fileName.endsWith(UNIX_SEPARATOR)) {
            this.fileName = this.fileName.substring(0, this.fileName.length() - 1);
        }
        if (this.fileName.startsWith(UNIX_SEPARATOR)) {
            this.fileName = this.fileName.substring(1);
        }
    }

    void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        long l = objectInput.readLong();
        if (l != 100L && l != 101L) {
            throw new InvalidClassException(this.getClass().getName(), "Unable to read. extVersionUID(steam): " + l + ", supported: 100, 101");
        }
        this.fileName = objectInput.readUTF();
        this.size = objectInput.readLong();
        if (objectInput.readBoolean()) {
            this.modifiedBy = MemberInfo.readExt(objectInput);
            this.modifiedBy = this.modifiedBy != null ? this.modifiedBy.intern() : null;
        } else {
            this.modifiedBy = null;
        }
        this.lastModifiedDate = ExternalizableUtil.readDate(objectInput);
        this.version = objectInput.readInt();
        this.deleted = objectInput.readBoolean();
        this.folderInfo = ExternalizableUtil.readFolderInfo(objectInput);
        FolderInfo folderInfo = this.folderInfo = this.folderInfo != null ? this.folderInfo.intern() : null;
        if (l == 100L) {
            return;
        }
        this.oid = objectInput.readBoolean() ? objectInput.readUTF() : null;
        this.hashes = objectInput.readBoolean() ? objectInput.readUTF() : null;
        this.tags = objectInput.readBoolean() ? objectInput.readUTF() : null;
        if (objectInput.readBoolean()) {
            this.modifiedByAccount = AccountInfo.readExt(objectInput);
            this.modifiedByAccount = this.modifiedByAccount != null ? this.modifiedByAccount.intern() : null;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        long l = this.oid == null && this.hashes == null && this.tags == null && this.modifiedByAccount == null ? 100L : 101L;
        objectOutput.writeInt(this.isFile() ? 0 : 1);
        objectOutput.writeLong(l);
        objectOutput.writeUTF(this.fileName);
        objectOutput.writeLong(this.size);
        objectOutput.writeBoolean(this.modifiedBy != null);
        if (this.modifiedBy != null) {
            this.modifiedBy.writeExternal(objectOutput);
        }
        ExternalizableUtil.writeDate(objectOutput, this.lastModifiedDate);
        objectOutput.writeInt(this.version);
        objectOutput.writeBoolean(this.deleted);
        ExternalizableUtil.writeFolderInfo(objectOutput, this.folderInfo, false);
        if (l == 100L) {
            return;
        }
        if (this.oid != null) {
            objectOutput.writeBoolean(true);
            objectOutput.writeUTF(this.oid);
        } else {
            objectOutput.writeBoolean(false);
        }
        if (this.hashes != null) {
            objectOutput.writeBoolean(true);
            objectOutput.writeUTF(this.hashes);
        } else {
            objectOutput.writeBoolean(false);
        }
        if (this.tags != null) {
            objectOutput.writeBoolean(true);
            objectOutput.writeUTF(this.tags);
        } else {
            objectOutput.writeBoolean(false);
        }
        if (this.modifiedByAccount != null) {
            objectOutput.writeBoolean(true);
            this.modifiedByAccount.writeExternal(objectOutput);
        } else {
            objectOutput.writeBoolean(false);
        }
    }

    public static String renameRelativeFileName(String string, String string2) {
        if (string2.contains(UNIX_SEPARATOR)) {
            throw new IllegalArgumentException("newFileName must not contain /: " + string);
        }
        if (string.contains(UNIX_SEPARATOR)) {
            String string3 = string.substring(0, string.lastIndexOf(UNIX_SEPARATOR));
            return string3 + UNIX_SEPARATOR + string2;
        }
        return string2;
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof FileInfoProto.FileInfo) {
            FileInfoProto.FileInfo fileInfo = (FileInfoProto.FileInfo)abstractMessage;
            this.deleted = fileInfo.getDeleted();
            this.fileName = fileInfo.getFileName();
            this.folderInfo = FolderInfoFactory.lookupInstance(fileInfo.getFolderId());
            this.lastModifiedDate = new Date(fileInfo.getLastModifiedDate());
            this.modifiedBy = new MemberInfo("", fileInfo.getModifiedByNodeId(), "");
            this.version = (int)fileInfo.getVersion();
            this.size = fileInfo.getSize();
            this.validate();
        }
    }

    @Override
    public AbstractMessage toD2D() {
        FileInfoProto.FileInfo.Builder builder = FileInfoProto.FileInfo.newBuilder();
        builder.setClazzName(this.getClass().getSimpleName());
        builder.setDeleted(this.deleted);
        if (this.fileName != null) {
            builder.setFileName(this.fileName);
        }
        if (this.folderInfo != null) {
            builder.setFolderId(this.folderInfo.getId());
        }
        if (this.lastModifiedDate != null) {
            builder.setLastModifiedDate(this.lastModifiedDate.getTime());
        }
        if (this.modifiedBy != null) {
            builder.setModifiedByNodeId(this.modifiedBy.getId());
        }
        builder.setVersion(this.version);
        if (this.size != null) {
            builder.setSize(this.size);
        }
        return builder.build();
    }
}

