/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.light;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.d2d.D2DEvent;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.d2d.NodeEvent;
import de.dal33t.powerfolder.protocol.AccountInfoProto;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.intern.AccountInfoInternalizer;
import de.dal33t.powerfolder.util.intern.Internalizer;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collection;
import javax.persistence.Embeddable;
import javax.persistence.Transient;

@Embeddable
public class AccountInfo
implements Serializable,
D2DObject,
D2DEvent {
    public static final String PROPERTYNAME_OID = "oid";
    public static final String PROPERTYNAME_USERNAME = "username";
    private static final long serialVersionUID = 100L;
    private static final Internalizer<AccountInfo> INTERNALIZER = new AccountInfoInternalizer();
    private String oid;
    private String username;
    @Transient
    private String displayName;
    @Transient
    private long avatarLastModifiedDate;
    @Transient
    private Collection<String> emails;
    private static final long extVersionUID = 100L;

    private AccountInfo() {
    }

    public AccountInfo(String string, String string2, String string3) {
        this.oid = string;
        this.username = string2;
        this.displayName = string3;
    }

    public AccountInfo(String string, String string2) {
        this(string, string2, null);
    }

    public AccountInfo(AbstractMessage abstractMessage) {
        this.initFromD2D(abstractMessage);
    }

    public String getOID() {
        return this.oid;
    }

    public String getDisplayName() {
        if (StringUtils.isNotBlank(this.displayName)) {
            return this.displayName;
        }
        return this.username;
    }

    public String getScrabledDisplayName() {
        return this.getScrabledName(this.getDisplayName());
    }

    public String getScrabledUsername() {
        return this.getScrabledName(this.username);
    }

    private String getScrabledName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(64);
        if (n < 0) {
            return string;
        }
        int n2 = Math.max(n - 3, 1);
        return string.substring(0, n2) + "..." + string.substring(n);
    }

    public String getUsername() {
        return this.username;
    }

    public AccountInfo intern(boolean bl) {
        if (bl) {
            return INTERNALIZER.rename(this);
        }
        return this.intern();
    }

    public long getAvatarLastModifiedDate() {
        return this.avatarLastModifiedDate;
    }

    public void setAvatarLastModifiedDate(long l) {
        this.avatarLastModifiedDate = l;
    }

    public Collection<String> getEmails() {
        return this.emails;
    }

    public void setEmails(Collection<String> collection) {
        this.emails = collection;
    }

    public AccountInfo intern() {
        return INTERNALIZER.intern(this);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.oid == null ? 0 : this.oid.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AccountInfo accountInfo = (AccountInfo)object;
        return !(this.oid == null ? accountInfo.oid != null : !this.oid.equals(accountInfo.oid));
    }

    public String toString() {
        return "AccountInfo '" + this.getScrabledDisplayName() + "' (" + this.oid + ")";
    }

    public static AccountInfo readExt(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        AccountInfo accountInfo = new AccountInfo();
        accountInfo.readExternal(objectInput);
        return accountInfo;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        long l = objectInput.readLong();
        if (l != 100L) {
            throw new InvalidClassException(this.getClass().getName(), "Unable to read. extVersionUID(steam): " + l + ", expected: 100");
        }
        this.oid = objectInput.readUTF();
        this.username = objectInput.readUTF();
        if (objectInput.readBoolean()) {
            this.displayName = objectInput.readUTF();
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(100L);
        objectOutput.writeUTF(this.oid != null ? this.oid : "");
        objectOutput.writeUTF(this.username != null ? this.username : "");
        if (this.displayName != null) {
            objectOutput.writeBoolean(true);
            objectOutput.writeUTF(this.displayName);
        } else {
            objectOutput.writeBoolean(false);
        }
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof AccountInfoProto.AccountInfo) {
            AccountInfoProto.AccountInfo accountInfo = (AccountInfoProto.AccountInfo)abstractMessage;
            this.oid = accountInfo.getId();
            this.username = accountInfo.getUsername();
            this.displayName = accountInfo.getDisplayName();
            this.avatarLastModifiedDate = accountInfo.getAvatarLastModifiedDate();
        }
    }

    @Override
    public AbstractMessage toD2D() {
        AccountInfoProto.AccountInfo.Builder builder = AccountInfoProto.AccountInfo.newBuilder();
        builder.setClazzName(this.getClass().getSimpleName());
        builder.setId(this.oid);
        builder.setUsername(this.username);
        if (null != this.displayName) {
            builder.setDisplayName(this.displayName);
        }
        builder.setAvatarLastModifiedDate(this.avatarLastModifiedDate);
        if (this.emails != null) {
            for (String string : this.emails) {
                builder.addEmails(string);
            }
        }
        return builder.build();
    }

    @Override
    public NodeEvent getNodeEvent() {
        return NodeEvent.ACCOUNT_INFO_REQUEST;
    }
}

