/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.distribution;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.distribution.AbstractDistribution;
import de.dal33t.powerfolder.skin.AbstractSyntheticaSkin;
import de.dal33t.powerfolder.skin.Origin;
import de.dal33t.powerfolder.ui.util.Icons;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;

public class Tabbles
extends AbstractDistribution {
    private static final String NAME = "Tabbles";
    private static final String DESCRIPTION = "Tabbles powered by PowerFolder";
    private static final String FOLDERS_BASE_NAME = "PowerFolders";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getBinaryName() {
        return NAME;
    }

    @Override
    public void init(Controller controller) {
        super.init(controller);
        Tabbles.setAppName(NAME);
        Tabbles.setAppDescription(DESCRIPTION);
        Tabbles.setFoldersBaseDirName(controller, FOLDERS_BASE_NAME);
        PreferencesEntry.SKIN_NAME.setValue(controller, NAME);
        this.loadPreConfigFromClasspath(controller);
    }

    @Override
    public boolean allowSkinChange() {
        return false;
    }

    public static class Skin
    extends AbstractSyntheticaSkin {
        @Override
        public String getName() {
            return Tabbles.NAME;
        }

        @Override
        public String getID() {
            return Tabbles.NAME;
        }

        @Override
        public Properties getIconsProperties() {
            Properties properties = Icons.getIconProperties();
            properties.putAll((Map<?, ?>)Icons.loadProperties(Origin.ICON_PROPERTIES_FILENAME));
            properties.putAll((Map<?, ?>)Icons.loadProperties("client/icons.properties"));
            return properties;
        }

        @Override
        public Path getDefaultSynthXMLPath() {
            return Paths.get("/client/synth.xml", new String[0]);
        }
    }
}

