/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk.problem;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.problem.FileProblemHelper;
import de.dal33t.powerfolder.disk.problem.ResolvableProblem;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.util.Translation;

public class TooLongFilenameProblem
extends ResolvableProblem {
    private final String description;
    private final FileInfo fileInfo;

    public TooLongFilenameProblem(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
        this.description = Translation.get("filename_problem.too_long", fileInfo.getFilenameOnly());
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getWikiLinkKey() {
        return "File-Name-Too-Long";
    }

    @Override
    public Folder getFolder(Controller controller) {
        return this.fileInfo.getFolder(controller.getFolderRepository());
    }

    @Override
    public Runnable resolution(Controller controller) {
        return () -> {
            Folder folder = this.getFolder(controller);
            if (folder == null) {
                return;
            }
            if (folder.getDiskItemFilter().isExcluded(this.fileInfo.getRelativeName())) {
                folder.removePattern(this.fileInfo.getRelativeName());
            }
            if (this.fileInfo.getLocalFileInfo(controller.getFolderRepository()) != null) {
                String string = FileProblemHelper.getShorterFilename(controller, this.fileInfo);
                FileProblemHelper.resolve(controller, this.fileInfo, string, this);
            }
        };
    }

    @Override
    public String getResolutionDescription() {
        return Translation.get("filename_problem.too_long.soln_desc");
    }
}

