/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk.problem;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.problem.ResolvableProblem;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.ui.wizard.PFWizard;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Translation;

public class FileConflictProblem
extends ResolvableProblem {
    private FileInfo fInfo;

    public FileConflictProblem(FileInfo fileInfo) {
        Reject.ifNull(fileInfo, "FileInfo");
        this.fInfo = fileInfo;
    }

    public FileInfo getFileInfo() {
        return this.fInfo;
    }

    @Override
    public String getDescription() {
        return Translation.get("file_conflict_problem.description", this.fInfo.getFolderInfo().getLocalizedName() + "/" + this.fInfo.getRelativeName());
    }

    @Override
    public String getWikiLinkKey() {
        return "Conflict_handling";
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = n * n2 + (this.fInfo == null ? 0 : this.fInfo.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FileConflictProblem fileConflictProblem = (FileConflictProblem)object;
        return !(this.fInfo == null ? fileConflictProblem.fInfo != null : !this.fInfo.equals(fileConflictProblem.fInfo));
    }

    @Override
    public Folder getFolder(Controller controller) {
        return this.fInfo.getFolder(controller.getFolderRepository());
    }

    @Override
    public Runnable resolution(final Controller controller) {
        return new Runnable(){

            @Override
            public void run() {
                Folder folder = controller.getFolderRepository().getFolder(FileConflictProblem.this.fInfo.getFolderInfo());
                PFWizard.openSingleFileRestoreWizard(controller, folder, FileConflictProblem.this.fInfo, FileConflictProblem.this.fInfo);
            }
        };
    }

    @Override
    public String getResolutionDescription() {
        return Translation.get("file_conflict_problem.soln_desc");
    }
}

