/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Constants;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.clientserver.FolderService;
import de.dal33t.powerfolder.clientserver.RemoteCallException;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.d2d.D2DSocketConnectionHandler;
import de.dal33t.powerfolder.disk.EncryptedFileSystemUtils;
import de.dal33t.powerfolder.disk.FileArchiver;
import de.dal33t.powerfolder.disk.FileInBasePathWarning;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.FolderRenameException;
import de.dal33t.powerfolder.disk.FolderScanner;
import de.dal33t.powerfolder.disk.FolderSettings;
import de.dal33t.powerfolder.disk.Locking;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.disk.problem.AccessDeniedProblem;
import de.dal33t.powerfolder.disk.problem.ProblemListener;
import de.dal33t.powerfolder.event.FolderAutoCreateEvent;
import de.dal33t.powerfolder.event.FolderAutoCreateListener;
import de.dal33t.powerfolder.event.FolderRepositoryEvent;
import de.dal33t.powerfolder.event.FolderRepositoryListener;
import de.dal33t.powerfolder.event.ListenerSupportFactory;
import de.dal33t.powerfolder.light.DirectoryInfo;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.FolderInfoFactory;
import de.dal33t.powerfolder.light.FolderStatisticInfo;
import de.dal33t.powerfolder.message.FileListRequest;
import de.dal33t.powerfolder.message.clientserver.AccountDetails;
import de.dal33t.powerfolder.security.Account;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.security.Permission;
import de.dal33t.powerfolder.security.SecurityException;
import de.dal33t.powerfolder.task.CreateFolderOnServerTask;
import de.dal33t.powerfolder.task.FolderObtainPermissionTask;
import de.dal33t.powerfolder.task.PersistentTask;
import de.dal33t.powerfolder.transfer.FileRequestor;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.notices.Notice;
import de.dal33t.powerfolder.ui.notices.WarningNotice;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.ProUtil;
import de.dal33t.powerfolder.util.Profiling;
import de.dal33t.powerfolder.util.ProfilingEntry;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.UserDirectories;
import de.dal33t.powerfolder.util.UserDirectory;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.Waiter;
import de.dal33t.powerfolder.util.WrappedScheduledThreadPoolExecutor;
import de.dal33t.powerfolder.util.collection.CompositeCollection;
import de.dal33t.powerfolder.util.compare.FolderComparator;
import de.dal33t.powerfolder.util.os.LinuxUtil;
import de.dal33t.powerfolder.util.os.OSUtil;
import de.dal33t.powerfolder.util.os.Win32.Spacetree;
import de.dal33t.powerfolder.util.os.Win32.WinUtils;
import de.dal33t.powerfolder.util.os.mac.MacUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class FolderRepository
extends PFComponent
implements Runnable {
    private static final Logger log = Logger.getLogger(FolderRepository.class.getName());
    private static final String DIRNAME_SNAPSHOT = ".snapshot";
    private final Map<FolderInfo, Folder> folders;
    private final Map<FolderInfo, Folder> metaFolders;
    private Thread myThread;
    private final FileRequestor fileRequestor;
    private Folder currentlyMaintainingFolder;
    private final Set<String> onLoginFolderEntryIds = new HashSet<String>();
    private boolean started;
    private final Object scanTrigger = new Object();
    private boolean triggered = false;
    private final AtomicInteger suspendNewFolderSearch = new AtomicInteger(0);
    private Path foldersBasedir;
    private final FolderRepositoryListener folderRepositoryListenerSupport;
    private final FolderScanner folderScanner;
    private final Locking locking;
    private AllFolderMembershipSynchronizer folderMembershipSynchronizer;
    private final Object folderMembershipSynchronizerLock = new Object();
    private final ProblemListener valveProblemListenerSupport;
    private FolderAutoCreateListener folderAutoCreateListener;
    private final Set<Path> ignoredFolderDirectories = new CopyOnWriteArraySet<Path>();
    private final ReentrantLock scanBasedirLock = new ReentrantLock();
    private ScheduledFuture<?> scanBaseDirFuture;
    private ReentrantLock accountSyncLock = new ReentrantLock();

    public FolderRepository(Controller controller) {
        super(controller);
        this.folders = new ConcurrentHashMap<FolderInfo, Folder>();
        this.metaFolders = new ConcurrentHashMap<FolderInfo, Folder>();
        this.fileRequestor = new FileRequestor(controller);
        this.started = false;
        this.loadIgnoredFolders();
        this.folderScanner = new FolderScanner(this.getController());
        this.locking = new Locking(this.getController());
        this.folderRepositoryListenerSupport = ListenerSupportFactory.createListenerSupport(FolderRepositoryListener.class);
        this.valveProblemListenerSupport = ListenerSupportFactory.createListenerSupport(ProblemListener.class);
        this.folderAutoCreateListener = ListenerSupportFactory.createListenerSupport(FolderAutoCreateListener.class);
    }

    private void loadIgnoredFolders() {
        String[] stringArray;
        String string = ConfigurationEntry.AUTO_SETUP_FOLDERS_IGNORED.getValue(this.getController());
        for (String string2 : stringArray = string.split("\\$")) {
            try {
                Path path = Paths.get(string2, new String[0]);
                if (EncryptedFileSystemUtils.endsWithEncryptionSuffix(path)) continue;
                this.ignoredFolderDirectories.add(path);
            }
            catch (Exception exception) {
                this.logFine("Unable to check removed dir: " + string2 + ". " + exception);
            }
        }
    }

    public void addProblemListenerToAllFolders(ProblemListener problemListener) {
        ListenerSupportFactory.addListener(this.valveProblemListenerSupport, problemListener);
    }

    public void removeProblemListenerFromAllFolders(ProblemListener problemListener) {
        ListenerSupportFactory.removeListener(this.valveProblemListenerSupport, problemListener);
    }

    public void addFolderAutoCreateListener(FolderAutoCreateListener folderAutoCreateListener) {
        ListenerSupportFactory.addListener(this.folderAutoCreateListener, folderAutoCreateListener);
    }

    public void removeFolderAutoCreateListener(FolderAutoCreateListener folderAutoCreateListener) {
        ListenerSupportFactory.removeListener(this.folderAutoCreateListener, folderAutoCreateListener);
    }

    public FolderScanner getFolderScanner() {
        return this.folderScanner;
    }

    public Locking getLocking() {
        return this.locking;
    }

    public void setSuspendFireEvents(boolean bl) {
        ListenerSupportFactory.setSuspended(this.folderRepositoryListenerSupport, bl);
        this.logFine("setSuspendFireEvents: " + bl);
    }

    public void init() {
        this.initFoldersBasedir();
        this.fixPFS3334();
        this.processV4Format();
        if (this.getController().isFirstStart()) {
            this.createShortcuts();
        }
        if (Spacetree.isSupported(this.getController())) {
            try {
                Spacetree spacetree = Spacetree.create(this.getController());
                if (spacetree != null) {
                    spacetree.install();
                }
            }
            catch (Exception exception) {
                this.logWarning("Unable to setup space tree icon integration into Windows-Explorer. " + exception.getMessage(), exception);
            }
        }
        this.tidyOldLinks();
    }

    public void createShortcuts() {
        if (PreferencesEntry.CREATE_BASEDIR_DESKTOP_SHORTCUT.getValueBoolean(this.getController()).booleanValue()) {
            String string;
            Path path = this.getController().getFolderRepository().getFoldersBasedir();
            Path path2 = path.getFileName();
            if (path2 == null) {
                path2 = path.getRoot();
            }
            if (!Util.isDesktopShortcut(string = path2.toString())) {
                Util.createDesktopShortcut(string, this.getController().getFolderRepository().getFoldersBasedir());
            }
        }
        if (PreferencesEntry.CREATE_FAVORITES_SHORTCUT.getValueBoolean(this.getController()).booleanValue()) {
            try {
                if (WinUtils.isSupported()) {
                    WinUtils.getInstance().setPFLinks(true, this.getController());
                } else if (MacUtils.isSupported()) {
                    MacUtils.getInstance().setPFPlaces(true, this.getController());
                }
            }
            catch (IOException iOException) {
                this.logSevere(iOException);
            }
        }
    }

    public void updateShortcuts(String string) {
        if (PreferencesEntry.CREATE_BASEDIR_DESKTOP_SHORTCUT.getValueBoolean(this.getController()).booleanValue() && Util.isDesktopShortcut(string)) {
            Util.removeDesktopShortcut(string);
            Path path = this.getController().getFolderRepository().getFoldersBasedir();
            Path path2 = path.getFileName();
            if (path2 == null) {
                path2 = path.getRoot();
            }
            String string2 = path2.toString();
            Util.createDesktopShortcut(string2, this.getController().getFolderRepository().getFoldersBasedir());
        }
        if (PreferencesEntry.CREATE_FAVORITES_SHORTCUT.getValueBoolean(this.getController()).booleanValue()) {
            try {
                if (WinUtils.isSupported() && WinUtils.isPFLinks(string)) {
                    WinUtils.removePFLinks(string);
                    WinUtils.getInstance().setPFLinks(true, this.getController());
                } else if (MacUtils.isSupported()) {
                    MacUtils.getInstance().setPFPlaces(true, this.getController());
                }
            }
            catch (IOException iOException) {
                this.logSevere(iOException);
            }
        }
    }

    private void tidyOldLinks() {
        Path path = this.getFoldersBasedir();
        if (Files.exists(path, new LinkOption[0])) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, "*.lnk");){
                for (Path path2 : directoryStream) {
                    boolean bl = false;
                    for (Folder folder : this.getFolders()) {
                        if (!(folder.getName() + ".lnk").equals(path2.getFileName().toString())) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    boolean bl2 = Files.deleteIfExists(path2);
                    this.logInfo("Removed old link " + path2.getFileName() + "? " + bl2);
                }
            }
            catch (IOException iOException) {
                this.logWarning(iOException.getMessage() + ". " + iOException);
            }
        }
    }

    private boolean initFoldersBasedir() {
        boolean bl;
        String string;
        String string2;
        String string3 = string2 = this.getController().getCommandLine() != null ? this.getController().getCommandLine().getOptionValue("b") : null;
        if (StringUtils.isNotBlank(string2)) {
            string = string2;
        } else {
            string = ConfigurationEntry.FOLDER_BASEDIR.getValue(this.getController());
            boolean bl2 = PreferencesEntry.FOLDER_BASE_PATH_OVERWRITE.getValueBoolean(this.getController());
            if (bl2 && !PreferencesEntry.FOLDER_BASE_PATH.getValueString(this.getController()).isEmpty()) {
                string = PreferencesEntry.FOLDER_BASE_PATH.getValueString(this.getController());
                ConfigurationEntry.FOLDER_BASEDIR.setValue(this.getController(), string);
                PreferencesEntry.FOLDER_BASE_PATH_OVERWRITE.setValue(this.getController(), false);
            }
        }
        try {
            if (StringUtils.isNotBlank(string)) {
                String string4 = System.getProperty("user.name");
                if (StringUtils.isNotBlank(this.getController().getOSClient().getUsername())) {
                    string4 = this.getController().getOSClient().getUsername();
                }
                if (string.contains("%username%")) {
                    string = string.replace("%username%", string4);
                    this.logWarning("New basedir: " + string);
                }
                if (string.contains("$username")) {
                    string = string.replace("$username", string4);
                    this.logWarning("New basedir: " + string);
                }
            }
        }
        catch (Exception exception) {
            this.logWarning("Unable to resolve 'username' placeholder in basepath: " + string + ". " + exception);
        }
        Path path = Paths.get(string, new String[0]);
        if (!ConfigurationEntry.FOLDER_CREATE_ALLOW_NETWORK.getValueBoolean(this.getController()).booleanValue() && Files.exists(path, new LinkOption[0])) {
            try {
                if (PathUtils.isNetworkPath(path)) {
                    this.foldersBasedir = Paths.get(ConfigurationEntry.FOLDER_BASEDIR.getDefaultValue(), new String[0]);
                    String string5 = Translation.get("dialog.folder.network_paths_not_allowed") + this.foldersBasedir;
                    Object[] objectArray = new Object[]{"OK"};
                    JOptionPane.showOptionDialog(null, string5, Translation.get("dialog.folder.title.network_paths_not_allowed"), -1, 2, null, objectArray, objectArray[0]);
                    PreferencesEntry.FOLDER_BASE_PATH.setValue(this.getController(), this.foldersBasedir.toString());
                    ConfigurationEntry.FOLDER_BASEDIR.setValue(this.getController(), this.foldersBasedir.toString());
                    this.getController().saveConfig();
                    this.logWarning("Network shares not allowed as base path: " + string + ", switching to default: " + this.foldersBasedir);
                    return true;
                }
            }
            catch (IOException iOException) {
                this.logWarning("Failed to resolve symlink at " + path);
                throw new IllegalStateException("Failed to resolve symlink at " + path);
            }
        }
        if (this.foldersBasedir == null || !this.foldersBasedir.equals(string)) {
            this.foldersBasedir = Paths.get(string, new String[0]).toAbsolutePath();
        }
        if (Files.notExists(this.foldersBasedir, new LinkOption[0])) {
            try {
                Files.createDirectories(this.foldersBasedir, new FileAttribute[0]);
                this.logInfo("Created base path for folders: " + this.foldersBasedir);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (Exception exception) {
                this.logWarning("Unable to create base path for folders: " + this.foldersBasedir + ". " + exception.getMessage());
            }
        }
        boolean bl3 = bl = Files.exists(this.foldersBasedir, new LinkOption[0]) && Files.isReadable(this.foldersBasedir) && Files.isDirectory(this.foldersBasedir, new LinkOption[0]);
        if (!bl && ConfigurationEntry.FOLDER_BASEDIR_FALLBACK_TO_DEFAULT.getValueBoolean(this.getController()).booleanValue()) {
            this.foldersBasedir = Paths.get(ConfigurationEntry.FOLDER_BASEDIR.getDefaultValue(), new String[0]);
            if (Files.notExists(this.foldersBasedir, new LinkOption[0])) {
                try {
                    Files.createDirectories(this.foldersBasedir, new FileAttribute[0]);
                    this.logInfo("Created base path for folders: " + this.foldersBasedir);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                }
                catch (Exception exception) {
                    this.logWarning("Unable to create base path for folders: " + this.foldersBasedir + ". " + exception.getMessage());
                }
            }
        }
        boolean bl4 = bl = Files.exists(this.foldersBasedir, new LinkOption[0]) && Files.isReadable(this.foldersBasedir) && Files.isDirectory(this.foldersBasedir, new LinkOption[0]);
        if (bl) {
            HashSet<PosixFilePermission> hashSet;
            this.logFine("Using base path for folders: " + this.foldersBasedir);
            if (OSUtil.isMacOS()) {
                try {
                    hashSet = new HashSet<PosixFilePermission>(3);
                    hashSet.add(PosixFilePermission.OWNER_EXECUTE);
                    hashSet.add(PosixFilePermission.OWNER_READ);
                    hashSet.add(PosixFilePermission.OWNER_WRITE);
                    Files.setPosixFilePermissions(this.foldersBasedir, hashSet);
                }
                catch (IOException iOException) {
                    this.logInfo("Could not set permissions to base path for folders: " + this.foldersBasedir + ". " + iOException);
                }
            }
            PathUtils.maintainDesktopIni(this.getController(), this.foldersBasedir);
            try {
                if (ConfigurationEntry.COPY_GETTING_STARTED_GUIDE.getValueBoolean(this.getController()).booleanValue() && Files.notExists(hashSet = this.foldersBasedir.resolve("Getting started.pdf"), new LinkOption[0])) {
                    Util.copyResourceTo("Getting started.pdf", null, hashSet, false, true);
                }
            }
            catch (Exception exception) {
                this.logWarning("Unable to copy getting started guide. " + exception);
            }
        } else {
            this.logWarning("Unable to access base path for folders: " + this.foldersBasedir);
        }
        PreferencesEntry.FOLDER_BASE_PATH.setValue(this.getController(), string);
        ConfigurationEntry.FOLDER_BASEDIR.setValue(this.getController(), string);
        this.getController().saveConfig();
        return bl;
    }

    private void fixPFS3334() {
        String string = ConfigurationEntry.DEFAULT_TRANSFER_MODE.getValue(this.getController());
        if (StringUtils.isNotBlank(string) && !string.equals("folder.scan.continuous") && !string.equals("folder.scan.24.hours")) {
            return;
        }
        this.logInfo("PFS-3334: Fixing default transfer mode");
        Properties properties = this.getController().getConfig();
        ConfigurationEntry.DEFAULT_TRANSFER_MODE.setValue(properties, ConfigurationEntry.DEFAULT_TRANSFER_MODE.getDefaultValue());
        Set<String> set = FolderSettings.loadEntryIds(properties);
        for (String string2 : set) {
            FolderSettings folderSettings = FolderSettings.load(this.getController(), string2);
            if (!folderSettings.getSyncProfile().equals(SyncProfile.MANUAL_SYNCHRONIZATION)) continue;
            String string3 = FolderSettings.loadFolderName(this.getController().getConfig(), string2);
            this.logWarning("PFS-3334: Fixed transfer mode for folder " + string3 + ". EntryID: " + string2);
            properties.setProperty("f." + string2 + ".syncprofile", ConfigurationEntry.DEFAULT_TRANSFER_MODE.getValue(properties));
        }
        this.logWarning("PFS-3334: Fixed default transfer mode. All back to normal.");
        this.getController().saveConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processV4Format() {
        Properties properties = this.getController().getConfig();
        Set<String> set = FolderSettings.loadEntryIds(properties);
        int n = Runtime.getRuntime().availableProcessors() - 2;
        if (n <= 0) {
            n = 1;
        }
        Semaphore semaphore = new Semaphore(n);
        AtomicInteger atomicInteger = new AtomicInteger();
        for (String string : set) {
            try {
                semaphore.acquire();
            }
            catch (InterruptedException interruptedException) {
                this.logFiner(interruptedException);
                return;
            }
            Runnable runnable = () -> {
                try {
                    Object object;
                    String string2 = properties.getProperty("f." + string + ".id");
                    if (StringUtils.isBlank(string2)) {
                        this.logWarning("Folder id blank. Removed illegal folder config entry: " + string);
                        this.removeConfigEntries(string);
                        return;
                    }
                    Object object2 = FolderSettings.loadFolderName(this.getController().getConfig(), string);
                    if (StringUtils.isBlank((String)object2)) {
                        this.logWarning("Foldername not found.Removed illegal folder config entry: " + (String)object2 + "/" + string);
                        this.removeConfigEntries(string);
                        return;
                    }
                    if (string2.contains("$fromAccount")) {
                        this.logFine("Folder load scheduled after first login: " + (String)object2 + "/" + string);
                        this.onLoginFolderEntryIds.add(string);
                        return;
                    }
                    FolderSettings folderSettings = FolderSettings.load(this.getController(), string);
                    FolderInfo folderInfo = FolderInfoFactory.readFrom(folderSettings.getLocalBaseDir());
                    if (folderInfo == null) {
                        folderInfo = FolderInfoFactory.lookupInstance(string2, (String)object2);
                    } else if (!folderInfo.getId().equals(string2)) {
                        object = folderInfo.getId();
                        folderInfo = FolderInfoFactory.unmarshallExistingFolder(string2, (String)object2, folderInfo.getVersion(), folderInfo.getParent());
                        this.logInfo(folderInfo + ": Adjusted ID, found in 'FolderInfo' meta-data file: " + (String)object + ". Set from config to " + folderInfo.getId());
                    }
                    if (folderSettings == null) {
                        this.logWarning("Unable to load folder settings.Removed folder config entry: " + (String)object2 + "/" + string);
                        this.removeConfigEntries(string);
                        return;
                    }
                    if (folderSettings.getLocalBaseDirString().equals("/encDir")) {
                        object2 = (String)object2 + ".crypto";
                        object = this.getFoldersBasedir().resolve("RECOVERED").resolve((String)object2);
                        Path path = PathUtils.createEmptyDirectory((Path)object);
                        folderSettings = folderSettings.changeBaseDir(path);
                        this.logWarning("Repaired broken encrypted Folder " + (String)object2 + "/" + folderInfo.getId() + ". New storage path: " + path);
                    }
                    if (!this.hasJoinedFolder(folderInfo) && folderSettings != null) {
                        if (ConfigurationEntry.FOLDER_CREATE_ON_STARTUP.getValueBoolean(this.getController()).booleanValue() && Files.notExists(folderSettings.getLocalBaseDir(), new LinkOption[0])) {
                            Files.createDirectories(folderSettings.getLocalBaseDir(), new FileAttribute[0]);
                        }
                        this.createFolder(folderInfo, folderSettings, false, true);
                    }
                }
                catch (Exception exception) {
                    this.logWarning("Problem loading/creating folder #" + string + ". " + exception, exception);
                }
                finally {
                    semaphore.release();
                    AtomicInteger atomicInteger2 = atomicInteger;
                    synchronized (atomicInteger2) {
                        atomicInteger.incrementAndGet();
                        atomicInteger.notify();
                    }
                }
            };
            this.getController().getIOProvider().startIO(runnable);
        }
        while (atomicInteger.get() < set.size()) {
            AtomicInteger atomicInteger2 = atomicInteger;
            synchronized (atomicInteger2) {
                try {
                    atomicInteger.wait(10L);
                }
                catch (InterruptedException interruptedException) {
                    this.logFiner(interruptedException);
                    return;
                }
            }
        }
        this.logInfo("Loaded " + this.getFoldersCount() + " folders");
    }

    public void start() {
        if (!ConfigurationEntry.FOLDER_REPOSITORY_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
            this.logWarning("Not starting FolderRepository. disabled by config");
            return;
        }
        this.folderScanner.start();
        this.myThread = new Thread((Runnable)this, this.getClass().getName());
        this.myThread.setPriority(1);
        this.myThread.start();
        this.fileRequestor.start();
        this.getController().scheduleAndRepeat(new CheckSyncTask(), 120000L, 60000L);
        this.scanBaseDirFuture = this.getController().getThreadPool().scheduleWithFixedDelay(() -> this.scanBasedir(), 10L, 10L, TimeUnit.SECONDS);
        this.locking.start();
        boolean bl = this.getController().getPreferences().getBoolean("is0byteRecoveryRun", false);
        if (!bl && ConfigurationEntry.RECOVER_0BYTE_FILES.getValueBoolean(this.getController()).booleanValue() && !this.getController().getMySelf().isServer()) {
            this.getController().getIOProvider().startIO(() -> {
                try {
                    this.restoreZeroByteFiles();
                    this.getController().getPreferences().putBoolean("is0byteRecoveryRun", true);
                }
                catch (RuntimeException runtimeException) {
                    this.logSevere("An error occured while trying to recover zero byte files: " + runtimeException, runtimeException);
                }
            });
        }
        this.started = true;
    }

    private void restoreZeroByteFiles() {
        this.logFine("Start recovering 0-byte files.");
        for (Folder folder : this.getFolders()) {
            FileArchiver fileArchiver = folder.getFileArchiver();
            for (FileInfo fileInfo : folder.getKnownFiles()) {
                Path path;
                this.logFine("Checking for " + fileInfo);
                if (!fileInfo.getModifiedBy().getNode(this.getController(), true).isServer() || fileInfo.getModifiedByAccount() != null || !fileArchiver.hasArchivedFileInfo(fileInfo) || Files.notExists(path = fileInfo.getDiskFile(this), new LinkOption[0])) continue;
                try {
                    if (Files.size(path) != 0L) continue;
                    this.logFine(fileInfo + " has archived file and was lastly changed by a server " + fileInfo.getModifiedBy() + " and has a size of 0 bytes");
                    List<FileInfo> list = fileArchiver.getSortedArchivedFilesInfos(fileInfo);
                    if (list.isEmpty()) {
                        this.logFine("No history of file " + fileInfo);
                        continue;
                    }
                    FileInfo fileInfo2 = list.get(list.size() - 1);
                    if (fileInfo2.getVersion() < fileInfo.getVersion()) {
                        this.logInfo("Restoring " + fileInfo + " to previous version " + fileInfo2.getVersion());
                        fileArchiver.restore(fileInfo2, path);
                        continue;
                    }
                    this.logFine("Not restoring " + fileInfo + " with version " + fileInfo.getVersion() + " to " + fileInfo2.getVersion());
                }
                catch (IOException iOException) {
                    this.logWarning("Could not check file size while trying to restore last version of " + fileInfo, iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.scanBaseDirFuture != null) {
            this.getController().removeScheduled(this.scanBaseDirFuture);
        }
        Iterator<Folder> iterator = this.folderMembershipSynchronizerLock;
        synchronized (iterator) {
            if (this.folderMembershipSynchronizer != null) {
                this.folderMembershipSynchronizer.canceled.set(true);
            }
        }
        this.folderScanner.shutdown();
        if (this.myThread != null) {
            this.myThread.interrupt();
        }
        iterator = this.scanTrigger;
        synchronized (iterator) {
            this.scanTrigger.notifyAll();
        }
        this.fileRequestor.shutdown();
        for (Folder folder : this.metaFolders.values()) {
            folder.shutdown();
        }
        for (Folder folder : this.folders.values()) {
            folder.shutdown();
        }
        this.folders.clear();
        this.metaFolders.clear();
        this.locking.shutdown();
        try {
            if (Spacetree.isSupported(this.getController())) {
                Spacetree.uninstall();
            }
        }
        catch (Exception exception) {
            this.logWarning("Unable to uninstall Spacetree Windows-Explorer integration. " + exception.getMessage(), exception);
        }
        this.logFine("Stopped");
    }

    public String getFoldersBasedirString() {
        return this.getFoldersBasedir() != null ? this.getFoldersBasedir().toAbsolutePath().toString() : null;
    }

    public Path getFoldersBasedir() {
        if (this.foldersBasedir == null) {
            this.initFoldersBasedir();
        }
        return this.foldersBasedir;
    }

    public void setFoldersBasedir(String string) {
        if (string == null) {
            ConfigurationEntry.FOLDER_BASEDIR.removeValue(this.getController());
            return;
        }
        String string2 = ConfigurationEntry.FOLDER_BASEDIR.getValue(this.getController());
        String string3 = PreferencesEntry.FOLDER_BASE_PATH.getValueString(this.getController());
        ConfigurationEntry.FOLDER_BASEDIR.setValue(this.getController(), string);
        PreferencesEntry.FOLDER_BASE_PATH.setValue(this.getController(), string);
        if (!this.initFoldersBasedir()) {
            ConfigurationEntry.FOLDER_BASEDIR.setValue(this.getController(), string2);
            PreferencesEntry.FOLDER_BASE_PATH.setValue(this.getController(), string3);
        }
    }

    public FileRequestor getFileRequestor() {
        return this.fileRequestor;
    }

    public boolean hasJoinedFolder(FolderInfo folderInfo) {
        if (!folderInfo.isMetaFolder()) {
            return this.folders.containsKey(folderInfo);
        }
        for (Folder folder : this.metaFolders.values()) {
            if (!folder.getInfo().equals(folderInfo)) continue;
            return true;
        }
        return false;
    }

    public Folder getFolder(String string) {
        return this.getFolder(FolderInfoFactory.lookupInstance(string));
    }

    public Folder getFolder(FolderInfo folderInfo) {
        if (!folderInfo.isMetaFolder()) {
            return this.folders.get(folderInfo);
        }
        for (Folder folder : this.metaFolders.values()) {
            if (!folder.getInfo().equals(folderInfo)) continue;
            return folder;
        }
        return null;
    }

    public Folder getSubFolder(DirectoryInfo directoryInfo) {
        Reject.ifNull(directoryInfo, "Location");
        for (Folder folder : this.folders.values()) {
            if (!directoryInfo.equals(folder.getInfo().getLocation())) continue;
            return folder;
        }
        return null;
    }

    public Collection<Folder> getFolders() {
        return this.getFolders(false);
    }

    public Collection<Folder> getFolders(boolean bl) {
        if (!bl) {
            return Collections.unmodifiableCollection(this.folders.values());
        }
        CompositeCollection compositeCollection = new CompositeCollection();
        compositeCollection.addComposited((Collection)this.folders.values(), (Collection)this.metaFolders.values());
        return Collections.unmodifiableCollection(compositeCollection);
    }

    public int getFoldersCount() {
        return this.getFoldersCount(false);
    }

    public int getFoldersCount(boolean bl) {
        return this.folders.size() + (bl ? this.metaFolders.size() : 0);
    }

    public int getFolderProblemsCount() {
        int n = 0;
        for (Folder folder : this.getFolders()) {
            n += folder.getProblems().size();
        }
        return n;
    }

    public Collection<FolderInfo> getJoinedFolderInfos() {
        return Collections.unmodifiableCollection(this.folders.keySet());
    }

    public Folder findExistingFolder(Path path) {
        return this.findExistingFolder(path, true);
    }

    public Folder findExistingFolder(Path path, boolean bl) {
        if (!path.isAbsolute()) {
            path = this.foldersBasedir.resolve(path);
            this.logInfo("Original path: " + path + ". Choosen relative path: " + path);
        }
        for (Folder folder : this.getController().getFolderRepository().getFolders()) {
            if (folder.getLocalBase().equals(path)) {
                return folder;
            }
            if (!bl) continue;
            try {
                if (!folder.getCommitOrLocalDir().toRealPath(new LinkOption[0]).equals(path.toRealPath(new LinkOption[0]))) continue;
                return folder;
            }
            catch (IOException iOException) {
                this.logFine("Unable to access: " + folder.getLocalBase() + ". " + iOException);
            }
        }
        return null;
    }

    public Folder findExistingFolder(String string) {
        for (Folder folder : this.getController().getFolderRepository().getFolders()) {
            if (!folder.getName().equalsIgnoreCase(string)) continue;
            return folder;
        }
        return null;
    }

    public Folder findContainingFolder(Path path) {
        for (Folder folder : this.folders.values()) {
            if (!path.startsWith(folder.getLocalBase().toAbsolutePath())) continue;
            return folder;
        }
        return null;
    }

    public Folder createFolder(FolderInfo folderInfo, FolderSettings folderSettings) {
        Object object;
        try {
            String string;
            Path path;
            if (ConfigurationEntry.FOLDER_CREATE_USE_EXISTING.getValueBoolean(this.getController()).booleanValue()) {
                Files.createDirectories(folderSettings.getLocalBaseDir(), new FileAttribute[0]);
            } else if (!(!Files.notExists(folderSettings.getLocalBaseDir(), new LinkOption[0]) && PathUtils.isEmptyDir(folderSettings.getLocalBaseDir()) || (path = PathUtils.createEmptyDirectory((Path)(object = folderSettings.getLocalBaseDir().getParent()), string = folderSettings.getLocalBaseDir().getFileName().toString())).equals(object))) {
                folderSettings = folderSettings.changeBaseDir(path);
            }
        }
        catch (IOException iOException) {
            this.logWarning("Unable to create Folder: " + folderInfo.getName() + " @ " + folderSettings.getLocalBaseDir() + " : " + iOException.getMessage());
        }
        object = this.createFolder(folderInfo, folderSettings, true, true);
        if (this.getController().getOSClient().isLoggedIn() && !this.getController().getOSClient().getAccount().hasPermission(FolderPermission.read(folderInfo))) {
            this.getController().getTaskManager().scheduleTask(new FolderObtainPermissionTask(this.getController().getOSClient().getAccountInfo(), ((Folder)object).getInfo()));
        }
        return object;
    }

    public Folder createFolder(FolderInfo folderInfo, FolderSettings folderSettings, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        Object object3;
        boolean bl3;
        Reject.ifNull(folderInfo, "FolderInfo is null");
        Reject.ifNull(folderSettings, "FolderSettings is null");
        if (this.hasJoinedFolder(folderInfo)) {
            Folder folder = this.folders.get(folderInfo);
            if (!folder.getLocalBase().equals(folderSettings.getLocalBaseDir())) {
                this.logWarning("Tried to create new folder " + folderInfo.getName() + " @ " + folderSettings.getLocalBaseDirString() + ", but already existing @ " + folder.getLocalBase());
            }
            return folder;
        }
        Object object4 = this.folders.values().iterator();
        while (object4.hasNext()) {
            Folder folder = object4.next();
            if (!folder.getCommitOrLocalDir().equals(folderSettings.getLocalBaseDir())) continue;
            this.logWarning("Tried to create duplicate folder " + folder.getName() + ". at " + folder.getCommitOrLocalDir() + ". Existing folder ID: " + folder.getId() + ". Requested folder ID: " + folderInfo.getId() + ". " + folderSettings.getLocalBaseDir());
            throw new IllegalStateException("Tried to create duplicate folder " + folder.getName() + ". at " + folder.getCommitOrLocalDir() + ". Existing folder ID: " + folder.getId() + ". Requested folder ID: " + folderInfo.getId() + ". " + folderSettings.getLocalBaseDir());
        }
        if (ConfigurationEntry.FOLDER_CREATE_IN_BASEDIR_ONLY.getValueBoolean(this.getController()).booleanValue() && (object4 = folderSettings.getLocalBaseDir().getParent()) != null && !(bl3 = object4.equals(this.getFoldersBasedir()))) {
            this.logWarning("Not allowed to create " + folderInfo + " at " + folderSettings.getLocalBaseDir() + ". Must be in base directory: " + this.getFoldersBasedir());
            throw new IllegalStateException("Not allowed to create " + folderInfo + " at " + folderSettings.getLocalBaseDir() + ". Must be in base directory: " + this.getFoldersBasedir());
        }
        object4 = folderSettings.getLocalBaseDir();
        if (!ConfigurationEntry.FOLDER_CREATE_ALLOW_NETWORK.getValueBoolean(this.getController()).booleanValue() && Files.exists((Path)object4, new LinkOption[0])) {
            try {
                if (Files.isSymbolicLink((Path)object4)) {
                    object4 = object4.toRealPath(new LinkOption[0]);
                }
            }
            catch (IOException iOException) {
                this.logWarning("Failed to resolve symlink at " + (Path)object4 + " for " + folderInfo);
                throw new IllegalStateException("Failed to resolve symlink at " + (Path)object4 + " for " + folderInfo);
            }
            try {
                if (PathUtils.isNetworkPath((Path)object4)) {
                    if (bl) {
                        this.getController().saveConfig();
                    }
                    this.logWarning("Not allowed to create " + folderInfo + " at " + folderSettings.getLocalBaseDir() + ". Network shares not allowed");
                    throw new IllegalStateException("Not allowed to create " + folderInfo + " at " + folderSettings.getLocalBaseDir() + ". Network shares not allowed");
                }
            }
            catch (IOException iOException) {
                this.logWarning("Failed to resolve symlink at " + (Path)object4);
                throw new IllegalStateException("Failed to resolve symlink at " + (Path)object4 + " for " + folderInfo);
            }
        }
        if (folderSettings.getLocalBaseDirString().toLowerCase().startsWith("http") && OSUtil.isLinux()) {
            String string = folderSettings.getLocalBaseDirString();
            if (string.contains("http") && !string.contains("://")) {
                string = string.replace(":/", "://");
            }
            object3 = this.getFoldersBasedir();
            object2 = PathUtils.removeInvalidFilenameChars(folderInfo.getLocalizedName() + ".webdav");
            object = object3.resolve("webdav").resolve((String)object2);
            try {
                String string2 = LinuxUtil.mountWebDAV(string, (Path)object);
                if (string2.startsWith("N")) {
                    this.logSevere("Failed to mount " + folderInfo + " as WebDAV resource. Error message: " + string2);
                }
                folderSettings = folderSettings.changeBaseDir((Path)object);
            }
            catch (MalformedURLException malformedURLException) {
                this.logSevere("Failed to mount " + folderInfo + " as WebDAV resource @ " + malformedURLException, malformedURLException);
            }
        } else if (folderSettings.getLocalBaseDir().toString().contains(".webdav") && !OSUtil.isLinux()) {
            this.logSevere("WebDAV folder mounting is only supported with Linux as operating system.");
            throw new IllegalStateException("WebDAV folder mounting is only supported with Linux as operating system.");
        }
        Folder folder = new Folder(this.getController(), folderInfo, folderSettings);
        folder.addProblemListener(this.valveProblemListenerSupport);
        object3 = folder.getInfo().getMetaFolderInfo();
        object2 = folder.getSystemSubDir();
        object = new FolderSettings(object2.resolve("meta"), SyncProfile.META_FOLDER_SYNC, 0);
        boolean bl4 = folder.checkIfDeviceDisconnected();
        if (!bl4) {
            try {
                if (Files.notExists(((FolderSettings)object).getLocalBaseDir(), new LinkOption[0])) {
                    Files.createDirectory(((FolderSettings)object).getLocalBaseDir(), new FileAttribute[0]);
                }
            }
            catch (IOException iOException) {
                this.logInfo("Unable to create metafolder directory: " + ((FolderSettings)object).getLocalBaseDir() + "." + iOException.toString());
            }
        }
        Folder folder2 = new Folder(this.getController(), (FolderInfo)object3, (FolderSettings)object);
        if (!bl4) {
            try {
                if (Files.notExists(folder2.getSystemSubDir(), new LinkOption[0])) {
                    Files.createDirectory(folder2.getSystemSubDir(), new FileAttribute[0]);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.metaFolders.containsKey(folderInfo)) {
            this.logWarning("Meta " + folderInfo + " already in meta folders list");
        }
        this.metaFolders.put(folderInfo, folder2);
        if (this.folders.containsKey(folderInfo)) {
            this.logWarning(folderInfo + " already in folders list");
        }
        this.folders.put(folder.getInfo(), folder);
        this.saveFolderConfig(folderInfo, folderSettings, bl);
        if (!folder2.hasOwnDatabase()) {
            folder2.setSyncProfile(SyncProfile.MANUAL_SYNCHRONIZATION);
            folder2.recommendScanOnNextMaintenance(true);
        }
        this.logFine("Created metaFolder " + ((FolderInfo)object3).getName() + ", local copy at '" + ((FolderSettings)object).getLocalBaseDir() + "'");
        this.triggerSynchronizeAllFolderMemberships();
        folder.getStatistic().scheduleCalculate();
        this.getController().getFolderRepository().triggerMaintenance();
        if (folder.hasOwnDatabase()) {
            this.fileRequestor.triggerFileRequesting(folder.getInfo());
        }
        if (bl2) {
            this.fireFolderCreated(folder);
        }
        if (this.isFine()) {
            String string = "Setup folder " + folderInfo + " at " + folder.getLocalBase();
            this.logFine(string);
        }
        this.removeFromIgnoredFolders(folder);
        WrappedScheduledThreadPoolExecutor.setWarningLevel(this.getFoldersCount());
        return folder;
    }

    public void saveFolderConfig(FolderInfo folderInfo, FolderSettings folderSettings, boolean bl) {
        Properties properties = this.getController().getConfig();
        folderSettings.set(folderInfo, properties);
        if (bl) {
            this.getController().saveConfig();
        }
    }

    public void removeFolder(Folder folder, boolean bl) {
        this.removeFolder(folder, bl, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFolder(Folder folder, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        block20: {
            Reject.ifNull(folder, "Folder is null");
            bl4 = PathUtils.isWebDAVFolder(folder.getLocalBase());
            try {
                Folder folder2;
                this.scanBasedirLock.lock();
                this.removeLink(folder);
                folder.removeDesktopShortcut();
                folder.clearAllProblemListeners();
                if (OSUtil.isWindowsSystem()) {
                    PathUtils.deleteDesktopIni(folder.getLocalBase());
                }
                this.removeConfigEntries(folder.getConfigEntryId());
                if (bl2) {
                    this.getController().saveConfig();
                }
                if ((folder2 = this.getMetaFolder(folder.getInfo())) != null) {
                    this.metaFolders.remove(folder2.getInfo());
                    this.metaFolders.remove(folder.getInfo());
                    this.getController().getTransferManager().breakTransfers(folder2.getInfo());
                    folder2.shutdown();
                }
                this.folders.remove(folder.getInfo());
                folder.removeProblemListener(this.valveProblemListenerSupport);
                this.getController().getTransferManager().breakTransfers(folder.getInfo());
                folder.shutdown();
                this.triggerSynchronizeAllFolderMemberships();
                boolean bl5 = folder.equals(this.folderScanner.getCurrentScanningFolder());
                if (bl5) {
                    this.folderScanner.abortScan();
                }
                if (!bl) break block20;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    PathUtils.recursiveDeleteVisitor(folder.getSystemSubDir());
                }
                catch (IOException iOException) {
                    this.logWarning("Failed to delete: " + folder.getSystemSubDir() + ". " + iOException);
                }
                if (bl4) break block20;
                Path path = folder.getLocalBase();
                try {
                    if (EncryptedFileSystemUtils.isCryptoInstance(path) && PathUtils.isEmptyDir(path)) {
                        PathUtils.recursiveDeleteVisitor(EncryptedFileSystemUtils.getPhysicalStorageLocation(path));
                        break block20;
                    }
                    Files.delete(path);
                }
                catch (DirectoryNotEmptyException | NoSuchFileException fileSystemException) {
                }
                catch (IOException iOException) {
                    this.logSevere("Failed to delete local base: " + path.toAbsolutePath() + ": " + iOException);
                }
            }
            finally {
                this.scanBasedirLock.unlock();
            }
        }
        if (bl3) {
            this.fireFolderRemoved(folder);
        }
        this.fileRequestor.triggerFileRequesting();
        if (this.isFine()) {
            this.logFine(folder + " removed");
        }
        if (bl && !bl4 && EncryptedFileSystemUtils.isCryptoInstance(folder.getLocalBase())) {
            try {
                folder.getLocalBase().getFileSystem().close();
            }
            catch (IOException | FileSystemNotFoundException exception) {
                this.logWarning("Failed to close FileSystem for encrypted folder " + folder);
            }
        }
    }

    private void removeLink(Folder folder) {
        FolderRepository folderRepository = this.getController().getFolderRepository();
        Path path = folderRepository.getFoldersBasedir();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                Path path2 = path.resolve(folder.getName() + ".lnk");
                boolean bl = Files.deleteIfExists(path2);
                this.logFine("Removed link " + path2.getFileName() + "? " + bl);
            }
            catch (Exception exception) {
                this.logWarning(exception.getMessage());
            }
        }
    }

    public void addToIgnoredFolders(Folder folder) {
        Path path = folder.getLocalBase();
        if (this.ignoredFolderDirectories.add(path)) {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<Path> iterator = this.ignoredFolderDirectories.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toAbsolutePath().toString();
                stringBuilder.append(string);
                if (!iterator.hasNext()) continue;
                stringBuilder.append('$');
            }
            ConfigurationEntry.AUTO_SETUP_FOLDERS_IGNORED.setValue(this.getController(), stringBuilder.toString());
        }
    }

    private void removeFromIgnoredFolders(Folder folder) {
        if (this.ignoredFolderDirectories.remove(folder.getLocalBase())) {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<Path> iterator = this.ignoredFolderDirectories.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toAbsolutePath().toString();
                stringBuilder.append(string);
                if (!iterator.hasNext()) continue;
                stringBuilder.append('$');
            }
            ConfigurationEntry.AUTO_SETUP_FOLDERS_IGNORED.setValue(this.getController(), stringBuilder.toString());
        }
    }

    public void removeFromAllFolders(Member member) {
        if (this.isFiner()) {
            this.logFiner("Removing node from all folders: " + member);
        }
        for (Folder folder : this.getFolders(true)) {
            folder.remove(member);
        }
        if (this.isFiner()) {
            this.logFiner("Node removed from all folders: " + member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerSynchronizeAllFolderMemberships() {
        if (!this.started) {
            this.logFiner("Not synchronizing Foldermemberships, repo not started, yet");
        }
        Object object = this.folderMembershipSynchronizerLock;
        synchronized (object) {
            if (this.folderMembershipSynchronizer != null) {
                this.folderMembershipSynchronizer.canceled.set(true);
            }
            this.folderMembershipSynchronizer = new AllFolderMembershipSynchronizer();
            this.getController().getIOProvider().startIO(this.folderMembershipSynchronizer);
        }
    }

    public void broadcastScanCommandOnAllFolders() {
        if (log.isLoggable(Level.FINE)) {
            this.logFine("Sending remote scan commando");
        }
        for (Folder folder : this.getFolders(true)) {
            folder.broadcastScanCommand();
        }
    }

    public Folder getCurrentlyMaintainingFolder() {
        return this.currentlyMaintainingFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerMaintenance() {
        if (this.isFiner()) {
            this.logFiner("Scan triggerd");
        }
        this.triggered = true;
        Object object = this.scanTrigger;
        synchronized (object) {
            this.scanTrigger.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Waiter waiter = new Waiter(30000L);
        while (!(waiter.isTimeout() || this.getController().isUIEnabled() && this.getController().isUIOpen() || this.getController().isStarted())) {
            try {
                waiter.waitABit();
            }
            catch (Exception exception) {
                return;
            }
        }
        ArrayList<Folder> arrayList = new ArrayList<Folder>();
        Controller controller = this.getController();
        while (!this.myThread.isInterrupted() && this.myThread.isAlive()) {
            Iterator<Folder> iterator;
            if (!controller.isPaused()) {
                arrayList.clear();
                for (Folder folder : this.folders.values()) {
                    if (!folder.isMaintenanceRequired()) continue;
                    arrayList.add(folder);
                }
                for (Folder folder : this.metaFolders.values()) {
                    if (!folder.isMaintenanceRequired()) continue;
                    arrayList.add(folder);
                }
                arrayList.sort(FolderComparator.INSTANCE);
                if (this.isFiner()) {
                    this.logFiner("Maintaining " + arrayList.size() + " folders...");
                }
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    Folder folder;
                    this.currentlyMaintainingFolder = folder = iterator.next();
                    this.fireMaintanceStarted(this.currentlyMaintainingFolder);
                    try {
                        this.currentlyMaintainingFolder.maintain();
                    }
                    catch (RuntimeException runtimeException) {
                        this.logWarning("Unable to maintain folder " + this.currentlyMaintainingFolder.getName() + "/" + this.currentlyMaintainingFolder.getId() + ": " + runtimeException, runtimeException);
                    }
                    Folder folder2 = this.currentlyMaintainingFolder;
                    this.currentlyMaintainingFolder = null;
                    this.fireMaintenanceFinished(folder2);
                    if (controller.isPaused() || this.myThread.isInterrupted()) break;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
                if (this.isFiner()) {
                    this.logFiner("Maintained " + arrayList.size() + " folder(s)");
                }
            }
            if (!this.triggered) {
                try {
                    iterator = this.scanTrigger;
                    synchronized (iterator) {
                        this.scanTrigger.wait(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.logFiner(interruptedException);
                    break;
                }
            }
            this.triggered = false;
        }
    }

    public String toString() {
        return "Folders of " + this.getController().getMySelf().getNick();
    }

    public void setSuspendNewFolderSearch(boolean bl) {
        if (bl) {
            this.suspendNewFolderSearch.incrementAndGet();
        } else {
            this.suspendNewFolderSearch.decrementAndGet();
        }
        this.logFine("setSuspendNewFolderSearch to " + bl + " now: " + this.suspendNewFolderSearch.get());
    }

    public boolean scanBasedir() {
        if (this.suspendNewFolderSearch.get() > 0) {
            return false;
        }
        this.scanBasedirLock.lock();
        boolean bl = false;
        try {
            if (ConfigurationEntry.LOOK_FOR_FOLDER_CANDIDATES.getValueBoolean(this.getController()).booleanValue()) {
                bl = this.lookForNewFolders();
            }
            if (ConfigurationEntry.LOOK_FOR_FOLDERS_TO_BE_REMOVED.getValueBoolean(this.getController()).booleanValue()) {
                bl = this.lookForFoldersToBeRemoved() && bl;
            }
        }
        finally {
            this.scanBasedirLock.unlock();
        }
        return bl;
    }

    private boolean lookForNewFolders() {
        DirectoryStream<Path> directoryStream;
        Object object;
        if (!this.getMySelf().isServer()) {
            if (!this.getController().getOSClient().isLoggedIn()) {
                if (this.isFine()) {
                    this.logFine("Skipping searching for new folders... (not logged in)");
                }
                return false;
            }
            if (!this.getController().getOSClient().isAllowedToCreateFolders()) {
                if (this.isFine()) {
                    this.logFine("Skipping searching for new folders (no permission)...");
                }
                return false;
            }
            object = this.getController().getOSClient().getAccount();
            if (!((Account)object).hasOwnStorage()) {
                if (this.isFine()) {
                    this.logFine("Account " + ((Account)object).getUsername() + " does not have storage, not checking for new folders.");
                }
                if (this.getController().isUIEnabled()) {
                    WarningNotice warningNotice = new WarningNotice(Translation.get("warning_notice.title"), Translation.get("warning_notice.no_folder_create_summary"), Translation.get("warning_notice.no_folder_create_message"));
                    this.getController().getUIController().getApplicationModel().getNoticesModel().handleNotice(warningNotice);
                }
                return false;
            }
        }
        if (this.getController().isPaused()) {
            this.logFine("Skipping searching for new folders (paused)...");
            return false;
        }
        if (this.isFine()) {
            this.logFine("Searching for new folders...");
        }
        if (Files.notExists((Path)(object = this.getFoldersBasedir()), new LinkOption[0]) || !Files.isReadable((Path)object)) {
            return false;
        }
        DirectoryStream.Filter<Path> filter = path -> {
            String string = path.getFileName().toString();
            if (string.equals(Constants.POWERFOLDER_SYSTEM_SUBDIR)) {
                return false;
            }
            if (string.equals(ConfigurationEntry.FOLDER_BASEDIR_DELETED_DIR.getValue(this.getController())) || string.equals(ConfigurationEntry.FOLDER_BASEDIR_DELETED_DIR.getDefaultValue())) {
                return false;
            }
            if (string.equals("RECOVERED")) {
                return false;
            }
            if (string.equalsIgnoreCase(DIRNAME_SNAPSHOT)) {
                return false;
            }
            if (!Files.isDirectory(path, new LinkOption[0])) {
                return false;
            }
            if (string.contains(".crypto")) {
                return false;
            }
            if (string.endsWith(".webdav")) {
                return false;
            }
            if (ConfigurationEntry.AUTO_SETUP_FOLDERS_IGNORED.getValue(this.getController()).contains(string)) {
                return false;
            }
            return !this.isIgnoredFolderDirectory((Path)path);
        };
        try {
            directoryStream = Files.newDirectoryStream((Path)object, filter);
            try {
                for (Path path2 : directoryStream) {
                    boolean bl = false;
                    for (Folder folder : this.getFolders()) {
                        if (!this.getMySelf().isServer() && folder.getName().equals(path2.getFileName().toString())) {
                            bl = true;
                            break;
                        }
                        Path path3 = folder.getPhysicalDir();
                        if (Files.isSymbolicLink(path3)) {
                            path3 = path3.toRealPath(new LinkOption[0]);
                        }
                        if (Files.isSymbolicLink(path2)) {
                            path2 = path2.toRealPath(new LinkOption[0]);
                        }
                        if (!path3.equals(path3.getFileSystem().getPath(path2.toString(), new String[0])) && !path3.toAbsolutePath().startsWith(path3.getFileSystem().getPath(path2.toAbsolutePath().toString(), new String[0])) && !path3.toAbsolutePath().startsWith(path2.toAbsolutePath()) && !path3.equals(path2)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    this.handleNewFolder(path2);
                }
            }
            finally {
                if (directoryStream != null) {
                    directoryStream.close();
                }
            }
        }
        catch (IOException iOException) {
            this.logWarning("Could not access base dir while looking for new folders @ " + object.toString() + ". " + iOException.toString());
            return false;
        }
        if (!this.getMySelf().isServer() && this.getController().isUIEnabled()) {
            filter = path -> {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    return false;
                }
                if (PathUtils.isDesktopIni(path)) {
                    return false;
                }
                if (path.getFileName().toString().toLowerCase().endsWith(".lnk")) {
                    return false;
                }
                if (path.getFileName().toString().equalsIgnoreCase("Getting started.pdf")) {
                    return false;
                }
                try {
                    if (Files.isHidden(path)) {
                        return false;
                    }
                }
                catch (IOException iOException) {
                    this.logFine("Could not find out if '" + path.toAbsolutePath().toString() + "' is hidden. " + iOException);
                    return false;
                }
                return true;
            };
            this.getController().getUIController().getApplicationModel().getNoticesModel().clearAllFileInBasePathWarnings();
            try {
                directoryStream = Files.newDirectoryStream((Path)object, filter);
                try {
                    for (Path path2 : directoryStream) {
                        FileInBasePathWarning fileInBasePathWarning = new FileInBasePathWarning(Translation.get("notice.file_in_base_path.title"), Translation.get("notice.file_in_base_path.message"), Translation.get("notice.file_in_base_path.summary", path2.getFileName().toString(), this.getController().getDistribution().getName(), path2.toString()));
                        this.getController().getUIController().getApplicationModel().getNoticesModel().handleNotice(fileInBasePathWarning);
                    }
                }
                finally {
                    if (directoryStream != null) {
                        directoryStream.close();
                    }
                }
            }
            catch (IOException iOException) {
                this.logWarning(iOException);
            }
        }
        return true;
    }

    private boolean isIgnoredFolderDirectory(Path path) {
        boolean bl;
        boolean bl2 = this.ignoredFolderDirectories.contains(path);
        boolean bl3 = bl = this.checkSystemSubdirForFolder(path) != null && this.isFolderRenamed(path);
        if (bl2) {
            if (bl) {
                this.ignoredFolderDirectories.remove(path);
                return false;
            }
            return true;
        }
        if (path.getFileName() == null) {
            return false;
        }
        for (Path path2 : this.ignoredFolderDirectories) {
            if (path2.getFileName() == null || !path2.getFileName().equals(path.getFileName())) continue;
            bl2 = true;
        }
        return bl2;
    }

    private boolean isFolderRenamed(Path path) {
        String string;
        Path path2 = path.resolve(Constants.POWERFOLDER_SYSTEM_SUBDIR).resolve("FolderStatistic");
        FolderStatisticInfo folderStatisticInfo = FolderStatisticInfo.load(path2);
        if (folderStatisticInfo == null) {
            return false;
        }
        if (path.getFileName() == null) {
            return false;
        }
        String string2 = path.getFileName().toString();
        return !PathUtils.isSameName(string2, string = folderStatisticInfo.getFolder().getLocalizedName());
    }

    private void handleNewFolder(Path path) {
        Object object2;
        if (this.getController().isShuttingDown() || !this.getController().isStarted()) {
            return;
        }
        Object object3 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        ServerClient serverClient = this.getController().getOSClient();
        if (serverClient.isConnected() && serverClient.isLoggedIn()) {
            object3 = this.checkSystemSubdirForFolder(path);
            bl2 = this.folderStillExists((FolderInfo)object3);
            if (object3 != null) {
                try {
                    Object object4;
                    object2 = ((FolderInfo)object3).getFolder(this.getController());
                    if (object2 != null && ((Folder)object2).checkIfDeviceDisconnected()) {
                        this.removeFolder((Folder)object2, false, false, true);
                    }
                    if ((object4 = this.tryRenaming(serverClient, path, (FolderInfo)object3, bl2)) != null && ((FolderInfo)object4).equals(object3) && !((FolderInfo)object4).getName().equals(((FolderInfo)object3).getName())) {
                        object3 = object4;
                        bl = true;
                    }
                }
                catch (FolderRenameException folderRenameException) {
                    this.logInfo("Could not rename Folder on server " + folderRenameException);
                    this.logFine(folderRenameException);
                }
            } else {
                object2 = path.getFileName().toString();
                for (FolderInfo object5 : serverClient.getAccount().getFolders()) {
                    if (!PathUtils.isSameName(object5.getLocalizedName(), (String)object2)) continue;
                    boolean bl4 = ((String)object2).contains("(") && ((String)object2).endsWith(")");
                    boolean bl5 = serverClient.getAccount().hasOwnerPermission(object5);
                    if (bl4 && !bl5) {
                        this.logInfo("Found existing folder ID " + object5.getId() + " for received folder " + (String)object2);
                        object3 = object5;
                        continue;
                    }
                    if (bl4 || !bl5) continue;
                    this.logInfo("Found existing folder ID " + object5.getId() + " for own folder " + (String)object2);
                    object3 = object5;
                }
            }
        } else if (this.getMySelf().isServer()) {
            object3 = this.checkSystemSubdirForFolder(path);
            bl2 = this.folderStillExists((FolderInfo)object3);
        }
        this.logInfo("handleNewFolder.p1 of " + path);
        if (object3 != null) {
            this.logInfo(" Folder name: " + ((FolderInfo)object3).getLocalizedName());
            this.logInfo(" Folder ID: " + ((FolderInfo)object3).getId());
            this.logInfo(" Folder Version: " + ((FolderInfo)object3).getVersion());
        }
        this.logInfo(" renamedOnServer: " + bl);
        this.logInfo(" stillPresent: " + bl2);
        if (object3 == null) {
            object3 = FolderInfoFactory.newTopFolder(path.getFileName().toString());
            bl3 = true;
        } else if (!this.getController().getSecurityManager().hasPermission(this.getMySelf().getInfo(), (Permission)FolderPermission.read((FolderInfo)object3))) {
            this.cleanupMetaInformation(path);
            object3 = FolderInfoFactory.newTopFolder(path.getFileName().toString());
            bl3 = true;
        }
        this.logInfo(" createdNew: " + bl3);
        object2 = new FolderSettings(path, SyncProfile.getDefault(this.getController()), ConfigurationEntry.DEFAULT_ARCHIVE_VERSIONS.getValueInt(this.getController()));
        boolean bl6 = false;
        if (serverClient.isBackupByDefault() && !serverClient.joinedByServer((FolderInfo)object3)) {
            try {
                this.getController().getOSClient().getFolderService().createFolder((FolderInfo)object3, null);
                if (serverClient.getAccount().hasAdminPermission((FolderInfo)object3)) {
                    this.getController().getOSClient().getFolderService((FolderInfo)object3).setArchiveMode((FolderInfo)object3, ((FolderSettings)object2).getVersions());
                }
            }
            catch (Exception exception) {
                bl6 = true;
            }
        }
        Folder folder = this.createFolder((FolderInfo)object3, (FolderSettings)object2, true, true);
        folder.addDefaultExcludes();
        if (bl6) {
            this.logFine("Scheduling setup of folder: " + ((FolderInfo)object3).getName());
            CreateFolderOnServerTask createFolderOnServerTask = new CreateFolderOnServerTask((FolderInfo)object3, null);
            createFolderOnServerTask.setArchiveVersions(((FolderSettings)object2).getVersions());
            this.getController().getTaskManager().scheduleTask(createFolderOnServerTask);
        }
        this.logInfo("Auto-setup " + (bl3 ? "new" : "existing") + " folder: " + folder.getName() + "/" + folder.getId() + " @ " + folder.getLocalBase());
        if (!bl && bl3) {
            this.folderAutoCreateListener.folderAutoCreated(new FolderAutoCreateEvent((FolderInfo)object3));
        }
        this.logInfo("handleNewFolder.p2 of " + path);
        this.logInfo(" Folder name: " + ((FolderInfo)object3).getLocalizedName());
        this.logInfo(" Folder ID: " + ((FolderInfo)object3).getId());
        this.logInfo(" Folder Version: " + ((FolderInfo)object3).getVersion());
        this.logInfo(" renamedOnServer: " + bl);
        this.logInfo(" stillPresent: " + bl2);
        this.logInfo(" createdNew: " + bl3);
    }

    private void cleanupMetaInformation(Path path) {
        Reject.ifNull(path, "Base dir is null");
        try {
            Path path2 = path.resolve(Constants.POWERFOLDER_SYSTEM_SUBDIR);
            Path path3 = path2.resolve("meta");
            Files.deleteIfExists(path3.resolve("Members"));
            Files.deleteIfExists(path2.resolve("FolderStatistic"));
            Files.deleteIfExists(path2.resolve(Constants.DB_FILENAME));
            Files.deleteIfExists(path2.resolve(Constants.DB_BACKUP_FILENAME));
            PathUtils.recursiveDelete(path3.resolve("locks"));
        }
        catch (IOException iOException) {
            this.logInfo("Could not delete members list and/or lock files in case of possible hijack. " + iOException);
        }
    }

    public FolderInfo renameFolder(FolderInfo folderInfo, String string) {
        Reject.ifNull(folderInfo, "folder info is null");
        Reject.ifBlank(string, "New name is blank");
        if (folderInfo.getName().equals(string)) {
            return folderInfo;
        }
        FolderInfo folderInfo2 = FolderInfoFactory.rename(folderInfo, string);
        this.renameFolder(folderInfo2, false, null);
        return folderInfo2;
    }

    public boolean renameFolder(FolderInfo folderInfo, boolean bl, String string) {
        Reject.ifNull(folderInfo, "folder info is null");
        folderInfo.intern(true);
        Folder folder = this.folders.get(folderInfo);
        if (folder == null) {
            return false;
        }
        folder.updateInfo(folderInfo);
        this.folders.remove(folderInfo);
        this.folders.put(folderInfo, folder);
        Folder folder2 = this.getMetaFolder(folderInfo);
        if (folder2 != null) {
            folder2.updateInfo(folderInfo.getMetaFolderInfo());
            this.metaFolders.remove(folderInfo);
            this.metaFolders.put(folderInfo, folder2);
        }
        if (bl &= !PathUtils.isSameName(folder.getLocalBase().getFileName().toString(), folderInfo.getLocalizedName())) {
            Path path;
            Object object = PathUtils.removeInvalidFilenameChars(folderInfo.getLocalizedName());
            if (StringUtils.isNotBlank(string)) {
                object = (String)object + " (";
                object = (String)object + PathUtils.removeInvalidFilenameChars(string);
                object = (String)object + ")";
            }
            if ((folder = this.moveLocalFolder(folder, path = folder.getLocalBase().getParent().resolve((String)object), true)) == null) {
                this.logWarning(folderInfo + ": Failed to move to new directory " + path);
                return false;
            }
        } else {
            for (Member member : folder.getConnectedMembers()) {
                member.synchronizeFolderMemberships(null, true);
            }
        }
        this.logFine(folderInfo + ": Rename done");
        return true;
    }

    private FolderInfo tryRenaming(ServerClient serverClient, Path path, FolderInfo folderInfo, boolean bl) throws FolderRenameException {
        Folder folder = folderInfo.getFolder(this.getController());
        FolderInfo object2 = null;
        for (FolderInfo object3 : serverClient.getAccountFolders()) {
            if (!object3.getLocalizedName().equals(path.getFileName().toString())) continue;
            object2 = object3;
            break;
        }
        if (folderInfo == null) {
            return object2;
        }
        String string = folderInfo.getName();
        String string2 = path.getFileName().toString();
        this.logInfo("tryRenaming");
        this.logInfo(" file: " + path);
        this.logInfo(" name: " + folderInfo.getName());
        this.logInfo(" ID: " + folderInfo.getId());
        this.logInfo(" knownFolderWithSameName: " + object2);
        this.logInfo(" stillPresent: " + bl);
        if (object2 == null && !PathUtils.isSameName(string, string2) && !bl) {
            this.logInfo("Renaming " + folderInfo + " to '" + string2 + "'");
            if (folder != null && folder.checkIfDeviceDisconnected()) {
                this.removeFolder(folder, false, false, true);
                this.ignoredFolderDirectories.remove(folder.getLocalBase());
            }
            FolderService folderService = serverClient.getFolderService(folderInfo);
            try {
                boolean securityException = this.getController().getSecurityManager().hasPermission(this.getMySelf().getInfo(), (Permission)FolderPermission.admin(folderInfo));
                if (!securityException || !folderService.renameFolder(folderInfo, string2)) {
                    this.logWarning("Could not rename the Folder " + (String)string + " on the server to " + folderInfo.getName());
                    String string3 = string2;
                    Object object = string;
                    if (this.getController().isUIEnabled() && this.getController().getUIController().isStarted()) {
                        UIUtil.invokeLaterInEDT(() -> this.lambda$tryRenaming$5(string3, (String)object));
                    }
                    throw new FolderRenameException(path, folderInfo);
                }
                folderInfo = FolderInfoFactory.rename(folderInfo, string2);
            }
            catch (SecurityException runtimeException) {
                this.logWarning(runtimeException.getMessage());
                throw new FolderRenameException(path, folderInfo, runtimeException);
            }
            catch (RuntimeException runtimeException) {
                this.logSevere("Unable to rename folder: " + (String)string + ": " + runtimeException, runtimeException);
                throw new FolderRenameException(path, folderInfo, runtimeException);
            }
        }
        return folderInfo;
    }

    private boolean folderStillExists(FolderInfo folderInfo) {
        if (folderInfo == null) {
            return false;
        }
        Folder folder = folderInfo.getFolder(this.getController());
        if (folder == null) {
            return false;
        }
        Path path = folder.getLocalBase();
        if (Files.notExists(path, new LinkOption[0])) {
            return false;
        }
        Path path2 = folder.getSystemSubDir().resolve("FolderStatistic");
        if (Files.notExists(path2, new LinkOption[0])) {
            return false;
        }
        return !folder.checkIfDeviceDisconnected();
    }

    private FolderInfo checkSystemSubdirForFolder(Path path) {
        FolderInfo folderInfo = FolderInfoFactory.readFrom(path);
        if (folderInfo != null) {
            return folderInfo;
        }
        Path path2 = path.resolve(Constants.POWERFOLDER_SYSTEM_SUBDIR).resolve("FolderStatistic");
        FolderStatisticInfo folderStatisticInfo = FolderStatisticInfo.load(path2);
        if (folderStatisticInfo == null) {
            return null;
        }
        return folderStatisticInfo.getFolder();
    }

    private boolean lookForFoldersToBeRemoved() {
        Path path2;
        if (!this.getMySelf().isServer()) {
            if (!this.getController().getOSClient().isLoggedIn()) {
                if (this.isFine()) {
                    this.logFine("Skipping searching for folders to be removed...");
                }
                return false;
            }
            if (!ConfigurationEntry.SECURITY_PERMISSIONS_STRICT.getValueBoolean(this.getController()).booleanValue()) {
                if (this.isFine()) {
                    this.logFine("Skipping searching for folders to be deleted (no strict security)...");
                }
                return false;
            }
        }
        if (this.isFine()) {
            this.logFine("Searching for folders to be removed...");
        }
        if (Files.notExists(path2 = this.getFoldersBasedir(), new LinkOption[0]) || !Files.isReadable(path2)) {
            return false;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Account account = this.getController().getOSClient().getAccount();
        for (FolderInfo object : account.getFolders()) {
            hashSet.add(object.getLocalizedName().toLowerCase().trim());
        }
        DirectoryStream.Filter<Path> filter = path -> {
            String string = path.getFileName().toString();
            if (string.equals(Constants.POWERFOLDER_SYSTEM_SUBDIR)) {
                return false;
            }
            if (string.equals(ConfigurationEntry.FOLDER_BASEDIR_DELETED_DIR.getValue(this.getController())) || string.equals(ConfigurationEntry.FOLDER_BASEDIR_DELETED_DIR.getDefaultValue())) {
                return false;
            }
            if (string.equalsIgnoreCase(DIRNAME_SNAPSHOT)) {
                return false;
            }
            if (hashSet.contains(string.toLowerCase())) {
                return false;
            }
            return Files.isDirectory(path, new LinkOption[0]);
        };
        try (DirectoryStream<Path> iOException = Files.newDirectoryStream(path2, (DirectoryStream.Filter<? super Path>)filter);){
            for (Path path3 : iOException) {
                boolean bl = false;
                for (Folder folder : this.getFolders()) {
                    Path path4 = folder.getLocalBase();
                    if (!path4.equals(path3) && !path4.toAbsolutePath().startsWith(path3.toAbsolutePath())) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                String string = ConfigurationEntry.FOLDER_BASEDIR_DELETED_DIR.getValue(this.getController());
                if (StringUtils.isNotBlank(string)) {
                    Path path5 = PathUtils.createEmptyDirectory(this.getFoldersBasedir().resolve(string), path3.getFileName().toString());
                    PathUtils.recursiveMove(path3, path5);
                    continue;
                }
                PathUtils.recursiveDelete(path3);
            }
        }
        catch (IOException iOException2) {
            this.logWarning(iOException2.getMessage());
            return false;
        }
        return true;
    }

    public boolean isInSync() {
        for (Folder folder : this.getFolders()) {
            if (folder.isInSync()) continue;
            if (this.isWarning()) {
                this.logWarning(folder + " not in sync yet");
            }
            return false;
        }
        return true;
    }

    public Folder getMetaFolder(FolderInfo folderInfo) {
        return this.metaFolders.get(folderInfo);
    }

    public Folder getContentFolder(FolderInfo folderInfo) {
        if (!folderInfo.isMetaFolder()) {
            return null;
        }
        return this.getFolder(folderInfo.lookupContentFolderInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFolders(AccountDetails accountDetails) {
        block15: {
            Reject.ifNull(accountDetails, "AccountDetails");
            Account account = accountDetails.getAccount();
            if (this.getMySelf().isServer()) {
                return;
            }
            if (!account.isValid()) {
                return;
            }
            if (!this.accountSyncLock.tryLock()) {
                this.logFine("Skip syncing folder setup with account permissions(" + account.getFolders() + "): " + account.getUsername());
                return;
            }
            try {
                this.scanBasedirLock.lock();
                if (this.isFine()) {
                    this.logFine("Syncing folder setup with account permissions(" + account.getFolders().size() + "): " + account.getUsername());
                }
                Collection<FolderInfo> collection = this.createLocalFolders(accountDetails);
                if (ConfigurationEntry.SECURITY_PERMISSIONS_STRICT.getValueBoolean(this.getController()).booleanValue()) {
                    if (!collection.isEmpty()) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            throw new RuntimeException(interruptedException);
                        }
                    }
                    if (ProUtil.isServerConfig(this.getController())) {
                        this.logSevere("Found server config running with client installation. Won't delete local folders.");
                        return;
                    }
                    this.removeLocalFolders(account, collection);
                    break block15;
                }
                for (Folder folder : this.getFolders()) {
                    AccessDeniedProblem accessDeniedProblem;
                    if (!account.hasReadPermissions(folder.getInfo())) {
                        accessDeniedProblem = new AccessDeniedProblem(folder.getInfo());
                        folder.removeProblem(accessDeniedProblem);
                        folder.addProblem(accessDeniedProblem);
                        continue;
                    }
                    if (folder.countProblems() <= 0) continue;
                    accessDeniedProblem = new AccessDeniedProblem(folder.getInfo());
                    folder.removeProblem(accessDeniedProblem);
                }
            }
            finally {
                this.scanBasedirLock.unlock();
                this.accountSyncLock.unlock();
            }
        }
    }

    public Folder moveLocalFolder(Folder folder, Path path) {
        return this.moveLocalFolder(folder, path, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Folder moveLocalFolder(Folder folder, Path path, boolean bl) {
        boolean bl2;
        block35: {
            boolean bl3 = EncryptedFileSystemUtils.isCryptoInstance(folder.getLocalBase());
            boolean bl4 = path.getFileName().toString().endsWith(".crypto");
            if (folder.getLocalBase().equals(path)) {
                this.logInfo("Source and target path of folder are same. doing nothing: " + folder.getLocalBase() + " and " + path);
                return null;
            }
            if (bl3 && !bl4) {
                this.logWarning("Not allowed to move encrypted folder to unencrypted target directory. From: " + folder.getLocalBase() + " to " + path);
                return null;
            }
            if (Files.exists(path = PathUtils.removeInvalidFilenameChars(path), new LinkOption[0]) && !PathUtils.isEmptyDir(path)) {
                Path path2 = folder.getPhysicalDir();
                this.logWarning(folder + ": Not moving to new directory " + path.toString() + ". The new directory is not empty. Keeping the old directory " + path2);
                return null;
            }
            bl2 = false;
            long l = System.currentTimeMillis();
            try {
                List<String> list;
                boolean bl5;
                FolderSettings folderSettings;
                Path path3;
                block34: {
                    this.scanBasedirLock.lock();
                    path3 = folder.getPhysicalDir().toRealPath(new LinkOption[0]);
                    if (path3.equals(path)) {
                        this.logFine("Not required to move folder from/to " + path);
                        Folder folder2 = folder;
                        return folder2;
                    }
                    folderSettings = FolderSettings.load(this.getController(), folder.getConfigEntryId());
                    bl5 = false;
                    list = folder.getDiskItemFilter().getPatterns();
                    this.removeFolder(folder, false, false, false);
                    try {
                        if (Files.exists(path, new LinkOption[0]) && PathUtils.isEmptyDir(path)) {
                            PathUtils.recursiveDelete(path);
                        }
                        if (bl) {
                            Files.move(path3, path, new CopyOption[0]);
                        } else {
                            PathUtils.recursiveMoveCopyFallbackVisitor(path3, path);
                        }
                        folderSettings = folderSettings.changeBaseDir(path);
                        bl2 = true;
                    }
                    catch (IOException iOException) {
                        if (bl) break block34;
                        if (Files.exists(path, new LinkOption[0]) && PathUtils.isEmptyDir(path)) {
                            try {
                                PathUtils.recursiveDelete(path);
                            }
                            catch (IOException iOException2) {
                                this.logWarning("Unable to cleanup empty target path while moving folder " + folder.getName() + " to " + path + ": " + iOException);
                            }
                        }
                        if (Files.notExists(path, new LinkOption[0])) {
                            try {
                                PathUtils.recursiveCopyVisitor(path3, path);
                                folderSettings = folderSettings.changeBaseDir(path);
                                bl2 = true;
                                bl5 = true;
                            }
                            catch (IOException iOException3) {
                                this.logWarning("Unable to move/copy folder " + folder.getName() + " to " + path + ". @" + iOException3 + " and " + iOException);
                                bl5 = false;
                            }
                        }
                        try {
                            Object object = PathUtils.calculateDirectorySizeAndCount(path);
                            long l2 = 0L;
                            long l3 = 0L;
                            if (((Long[])object).length >= 2) {
                                l2 = object[0];
                                l3 = object[1];
                            }
                            object = PathUtils.calculateDirectorySizeAndCount(path3);
                            long l4 = 0L;
                            long l5 = 0L;
                            if (((Long[])object).length >= 2) {
                                l4 = (Long)object[0];
                                l5 = (Long)object[1];
                            }
                            if (l3 > l5 && l2 > l4) {
                                if (l5 > 0L || l4 > 0L) {
                                    this.logSevere("Possible incomplete folder move from " + path3 + " to " + path + ". Files in source: " + l5 + " (" + Format.formatBytesShort(l4) + "), target: " + l3 + " (" + Format.formatBytesShort(l2) + "). Using target path: " + path);
                                }
                                folderSettings = folderSettings.changeBaseDir(path);
                                bl2 = true;
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            this.logSevere("Possible incomplete folder move: Error on folder " + folder.getName() + " from " + path3 + " to " + path + ": " + runtimeException, runtimeException);
                        }
                    }
                }
                Folder folder3 = folder;
                folder = this.createFolder(folder.getInfo().intern(), folderSettings, true, false);
                PathUtils.setAttributesOnWindows(folder.getLocalBase(), null, true);
                PathUtils.setAttributesOnWindows(folder.getSystemSubDir(), true, true);
                if (bl2) {
                    this.fireFolderMoved(folder, folder3);
                }
                for (String string : list) {
                    folder.addPattern(string);
                }
                if (bl2) {
                    long l6 = System.currentTimeMillis() - l;
                    this.logInfo(folder + ": Successfully moved folder from " + path3 + " to " + path + ". Took " + l6 + "ms.");
                } else {
                    this.logInfo(folder + ": Not moved folder from " + path3 + " to " + path + ". Using old directory");
                }
                if (!bl5) break block35;
                try {
                    if (Files.exists(path3, new LinkOption[0])) {
                        PathUtils.recursiveDeleteVisitor(path3);
                    }
                }
                catch (IOException iOException) {
                    this.logWarning("Failed to delete source directory " + path3 + " after moving folder " + folder.getName() + " to " + path, iOException);
                }
            }
            catch (IOException iOException) {
                this.logWarning(folder + ": Unable to move to " + path + ". " + iOException, iOException);
                this.logFine(iOException);
                Folder folder4 = null;
                return folder4;
            }
            finally {
                this.scanBasedirLock.unlock();
            }
        }
        return bl2 ? folder : null;
    }

    private void removeLocalFolders(Account account, Collection<FolderInfo> collection) {
        if (!account.isValid()) {
            return;
        }
        for (Folder folder : this.getFolders()) {
            if (collection.contains(folder.getInfo()) || account.hasReadPermissions(folder.getInfo())) continue;
            this.logWarning("Removing local " + folder + " " + account + " does not have read permission. Wiping out data.");
            this.removeFolder(folder, true);
            final Path path = folder.getLocalBase();
            this.getController().getIOProvider().startIO(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(2000L);
                        PathUtils.recursiveDelete(path);
                    }
                    catch (Exception exception) {
                        FolderRepository.this.logWarning("Unable to delete directory: " + path);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Collection<FolderInfo> createLocalFolders(AccountDetails accountDetails) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Account account = accountDetails.getAccount();
        if (!account.isValid()) {
            return Collections.emptyList();
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Object object6 = this.onLoginFolderEntryIds.iterator();
        while (object6.hasNext()) {
            String object7 = object6.next();
            object4 = FolderSettings.load(this.getController(), object7);
            object3 = FolderSettings.loadFolderName(this.getController().getConfig(), object7);
            if (object4 == null) {
                object2 = this.getController().getConfig().getProperty("f." + object7 + ".dir");
                this.logWarning("Not setting up folder " + (String)object3 + " / " + object7 + " local base dir not found: " + (String)object2);
                continue;
            }
            object2 = null;
            for (FolderInfo iOException : account.getFolders()) {
                if (!iOException.getName().equals(object3)) continue;
                this.logInfo("Folder found on account " + account.getUsername() + ". Loading it: " + iOException);
                object2 = iOException;
                break;
            }
            try {
                block40: {
                    this.scanBasedirLock.lock();
                    try {
                        Files.createDirectories(((FolderSettings)object4).getLocalBaseDir(), new FileAttribute[0]);
                    }
                    catch (IOException exception) {
                        if (!this.isFine()) break block40;
                        this.logFine(exception.getMessage());
                    }
                }
                if (object2 == null) {
                    object2 = FolderInfoFactory.backupFolderOfAccount((String)object3, account.createInfo());
                    this.logInfo("Folder not found on account " + account.getUsername() + ". Created new: " + (FolderInfo)object2);
                }
                boolean userDirectory = false;
                try {
                    this.getController().getOSClient().getFolderService().createFolder((FolderInfo)object2, null);
                    if (object4 != null && accountDetails.getAccount().hasAdminPermission((FolderInfo)object2)) {
                        this.getController().getOSClient().getFolderService((FolderInfo)object2).setArchiveMode((FolderInfo)object2, ((FolderSettings)object4).getVersions());
                    }
                }
                catch (Exception iOException) {
                    userDirectory = true;
                }
                Folder folder = this.createFolder((FolderInfo)object2, (FolderSettings)object4, true, true);
                folder.addDefaultExcludes();
                if (userDirectory) {
                    this.logFine("Scheduling setup of folder: " + ((FolderInfo)object2).getName());
                    object = new CreateFolderOnServerTask((FolderInfo)object2, null);
                    ((CreateFolderOnServerTask)object).setArchiveVersions(((FolderSettings)object4).getVersions());
                    this.getController().getTaskManager().scheduleTask((PersistentTask)object);
                }
                object6.remove();
                hashMap.put(object2, object4);
            }
            catch (Exception exception) {
                this.logWarning("Unable to create folder " + (String)object3 + " at " + ((FolderSettings)object4).getLocalBaseDir() + ". " + exception);
            }
            finally {
                this.scanBasedirLock.unlock();
            }
        }
        if (this.getController().isUIEnabled() && ConfigurationEntry.AUTO_SETUP_ACCOUNT_FOLDERS.getValueBoolean(this.getController()).booleanValue() && !this.sufficientDiskSpaceAvailable(accountDetails)) {
            ConfigurationEntry.AUTO_SETUP_ACCOUNT_FOLDERS.setValue(this.getController(), false);
            this.getController().saveConfig();
            object6 = new WarningNotice(Translation.get("disc_space_warning.title"), Translation.get("disc_space_warning.summary"), Translation.get("disc_space_warning.summary"));
            this.getController().getUIController().getApplicationModel().getNoticesModel().handleNotice((Notice)object6);
        }
        if (ConfigurationEntry.AUTO_SETUP_ACCOUNT_FOLDERS.getValueBoolean(this.getController()).booleanValue()) {
            for (FolderInfo folderInfo : account.getFolders()) {
                UserDirectory userDirectory;
                block41: {
                    if (this.hasJoinedFolder(folderInfo) || folderInfo.getName().equals("$mail_attachments")) continue;
                    object4 = PathUtils.removeInvalidFilenameChars(folderInfo.getLocalizedName());
                    object3 = SyncProfile.getDefault(this.getController());
                    userDirectory = null;
                    if (!account.hasOwnerPermission(folderInfo)) {
                        try {
                            String string = this.getController().getOSClient().getFolderService(folderInfo).getOwnerDisplayname(folderInfo);
                            if (StringUtils.isNotBlank(string)) {
                                object4 = (String)object4 + " (";
                                object4 = (String)object4 + PathUtils.removeInvalidFilenameChars(string);
                                object4 = (String)object4 + ")";
                            }
                            break block41;
                        }
                        catch (RemoteCallException remoteCallException) {
                            log.warning("Unable to retrieve owner name of " + folderInfo.getName() + ". " + remoteCallException);
                            continue;
                        }
                    }
                    userDirectory = UserDirectories.getUserDirectories(this.getController()).get(object4);
                }
                if (userDirectory != null) {
                    if (this.isIgnoredFolderDirectory(userDirectory.getDirectory())) continue;
                    object2 = userDirectory.getDirectory();
                } else {
                    object2 = this.getController().getFolderRepository().getFoldersBasedir().resolve((String)object4);
                    if (Files.exists((Path)object2, new LinkOption[0])) {
                        this.logInfo("Using existing directory " + (Path)object2 + " for " + folderInfo);
                    }
                }
                if (!ConfigurationEntry.FOLDER_CREATE_ALLOW_NETWORK.getValueBoolean(this.getController()).booleanValue() && Files.exists((Path)object2, new LinkOption[0])) {
                    try {
                        if (Files.isSymbolicLink((Path)object2)) {
                            object2 = object2.toRealPath(new LinkOption[0]);
                        }
                    }
                    catch (IOException iOException) {
                        this.logWarning("Failed to resolve symlink at " + (Path)object2 + " for folder " + folderInfo.getName());
                        throw new IllegalStateException("Failed to resolve symlink at " + (Path)object2 + " for folder " + folderInfo.getName());
                    }
                    try {
                        if (PathUtils.isNetworkPath((Path)object2)) {
                            this.logWarning("No auto setup up on network drive for folder " + folderInfo.getName() + "/" + folderInfo.getId() + " @ " + (Path)object2);
                            continue;
                        }
                    }
                    catch (IOException iOException) {
                        this.logWarning("Failed to resolve symlink at " + (Path)object2);
                        throw new IllegalStateException("Failed to resolve symlink at " + (Path)object2 + " for folder " + folderInfo.getName());
                    }
                }
                if (this.isIgnoredFolderDirectory((Path)object2)) continue;
                this.logInfo("Auto setting up folder " + folderInfo.getName() + "/" + folderInfo.getId() + " @ " + (Path)object2);
                FolderSettings folderSettings = new FolderSettings((Path)object2, (SyncProfile)object3, ConfigurationEntry.DEFAULT_ARCHIVE_VERSIONS.getValueInt(this.getController()));
                try {
                    this.scanBasedirLock.lock();
                    Files.createDirectories(folderSettings.getLocalBaseDir(), new FileAttribute[0]);
                    object = this.createFolder(folderInfo, folderSettings, true, true);
                    ((Folder)object).addDefaultExcludes();
                    hashMap.put(folderInfo, folderSettings);
                }
                catch (IOException iOException) {
                    if (!this.isFine()) continue;
                    this.logFine(iOException.getMessage());
                }
                catch (Exception exception) {
                    this.logWarning("Unable to create folder " + folderInfo.getName() + " at " + folderSettings.getLocalBaseDir() + ". " + exception);
                }
                finally {
                    this.scanBasedirLock.unlock();
                }
            }
        }
        return hashMap.keySet();
    }

    private void fireFolderCreated(Folder folder) {
        this.folderRepositoryListenerSupport.folderCreated(new FolderRepositoryEvent(this, folder));
    }

    private void fireFolderRemoved(Folder folder) {
        this.folderRepositoryListenerSupport.folderRemoved(new FolderRepositoryEvent(this, folder));
    }

    private void fireFolderMoved(Folder folder, Folder folder2) {
        this.folderRepositoryListenerSupport.folderMoved(new FolderRepositoryEvent(this, folder, folder2));
    }

    private void fireMaintanceStarted(Folder folder) {
        this.folderRepositoryListenerSupport.maintenanceStarted(new FolderRepositoryEvent(this, folder));
    }

    private void fireMaintenanceFinished(Folder folder) {
        this.folderRepositoryListenerSupport.maintenanceFinished(new FolderRepositoryEvent(this, folder));
    }

    private void fireCleanupStarted() {
        this.folderRepositoryListenerSupport.cleanupStarted(new FolderRepositoryEvent(this));
    }

    private void fireCleanupFinished() {
        this.folderRepositoryListenerSupport.cleanupFinished(new FolderRepositoryEvent(this));
    }

    public void addFolderRepositoryListener(FolderRepositoryListener folderRepositoryListener) {
        ListenerSupportFactory.addListener(this.folderRepositoryListenerSupport, folderRepositoryListener);
    }

    public void removeFolderRepositoryListener(FolderRepositoryListener folderRepositoryListener) {
        ListenerSupportFactory.removeListener(this.folderRepositoryListenerSupport, folderRepositoryListener);
    }

    private void removeConfigEntries(String string) {
        Properties properties = this.getController().getConfig();
        FolderSettings.removeEntries(properties, string);
    }

    public void cleanupOldFiles() {
        this.cleanupOldFiles(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupOldFiles(boolean bl) {
        boolean bl2 = true;
        int n = ConfigurationEntry.DEFAULT_ARCHIVE_CLEANUP_DAYS.getValueInt(this.getController());
        if (!(bl || n != Integer.MAX_VALUE && n > 0)) {
            bl2 = false;
        }
        try {
            this.logFine("cleanupOldFiles starting");
            this.fireCleanupStarted();
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -n);
            Date date = calendar.getTime();
            Collection<Folder> collection = this.getFolders(true);
            this.logInfo("cleanupOldFiles started for " + collection.size() + " folders");
            for (Folder folder : collection) {
                if (bl2) {
                    folder.cleanupOldArchiveFiles(date);
                }
                this.getController().getTransferManager().cleanIncompletedDownloadFiles(folder);
            }
            this.logInfo("cleanupOldFiles done for " + this.getFoldersCount() + " folders");
        }
        finally {
            this.fireCleanupFinished();
        }
    }

    public boolean doesFolderAlreadyExist(Path path) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return false;
        }
        for (Folder folder : this.folders.values()) {
            if (!path.equals(folder.getBaseDirectoryInfo().getDiskFile(this))) continue;
            return true;
        }
        return false;
    }

    public boolean areAllFoldersInSync() {
        for (Folder folder : this.folders.values()) {
            if (Double.compare(folder.getStatistic().getHarmonizedSyncPercentage(), 100.0) >= 0) continue;
            return false;
        }
        return true;
    }

    boolean handleDeviceDisconnected(Folder folder) {
        Reject.ifNull(folder, "Folder");
        if (folder.getInfo().isMetaFolder()) {
            return false;
        }
        if (!ConfigurationEntry.FOLDER_REMOVE_IN_BASEDIR_WHEN_DISAPPEARED.getValueBoolean(this.getController()).booleanValue()) {
            return false;
        }
        Path path = this.getFoldersBasedir().toAbsolutePath();
        boolean bl = false;
        if (path != null) {
            bl = folder.getPhysicalDir().toAbsolutePath().startsWith(path);
        }
        if (!bl) {
            return false;
        }
        this.getController().schedule(() -> {
            if (this.hasJoinedFolder(folder.getInfo())) {
                this.scanBasedir();
                Folder folder2 = this.getFolder(folder.getInfo());
                if (folder2 != null && !folder2.checkIfDeviceDisconnected()) {
                    return;
                }
                this.logFine("Removing " + folder.toString());
                this.removeFolder(folder, false);
                this.scanBasedir();
            }
        }, 5000L);
        return true;
    }

    public boolean sufficientDiskSpaceAvailable(AccountDetails accountDetails) {
        try {
            long l = accountDetails.getSpaceUsed();
            long l2 = Files.getFileStore(this.getFoldersBasedir()).getUsableSpace();
            return l < l2;
        }
        catch (IOException iOException) {
            this.logSevere("Cannot get file store: " + iOException);
            return true;
        }
    }

    private /* synthetic */ void lambda$tryRenaming$5(String string, String string2) {
        DialogFactory.genericDialog(this.getController(), Translation.get("notice.rename_folder_failed.title"), Translation.get("notice.rename_folder_failed.summary", string, string2), GenericDialogType.WARN);
    }

    private class AllFolderMembershipSynchronizer
    implements Runnable {
        private AtomicBoolean canceled = new AtomicBoolean(false);

        private AllFolderMembershipSynchronizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ProfilingEntry profilingEntry = Profiling.start(this.getClass(), "synchronizeAllFolderMemberships");
            try {
                if (this.canceled.get()) {
                    FolderRepository.this.logFine("Not synchronizing Foldermemberships, operation already canceled yet");
                    return;
                }
                if (FolderRepository.this.isFiner()) {
                    FolderRepository.this.logFiner("All Nodes: Synchronize Foldermemberships");
                }
                Collection<Member> collection = FolderRepository.this.getController().getNodeManager().getConnectedNodes();
                Iterator<Member> iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Member member = iterator.next();
                    member.synchronizeFolderMemberships(this.canceled, false);
                    if (!this.canceled.get()) continue;
                    FolderRepository.this.logFiner("Foldermemberships synchroniziation cancelled");
                    return;
                }
            }
            finally {
                Profiling.end(profilingEntry);
                Object object = FolderRepository.this.folderMembershipSynchronizerLock;
                synchronized (object) {
                    if (FolderRepository.this.folderMembershipSynchronizer == this) {
                        FolderRepository.this.folderMembershipSynchronizer = null;
                    }
                }
            }
        }
    }

    private class CheckSyncTask
    implements Runnable {
        private boolean recalculateStatisticZeroFilesDone = false;

        private CheckSyncTask() {
        }

        @Override
        public void run() {
            boolean bl = false;
            for (Folder pFComponent : FolderRepository.this.getController().getFolderRepository().getFolders()) {
                if (!this.recalculateStatisticZeroFilesDone && pFComponent.getStatistic().getTotalFilesCount() == 0) {
                    pFComponent.getStatistic().scheduleCalculate();
                }
                pFComponent.checkSync();
                if (pFComponent.getStatistic().getHarmonizedSyncPercentage() == 100.0) continue;
                if (FolderRepository.this.getController().getOSClient().isConnected() && !FolderRepository.this.getController().getOSClient().joinedByCloud(pFComponent)) {
                    if (FolderRepository.this.isFine()) {
                        FolderRepository.this.logFine("Re-sync memberships with server: " + FolderRepository.this.getController().getOSClient().getServerString() + " / " + pFComponent);
                    }
                    bl = true;
                }
                if (pFComponent.getCompletelyConnectedMembersCount() == 0 || pFComponent.getKnownItemCount() == 0 || !pFComponent.hasReadPermission(FolderRepository.this.getController().getMySelf())) continue;
                pFComponent.getStatistic().scheduleCalculate();
                for (Member member : pFComponent.getConnectedMembers()) {
                    int n;
                    Date date;
                    if (!member.isCompletelyConnected() || (date = member.getLastConnectTime()) == null) continue;
                    long l = System.currentTimeMillis() - date.getTime();
                    if (!member.hasCompleteFileListFor(pFComponent.getInfo()) && l < 60000L || (n = pFComponent.getDAO().count(member.getId(), true, false)) > 0 || member.getPeer() instanceof D2DSocketConnectionHandler) continue;
                    if (FolderRepository.this.isFine()) {
                        FolderRepository.this.logFine("Re-requesting file list for " + pFComponent.getName() + " from " + member.getNick());
                    }
                    member.sendMessageAsynchron(new FileListRequest(pFComponent.getInfo()));
                }
            }
            this.recalculateStatisticZeroFilesDone = true;
            if (bl) {
                for (Member member : FolderRepository.this.getController().getNodeManager().getNodesAsCollection()) {
                    if (!member.isServer() || !member.isCompletelyConnected()) continue;
                    member.synchronizeFolderMemberships();
                }
            }
        }
    }
}

