/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.util.Translation;
import java.awt.EventQueue;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class FolderException
extends Exception
implements Serializable {
    private static final Logger log = Logger.getLogger(FolderException.class.getName());
    private static final long serialVersionUID = 100L;
    public FolderInfo fInfo;

    public FolderException() {
    }

    public FolderException(FolderInfo folderInfo, String string) {
        super(string);
        this.fInfo = folderInfo;
    }

    public FolderException(Throwable throwable) {
        super(throwable);
    }

    public FolderException(String string, Throwable throwable) {
        super(string, throwable);
    }

    @Override
    public String getMessage() {
        Object object = "";
        if (this.fInfo != null) {
            object = "Folder '" + this.fInfo.getLocalizedName() + "': ";
        }
        return (String)object + super.getMessage();
    }

    public void show(Controller controller) {
        this.show(controller, null);
    }

    public void show(final Controller controller, final String string) {
        if (controller.isUIEnabled()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (controller.isUIOpen()) {
                        String string2 = string != null ? "\n" + string : "";
                        DialogFactory.genericDialog(controller, Translation.get("folder_exception.dialog.title", FolderException.this.fInfo == null ? "null" : FolderException.this.fInfo.getLocalizedName()), Translation.get("folder_exception.dialog.text", FolderException.this.fInfo == null ? "null" : FolderException.this.fInfo.getLocalizedName(), FolderException.super.getMessage()) + string2, controller.isVerbose(), FolderException.this);
                    }
                }
            };
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (InterruptedException interruptedException) {
                    log.log(Level.SEVERE, "InterruptedException", interruptedException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    log.log(Level.SEVERE, "InvocationTargetException", invocationTargetException);
                }
            }
        }
    }
}

