/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.clientserver;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.clientserver.RemoteCallException;
import de.dal33t.powerfolder.clientserver.RequestExecutor;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.clientserver.ThrowableHandler;
import de.dal33t.powerfolder.message.Identity;
import de.dal33t.powerfolder.message.clientserver.RemoteMethodCallRequest;
import de.dal33t.powerfolder.message.clientserver.RemoteMethodCallResponse;
import de.dal33t.powerfolder.net.ConnectionException;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StackDump;
import de.dal33t.powerfolder.util.Util;
import java.awt.EventQueue;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteServiceStubFactory {
    private static final Logger LOG = Logger.getLogger(RemoteServiceStubFactory.class.getName());

    private RemoteServiceStubFactory() {
    }

    public static <T> T createRemoteStub(Controller controller, Class<? extends T> clazz, Member member) {
        return RemoteServiceStubFactory.createRemoteStub(controller, clazz, member, null);
    }

    public static <T> T createRemoteStub(Controller controller, Class<? extends T> clazz, Member member, ThrowableHandler throwableHandler) {
        Reject.ifNull(controller, "Controller is null");
        Reject.ifNull(member, "Remote site is null");
        Reject.ifFalse(clazz.isInterface(), "Service interface class is not a interface! " + clazz);
        RemoteInvocationHandler remoteInvocationHandler = new RemoteInvocationHandler(controller, clazz.getName(), member, throwableHandler);
        return (T)Proxy.newProxyInstance(RemoteServiceStubFactory.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)remoteInvocationHandler);
    }

    private static class RemoteInvocationHandler
    implements InvocationHandler {
        private Controller controller;
        private Member remoteSide;
        private String serviceId;
        private ThrowableHandler throwableHandler;

        private RemoteInvocationHandler(Controller controller, String string, Member member, ThrowableHandler throwableHandler) {
            this.controller = controller;
            this.remoteSide = member;
            this.serviceId = string;
            this.throwableHandler = throwableHandler;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            RemoteMethodCallResponse remoteMethodCallResponse;
            if (Util.isAwtAvailable() && EventQueue.isDispatchThread()) {
                LOG.log(Level.WARNING, "Call to remote service method (" + method + ") executed in EDT thread. Args: " + (objectArray != null ? Arrays.asList(objectArray) : "n/a"), new StackDump());
            }
            if (ServerClient.SERVER_HANDLE_MESSAGE_THREAD.get().booleanValue()) {
                LOG.log(Level.WARNING, "Call to remote service method (" + method + ") executed Server/Member.handleMessage. Args: " + (objectArray != null ? Arrays.asList(objectArray) : "n/a"), new StackDump());
            }
            Identity identity = this.remoteSide.getIdentity();
            RequestExecutor requestExecutor = new RequestExecutor(this.controller, this.remoteSide);
            RemoteMethodCallRequest remoteMethodCallRequest = new RemoteMethodCallRequest(this.serviceId, method, objectArray);
            if (identity == null || identity.isSupportsSerializedRequest()) {
                remoteMethodCallRequest = remoteMethodCallRequest.toSerzializedForm();
            } else if (ConfigurationEntry.SECURITY_PERMISSIONS_STRICT.getValueBoolean(this.controller).booleanValue()) {
                LOG.severe("Using strict permission security setting while executing legacy type request.Please check program version of " + this.remoteSide + ": " + identity.getProgramVersion() + ". Request: " + remoteMethodCallRequest);
            }
            try {
                remoteMethodCallResponse = (RemoteMethodCallResponse)requestExecutor.execute(remoteMethodCallRequest);
            }
            catch (ConnectionException connectionException) {
                throw new RemoteCallException(connectionException);
            }
            if (remoteMethodCallResponse.isException()) {
                StackTraceElement[] stackTraceElementArray = remoteMethodCallResponse.getException().getStackTrace();
                StackTraceElement[] stackTraceElementArray2 = new RuntimeException().getStackTrace();
                StackTraceElement[] stackTraceElementArray3 = new StackTraceElement[stackTraceElementArray.length + stackTraceElementArray2.length];
                System.arraycopy(stackTraceElementArray, 0, stackTraceElementArray3, 0, stackTraceElementArray.length);
                System.arraycopy(stackTraceElementArray2, 0, stackTraceElementArray3, stackTraceElementArray.length, stackTraceElementArray2.length);
                remoteMethodCallResponse.getException().setStackTrace(stackTraceElementArray3);
                boolean bl = Arrays.asList(method.getExceptionTypes()).contains(remoteMethodCallResponse.getException().getClass());
                if (bl) {
                    throw remoteMethodCallResponse.getException();
                }
                if (this.throwableHandler != null) {
                    try {
                        this.throwableHandler.handle(remoteMethodCallResponse.getException());
                    }
                    catch (Exception exception) {
                        LOG.warning("ThrowableHandler threw exception! What a pity! " + exception);
                    }
                }
                if (remoteMethodCallResponse.getException() instanceof RuntimeException) {
                    throw (RuntimeException)remoteMethodCallResponse.getException();
                }
                throw new RemoteCallException(remoteMethodCallResponse.getException());
            }
            return remoteMethodCallResponse.getResult();
        }
    }
}

