/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.util.net.NetworkUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebClientLogin
extends PFComponent {
    private ServerSocket serverSocket;
    private Thread myThread;
    private static final Logger log = Logger.getLogger(WebClientLogin.class.getName());

    public WebClientLogin(Controller controller) {
        super(controller);
    }

    public void start() {
        Integer n = ConfigurationEntry.WEB_CLIENT_PORT.getValueInt(this.getController());
        try {
            this.serverSocket = new ServerSocket(n);
            this.myThread = new Thread((Runnable)new Worker(), "Web Client Login");
            this.myThread.start();
            this.logInfo("");
        }
        catch (UnknownHostException unknownHostException) {
            log.warning("Unable to open Web Client Login on port " + n + ": " + unknownHostException);
            log.log(Level.FINER, "UnknownHostException", unknownHostException);
        }
        catch (IOException iOException) {
            log.warning("Unable to open Web Client Login on port " + n + ": " + iOException);
            log.log(Level.FINER, "IOException", iOException);
        }
    }

    public void stop() {
        if (this.myThread != null) {
            this.myThread.interrupt();
        }
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException iOException) {
            this.logWarning("Unable to close server socket @ " + this.serverSocket + " " + iOException, iOException);
        }
    }

    private String getInetAddress() throws SocketException {
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        String string = null;
        for (NetworkInterface networkInterface : Collections.list(enumeration)) {
            if (!networkInterface.getDisplayName().contains("bond0")) continue;
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            for (InetAddress inetAddress : Collections.list(enumeration2)) {
                if (!(inetAddress instanceof Inet4Address)) continue;
                string = inetAddress.toString();
            }
        }
        return string != null ? string.replace("/", "") : null;
    }

    private void sendAuthenticationRequest(OutputStream outputStream, String string) {
        if (string == null) {
            try {
                string = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                string = ConfigurationEntry.HOSTNAME.getValue(this.getController());
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Location: ");
        stringBuilder.append(ConfigurationEntry.CONFIG_URL.getValue(this.getController()));
        stringBuilder.append("/login?autoLogin=1&");
        stringBuilder.append("originalURI");
        stringBuilder.append("=http://");
        stringBuilder.append(string);
        stringBuilder.append(":");
        stringBuilder.append(ConfigurationEntry.WEB_CLIENT_PORT.getValue(this.getController()));
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter(outputStream, StandardCharsets.UTF_8), true);
        printWriter.println("HTTP/1.1 301 Moved Permanently");
        printWriter.println(stringBuilder.toString());
        printWriter.println("Connection: close");
        printWriter.println("");
        printWriter.close();
    }

    private void sendAuthSuccessRequest(OutputStream outputStream) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Location: ");
        stringBuilder.append(ConfigurationEntry.CONFIG_URL.getValue(this.getController()));
        stringBuilder.append("/authsuccess");
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter(outputStream, StandardCharsets.UTF_8), true);
        printWriter.println("HTTP/1.1 301 Moved Permanently");
        printWriter.println(stringBuilder.toString());
        printWriter.println("Connection: close");
        printWriter.println("");
        printWriter.close();
    }

    private void consumeToken(String string) {
        String string2 = string.substring(string.indexOf("Token") + 6, string.lastIndexOf(" "));
        this.getController().getOSClient().login("WDMyCloud", string2);
        ConfigurationEntry.SERVER_CONNECT_TOKEN.setValue(this.getController().getConfig(), string2);
        this.getController().saveConfig();
        log.log(Level.INFO, "Successfully logged in to server.");
    }

    public static boolean hasRunningInstance() {
        return WebClientLogin.hasRunningInstance(Integer.valueOf(ConfigurationEntry.WEB_CLIENT_PORT.getDefaultValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasRunningInstance(int n) {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(n, 30, InetAddress.getByName(NetworkUtil.LOOPBACK_LOCALHOST_IPv4));
            log.fine("No running instance found");
            boolean bl = false;
            return bl;
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {
                    log.log(Level.SEVERE, "Unable to close already running test socket. " + serverSocket, iOException);
                }
            }
        }
        log.warning("Running instance found");
        return true;
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            log.info("Listening for authentication requests on port " + WebClientLogin.this.serverSocket.getInetAddress() + ":" + WebClientLogin.this.serverSocket.getLocalPort());
            while (!Thread.currentThread().isInterrupted()) {
                Socket socket;
                BufferedReader bufferedReader = null;
                try {
                    socket = WebClientLogin.this.serverSocket.accept();
                }
                catch (IOException iOException) {
                    log.log(Level.FINER, "Socket closed, stopping", iOException);
                    break;
                }
                log.info("Authentication request from " + socket);
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
                    String string = bufferedReader.readLine();
                    if (string == null || !string.startsWith("GET")) continue;
                    if (string.contains("/login")) {
                        String string2 = WebClientLogin.this.getInetAddress();
                        if (string2 != null) {
                            WebClientLogin.this.sendAuthenticationRequest(socket.getOutputStream(), string2);
                            continue;
                        }
                        WebClientLogin.this.logWarning("Process authentication request failed. Client authentication request only supported from WDNAS devices. Are you an a WDNAS device?");
                        continue;
                    }
                    if (!string.contains("Token")) continue;
                    WebClientLogin.this.consumeToken(string);
                    WebClientLogin.this.sendAuthSuccessRequest(socket.getOutputStream());
                }
                catch (Exception exception) {
                    WebClientLogin.this.logWarning("Problems parsing authentication request from " + socket + ". " + exception, exception);
                    WebClientLogin.this.logFiner(exception);
                }
                finally {
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        if (socket == null) continue;
                        socket.close();
                    }
                    catch (IOException iOException) {
                        WebClientLogin.this.logWarning("Unable to close socket " + socket + ". " + iOException);
                    }
                }
            }
        }
    }
}

