/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.logging.Loggable;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class PFComponent
extends Loggable {
    private Controller controller;
    private PropertyChangeSupport changeSupport;

    protected PFComponent() {
    }

    protected PFComponent(Controller controller) {
        Reject.ifNull(controller, "Controller");
        this.controller = controller;
    }

    public Controller getController() {
        return this.controller;
    }

    protected Member getMySelf() {
        return this.controller.getMySelf();
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.getPropertyChangeSupport().firePropertyChange(string, object, object2);
    }

    protected void firePropertyChange(String string, boolean bl, boolean bl2) {
        this.getPropertyChangeSupport().firePropertyChange(string, bl, bl2);
    }

    protected void firePropertyChange(String string, int n, int n2) {
        this.getPropertyChangeSupport().firePropertyChange(string, n, n2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(propertyChangeListener);
    }

    protected void removeAllListeners() {
        PropertyChangeListener[] propertyChangeListenerArray;
        for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray = this.getPropertyChangeSupport().getPropertyChangeListeners()) {
            this.removePropertyChangeListener(propertyChangeListener);
        }
    }

    private synchronized PropertyChangeSupport getPropertyChangeSupport() {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        return this.changeSupport;
    }
}

