/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.ConnectResult;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Feature;
import de.dal33t.powerfolder.NetworkingMode;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.d2d.D2DSocketConnectionHandler;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.FolderRepository;
import de.dal33t.powerfolder.disk.problem.FolderReadOnlyProblem;
import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.FolderInfoFactory;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.message.AbortDownload;
import de.dal33t.powerfolder.message.AbortUpload;
import de.dal33t.powerfolder.message.AddFriendNotification;
import de.dal33t.powerfolder.message.ConfigurationLoadRequest;
import de.dal33t.powerfolder.message.DownloadQueued;
import de.dal33t.powerfolder.message.FileChunk;
import de.dal33t.powerfolder.message.FileHistoryReply;
import de.dal33t.powerfolder.message.FileHistoryRequest;
import de.dal33t.powerfolder.message.FileList;
import de.dal33t.powerfolder.message.FileListRequest;
import de.dal33t.powerfolder.message.FileRequestCommand;
import de.dal33t.powerfolder.message.FolderDBMaintCommando;
import de.dal33t.powerfolder.message.FolderFilesChanged;
import de.dal33t.powerfolder.message.FolderList;
import de.dal33t.powerfolder.message.FolderListExt;
import de.dal33t.powerfolder.message.FolderRelatedMessage;
import de.dal33t.powerfolder.message.HandshakeCompleted;
import de.dal33t.powerfolder.message.Identity;
import de.dal33t.powerfolder.message.IdentityReply;
import de.dal33t.powerfolder.message.Invitation;
import de.dal33t.powerfolder.message.KnownNodes;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.message.MessageListener;
import de.dal33t.powerfolder.message.NodeInformation;
import de.dal33t.powerfolder.message.Ping;
import de.dal33t.powerfolder.message.Pong;
import de.dal33t.powerfolder.message.Problem;
import de.dal33t.powerfolder.message.QuotaExceeded;
import de.dal33t.powerfolder.message.RelayedMessage;
import de.dal33t.powerfolder.message.ReplyFilePartsRecord;
import de.dal33t.powerfolder.message.RequestDownload;
import de.dal33t.powerfolder.message.RequestFilePartsRecord;
import de.dal33t.powerfolder.message.RequestNodeInformation;
import de.dal33t.powerfolder.message.RequestNodeList;
import de.dal33t.powerfolder.message.RequestPart;
import de.dal33t.powerfolder.message.RevertedFile;
import de.dal33t.powerfolder.message.ScanCommand;
import de.dal33t.powerfolder.message.SearchNodeRequest;
import de.dal33t.powerfolder.message.SettingsChange;
import de.dal33t.powerfolder.message.StartUpload;
import de.dal33t.powerfolder.message.StopUpload;
import de.dal33t.powerfolder.message.TransferStatus;
import de.dal33t.powerfolder.message.UDTMessage;
import de.dal33t.powerfolder.message.clientserver.AccountStateChanged;
import de.dal33t.powerfolder.net.ConnectionException;
import de.dal33t.powerfolder.net.ConnectionHandler;
import de.dal33t.powerfolder.net.InvalidIdentityException;
import de.dal33t.powerfolder.task.FolderRenameTask;
import de.dal33t.powerfolder.transfer.Download;
import de.dal33t.powerfolder.transfer.TransferManager;
import de.dal33t.powerfolder.transfer.Upload;
import de.dal33t.powerfolder.ui.notices.CloudStorageNotice;
import de.dal33t.powerfolder.ui.notices.VersionTooOldNotice;
import de.dal33t.powerfolder.util.ConfigurationLoader;
import de.dal33t.powerfolder.util.Debug;
import de.dal33t.powerfolder.util.Filter;
import de.dal33t.powerfolder.util.MessageListenerSupport;
import de.dal33t.powerfolder.util.Profiling;
import de.dal33t.powerfolder.util.ProfilingEntry;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StackDump;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.Waiter;
import de.dal33t.powerfolder.util.logging.LoggingManager;
import de.dal33t.powerfolder.util.net.NetworkUtil;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class Member
extends PFComponent
implements Comparable<Member> {
    private MessageListenerSupport messageListenerSupport;
    private volatile ConnectionHandler peer;
    private volatile boolean handshaked;
    private volatile int connectionRetries;
    private final AtomicInteger currentConnectTries = new AtomicInteger(0);
    private final MemberInfo info;
    private Date lastNetworkConnectTime;
    private final Object peerInitializeLock = new Object();
    private final Object folderListWaiter = new Object();
    private final ReentrantLock folderJoinLock = new ReentrantLock();
    private volatile FolderList nextFolderList;
    private volatile boolean folderListReceived;
    private volatile FolderList lastFolderList;
    private final Map<FolderInfo, Integer> expectedListMessages = Util.createConcurrentHashMap();
    private volatile HandshakeCompleted lastHandshakeCompleted;
    private TransferStatus lastTransferStatus;
    private volatile Problem lastProblem;
    private boolean isConnectedToNetwork;
    private boolean receivedWrongRemoteIdentity;
    private boolean askedForFriendship;
    private boolean server;
    private Boolean mySelf;

    public Member(Controller controller, MemberInfo memberInfo) {
        super(controller);
        this.info = memberInfo;
    }

    public boolean matches(String string) {
        return this.matches(string, false);
    }

    public boolean matches(String string, boolean bl) {
        if (this.info.matches(string)) {
            return true;
        }
        if (!bl) {
            return false;
        }
        AccountInfo accountInfo = this.getAccountInfo();
        if (accountInfo == null) {
            return false;
        }
        if (accountInfo.getUsername() != null && accountInfo.getUsername().toLowerCase().contains(string)) {
            return true;
        }
        return accountInfo.getDisplayName() != null && accountInfo.getDisplayName().toLowerCase().contains(string);
    }

    public String getHostName() {
        if (this.getReconnectAddress() == null) {
            return null;
        }
        return this.getReconnectAddress().getHostName();
    }

    public String getIP() {
        if (this.getReconnectAddress() == null || this.getReconnectAddress().getAddress() == null) {
            return null;
        }
        return this.getReconnectAddress().getAddress().getHostAddress();
    }

    public int getPort() {
        if (this.getReconnectAddress() == null || this.getReconnectAddress().getAddress() == null) {
            return 0;
        }
        return this.getReconnectAddress().getPort();
    }

    public boolean isSecure() {
        return this.peer != null && this.peer.isEncrypted();
    }

    public boolean isMySelf() {
        if (this.mySelf != null) {
            return this.mySelf;
        }
        this.mySelf = this.equals(this.getController().getMySelf());
        return this.mySelf;
    }

    public boolean isMyComputer() {
        AccountInfo accountInfo = this.getAccountInfo();
        if (accountInfo == null) {
            return false;
        }
        return accountInfo.equals(this.getController().getOSClient().getAccountInfo());
    }

    public boolean isFriend() {
        return this.getController().getNodeManager().isFriend(this);
    }

    public void setFriend(boolean bl, String string) {
        boolean bl2 = this.isFriend() ^ bl;
        if (bl2) {
            this.getController().getNodeManager().friendStateChanged(this, bl, string);
            if (!bl && !this.isCompletelyConnected() && this.hasJoinedAnyFolder()) {
                for (Folder folder : this.getController().getFolderRepository().getFolders(true)) {
                    folder.remove(this);
                }
            }
        }
    }

    public void markForImmediateConnect() {
        this.getController().getReconnectManager().markNodeForImmediateReconnection(this);
    }

    public boolean isInteresting() {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4 = this.getController().getIOProvider().getRelayedConnectionManager().isRelay(this.getInfo());
        boolean bl5 = bl3 = this.isServer() || bl4;
        if (this.getController().getNetworkingMode() == NetworkingMode.SERVERONLYMODE && !bl3) {
            return false;
        }
        boolean bl6 = bl2 = this.isServer() && ConfigurationEntry.SERVER_CONNECT_FROM_LAN_TO_INTERNET.getValueBoolean(this.getController()) != false;
        if (!bl2 && this.getController().isLanOnly() && !this.isOnLAN()) {
            return false;
        }
        if (this.isServer() || bl4) {
            return true;
        }
        Identity identity = this.getIdentity();
        if (identity != null) {
            if (Util.compareVersions("2.0.0", identity.getProgramVersion())) {
                this.logWarning("Rejecting connection to old program client: " + identity + " v" + identity.getProgramVersion());
                return false;
            }
            if (identity.isPendingMessages()) {
                return true;
            }
        }
        if (this.isFriend() || this.isOnLAN() || this.hasJoinedAnyFolder()) {
            return true;
        }
        boolean bl7 = bl = !this.getController().getNodeManager().maxConnectionsReached();
        if (bl && (this.getController().getMySelf().isSupernode() || this.getController().getMySelf().isServer())) {
            return true;
        }
        if (bl && this.isSupernode()) {
            return this.getController().getNodeManager().countConnectedSupernodes() < 3;
        }
        return false;
    }

    public boolean isConnecting() {
        return this.currentConnectTries.get() > 0;
    }

    public int markConnecting() {
        int n = this.currentConnectTries.incrementAndGet();
        this.getController().getNodeManager().connectingStateChanged(this);
        return n;
    }

    public int unmarkConnecting() {
        int n = this.currentConnectTries.decrementAndGet();
        this.getController().getNodeManager().connectingStateChanged(this);
        return n;
    }

    public boolean isConnected() {
        try {
            ConnectionHandler connectionHandler = this.peer;
            return connectionHandler != null && connectionHandler.isConnected();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isCompletelyConnected() {
        return this.handshaked && this.isConnected();
    }

    public boolean isSupernode() {
        return this.info.isSupernode;
    }

    public boolean isOnLAN() {
        try {
            ConnectionHandler connectionHandler = this.peer;
            if (connectionHandler != null) {
                return connectionHandler.isOnLAN();
            }
            if (this.info.getConnectAddress() == null) {
                return false;
            }
            InetAddress inetAddress = this.info.getConnectAddress().getAddress();
            if (inetAddress == null) {
                return false;
            }
            return this.getController().getNodeManager().isOnLANorConfiguredOnLAN(inetAddress);
        }
        catch (RuntimeException runtimeException) {
            this.logWarning("Unable to check if client is on LAN. " + runtimeException);
            return false;
        }
    }

    public void setOnLAN(boolean bl) {
        if (this.peer != null) {
            this.peer.setOnLAN(bl);
        }
    }

    public boolean receivedWrongIdentity() {
        return this.receivedWrongRemoteIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownPeer() {
        ConnectionHandler connectionHandler = this.peer;
        if (connectionHandler != null) {
            connectionHandler.shutdown();
            Object object = this.peerInitializeLock;
            synchronized (object) {
                this.peer = null;
            }
        }
    }

    public ConnectionHandler getPeer() {
        return this.peer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectResult setPeer(ConnectionHandler connectionHandler) throws InvalidIdentityException {
        boolean bl;
        Object object;
        Identity identity;
        MemberInfo memberInfo;
        Reject.ifNull(connectionHandler, "Illegal call of setPeer(null)");
        if (this.isFiner()) {
            this.logFiner("Setting peer to " + connectionHandler);
        }
        MemberInfo memberInfo2 = memberInfo = (identity = connectionHandler.getIdentity()) != null ? identity.getMemberInfo() : null;
        if (memberInfo != null && memberInfo.matches(this.getMySelf())) {
            this.logFine("Loopback connection detected to " + connectionHandler + ", disconnecting");
            connectionHandler.shutdown();
            throw new InvalidIdentityException("Loopback connection detected to " + connectionHandler + ", disconnecting", connectionHandler);
        }
        if (memberInfo != null && !memberInfo.isOnSameNetwork(this.getController())) {
            if (this.isFine()) {
                this.logFine("Closing connection to node with different network ID. Our netID: " + this.getController().getNodeManager().getNetworkId() + ", remote netID: " + memberInfo.networkId + " on " + memberInfo);
            }
            connectionHandler.shutdown();
            this.setConnectedToNetwork(false);
            this.lastProblem = new Problem("Network ID mismatch", true, 888);
            throw new InvalidIdentityException("Closing connection to node with different network ID. Our netID: " + this.getController().getNodeManager().getNetworkId() + ", remote netID: " + memberInfo.networkId + " on " + memberInfo, connectionHandler);
        }
        if (!connectionHandler.isConnected()) {
            this.logFine("Peer disconnected while initializing connection: " + connectionHandler);
            return ConnectResult.failure("Peer disconnected while initializing connection");
        }
        if (identity == null || !identity.isValid() || !memberInfo.matches(this)) {
            this.receivedWrongRemoteIdentity = memberInfo != null && !memberInfo.matches(this);
            String string = identity != null ? identity.getMemberInfo().id : "n/a";
            try {
                connectionHandler.sendMessage(IdentityReply.reject("Invalid identity: " + string + ", expeced " + this.info));
            }
            catch (ConnectionException connectionException) {
                this.logFiner("Unable to send identity reject", connectionException);
            }
            finally {
                connectionHandler.shutdown();
            }
            throw new InvalidIdentityException(this + " Remote peer has wrong identity. remote ID: " + string + ", expected ID: " + this.getId(), connectionHandler);
        }
        if (ConfigurationEntry.NET_VERSION_MINIMUM.hasNonBlankValue(this.getController())) {
            String string = ConfigurationEntry.NET_VERSION_MINIMUM.getValue(this.getController());
            object = identity.getProgramVersion();
            if (StringUtils.isNotBlank((String)object) && Util.compareVersions(string, (String)object)) {
                this.lastProblem = new Problem("Version too old. Required minimum version: " + string, true, 999);
                if (this.isFine()) {
                    this.logFine(memberInfo + ": Closing connection. Version too old. Required version: " + string + ", remote version: " + (String)object);
                }
                try {
                    connectionHandler.sendMessage(this.lastProblem);
                }
                catch (ConnectionException connectionException) {
                    // empty catch block
                }
                connectionHandler.shutdown();
                this.setConnectedToNetwork(false);
                throw new InvalidIdentityException("Closing connection. Version too old. Required version: " + string + ", remote version: " + (String)object + " of " + memberInfo, connectionHandler);
            }
        }
        if (!(bl = connectionHandler.acceptIdentity(this))) {
            connectionHandler.shutdown();
            this.logFiner("Remote side did not accept our identity: " + connectionHandler);
            return ConnectResult.failure("Remote side did not accept our identity");
        }
        if (!identity.getMemberInfo().id.equals(this.info.id)) {
            this.logWarning("Got wrong identity from peer. Expected: " + this.info + ". got: " + identity.getMemberInfo());
            connectionHandler.shutdown();
            return ConnectResult.failure("Got wrong identity from peer. Expected: " + this.info + ". got: " + identity.getMemberInfo());
        }
        this.info.nick = identity.getMemberInfo().nick;
        this.info.setLastConnectNow();
        object = this.peerInitializeLock;
        synchronized (object) {
            ConnectionHandler connectionHandler2 = this.peer;
            this.peer = connectionHandler;
            if (connectionHandler2 != null) {
                connectionHandler2.shutdown();
            }
        }
        if (connectionHandler.getRemoteListenerPort() > 0) {
            if (connectionHandler.isOnLAN()) {
                this.info.isSupernode = false;
                this.info.setConnectAddress(new InetSocketAddress(connectionHandler.getRemoteAddress().getAddress(), connectionHandler.getRemoteListenerPort()));
            } else if (identity.getMemberInfo().isSupernode) {
                this.info.isSupernode = true;
                this.info.setConnectAddress(identity.getMemberInfo().getConnectAddress());
            } else {
                this.info.isSupernode = false;
                this.info.setConnectAddress(new InetSocketAddress(connectionHandler.getRemoteAddress().getAddress(), connectionHandler.getRemoteListenerPort()));
            }
        } else if (!identity.isTunneled()) {
            this.info.setConnectAddress(null);
        }
        this.info.setD2dPort(identity.getMemberInfo().getD2dPort());
        if (this.peer instanceof D2DSocketConnectionHandler) {
            return ConnectResult.success();
        }
        return this.completeHandshake();
    }

    private void checkPeer() throws ConnectionException {
        if (!this.isConnected()) {
            this.shutdownPeer();
            throw new ConnectionException("Not connected").with(this);
        }
    }

    public ConnectResult reconnect() throws InvalidIdentityException {
        return this.reconnect(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectResult reconnect(boolean bl) throws InvalidIdentityException {
        ConnectResult connectResult;
        if (!this.getController().isStarted()) {
            return ConnectResult.failure("Controller is not started");
        }
        if (this.isCompletelyConnected()) {
            return ConnectResult.success();
        }
        if (this.isFine()) {
            this.logFine("Reconnecting (tried " + this.connectionRetries + " times");
        }
        ++this.connectionRetries;
        ConnectionHandler connectionHandler = null;
        try {
            if (bl) {
                this.markConnecting();
            }
            String string = this.getHostName();
            if (this.isFiner()) {
                this.logFiner("Reconnect hostname is: " + string);
            }
            if (!StringUtils.isBlank(string)) {
                this.info.setConnectAddress(new InetSocketAddress(string, this.info.getConnectAddress().getPort()));
            }
            if (!this.getController().isStarted()) {
                ConnectResult connectResult2 = ConnectResult.failure("Controller is not started");
                return connectResult2;
            }
            connectionHandler = this.getController().getIOProvider().getConnectionHandlerFactory().tryToConnect(this.getInfo());
            connectResult = this.setPeer(connectionHandler);
        }
        catch (InvalidIdentityException invalidIdentityException) {
            this.logFiner(invalidIdentityException);
            if (connectionHandler != null) {
                connectionHandler.shutdown();
            }
            throw invalidIdentityException;
        }
        catch (ConnectionException connectionException) {
            if (this.isServer()) {
                this.logWarning(connectionException.getMessage());
            } else {
                this.logFine(connectionException.getMessage());
            }
            this.logFiner(connectionException);
            if (connectionHandler != null) {
                connectionHandler.shutdown();
            }
            connectResult = ConnectResult.failure(connectionException.getMessage());
        }
        finally {
            if (bl) {
                this.unmarkConnecting();
            }
        }
        if (connectResult.isSuccess()) {
            this.setConnectedToNetwork(true);
            this.connectionRetries = 0;
        } else if (this.isUnableToConnect() && this.isConnectedToNetwork) {
            this.logFine("Unable to connect directly to " + this.getReconnectAddress());
            this.setConnectedToNetwork(false);
        }
        return connectResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectResult completeHandshake() {
        boolean bl;
        List<Folder> list;
        Object object;
        if (!this.isConnected()) {
            return ConnectResult.failure("Not connected");
        }
        ConnectionHandler connectionHandler = this.peer;
        if (connectionHandler == null) {
            return ConnectResult.failure("Peer is not set");
        }
        if (this.getController().getOSClient().isPrimaryServer(this)) {
            this.getController().getOSClient().primaryServerConnected(this);
        }
        boolean bl2 = this.handshaked;
        Identity identity = connectionHandler.getIdentity();
        boolean bl3 = false;
        if (this.getMySelf().isServer() && identity != null && !identity.isRequestFullFolderlist()) {
            bl3 = this.waitForFoldersJoin();
        }
        Object object2 = this.peerInitializeLock;
        synchronized (object2) {
            if (!this.isConnected() || identity == null) {
                this.logFine("Disconnected while completing handshake");
                return ConnectResult.failure("Disconnected while completing handshake");
            }
            FolderList folderList = this.getLastFolderList();
            object = this.getFilteredFolderList(folderList, identity.isRequestFullFolderlist());
            if (this.getProtocolVersion() < 106) {
                list = new FolderList((Collection<FolderInfo>)object, this.peer.getRemoteMagicId());
            } else if (this.getProtocolVersion() < 112) {
                list = new FolderListExt((Collection<FolderInfo>)object, this.peer.getRemoteMagicId());
            } else {
                bl = this.getProtocolVersion() >= 113;
                list = new FolderListExt((Collection<FolderInfo>)object, bl);
            }
            if (this.isFiner()) {
                this.logFiner("Sending CH " + (FolderList)((Object)list));
            }
            this.peer.sendMessagesAsynchron(new Message[]{list});
        }
        bl3 = this.waitForFoldersJoin();
        object2 = this.peerInitializeLock;
        synchronized (object2) {
            if (!this.isConnected()) {
                this.logFine("Disconnected while completing handshake");
                return ConnectResult.failure("Disconnected while completing handshake");
            }
            if (!bl3) {
                if (this.isConnected()) {
                    this.logFine("Did not receive a folder list after 60s, disconnecting");
                    return ConnectResult.failure("Did not receive a folder list after 60s, disconnecting (1)");
                }
                this.shutdown();
                return ConnectResult.failure("Did not receive a folder list after 60s, disconnecting (2)");
            }
            if (!this.isConnected()) {
                this.logFine("Disconnected while waiting for folder list");
                return ConnectResult.failure("Disconnected while waiting for folder list");
            }
        }
        object2 = this.getController().getNodeManager().createDefaultNodeListRequestMessage();
        boolean bl4 = true;
        object = this.peerInitializeLock;
        synchronized (object) {
            if (!this.isConnected()) {
                this.logFine("Disconnected while completing handshake");
                return ConnectResult.failure("Disconnected while completing handshake");
            }
            if (this.isInteresting()) {
                this.peer.sendMessagesAsynchron(new Message[]{object2});
                this.peer.sendMessagesAsynchron(this.getController().getTransferManager().getStatus());
            } else {
                this.logFine("Rejected, Node not interesting");
                try {
                    this.peer.sendMessage(new Problem("You are boring", true, 666));
                }
                catch (ConnectionException connectionException) {
                    // empty catch block
                }
                bl4 = false;
            }
        }
        boolean bl5 = this.peer != null && this.peer.acceptHandshake();
        boolean bl6 = bl4 = bl4 && this.isConnected() && bl5;
        if (!bl4) {
            list = "not handshaked: connected? " + this.isConnected() + ", acceptByCH? " + bl5 + ", interesting? " + this.isInteresting() + ", peer " + this.peer;
            if (this.isFiner()) {
                this.logFiner((String)((Object)list));
            }
            this.shutdown();
            return ConnectResult.failure((String)((Object)list));
        }
        list = this.sendFilelists();
        if (list == null) {
            return ConnectResult.failure("Unable to send filelists to " + this.getNick());
        }
        bl = this.waitForFileLists(list);
        if (!bl) {
            String string = "Disconnecting. Did not receive the full filelists for " + list.size() + " folders: " + list;
            if (this.isServer()) {
                this.logWarning(string);
            } else {
                this.logFine(string);
            }
            if (this.isFine()) {
                for (Folder folder : list) {
                    this.logFine("Got filelist for " + folder.getName() + " ? " + this.hasCompleteFileListFor(folder.getInfo()));
                }
            }
            this.shutdown();
            return ConnectResult.failure(string);
        }
        if (this.isFiner()) {
            this.logFiner("Got complete filelists");
        }
        this.sendMessageAsynchron(new HandshakeCompleted());
        long l = System.currentTimeMillis();
        if (!this.waitForHandshakeCompletion()) {
            long l2 = System.currentTimeMillis() - l;
            String string = null;
            connectionHandler = this.peer;
            if (connectionHandler == null || !connectionHandler.isConnected()) {
                if (this.lastProblem == null) {
                    string = "Peer " + this.getNick() + " disconnected while waiting for handshake acknownledge (or problem)";
                }
            } else if (this.lastProblem == null) {
                string = "Did not receive a handshake not acknownledged (or problem) from " + this.getNick() + " after " + (int)(l2 / 1000L) + "s";
            }
            this.shutdown();
            if (string != null && this.isFine()) {
                this.logFine(string);
            }
            return ConnectResult.failure(string);
        }
        if (this.isFiner()) {
            this.logFiner("Got handshake completion");
        }
        this.connectionRetries = 0;
        if (bl2 != this.handshaked) {
            this.getController().getNodeManager().connectStateChanged(this);
            boolean bl7 = Feature.P2P_REQUIRES_LOGIN_AT_SERVER.isEnabled();
            this.getController().getSecurityManager().nodeAccountStateChanged(this, bl7);
        }
        for (Folder folder : list) {
            if (folder.getSyncProfile().isAutodownload()) {
                this.getController().getFolderRepository().getFileRequestor().triggerFileRequesting(folder.getInfo());
            }
            if (!folder.getSyncProfile().isSyncDeletion()) continue;
            folder.triggerSyncRemoteDeletedFiles(Collections.singleton(this), false);
        }
        if (this.getController().isDebugReports()) {
            this.sendMessageAsynchron(new RequestNodeInformation());
        }
        if (this.handshaked) {
            return ConnectResult.success();
        }
        return ConnectResult.failure("Not handshaked");
    }

    private List<Folder> sendFilelists() {
        List<Folder> list = this.getFoldersActuallyJoined();
        List<Folder> list2 = this.getFoldersRequestedToJoin();
        if (this.isFine() && !list.isEmpty()) {
            this.logFine("Joined " + list.size() + " folders: " + list);
        } else if (this.isFiner()) {
            this.logFiner("Joined " + list.size() + " folders: " + list);
        }
        for (Folder folder : list) {
            Message[] messageArray;
            folder.waitForScan();
            if (folder.hasOwnDatabase()) {
                messageArray = FileList.create(folder, folder.supportExternalizable(this));
            } else {
                messageArray = new Message[1];
                if (this.isFine()) {
                    this.logFine("Creating empty FileList for " + folder.getName() + " to send to " + this + " while sending FileList. No folder db", new StackDump());
                }
                messageArray[0] = FileList.createEmpty(folder.getInfo(), folder.supportExternalizable(this));
            }
            for (Message message : messageArray) {
                try {
                    this.sendMessage(message);
                }
                catch (ConnectionException connectionException) {
                    this.shutdown();
                    return null;
                }
            }
            list2.remove(folder);
        }
        if (!list2.isEmpty()) {
            if (this.isFine()) {
                this.logFine("Requested join : " + list2);
                this.logFine("Actually joined: " + list);
            }
            for (Folder folder : list2) {
                if (this.isFine()) {
                    this.logFine("Creating empty FileList for " + folder.getName() + " to send to " + this + " while sending FileList. Requested folder but not joined.", new StackDump());
                }
                this.sendMessagesAsynchron(FileList.createEmpty(folder.getInfo(), folder.supportExternalizable(this)));
            }
        }
        return list;
    }

    private boolean waitForFileLists(List<Folder> list) {
        if (this.isFiner()) {
            this.logFiner("Waiting for complete fileslists...");
        }
        Waiter waiter = new Waiter(0x6DDD00L);
        boolean bl = false;
        Date date = null;
        while (!waiter.isTimeout() && this.isConnected()) {
            boolean bl2;
            bl = true;
            for (Folder folder : list) {
                if (this.hasCompleteFileListFor(folder.getInfo())) continue;
                bl = false;
                break;
            }
            if (bl) break;
            Date date2 = date = this.peer != null ? this.peer.getLastKeepaliveMessageTime() : null;
            if (date == null) {
                this.logWarning("Unable to check last received message date. got null while waiting for filelist");
                return false;
            }
            boolean bl3 = bl2 = System.currentTimeMillis() - date.getTime() > 60000L;
            if (bl2) {
                if (this.isFine()) {
                    this.logFine("No message received since 1 minute while waiting for filelist from " + this.getNick());
                }
                return false;
            }
            try {
                waiter.waitABit();
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (waiter.isTimeout()) {
            this.logWarning("Timeout (" + waiter.getWaitTimeMS() / 60000L + " minutes) while waiting for filelist");
        }
        if (!this.isConnected() && this.isFine()) {
            this.logFine("Disconnected while waiting for filelist");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForFoldersJoin() {
        Object object = this.folderListWaiter;
        synchronized (object) {
            if (!this.folderListReceived) {
                try {
                    if (this.isFiner()) {
                        this.logFiner("Waiting for folderlist");
                    }
                    this.folderListWaiter.wait(60000L);
                }
                catch (InterruptedException interruptedException) {
                    this.logFiner(interruptedException);
                }
            }
        }
        this.folderJoinLock.lock();
        this.folderJoinLock.unlock();
        return this.folderListReceived;
    }

    private boolean waitForHandshakeCompletion() {
        Waiter waiter = new Waiter(0x6DDD00L);
        while (!waiter.isTimeout()) {
            boolean bl;
            Date date;
            if (this.lastHandshakeCompleted != null && this.handshaked) {
                return true;
            }
            if (this.isFiner()) {
                this.logFiner("Waiting for handshake complete message");
            }
            Date date2 = date = this.peer != null ? this.peer.getLastKeepaliveMessageTime() : null;
            if (date == null) {
                this.logFine("Unable to check last received message date. Got disconnected while waiting for handshake complete");
                return false;
            }
            boolean bl2 = bl = System.currentTimeMillis() - date.getTime() > 60000L;
            if (bl) {
                if (this.isFine()) {
                    this.logFine("No message received from " + this.getNick() + " since 1 minute while waiting for handshake complete");
                }
                return false;
            }
            if (!this.isConnected()) {
                return false;
            }
            waiter.waitABit();
        }
        return this.lastHandshakeCompleted != null && this.handshaked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.isMySelf()) {
            return;
        }
        boolean bl = this.handshaked;
        this.shutdownPeer();
        Iterator<Folder> iterator = this.folderListWaiter;
        synchronized (iterator) {
            this.folderListWaiter.notifyAll();
        }
        this.folderListReceived = false;
        this.lastFolderList = null;
        this.setConnectedToNetwork(false);
        this.handshaked = false;
        this.lastHandshakeCompleted = null;
        this.lastTransferStatus = null;
        this.expectedListMessages.clear();
        this.messageListenerSupport = null;
        for (Folder folder : this.getFoldersActuallyJoined()) {
            folder.getDAO().deleteDomain(this.getId(), -1);
        }
        if (bl) {
            this.info.setLastConnectNow();
            this.getController().getSecurityManager().nodeAccountStateChanged(this, false);
            this.getController().getNodeManager().connectStateChanged(this);
        }
    }

    public void sendMessage(Message message) throws ConnectionException {
        this.checkPeer();
        ConnectionHandler connectionHandler = this.peer;
        if (connectionHandler == null) {
            return;
        }
        connectionHandler.waitForEmptySendQueue();
        connectionHandler = this.peer;
        if (connectionHandler == null) {
            return;
        }
        connectionHandler.sendMessage(message);
    }

    public void sendMessageAsynchron(Message message) {
        ConnectionHandler connectionHandler = this.peer;
        if (connectionHandler != null && connectionHandler.isConnected()) {
            connectionHandler.sendMessagesAsynchron(message);
        }
    }

    public void sendMessagesAsynchron(Message ... messageArray) {
        ConnectionHandler connectionHandler = this.peer;
        if (connectionHandler != null && connectionHandler.isConnected()) {
            connectionHandler.sendMessagesAsynchron(messageArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message message, ConnectionHandler connectionHandler) {
        if (message == null) {
            throw new NullPointerException("Unable to handle message, message is null");
        }
        ProfilingEntry profilingEntry = null;
        if (Profiling.ENABLED) {
            profilingEntry = Profiling.start(this.getClass(), "handleMessage", message.getClass().getSimpleName());
        }
        int n = -1;
        long l = System.currentTimeMillis();
        try {
            Folder folder;
            FolderInfo folderInfo;
            if (this.getController().getOSClient().isPrimaryServer(this)) {
                ServerClient.SERVER_HANDLE_MESSAGE_THREAD.set(true);
            }
            if (message instanceof FolderRelatedMessage) {
                folderInfo = ((FolderRelatedMessage)message).folder;
                if (folderInfo != null) {
                    folder = this.getController().getFolderRepository().getFolder(folderInfo);
                } else {
                    folder = null;
                    this.logWarning("Got folder message without FolderInfo: " + message);
                }
            } else {
                folderInfo = null;
                folder = null;
            }
            if (message instanceof Ping) {
                Pong pong = new Pong((Ping)message);
                this.sendMessagesAsynchron(pong);
                n = 50;
            } else if (message instanceof HandshakeCompleted) {
                this.lastHandshakeCompleted = (HandshakeCompleted)message;
                this.handshaked = true;
                n = 100;
            } else if (message instanceof FolderList) {
                FolderList folderList = (FolderList)message;
                if (this.isWarning() && !this.isServer() && (folderList.folders != null && folderList.folders.length > 500 || folderList.secretFolders != null && folderList.secretFolders.length > 500) && this.getController().getFolderRepository().getFoldersCount() < 500) {
                    this.logWarning("Received large " + folderList);
                }
                this.getController().getIOProvider().startIO(() -> this.processFolderList(folderList, connectionHandler));
                n = 300;
            } else if (message instanceof ScanCommand) {
                if (folder != null) {
                    if (folder.getSyncProfile().isInstantSync() || folder.getSyncProfile().isPeriodicSync()) {
                        this.logFiner("Remote sync command received on " + folder);
                        this.getController().setPaused(false);
                        folder.recommendScanOnNextMaintenance();
                        this.getController().getFolderRepository().triggerMaintenance();
                    }
                    if (folder.getSyncProfile().isAutodownload()) {
                        this.getController().getFolderRepository().getFileRequestor().triggerFileRequesting(folderInfo);
                    }
                }
                n = 50;
            } else if (message instanceof FileRequestCommand) {
                if (folder != null && folder.getSyncProfile().isAutodownload()) {
                    this.getController().getFolderRepository().getFileRequestor().triggerFileRequesting(folderInfo);
                }
                n = 50;
            } else if (message instanceof FolderDBMaintCommando) {
                final FolderDBMaintCommando folderDBMaintCommando = (FolderDBMaintCommando)message;
                if (folder != null) {
                    this.getController().getIOProvider().startIO(new Runnable(){

                        @Override
                        public void run() {
                            folder.maintainFolderDB(folderDBMaintCommando.getDate().getTime());
                        }
                    });
                }
                n = 50;
            } else if (message instanceof RequestDownload) {
                final RequestDownload requestDownload = (RequestDownload)message;
                if (this.getController().isPaused()) {
                    this.logFine("Sending abort (paused) of " + requestDownload.file);
                    this.sendMessagesAsynchron(new AbortUpload(requestDownload.file));
                } else {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            Upload upload = Member.this.getController().getTransferManager().queueUpload(Member.this, requestDownload);
                            if (upload == null && Member.this.isCompletelyConnected()) {
                                if (Member.this.isFine()) {
                                    Member.this.logFine("Sending abort of " + requestDownload.file);
                                }
                                Member.this.sendMessagesAsynchron(new AbortUpload(requestDownload.file));
                            }
                            if (Member.this.getController().isPaused()) {
                                if (Member.this.isInfo()) {
                                    Member.this.logInfo("Sending abort (paused) of " + requestDownload.file);
                                }
                                Member.this.sendMessagesAsynchron(new AbortUpload(requestDownload.file));
                            }
                        }
                    };
                    this.getController().getIOProvider().startIO(runnable);
                }
                n = 100;
            } else if (message instanceof DownloadQueued) {
                DownloadQueued downloadQueued = (DownloadQueued)message;
                Download download = this.getController().getTransferManager().getActiveDownload(this, downloadQueued.file);
                if (download != null) {
                    download.setQueued(downloadQueued.file);
                } else if (!this.downloadRecentlyCompleted(downloadQueued.file)) {
                    this.logFine("Remote side queued non-existant download: " + downloadQueued.file);
                    this.sendMessageAsynchron(new AbortDownload(downloadQueued.file));
                }
                n = 100;
            } else if (message instanceof AbortDownload) {
                AbortDownload abortDownload = (AbortDownload)message;
                this.logFine("Received " + abortDownload);
                this.getController().getTransferManager().abortUpload(abortDownload.file, this);
                n = 100;
            } else if (message instanceof AbortUpload) {
                AbortUpload abortUpload = (AbortUpload)message;
                this.getController().getTransferManager().abortDownload(abortUpload.file, this);
                n = 100;
            } else if (message instanceof FileChunk) {
                FileChunk fileChunk = (FileChunk)message;
                Download download = this.getController().getTransferManager().getActiveDownload(this, fileChunk.file);
                if (download != null) {
                    download.addChunk(fileChunk);
                } else if (this.downloadRecentlyCompleted(fileChunk.file)) {
                    this.sendMessageAsynchron(new AbortDownload(fileChunk.file));
                }
                n = -1;
            } else if (message instanceof RequestNodeList) {
                RequestNodeList requestNodeList = (RequestNodeList)message;
                this.getController().getNodeManager().receivedRequestNodeList(requestNodeList, this);
                n = 100;
            } else if (message instanceof KnownNodes) {
                KnownNodes knownNodes = (KnownNodes)message;
                for (int i = 0; i < knownNodes.nodes.length; ++i) {
                    MemberInfo memberInfo = knownNodes.nodes[i];
                    if (memberInfo == null || !this.getInfo().equals(memberInfo)) continue;
                    this.updateInfo(memberInfo);
                }
                this.getController().getNodeManager().queueNewNodes(knownNodes.nodes);
                n = 200;
            } else if (message instanceof RequestNodeInformation) {
                if (this.getController().isDebugReports()) {
                    this.sendMessageAsynchron(new NodeInformation(this.getController()));
                    n = 50;
                }
            } else if (message instanceof TransferStatus) {
                this.lastTransferStatus = (TransferStatus)message;
                n = 50;
            } else if (message instanceof NodeInformation) {
                if (this.isFiner()) {
                    this.logFiner("Node information received");
                }
                if (LoggingManager.isLogToFile()) {
                    Debug.writeNodeInformation((NodeInformation)message);
                }
                n = -1;
            } else if (message instanceof SettingsChange) {
                SettingsChange settingsChange = (SettingsChange)message;
                if (settingsChange.newInfo != null) {
                    this.logFine("Changed nick to " + settingsChange.newInfo.nick);
                    this.setNick(settingsChange.newInfo.nick);
                }
                n = 50;
            } else if (message instanceof FileListRequest) {
                if (folder != null) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            if (folder.hasReadPermission(Member.this)) {
                                Message[] messageArray;
                                folder.waitForScan();
                                if (Member.this.isFine()) {
                                    Member.this.logFine(Member.this.getUsername() + ": Resending file list of " + folder.getName());
                                }
                                for (Message message : messageArray = FileList.create(folder, folder.supportExternalizable(Member.this))) {
                                    try {
                                        Member.this.sendMessage(message);
                                    }
                                    catch (ConnectionException connectionException) {
                                        Member.this.logFine("Unable to send new filelist of " + folder.getName() + ". " + connectionException);
                                    }
                                }
                            }
                        }
                    };
                    this.getController().getIOProvider().startIO(runnable);
                }
            } else if (message instanceof FileList) {
                FileList fileList = (FileList)message;
                if (this.isFine()) {
                    this.logFine("Received new filelist. Expecting " + fileList.nFollowingDeltas + " more deltas. " + message);
                }
                this.expectedListMessages.put(fileList.folder, fileList.nFollowingDeltas);
                if (folder != null) {
                    folder.fileListChanged(this, fileList);
                }
                n = 250;
            } else if (message instanceof FolderFilesChanged) {
                FileInfo fileInfo;
                int n2;
                FolderFilesChanged folderFilesChanged = (FolderFilesChanged)message;
                Integer n3 = this.expectedListMessages.get(folderFilesChanged.folder);
                if (n3 == null) {
                    this.logFine("Received folder changes, but not received the full filelist. Ignoring: " + folderFilesChanged);
                    return;
                }
                n3 = n3 - 1;
                this.expectedListMessages.put(folderFilesChanged.folder, n3);
                TransferManager transferManager = this.getController().getTransferManager();
                if (folderFilesChanged.getFiles() != null) {
                    for (n2 = 0; n2 < folderFilesChanged.getFiles().length; ++n2) {
                        fileInfo = folderFilesChanged.getFiles()[n2];
                        transferManager.abortDownload(fileInfo, this);
                    }
                }
                if (folderFilesChanged.getRemoved() != null) {
                    for (n2 = 0; n2 < folderFilesChanged.getRemoved().length; ++n2) {
                        fileInfo = folderFilesChanged.getRemoved()[n2];
                        transferManager.abortDownload(fileInfo, this);
                    }
                }
                if (this.isFine()) {
                    n2 = this.expectedListMessages.get(folderInfo);
                    if (n2 >= 0) {
                        this.logFine("Received folder change. Expecting " + n2 + " more deltas. " + message);
                    } else {
                        this.logFine("Received folder change. Received " + -n2 + " additional deltas. " + message);
                    }
                }
                if (folder != null) {
                    folder.fileListChanged(this, folderFilesChanged);
                }
                n = 250;
            } else if (message instanceof Invitation) {
                Invitation invitation = (Invitation)message;
                if (!this.getController().getOSClient().isPrimaryServer(this)) {
                    invitation.setSenderDevice(this.getInfo());
                }
                this.getController().invitationReceived(invitation);
                n = 100;
            } else if (message instanceof Problem) {
                this.lastProblem = (Problem)message;
                if (this.lastProblem.problemCode == 666) {
                    this.logFine("Problem received: Node reject our connection, we should not longer try to connect");
                    this.setConnectedToNetwork(true);
                } else if (this.lastProblem.problemCode == 777) {
                    if (this.getMySelf().isServer()) {
                        this.logFine("Problem received: Node thinks we have a dupe connection");
                    } else {
                        this.logWarning("Problem received: Node thinks we have a dupe connection");
                    }
                } else if (this.lastProblem.problemCode == 999) {
                    this.logWarning("Our program version is too old: " + this.lastProblem);
                    if (this.getController().isUIEnabled()) {
                        this.getController().getUIController().getApplicationModel().getNoticesModel().handleNotice(new VersionTooOldNotice());
                    }
                } else {
                    this.logWarning("Received: " + this.lastProblem);
                }
                if (this.lastProblem.fatal) {
                    this.shutdown();
                }
                n = 100;
            } else if (message instanceof SearchNodeRequest) {
                SearchNodeRequest searchNodeRequest = (SearchNodeRequest)message;
                this.getController().getNodeManager().receivedSearchNodeRequest(searchNodeRequest, this);
                n = 50;
            } else if (message instanceof AddFriendNotification) {
                AddFriendNotification addFriendNotification = (AddFriendNotification)message;
                this.getController().makeFriendship(addFriendNotification.getMemberInfo());
                n = 50;
            } else if (message instanceof RevertedFile) {
                RevertedFile revertedFile = (RevertedFile)message;
                if (folder != null) {
                    Path path = revertedFile.file.getDiskFile(this.getController().getFolderRepository());
                    FolderReadOnlyProblem folderReadOnlyProblem = new FolderReadOnlyProblem(folder, path, true);
                    folder.addProblem(folderReadOnlyProblem);
                }
            } else if (message instanceof QuotaExceeded) {
                if (this.getController().isUIEnabled()) {
                    this.getController().getUIController().getApplicationModel().getNoticesModel().handleNotice(CloudStorageNotice.full());
                }
            } else if (message instanceof RequestPart) {
                RequestPart requestPart = (RequestPart)message;
                Upload upload = this.getController().getTransferManager().getUpload(this, requestPart.getFile());
                if (upload != null) {
                    upload.enqueuePartRequest(requestPart);
                } else {
                    this.sendMessageAsynchron(new AbortUpload(requestPart.getFile()));
                }
                n = 100;
            } else if (message instanceof StartUpload) {
                StartUpload startUpload = (StartUpload)message;
                Download download = this.getController().getTransferManager().getActiveDownload(this, startUpload.getFile());
                if (download != null) {
                    download.uploadStarted(startUpload.getFile());
                } else if (this.downloadRecentlyCompleted(startUpload.getFile())) {
                    this.logFine("Download invalid or obsolete:" + startUpload.getFile());
                    this.sendMessageAsynchron(new AbortDownload(startUpload.getFile()));
                }
                n = 100;
            } else if (message instanceof StopUpload) {
                StopUpload stopUpload = (StopUpload)message;
                Upload upload = this.getController().getTransferManager().getUpload(this, stopUpload.getFile());
                if (upload != null) {
                    upload.stopUploadRequest(stopUpload);
                }
                n = 100;
            } else if (message instanceof RequestFilePartsRecord) {
                RequestFilePartsRecord requestFilePartsRecord = (RequestFilePartsRecord)message;
                Upload upload = this.getController().getTransferManager().getUpload(this, requestFilePartsRecord.getFile());
                if (upload != null) {
                    upload.receivedFilePartsRecordRequest(requestFilePartsRecord);
                } else {
                    this.sendMessageAsynchron(new AbortUpload(requestFilePartsRecord.getFile()));
                }
                n = 100;
            } else if (message instanceof ReplyFilePartsRecord) {
                ReplyFilePartsRecord replyFilePartsRecord = (ReplyFilePartsRecord)message;
                Download download = this.getController().getTransferManager().getActiveDownload(this, replyFilePartsRecord.getFile());
                if (download != null) {
                    download.receivedFilePartsRecord(replyFilePartsRecord.getFile(), replyFilePartsRecord.getRecord());
                } else if (this.downloadRecentlyCompleted(replyFilePartsRecord.getFile())) {
                    this.logInfo("Download not found: " + download);
                    this.sendMessageAsynchron(new AbortDownload(replyFilePartsRecord.getFile()));
                }
                n = 100;
            } else if (message instanceof RelayedMessage) {
                RelayedMessage relayedMessage = (RelayedMessage)message;
                this.getController().getIOProvider().getRelayedConnectionManager().handleRelayedMessage(this, relayedMessage);
                n = -1;
            } else if (message instanceof UDTMessage) {
                this.getController().getIOProvider().getUDTSocketConnectionManager().handleUDTMessage(this, (UDTMessage)message);
                n = 50;
            } else if (message instanceof FileHistoryRequest) {
                final FileInfo fileInfo = ((FileHistoryRequest)message).getFileInfo();
                this.getController().getIOProvider().startIO(new Runnable(){

                    @Override
                    public void run() {
                        Folder folder = Member.this.getController().getFolderRepository().getFolder(fileInfo.getFolderInfo());
                        if (folder == null) {
                            Member.this.logWarning("Illegal FileHistoryRequest : This client is not member of the folder.");
                            return;
                        }
                        Member.this.sendMessageAsynchron(new FileHistoryReply(folder.getDAO().getFileHistory(fileInfo), fileInfo));
                    }
                });
            } else if (message instanceof FileHistoryReply) {
                this.getController().getFolderRepository().getFileRequestor().receivedFileHistory((FileHistoryReply)message);
            } else if (message instanceof AccountStateChanged) {
                Member member;
                AccountStateChanged accountStateChanged = (AccountStateChanged)message;
                if (this.isFine()) {
                    this.logFine("Received: " + accountStateChanged);
                }
                if ((member = accountStateChanged.getNode().getNode(this.getController(), false)) != null) {
                    this.getController().getSecurityManager().nodeAccountStateChanged(member, true);
                }
                accountStateChanged.decreaseTTL();
                if (accountStateChanged.isAlive()) {
                    this.getController().getNodeManager().broadcastMessage(accountStateChanged, new Filter<Member>(){

                        @Override
                        public boolean accept(Member member) {
                            return !this.equals(member) && !member.isServer();
                        }
                    });
                }
            } else if (message instanceof ConfigurationLoadRequest) {
                boolean bl = this.getController().getOSClient().isFederatedServer(this);
                if (this.isServer() && !bl) {
                    ConfigurationLoadRequest configurationLoadRequest = (ConfigurationLoadRequest)message;
                    if (!this.getController().getMySelf().isServer()) {
                        ConfigurationLoader.processMessage(this.getController(), configurationLoadRequest);
                    } else if (configurationLoadRequest.isKeyValue()) {
                        ConfigurationLoader.processMessage(this.getController(), configurationLoadRequest);
                    } else {
                        this.logFine("Ignoring full reload config request for myself being server: " + message);
                    }
                } else if (bl) {
                    this.logFine("Ignoring reload config request from federated server: " + message);
                } else {
                    this.logWarning("Ignoring reload config request from non server: " + message);
                }
            } else if (this.isFiner()) {
                this.logFiner("Message not known to message handling code, maybe handled in listener: " + message);
            }
            this.getController().getNodeManager().messageReceived(this, message);
            this.fireMessageToListeners(message);
        }
        finally {
            ServerClient.SERVER_HANDLE_MESSAGE_THREAD.set(false);
            Profiling.end(profilingEntry, n);
            long l2 = System.currentTimeMillis() - l;
            if (l2 > 60000L) {
                this.logWarning("Handling took " + l2 / 1000L + "s: " + message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFolderList(FolderList folderList, ConnectionHandler connectionHandler) {
        Object object;
        try {
            boolean bl;
            this.nextFolderList = folderList;
            this.folderJoinLock.lock();
            if (folderList != this.nextFolderList) {
                if (this.isFine()) {
                    this.logFine("Skipping: " + folderList + " for newer list: " + this.nextFolderList);
                }
                return;
            }
            this.lastFolderList = folderList;
            this.folderListReceived = true;
            this.joinToLocalFolders(folderList, connectionHandler);
            object = this.peer;
            Identity identity = object != null ? object.getIdentity() : null;
            boolean bl2 = bl = identity != null && identity.isRequestFullFolderlist();
            if (this.getMySelf().isServer() && !bl && object != null) {
                FolderList folderList2;
                String string = object.getRemoteMagicId();
                Collection<FolderInfo> collection = this.getFilteredFolderList(folderList, false);
                if (this.getProtocolVersion() < 106) {
                    folderList2 = new FolderList(collection, string);
                } else if (this.getProtocolVersion() < 112) {
                    folderList2 = new FolderListExt(collection, string);
                } else {
                    boolean bl3 = this.getProtocolVersion() >= 113;
                    folderList2 = new FolderListExt(collection, bl3);
                }
                if (this.isFine()) {
                    this.logFine("Sending HM " + folderList2);
                }
                this.sendMessageAsynchron(folderList2);
            }
        }
        finally {
            this.folderJoinLock.unlock();
        }
        object = this.folderListWaiter;
        synchronized (object) {
            this.folderListWaiter.notifyAll();
        }
    }

    public void addMessageListener(MessageListener messageListener) {
        this.getMessageListenerSupport().addMessageListener(messageListener);
    }

    public void addMessageListener(Class<?> clazz, MessageListener messageListener) {
        this.getMessageListenerSupport().addMessageListener(clazz, messageListener);
    }

    public void removeMessageListener(MessageListener messageListener) {
        this.getMessageListenerSupport().removeMessageListener(messageListener);
    }

    @Override
    public void removeAllListeners() {
        if (this.isFiner()) {
            this.logFiner("Removing all listeners from member");
        }
        super.removeAllListeners();
        this.getMessageListenerSupport().removeAllListeners();
    }

    public void fireMessageToListeners(Message message) {
        MessageListenerSupport messageListenerSupport = this.getMessageListenerSupport();
        if (messageListenerSupport != null) {
            messageListenerSupport.fireMessage(this, message);
        }
    }

    private synchronized MessageListenerSupport getMessageListenerSupport() {
        if (this.messageListenerSupport == null) {
            this.messageListenerSupport = new MessageListenerSupport(this);
        }
        return this.messageListenerSupport;
    }

    public void synchronizeFolderMemberships() {
        this.synchronizeFolderMemberships(null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizeFolderMemberships(AtomicBoolean atomicBoolean, boolean bl) {
        String string;
        if (this.isMySelf()) {
            return;
        }
        if (!this.isCompletelyConnected()) {
            return;
        }
        ConnectionHandler connectionHandler = this.peer;
        String string2 = string = connectionHandler != null ? connectionHandler.getRemoteMagicId() : null;
        if (connectionHandler == null || StringUtils.isBlank(string)) {
            return;
        }
        try {
            while (!this.folderJoinLock.tryLock(50L, TimeUnit.MILLISECONDS)) {
                if (atomicBoolean == null || !atomicBoolean.get()) continue;
                if (this.isFine()) {
                    this.logFine("SFM canceled");
                }
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        try {
            FolderList folderList;
            Identity identity;
            FolderList folderList2 = this.getLastFolderList();
            if (folderList2 != null) {
                if (!bl) {
                    this.joinToLocalFolders(folderList2, connectionHandler);
                }
            } else {
                this.logWarning("Unable to synchronize memberships, did not received folderlist");
            }
            boolean bl2 = (identity = connectionHandler.getIdentity()) != null && identity.isRequestFullFolderlist();
            Collection<FolderInfo> collection = this.getFilteredFolderList(folderList2, bl2);
            if (this.getProtocolVersion() < 106) {
                folderList = new FolderList(collection, string);
            } else if (this.getProtocolVersion() < 112) {
                folderList = new FolderListExt(collection, string);
            } else {
                boolean bl3 = this.getProtocolVersion() >= 113;
                folderList = new FolderListExt(collection, bl3);
            }
            if (this.isFiner()) {
                this.logFiner("Sending SFM " + folderList);
            }
            this.sendMessageAsynchron(folderList);
        }
        finally {
            this.folderJoinLock.unlock();
        }
    }

    private Collection<FolderInfo> getFilteredFolderList(FolderList folderList, boolean bl) {
        Collection<FolderInfo> collection = this.getController().getFolderRepository().getJoinedFolderInfos();
        if (bl) {
            return collection;
        }
        if (folderList == null || this.peer == null) {
            return collection;
        }
        if (this.getMySelf().isServer()) {
            LinkedList<FolderInfo> linkedList = new LinkedList<FolderInfo>();
            if (this.getProtocolVersion() < 112) {
                String string = this.peer.getMyMagicId();
                if (StringUtils.isNotBlank(string)) {
                    for (FolderInfo folderInfo : collection) {
                        if (!folderList.contains(folderInfo, string)) continue;
                        linkedList.add(folderInfo);
                    }
                }
            } else {
                for (FolderInfo folderInfo : collection) {
                    if (!folderList.contains(folderInfo)) continue;
                    linkedList.add(folderInfo);
                }
            }
            if (this.isFiner() && collection.size() != linkedList.size()) {
                this.logFiner("Generated optimized folder list: " + linkedList.size() + "/" + collection.size());
            }
            return linkedList;
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void joinToLocalFolders(FolderList folderList, ConnectionHandler connectionHandler) {
        FolderRepository folderRepository = this.getController().getFolderRepository();
        HashSet<FolderInfo> hashSet = new HashSet<FolderInfo>();
        Collection<Folder> collection = folderRepository.getFolders();
        this.folderJoinLock.lock();
        try {
            PFComponent pFComponent;
            if (connectionHandler == null) {
                this.logWarning("Unable to join to local folders. peer is null/disconnected");
                return;
            }
            if (folderList.folders != null && folderList.folders.length > 0 || this.getProtocolVersion() >= 112) {
                for (FolderInfo folderInfo : folderList.folders) {
                    Folder folder = folderInfo.getFolder(this.getController());
                    if (folder == null) continue;
                    if (!folder.join(this)) {
                        if (!this.isFiner()) continue;
                        this.logFiner("Did not join into: " + folder);
                        continue;
                    }
                    if (this.isFiner()) {
                        this.logFiner("Joined " + folder);
                    }
                    hashSet.add(folder.getInfo());
                    if (!folderList.joinedMetaFolders) continue;
                    Folder object = folderRepository.getMetaFolder(folder.getInfo());
                    if (object == null) {
                        this.logFine("Unable to join meta folder. Not found " + folder);
                        continue;
                    }
                    if (!object.join(this)) {
                        if (!this.isFine()) continue;
                        this.logFine("Unable to join meta folder of " + folder);
                        continue;
                    }
                    hashSet.add(object.getInfo());
                    if (this.isFiner()) {
                        this.logFiner("Joined meta folder: " + object);
                    }
                    boolean bl = !folderInfo.getName().equals(folder.getName());
                    pFComponent = connectionHandler.getMember();
                    if (folderInfo.getVersion() > folder.getInfo().getVersion()) {
                        if (pFComponent == null || !folder.hasAdminPermission((Member)pFComponent)) continue;
                        if (bl) {
                            this.logInfo("Renaming local " + folder.getInfo() + ". Remote: " + folderInfo + ". " + (Member)pFComponent);
                        }
                        if (this.getMySelf().isServer()) {
                            this.getController().getFolderRepository().renameFolder(folderInfo, false, null);
                            continue;
                        }
                        new FolderRenameTask(folderInfo, (Member)pFComponent).scheduleTask(this.getController());
                        continue;
                    }
                    if (!bl || folderInfo.getVersion() != folder.getInfo().getVersion() || folderInfo.getVersion() == 0) continue;
                    if (this.getMySelf().isServer()) {
                        FolderInfo folderInfo2 = FolderInfoFactory.resolveConflict(folder.getInfo());
                        this.getController().getFolderRepository().renameFolder(folderInfo2, false, null);
                        this.logInfo("Renaming conflict detected. Name differs but same version. Local: " + folder.getInfo() + ". Remote: " + folderInfo + ". " + (Member)pFComponent + ". Resolved into: " + folderInfo2);
                        continue;
                    }
                    this.logWarning("Renaming conflict detected. Name differs but same version. Local: " + folder.getInfo() + ". Remote: " + folderInfo + ". " + (Member)pFComponent);
                }
            } else {
                String string = connectionHandler.getMyMagicId();
                if (StringUtils.isBlank(string)) {
                    this.logWarning("Unable to join to local folders. Own magic id of peer is blank: " + this.peer);
                    return;
                }
                if (folderList.secretFolders != null && folderList.secretFolders.length > 0) {
                    HashMap<String, Folder> hashMap = new HashMap<String, Folder>();
                    for (Folder folder : collection) {
                        String string2 = folder.getInfo().calculateSecureId(string);
                        hashMap.put(string2, folder);
                    }
                    for (FolderInfo folderInfo : folderList.secretFolders) {
                        if (!hashMap.containsKey(folderInfo.id)) continue;
                        Folder folder = (Folder)hashMap.get(folderInfo.id);
                        if (folder.join(this)) {
                            if (this.isFiner()) {
                                this.logFiner("Joined " + folder);
                            }
                            hashSet.add(folder.getInfo());
                            if (!folderList.joinedMetaFolders) continue;
                            pFComponent = folderRepository.getMetaFolder(folder.getInfo());
                            if (pFComponent != null) {
                                if (((Folder)pFComponent).join(this)) {
                                    hashSet.add(((Folder)pFComponent).getInfo());
                                    if (!this.isFiner()) continue;
                                    this.logFiner("Joined meta folder: " + (Folder)pFComponent);
                                    continue;
                                }
                                this.logFine("Unable to join meta folder of " + folder);
                                continue;
                            }
                            this.logFine("Unable to join meta folder. Not found " + folder);
                            continue;
                        }
                        if (!this.isFine()) continue;
                        this.logFine("Did not join into: " + folder);
                    }
                }
            }
            for (Folder folder : folderRepository.getFolders(true)) {
                if (hashSet.contains(folder.getInfo())) continue;
                folder.remove(this);
            }
            if (!hashSet.isEmpty()) {
                if (this.isFine()) {
                    this.logFine("Joined " + hashSet.size() + " folder");
                }
                if (!this.isFriend() && !this.server) {
                    this.getController().makeFriendship(this.getInfo());
                }
            }
        }
        finally {
            this.folderJoinLock.unlock();
        }
    }

    public FolderList getLastFolderList() {
        return this.lastFolderList;
    }

    public boolean hasCompleteFileListFor(FolderInfo folderInfo) {
        Integer n = this.expectedListMessages.get(folderInfo);
        if (n == null) {
            return false;
        }
        return n <= 0;
    }

    public TransferStatus getLastTransferStatus() {
        if (this.isMySelf()) {
            return this.getController().getTransferManager().getStatus();
        }
        return this.lastTransferStatus;
    }

    public boolean hasJoinedAnyFolder() {
        for (Folder folder : this.getController().getFolderRepository().getFolders()) {
            if (!folder.hasMember(this)) continue;
            return true;
        }
        return false;
    }

    private List<Folder> getFoldersActuallyJoined() {
        LinkedList<Folder> linkedList = new LinkedList<Folder>();
        for (Folder folder : this.getController().getFolderRepository().getFolders(true)) {
            if (!folder.hasMember(this)) continue;
            linkedList.add(folder);
        }
        return linkedList;
    }

    private List<Folder> getFoldersRequestedToJoin() {
        ConnectionHandler connectionHandler = this.peer;
        if (connectionHandler == null) {
            this.logFine("Node disconnected while getting folders");
            return Collections.emptyList();
        }
        FolderList folderList = this.getLastFolderList();
        if (folderList == null) {
            this.logFine("Unable to get last folder list");
            return Collections.emptyList();
        }
        LinkedList<Folder> linkedList = new LinkedList<Folder>();
        for (Folder folder : this.getController().getFolderRepository().getFolders(true)) {
            Object object;
            FolderInfo folderInfo = folder.getInfo();
            if (folderList.joinedMetaFolders && folderInfo.isMetaFolder() && (object = this.getController().getFolderRepository().getContentFolder(folder.getInfo())) != null) {
                folderInfo = ((Folder)object).getInfo();
            }
            if (this.getProtocolVersion() < 112) {
                object = connectionHandler.getMyMagicId();
                if (!folderList.contains(folderInfo, (String)object)) continue;
                linkedList.add(folder);
                continue;
            }
            if (!folderList.contains(folderInfo)) continue;
            linkedList.add(folder);
        }
        return linkedList;
    }

    public boolean hasFile(FileInfo fileInfo) {
        FileInfo fileInfo2 = this.getFile(fileInfo);
        return fileInfo2 != null && !fileInfo2.isDeleted();
    }

    public FileInfo getFile(FileInfo fileInfo) {
        if (fileInfo == null) {
            throw new NullPointerException("File is null");
        }
        Folder folder = fileInfo.getFolder(this.getController().getFolderRepository());
        if (folder == null) {
            return null;
        }
        if (this.isMySelf()) {
            return folder.getDAO().find(fileInfo, null);
        }
        return folder.getDAO().find(fileInfo, this.getId());
    }

    public String getId() {
        return this.info.id;
    }

    public String getNick() {
        return this.info.nick;
    }

    public void setNick(String string) {
        this.info.nick = string;
        this.getController().getNodeManager().fireNodeSettingsChanged(this);
    }

    public boolean isOnSameNetwork() {
        return this.info.isOnSameNetwork(this.getController());
    }

    public Identity getIdentity() {
        ConnectionHandler connectionHandler = this.peer;
        return connectionHandler != null ? connectionHandler.getIdentity() : null;
    }

    public int getProtocolVersion() {
        Identity identity = this.getIdentity();
        if (identity == null) {
            return 0;
        }
        return identity.getProtocolVersion();
    }

    public InetSocketAddress getReconnectAddress() {
        return this.info.getConnectAddress();
    }

    public Date getLastConnectTime() {
        return this.info.getLastConnectTime();
    }

    public Date getLastNetworkConnectTime() {
        Date date = this.getLastConnectTime();
        if (date == null) {
            return this.lastNetworkConnectTime;
        }
        if (this.lastNetworkConnectTime == null) {
            return date;
        }
        if (date.after(this.lastNetworkConnectTime)) {
            return date;
        }
        return this.lastNetworkConnectTime;
    }

    public MemberInfo getInfo() {
        this.info.isConnected = this.isConnected();
        return this.info;
    }

    public boolean isConnectedToNetwork() {
        return this.isCompletelyConnected() || this.isConnectedToNetwork;
    }

    public void setConnectedToNetwork(boolean bl) {
        boolean bl2 = this.isConnectedToNetwork != bl;
        this.isConnectedToNetwork = bl;
        if (bl2) {
            this.getController().getNodeManager().networkConnectionStateChanged(this);
        }
    }

    public boolean isDontConnect() {
        return this.lastProblem != null && (this.lastProblem.problemCode == 666 || this.lastProblem.problemCode == 888);
    }

    public boolean isUnableToConnect() {
        return this.connectionRetries >= 2;
    }

    public Problem getLastProblem() {
        return this.lastProblem;
    }

    public boolean isServer() {
        return this.server;
    }

    public boolean isServerOfOwnCluster(Controller controller) {
        return this.server && !controller.getOSClient().isClusterServer(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServer(boolean bl) {
        boolean bl2 = this.server;
        this.server = bl;
        if (bl2 != bl) {
            if (!bl) {
                this.logFine("Is not longer a server");
            } else {
                this.logFine("Is now a server");
            }
            if (this.getMySelf().isServer() && bl) {
                Object object = this.folderListWaiter;
                synchronized (object) {
                    this.folderListWaiter.notifyAll();
                }
            }
            this.getController().getNodeManager().serverStateChanged(this, bl);
        }
    }

    public boolean isIOS() {
        return this.getInfo().isIOS();
    }

    public String getUsername() {
        AccountInfo accountInfo = this.getAccountInfo();
        if (accountInfo == null) {
            return null;
        }
        return accountInfo.getUsername();
    }

    public AccountInfo getAccountInfo() {
        return this.getController().getSecurityManager().getAccountInfo(this);
    }

    public boolean updateInfo(MemberInfo memberInfo) {
        return this.updateInfo(memberInfo, false);
    }

    public boolean updateInfo(MemberInfo memberInfo, boolean bl) {
        boolean bl2;
        Serializable serializable;
        boolean bl3 = false;
        if (bl || !this.isConnected() && memberInfo.isConnected || this.info.getConnectAddress() == null && memberInfo.getConnectAddress() != null) {
            if (memberInfo.isSupernode && !this.info.isSupernode && this.isFiner()) {
                this.logFiner("Received new supernode information: " + memberInfo);
            }
            this.info.isSupernode = memberInfo.isSupernode;
            this.info.networkId = memberInfo.networkId;
            serializable = memberInfo.getConnectAddress();
            if (serializable != null) {
                bl2 = false;
                if (((InetSocketAddress)serializable).isUnresolved()) {
                    bl2 = true;
                }
                if (((InetSocketAddress)serializable).getAddress() != null && !NetworkUtil.isNullIP(((InetSocketAddress)serializable).getAddress())) {
                    bl2 = true;
                }
                if (bl2) {
                    this.info.setConnectAddress((InetSocketAddress)serializable);
                } else if (this.isFiner()) {
                    this.logFiner("Not updating address. Got: " + this.info.getConnectAddress() + ". New: " + (InetSocketAddress)serializable);
                }
            }
            bl3 = true;
        }
        serializable = memberInfo.getLastConnectTime();
        boolean bl4 = bl2 = this.lastNetworkConnectTime == null && serializable != null || serializable != null && this.lastNetworkConnectTime.before((Date)serializable);
        if (!this.isConnected() && bl2) {
            this.lastNetworkConnectTime = serializable;
            bl3 = true;
        }
        if (bl3) {
            this.connectionRetries = 0;
        }
        return bl3;
    }

    public boolean askedForFriendship() {
        return this.askedForFriendship;
    }

    public void setAskedForFriendship(boolean bl) {
        this.askedForFriendship = bl;
    }

    private boolean downloadRecentlyCompleted(FileInfo fileInfo) {
        Reject.ifNull(fileInfo, "FileInfo is null");
        if (ConfigurationEntry.DOWNLOAD_AUTO_CLEANUP_FREQUENCY.getValueInt(this.getController()) == 0) {
            return true;
        }
        Download download = this.getController().getTransferManager().getCompletedDownload(this, fileInfo);
        return download != null;
    }

    @Override
    protected void logWarning(String string) {
        super.logWarning(this.getNick() + ": " + string);
    }

    @Override
    protected void logInfo(String string) {
        super.logInfo(this.getNick() + ": " + string);
    }

    @Override
    protected void logFine(String string) {
        super.logFine(this.getNick() + ": " + string);
    }

    @Override
    protected void logFiner(String string) {
        super.logFiner(this.getNick() + ": " + string);
    }

    public String toString() {
        Object object = this.isConnected() ? "" + this.peer : (this.isMySelf() ? "myself" : "-disco.-, recon. at " + this.getReconnectAddress());
        String string = this.isServer() || this.isSupernode() ? "Server" : "Member";
        return string + " '" + this.info.nick + "' (" + (String)object + ")";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Member) {
            Member member = (Member)object;
            return Util.equals(this.info.id, member.info.id);
        }
        return false;
    }

    public int hashCode() {
        return this.info.id == null ? 0 : this.info.id.hashCode();
    }

    @Override
    public int compareTo(Member member) {
        return this.info.id.compareTo(member.info.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handshakeFolderList() {
        Object object = this.peerInitializeLock;
        synchronized (object) {
            boolean bl = true;
            this.peer.sendMessagesAsynchron(new FolderListExt(this.getFilteredFolderList(this.getLastFolderList(), false), bl));
        }
        this.peer.sendMessagesAsynchron(new HandshakeCompleted());
    }

    public void completeHandshakeD2D() {
        this.connectionRetries = 0;
        this.handshaked = true;
        this.getController().getNodeManager().connectStateChanged(this);
        this.getController().getSecurityManager().nodeAccountStateChanged(this, true);
        for (Folder folder : this.getFoldersActuallyJoined()) {
            if (folder.getSyncProfile().isAutodownload()) {
                this.getController().getFolderRepository().getFileRequestor().triggerFileRequesting(folder.getInfo());
            }
            if (!folder.getSyncProfile().isSyncDeletion()) continue;
            folder.triggerSyncRemoteDeletedFiles(Collections.singleton(this), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFolderListD2D(FolderList folderList) {
        for (FolderInfo folderInfo : folderList.folders) {
            this.expectedListMessages.put(folderInfo, -1);
        }
        try {
            this.folderJoinLock.lock();
            this.lastFolderList = folderList;
            this.joinToLocalFolders(folderList, this.peer);
        }
        finally {
            this.folderJoinLock.unlock();
        }
    }
}

